/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.ai.cvp.common.Enum.LicenseTypeEnum;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.license.LicenseCallDosageModel;
import kd.ai.cvp.entity.license.LicenseStatisticsVO;
import kd.ai.cvp.utils.DateUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.tenant.TenantInfo;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class LicenseDosageReqUtils {
    private static Log logger = LogFactory.getLog(LicenseDosageReqUtils.class);
    private static String KEY_PRESETCALL = "presetNum";
    private static String KEY_SELFDESIGN = "selfDesign";
    private static String KEY_FILEDIFFERENCE = "fileDifference";
    private static String KEY_FILEEXTRACT = "fileExtract";
    private static String KEY_TOTAL = "total";
    private static final String KEY_CURRENTBEGINTIME = "currentBeginTime";
    private static final String KEY_CURRENTEXPIRETIME = "currentExpireTime";
    private static String LABEL_PRESETTEMPLATE_NUM = "labelap";
    private static String LABEL_SELFDESIGN_NUM = "labelap2";
    private static String LABEL_FILEDIFFERENCE_NUM = "labelap21";
    private static String LABEL_FILEEXTRACT_NUM = "labelap23";

    private LicenseDosageReqUtils() {
        throw new KDBizException("\u521d\u59cb\u5316\u5f02\u5e38\u3002\u5de5\u5177\u7c7b\u4e0d\u5e94\u521d\u59cb\u5316\u7c7b\u7684\u5bf9\u8c61\u3002");
    }

    public static LicenseCallDosageModel queryCurrentLicenseUsage(LicenseStatisticsVO licenseCallVO) throws Exception {
        if (licenseCallVO == null) {
            throw new KDBizException("\u8bf7\u6c42\u8c03\u7528\u91cf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        String callStr = JSON.toJSONString((Object)licenseCallVO);
        logger.info(String.format("\u8bf7\u6c42\u8ba1\u6570\u670d\u52a1\u5165\u53c2\uff1a%s", callStr));
        StringEntity jsonEntity = new StringEntity(callStr, ContentType.APPLICATION_JSON);
        jsonEntity.setContentEncoding("UTF-8");
        long startReqTime = System.currentTimeMillis();
        String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/license/queryCallNumByType", (HttpEntity)jsonEntity);
        long endReqTime = System.currentTimeMillis();
        logger.info(String.format("\u8bf7\u6c42\u7b97\u6cd5\u8c03\u5ea6\u7528\u65f6%s,\u7ed3\u679c\uff1a%s", endReqTime - startReqTime, resultStr));
        AlgoResultData resultData = (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
        if (resultData != null && resultData.getData() != null) {
            return (LicenseCallDosageModel)JSON.parseObject((String)resultData.getData().toString(), LicenseCallDosageModel.class);
        }
        throw new KDBizException("\u8bf7\u6c42\u8c03\u7528\u91cf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
    }

    public static Map<String, Long> queryLicenseRemainCount(IFormView view, Boolean issumCard) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(KEY_PRESETCALL, 0L);
        map.put(KEY_SELFDESIGN, 0L);
        map.put(KEY_FILEDIFFERENCE, 0L);
        map.put(KEY_FILEEXTRACT, 0L);
        map.put(KEY_TOTAL, 0L);
        Boolean cvprn_License = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String productID = "";
        String productNo = "";
        String prodInstCode = "";
        if (productInfo != null) {
            productID = (String)productInfo.get("productID");
            prodInstCode = (String)productInfo.get("prodInstCode");
            productNo = (String)productInfo.get("productNo");
        }
        String licenseType = LicenseTypeEnum.TEMP_LICENSE.getType();
        boolean temporaryLicense = LicenseServiceHelper.isTemporaryLicense();
        if (!temporaryLicense) {
            licenseType = LicenseTypeEnum.FORMAL_LICENSE.getType();
        }
        RequestContext rc = RequestContext.getOrCreate();
        String tenantId = "";
        String tenantCode = "";
        String tenantName = "";
        tenantId = rc.getTenantId();
        tenantCode = rc.getTenantCode();
        TenantInfo tenantInfo = rc.getTenantInfo();
        if (tenantInfo != null) {
            tenantName = tenantInfo.getName();
        }
        Long beginTime = 0L;
        Long endTime = 0L;
        Map<String, Long> dateRangeMap = LicenseDosageReqUtils.getCurrentSubscriptionDate(cvprn_License);
        if (dateRangeMap.size() > 0) {
            beginTime = dateRangeMap.get(KEY_CURRENTBEGINTIME);
            endTime = dateRangeMap.get(KEY_CURRENTEXPIRETIME);
        }
        LicenseStatisticsVO licenseCallVO = new LicenseStatisticsVO();
        licenseCallVO.setTenantId(tenantId);
        licenseCallVO.setTenantCode(tenantCode);
        licenseCallVO.setLicenseProductNo(productNo);
        licenseCallVO.setLicenseProdInstCode(prodInstCode);
        licenseCallVO.setLicenseType(licenseType);
        licenseCallVO.setBeginTime(beginTime);
        licenseCallVO.setEndTime(endTime);
        LicenseCallDosageModel callDosageModel = null;
        try {
            callDosageModel = LicenseDosageReqUtils.queryCurrentLicenseUsage(licenseCallVO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8c03\u7528\u91cf\u5f02\u5e38", (Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8c03\u7528\u91cf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"OcrCallDosagePlugin_01", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        if (callDosageModel != null) {
            Long fileDifferenceCallCount = callDosageModel.getFileDifferenceCallCount();
            Long presetTemplateCallCount = callDosageModel.getPresetTemplateCallCount();
            Long selfDesignTemplateCallCount = callDosageModel.getSelfDesignTemplateCallCount();
            Long fileExtractCallCount = callDosageModel.getFileExtractCallCount();
            Long complexFileCallCount = callDosageModel.getComplexFileCallCount();
            logger.info("\u9884\u7f6e\u6a21\u677f\uff1a{}\uff0c\u81ea\u5b9a\u4e49\u6a21\u677f\uff1a{}\uff0c\u5dee\u5f02\u6bd4\u5bf9\uff1a{}\uff0c\u4fe1\u606f\u63d0\u53d6\uff1a{}\uff0c\u590d\u6742\u6587\u6863\uff1a{}", new Object[]{presetTemplateCallCount, selfDesignTemplateCallCount, fileDifferenceCallCount, fileExtractCallCount, complexFileCallCount});
            presetTemplateCallCount = presetTemplateCallCount + complexFileCallCount;
            if (!issumCard.booleanValue()) {
                Label presetNumLabel = (Label)view.getControl(LABEL_PRESETTEMPLATE_NUM);
                Label selfDesignLabel = (Label)view.getControl(LABEL_SELFDESIGN_NUM);
                Label fileDifferenceLabel = (Label)view.getControl(LABEL_FILEDIFFERENCE_NUM);
                Label fileExtractLabel = (Label)view.getControl(LABEL_FILEEXTRACT_NUM);
                if (presetNumLabel != null) {
                    presetNumLabel.setText(String.valueOf(presetTemplateCallCount));
                }
                if (selfDesignLabel != null) {
                    selfDesignLabel.setText(String.valueOf(selfDesignTemplateCallCount));
                }
                if (fileDifferenceLabel != null) {
                    fileDifferenceLabel.setText(String.valueOf(fileDifferenceCallCount));
                }
                if (fileExtractLabel != null) {
                    fileExtractLabel.setText(String.valueOf(fileExtractCallCount));
                }
            }
            map.put(KEY_PRESETCALL, presetTemplateCallCount);
            map.put(KEY_SELFDESIGN, selfDesignTemplateCallCount);
            map.put(KEY_FILEDIFFERENCE, fileDifferenceCallCount);
            map.put(KEY_FILEEXTRACT, fileExtractCallCount);
            map.put(KEY_TOTAL, callDosageModel.getTotalCount());
        }
        return map;
    }

    private static Map<String, Long> getCurrentSubscriptionDate(Boolean isCVPRN) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        Map groupTimeRange = LicenseServiceHelper.getGroupTimeRange((Long)506L);
        Date beginDate = null;
        Date expireDate = null;
        if (groupTimeRange != null) {
            beginDate = (Date)groupTimeRange.get("beginDate");
            expireDate = (Date)groupTimeRange.get("expireDate");
        }
        if (beginDate != null && expireDate != null) {
            if (isCVPRN.booleanValue()) {
                Map<String, Date> currentSubScriptionDate = DateUtils.getCurrentSubScriptionDate(beginDate, expireDate);
                if (currentSubScriptionDate != null && currentSubScriptionDate.size() > 0) {
                    Date currentBeginDate = currentSubScriptionDate.get("beginDate");
                    Date currentExpireDate = currentSubScriptionDate.get("expireDate");
                    if (currentBeginDate != null && currentExpireDate != null) {
                        resultMap.put(KEY_CURRENTBEGINTIME, currentBeginDate.getTime());
                        resultMap.put(KEY_CURRENTEXPIRETIME, currentExpireDate.getTime());
                    }
                }
            } else {
                resultMap.put(KEY_CURRENTBEGINTIME, beginDate.getTime());
                resultMap.put(KEY_CURRENTEXPIRETIME, expireDate.getTime());
            }
        }
        return resultMap;
    }
}

