/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.ai.cvp.common.Enum.LicenseCountServiceNameEnum;
import kd.ai.cvp.common.Enum.LicenseTypeEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.license.LicenseApiInfoVO;
import kd.ai.cvp.entity.license.LicenseCallDosageModel;
import kd.ai.cvp.entity.license.LicenseStatisticsVO;
import kd.ai.cvp.utils.DateUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class LicenseUtils {
    private static Log logger = LogFactory.getLog(LicenseUtils.class);
    private static final String TOTALNUMBER = "totalNumber";
    private static final String USEDNUM = "usedNum";
    private static final String APPNAME = "ai-cvp";
    private static final int NO_AUTHORITY = 40001;

    private LicenseUtils() {
    }

    public static boolean checkLicenseAndDosage(IFormView view) {
        boolean hasDosageLicense = true;
        boolean hasRDLicense = LicenseUtils.checkHasRDLicense();
        if (!hasRDLicense) {
            boolean cvprnLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
            if (cvprnLicense) {
                logger.info("\u8bb8\u53ef\u6d41\u91cf\u7248\u6821\u9a8c\u7528\u91cf\u3002\u3002");
                hasDosageLicense = LicenseUtils.checkLicenseDosage(view);
            } else {
                String message = ResManager.loadKDString((String)"\u672a\u83b7\u5f97\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\uff0c\u8bf7\u5148\u8d2d\u4e70\u3002", (String)"LicenseUtils_0", (String)"ai-cvp-common", (Object[])new Object[0]);
                String format = String.format("traceid:%s,errorCode:%s,errorMsg:%s", RequestContext.get().getTraceId(), 40001, message);
                logger.error("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\uff0c\u64cd\u4f5c\u8bf7\u6c42\u4fe1\u606f: " + format);
                view.showTipNotification(message);
                hasDosageLicense = false;
            }
        }
        return hasDosageLicense;
    }

    public static boolean checkPureLicense() {
        boolean hasRDLicense = LicenseUtils.checkHasRDLicense();
        if (!hasRDLicense) {
            hasRDLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
        }
        return hasRDLicense;
    }

    public static boolean checkLicenseWithDROrRN() {
        boolean cvprLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPR").getHasLicense();
        boolean cvpdLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPD").getHasLicense();
        String productVersion = LicenseServiceHelper.getProductVersion();
        boolean cvprnLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
        return "1.0".equalsIgnoreCase(productVersion) || cvpdLicense && cvprLicense || cvprnLicense;
    }

    public static boolean checkHasRDLicense() {
        boolean cvprLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPR").getHasLicense();
        boolean cvpdLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPD").getHasLicense();
        String productVersion = LicenseServiceHelper.getProductVersion();
        String pubTenantType = LicenseServiceHelper.getPubTenantType();
        boolean envStatus = Boolean.parseBoolean(pubTenantType);
        logger.info(String.format("\u8bb8\u53ef\u72b6\u6001\uff1acvpr:%s,cvpd:%s,productVersion:%s", cvprLicense, cvpdLicense, productVersion));
        return "1.0".equalsIgnoreCase(productVersion) || envStatus && cvpdLicense || !envStatus && cvprLicense;
    }

    private static boolean checkLicenseDosage(IFormView view) {
        int totalNumber = LicenseServiceHelper.getTotalNumber((Object)506L);
        logger.info(String.format("\u8bb8\u53ef\u603b\u91cf\uff1a%s", totalNumber));
        Map<String, Date> currentMap = LicenseUtils.getCurrentPeriodDate();
        Date beginDate = null;
        Date expireDate = null;
        if (currentMap != null && currentMap.size() > 0) {
            beginDate = currentMap.get("beginDate");
            expireDate = currentMap.get("expireDate");
            logger.info(String.format("\u5f53\u524d\u8bb8\u53ef\u65f6\u95f4\uff1a\u8d77\uff1a%s\uff0c\u6b62\uff1a%s", beginDate, expireDate));
        }
        if (beginDate == null || expireDate == null) {
            throw new KDBizException("\u8bb8\u53ef\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String productID = "";
        String prodInstCode = "";
        String productNo = "";
        if (productInfo != null && productInfo.size() > 0) {
            productID = (String)productInfo.get("productID");
            prodInstCode = (String)productInfo.get("prodInstCode");
            productNo = (String)productInfo.get("productNo");
        }
        String licenseType = LicenseTypeEnum.TEMP_LICENSE.getType();
        boolean temporaryLicense = LicenseServiceHelper.isTemporaryLicense();
        if (!temporaryLicense) {
            licenseType = LicenseTypeEnum.FORMAL_LICENSE.getType();
        }
        RequestContext requestContext = RequestContext.get();
        String tenantId = "";
        String tenantCode = "";
        if (requestContext == null) {
            requestContext = RequestContext.create();
        }
        tenantId = requestContext.getTenantId();
        tenantCode = requestContext.getTenantCode();
        LicenseStatisticsVO licenseCallVO = new LicenseStatisticsVO();
        licenseCallVO.setTenantId(tenantId);
        licenseCallVO.setTenantCode(tenantCode);
        licenseCallVO.setLicenseProductNo(productNo);
        licenseCallVO.setLicenseProdInstCode(prodInstCode);
        licenseCallVO.setLicenseType(licenseType);
        licenseCallVO.setBeginTime(beginDate.getTime());
        licenseCallVO.setEndTime(expireDate.getTime());
        long usedNum = -1L;
        try {
            usedNum = LicenseUtils.queryCurrentLicenseUsage(licenseCallVO);
        }
        catch (Exception e) {
            logger.error(String.format("\u8bf7\u6c42\u7b97\u6cd5\u8c03\u5ea6\u5f02\u5e38,mc\u914d\u7f6e\u7684\u7b97\u6cd5\u8c03\u5ea6\u670d\u52a1\u5730\u5740\u4e3a\uff1a%s", LicenseUtils.getMcConfigIp()), (Throwable)e);
            throw new KDBizException("\u7b97\u6cd5\u670d\u52a1\u54cd\u5e94\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5MC\u914d\u7f6e\u9879cvp.ocr.service.host\u662f\u5426\u6b63\u786e");
        }
        if (usedNum >= (long)totalNumber) {
            view.showTipNotification("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u7528\u91cf\u5df2\u7528\u5b8c\uff0c\u8bf7\u7acb\u5373\u52a0\u8d2d\u6d41\u91cf\u3002");
            return false;
        }
        if ((double)usedNum > (double)totalNumber * 0.9) {
            view.showTipNotification(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5f53\u5e74\u8ba2\u9605\u671f\u5185\u5269\u4f59\u7528\u91cf\u4e0d\u8db3\uff08<10%\uff09\uff0c\u8bf7\u53ca\u65f6\u52a0\u8d2d\u6d41\u91cf\u3002", (String)"LicenseUtils_11", (String)"ai-cvp-common", (Object[])new Object[0]));
        }
        return true;
    }

    private static Map<String, Date> getCurrentPeriodDate() {
        Map groupTimeRange = LicenseServiceHelper.getGroupTimeRange((Long)506L);
        Date beginDate = null;
        Date expireDate = null;
        if (groupTimeRange == null) {
            throw new KDBizException("\u8bb8\u53ef\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        beginDate = (Date)groupTimeRange.get("beginDate");
        expireDate = (Date)groupTimeRange.get("expireDate");
        logger.info(String.format("\u8bb8\u53ef\u8d77\u6b62\u65e5\u671f\uff1a\u8d77\uff1a%s,\u6b62\uff1a%s", beginDate, expireDate));
        if (beginDate != null && expireDate != null) {
            return DateUtils.getCurrentSubScriptionDate(beginDate, expireDate);
        }
        return new HashMap<String, Date>(1);
    }

    private static String getMcConfigIp() {
        String host = System.getProperty("cvp.ocr.service.host");
        String hostOld = System.getProperty("algo.ocr.service.ip");
        return kd.bos.util.StringUtils.isEmpty((String)host) ? hostOld : host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDosageLicense(int callNum, String countKey) throws KDBizException {
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String productID = null;
        String productNo = "";
        String prodInstCode = "";
        if (productInfo != null) {
            productID = (String)productInfo.get("productID");
            prodInstCode = (String)productInfo.get("prodInstCode");
            productNo = (String)productInfo.get("productNo");
        }
        if (kd.bos.util.StringUtils.isEmpty(productID)) {
            logger.error("productID \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u76f8\u5e94\u8bb8\u53ef\u7684\u64cd\u4f5c\u3002");
            throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u8bb8\u53ef\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"LicenseUtils_01", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
        }
        String licenseType = LicenseTypeEnum.TEMP_LICENSE.getType();
        boolean temporaryLicense = LicenseServiceHelper.isTemporaryLicense();
        if (!temporaryLicense) {
            licenseType = LicenseTypeEnum.FORMAL_LICENSE.getType();
        }
        RequestContext rc = RequestContext.get();
        String tenantCode = rc.getTenantCode();
        String tenantId = rc.getTenantId();
        String lockObjStr = "cvp_".concat(tenantCode).concat("_").concat(productID);
        DLock lock = DLock.create((String)lockObjStr, (String)String.format("\u79df\u6237id:%s,\u4ea7\u54c1\u8bb8\u53efid:%s\u8bb8\u53ef\u7528\u91cf\u9501", tenantCode, productID));
        lock.fastMode();
        boolean lockFlag = false;
        int totalNumber = -1;
        int usedNum = -1;
        try {
            Map<String, Object> paramMap = LicenseUtils.prepareParam(productID, prodInstCode, productNo, tenantId, tenantCode, licenseType);
            if (paramMap.size() > 0 && paramMap.get(TOTALNUMBER) != null && paramMap.get(USEDNUM) != null) {
                totalNumber = Integer.parseInt(paramMap.get(TOTALNUMBER).toString());
                usedNum = Integer.parseInt(paramMap.get(USEDNUM).toString());
            }
            if (totalNumber < 0 || usedNum < 0) {
                logger.error(String.format("\u603b\u91cf\u6216\u4f7f\u7528\u91cf\u9519\u8bef\uff0ctotalNumber:%d,usedNum:%d", totalNumber, usedNum));
                throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"LicenseUtils_02", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
            }
            try {
                lockFlag = lock.tryLock(2000L);
                if (!lockFlag) {
                    logger.info("\u9501\u83b7\u53d6\u8d85\u65f6\uff0c\u91ca\u653e\u9501,\u9501key:" + lockObjStr);
                }
            }
            catch (Exception e) {
                logger.error(String.format("\u83b7\u53d6\u9501\u8d85\u65f6,\u9501key:%s", lockObjStr), (Throwable)e);
                throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u73af\u5883\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002\u82e5\u591a\u6b21\u51fa\u73b0\u672c\u63d0\u793a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"LicenseUtils_06", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
            }
            logger.info("\u83b7\u53d6\u9501\u72b6\u6001\uff1a\uff1a" + lockFlag);
            if (lockFlag) {
                boolean bl = LicenseUtils.preuseHandle(countKey, productID, usedNum, totalNumber, callNum);
                return bl;
            }
            logger.error("\u672a\u83b7\u53d6\u5230\u9501\uff0c\u9501key::" + lockObjStr);
        }
        finally {
            logger.info("\u91ca\u653e\u9501\u3002\u3002\u3002\u9501key\uff1a\uff1a" + lockObjStr);
            lock.unlock();
            lock.close();
        }
        throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"LicenseUtils_03", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
    }

    private static Map<String, Object> prepareParam(String productID, String prodInstCode, String productNo, String tenantId, String tenantCode, String licenseType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
        int totalNumber = LicenseServiceHelper.getTotalNumber((Object)506L);
        paramMap.put(TOTALNUMBER, totalNumber);
        Map<String, Date> currentMap = LicenseUtils.getCurrentPeriodDate();
        Date beginDate = null;
        Date expireDate = null;
        if (currentMap != null && currentMap.size() > 0) {
            beginDate = currentMap.get("beginDate");
            expireDate = currentMap.get("expireDate");
        }
        if (beginDate == null || expireDate == null) {
            throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u8bb8\u53ef\u671f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b", (String)"LicenseUtils_03", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
        }
        LicenseStatisticsVO licenseCallVO = new LicenseStatisticsVO();
        licenseCallVO.setTenantId(tenantId);
        licenseCallVO.setTenantCode(tenantCode);
        licenseCallVO.setLicenseProductNo(productNo);
        licenseCallVO.setLicenseProdInstCode(prodInstCode);
        licenseCallVO.setLicenseType(licenseType);
        licenseCallVO.setBeginTime(beginDate.getTime());
        licenseCallVO.setEndTime(expireDate.getTime());
        long usedNum = -1L;
        try {
            usedNum = LicenseUtils.queryCurrentLicenseUsage(licenseCallVO);
        }
        catch (KDBizException be) {
            logger.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)be);
            throw be;
        }
        catch (Exception e) {
            logger.error(String.format("\u8bf7\u6c42\u7b97\u6cd5\u8c03\u5ea6\u5f02\u5e38,mc\u914d\u7f6e\u7684\u7b97\u6cd5\u8c03\u5ea6\u670d\u52a1\u5730\u5740\u4e3a\uff1a%s", LicenseUtils.getMcConfigIp()), (Throwable)e);
            throw new KDBizException(new ErrorCode(String.valueOf(40002), ResManager.loadKDString((String)"\u7b97\u6cd5\u670d\u52a1\u54cd\u5e94\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5MC\u914d\u7f6e\u9879\u662f\u5426\u6b63\u786e", (String)"LicenseUtils_04", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
        }
        if (usedNum >= (long)totalNumber) {
            throw new KDBizException(new ErrorCode(String.valueOf(40004), ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5f53\u5e74\u8ba2\u9605\u671f\u5185\u7528\u91cf\u5df2\u7528\u5b8c\uff0c\u8bf7\u7acb\u5373\u52a0\u8d2d\u6d41\u91cf\u3002", (String)"LicenseUtils_05", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
        }
        paramMap.put(USEDNUM, usedNum);
        return paramMap;
    }

    private static boolean preuseHandle(String countKey, String productID, long usedNum, int totalNumber, int callNum) {
        if (usedNum < 0L || totalNumber < 0 || callNum < 1) {
            throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"LicenseUtils_07", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
        }
        IAppCache appCache = AppCache.get((String)APPNAME);
        RequestContext rc = RequestContext.get();
        String tenantCode = rc.getTenantCode();
        String name = rc.getTenantInfo().getName();
        String cacheKey = tenantCode.concat("_").concat(productID).concat("_").concat(name);
        logger.info("\u7f13\u5b58key\uff1a\uff1a" + cacheKey);
        String preuseCountStr = (String)appCache.get(cacheKey, String.class);
        long preuseCount = 0L;
        if (!kd.bos.util.StringUtils.isEmpty((String)preuseCountStr)) {
            preuseCount = Long.parseLong(preuseCountStr);
        }
        if (preuseCount + usedNum >= (long)totalNumber) {
            throw new KDBizException(new ErrorCode(String.valueOf(40004), ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5f53\u5e74\u8ba2\u9605\u671f\u5185\u5269\u4f59\u7528\u91cf\u4e0d\u8db3,\u65e0\u6cd5\u5b8c\u6210\u672c\u6b21\u8bc6\u522b\uff0c\u8bf7\u53ca\u65f6\u52a0\u8d2d\u6d41\u91cf\u3002", (String)"LicenseUtils_08", (String)APPNAME, (Object[])new Object[0])), new Object[0]);
        }
        appCache.put(cacheKey, (Object)String.valueOf(preuseCount + (long)callNum));
        appCache.put(countKey, (Object)String.valueOf(callNum));
        return true;
    }

    private static long queryCurrentLicenseUsage(LicenseStatisticsVO licenseCallVO) throws Exception {
        if (licenseCallVO == null) {
            throw new KDBizException("\u8bf7\u6c42\u8c03\u7528\u91cf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        String callStr = JSON.toJSONString((Object)licenseCallVO);
        logger.info(String.format("\u8bf7\u6c42\u8ba1\u6570\u670d\u52a1\u5165\u53c2\uff1a%s", callStr));
        StringEntity entity = new StringEntity(callStr, ContentType.APPLICATION_JSON);
        entity.setContentEncoding("UTF-8");
        long startReqTime = System.currentTimeMillis();
        String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/license/queryCallNumByType", (HttpEntity)entity);
        long endReqTime = System.currentTimeMillis();
        logger.info(String.format("\u8bf7\u6c42\u7b97\u6cd5\u8c03\u5ea6\u7528\u65f6:%s,\u7ed3\u679c\u4e3a\uff1a%s", endReqTime - startReqTime, resultStr));
        AlgoResultData resultData = (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
        LicenseCallDosageModel callDosageModel = null;
        if (resultData != null) {
            if (resultData.getErrorCode() == 0 && resultData.getData() != null) {
                callDosageModel = (LicenseCallDosageModel)JSON.parseObject((String)resultData.getData().toString(), LicenseCallDosageModel.class);
                return callDosageModel.getTotalCount();
            }
            throw new KDBizException(kd.bos.util.StringUtils.isEmpty((String)resultData.getDescription()) ? "\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b" : resultData.getDescription());
        }
        throw new KDBizException("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b");
    }

    public static boolean checkLicense(int pageNum, String serviceName, String countKey) {
        logger.info("\u5f00\u59cb\u6821\u9a8c\u8bb8\u53ef\u3002\u3002\u3002");
        if (pageNum < 1) {
            throw new KDBizException(new ErrorCode(String.valueOf(40000), "\u6587\u4ef6\u9875\u6570\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002"), new Object[0]);
        }
        boolean status = true;
        boolean hasRDLicense = LicenseUtils.checkHasRDLicense();
        if (!hasRDLicense) {
            boolean cvprnLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
            if (cvprnLicense) {
                int countTimes = 1;
                if (!kd.bos.util.StringUtils.isEmpty((String)serviceName)) {
                    countTimes = LicenseCountServiceNameEnum.getLicenseCountTimesByName(serviceName);
                }
                logger.info("\u8bb8\u53ef\u6d88\u8017\u500d\u7387\uff1a{}", (Object)countTimes);
                status = LicenseUtils.checkDosageLicense(countTimes * pageNum, countKey);
                logger.info("\u8bb8\u53ef\u6821\u9a8c\u7ed3\u679c\uff1a" + status + " \uff08\u6ce8\uff1atrue\u4e3a\u8bb8\u53ef\u6821\u9a8c\u901a\u8fc7\u4e14\u6d41\u91cf\u6821\u9a8c\u901a\u8fc7\uff09\u3002");
            } else {
                status = false;
            }
        }
        logger.info("\u8bb8\u53ef\u6821\u9a8c\u7ed3\u675f\u3002\u3002\u3002");
        return status;
    }

    private static boolean genHttpToAlgo(LicenseApiInfoVO licenseApiInfoVO) throws Exception {
        String callEntityStr = JSON.toJSONString((Object)licenseApiInfoVO);
        logger.info("\u65b0\u589e\u8bb0\u5f55\u5bf9\u8c61\uff1a{}", (Object)callEntityStr);
        StringEntity algoHttpEntity = new StringEntity(callEntityStr, ContentType.APPLICATION_JSON);
        String resultLicenseStr = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/license/callApi", (HttpEntity)algoHttpEntity);
        AlgoResultData resultSaveData = (AlgoResultData)JSON.parseObject((String)resultLicenseStr, AlgoResultData.class);
        if (0 == resultSaveData.getErrorCode()) {
            return (Boolean)resultSaveData.getData();
        }
        logger.error(String.format("\u8bf7\u6c42\u63d2\u5165\u9884\u8c03\u7528\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\u4e3a\uff1a%s", resultSaveData.getDescription()));
        return false;
    }

    private static void clearPresetNumInCache(String tenantCode, String tenantName, String productID, String traceId, String taskId) {
        IAppCache appCache = AppCache.get((String)APPNAME);
        String cacheKey = tenantCode.concat("_").concat(productID).concat("_").concat(tenantName);
        logger.info("\u6838\u9500key:" + cacheKey);
        String preUseCountStr = (String)appCache.get(cacheKey, String.class);
        if (kd.bos.util.StringUtils.isEmpty((String)traceId) && kd.bos.util.StringUtils.isNotEmpty((String)taskId)) {
            traceId = (String)appCache.get(taskId, String.class);
        }
        String currentCallNumStr = (String)appCache.get(traceId, String.class);
        if (!kd.bos.util.StringUtils.isEmpty((String)preUseCountStr) && !kd.bos.util.StringUtils.isEmpty((String)currentCallNumStr)) {
            appCache.put(cacheKey, (Object)String.valueOf(Long.parseLong(preUseCountStr) - Long.parseLong(currentCallNumStr)));
            appCache.remove(traceId);
            if (kd.bos.util.StringUtils.isNotEmpty((String)taskId)) {
                appCache.remove(taskId);
            }
        }
    }

    public static void refreshPresetNumInCache(String tenantCode, String tenantName, String productID, String taskId) {
        IAppCache appCache = AppCache.get((String)APPNAME);
        String cacheKey = tenantCode.concat("_").concat(productID).concat("_").concat(tenantName);
        String preUseCountStr = (String)appCache.get(cacheKey, String.class);
        appCache.put(cacheKey, (Object)preUseCountStr);
        String traceId = (String)appCache.get(taskId, String.class);
        logger.info(String.format("\u6838\u9500key:%s,taskId:%s,traceId:%s", cacheKey, taskId, traceId));
        if (kd.bos.util.StringUtils.isNotEmpty((String)traceId)) {
            String currentCallNumStr = (String)appCache.get(traceId, String.class);
            appCache.put(traceId, (Object)currentCallNumStr);
            logger.info(String.format("\u7f13\u5b58\u9884\u8c03\u7528\u603b\u91cf\uff1a%s,\u5f53\u524d\u9884\u8c03\u7528\u91cf\uff1a%s", preUseCountStr, currentCallNumStr));
        }
    }

    private static boolean ensureCallNumToAlgo(boolean reqSuc, String traceId, String taskId, int callNum, SourceTypeEnum sourceTypeEnum) {
        String licenseType = LicenseTypeEnum.TEMP_LICENSE.getType();
        boolean temporaryLicense = LicenseServiceHelper.isTemporaryLicense();
        if (!temporaryLicense) {
            licenseType = LicenseTypeEnum.FORMAL_LICENSE.getType();
        }
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String tenantCode = rc.getTenantCode();
        String tenantName = rc.getTenantInfo().getName();
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String productID = "";
        String prodInstCode = "";
        String productNo = "";
        if (productInfo != null && !productInfo.isEmpty()) {
            productID = (String)productInfo.get("productID");
            prodInstCode = (String)productInfo.get("prodInstCode");
            productNo = (String)productInfo.get("productNo");
        }
        LicenseApiInfoVO licenseApiInfoVO = new LicenseApiInfoVO(tenantId, tenantCode, tenantName, productID, productNo, prodInstCode, licenseType, sourceTypeEnum.getSourceType(), callNum);
        boolean flag = false;
        try {
            if (reqSuc) {
                flag = LicenseUtils.genHttpToAlgo(licenseApiInfoVO);
                logger.info(String.format("\u8ba1\u6570\u670d\u52a1\u65b0\u589e\u6210\u529f...\u79df\u6237code:%s,\u4ea7\u54c1id\uff1a%s,\u8c03\u7528\u6b21\u6570\uff1a%d,traceId:%s,taskId:%s", tenantCode, productID, callNum, traceId, taskId));
            }
            LicenseUtils.clearPresetNumInCache(tenantCode, tenantName, productID, traceId, taskId);
        }
        catch (Exception e) {
            logger.error(String.format("\u6838\u9500\u90e8\u5206\u5931\u8d25\uff0ctraceId:%s,taskId:%s,\u8c03\u7528\u91cf\uff1a%d\uff0c\u4ea7\u54c1ID\uff1a%s,\u79df\u6237code:%s,\u8c03\u7528\u7c7b\u578b\uff1a%s", traceId, taskId, callNum, productID, tenantCode, sourceTypeEnum.getSourceType()));
            LicenseUtils.clearPresetNumInCache(tenantCode, tenantName, productID, traceId, taskId);
        }
        return flag;
    }

    private static boolean ensureCallNumToAlgo(boolean reqSuc, String traceId, int callNum, SourceTypeEnum sourceTypeEnum) {
        logger.info(String.format("\u8ba1\u6570\u670d\u52a1- \u81ea\u5b9a\u4e49\u6a21\u7248\u8c03\u7528\u6b21\u6570\uff1a%d,traceId:%s", callNum, traceId));
        return LicenseUtils.ensureCallNumToAlgo(reqSuc, traceId, null, callNum, sourceTypeEnum);
    }

    public static boolean ensureCallNumToAlgoAsync(boolean reqSuc, String taskId, SourceTypeEnum sourceTypeEnum) {
        boolean cvprnLicense;
        boolean result = true;
        boolean hasRDLicense = LicenseUtils.checkHasRDLicense();
        if (!hasRDLicense && (cvprnLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense().booleanValue())) {
            result = LicenseUtils.ensureCallNumToAlgo(reqSuc, null, taskId, LicenseUtils.getAppCachePresetUseNum(taskId), sourceTypeEnum);
        }
        return result;
    }

    public static boolean ensurePracticalCallNumByTaskIdAndPageNum(String taskId, int pageCount, String serviceName, SourceTypeEnum sourceTypeEnum) {
        boolean cvprnLicense;
        boolean result = true;
        boolean hasRDLicense = LicenseUtils.checkHasRDLicense();
        if (!hasRDLicense && (cvprnLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense().booleanValue())) {
            int countTimes = 1;
            if (!kd.bos.util.StringUtils.isEmpty((String)serviceName)) {
                countTimes = LicenseCountServiceNameEnum.getLicenseCountTimesByName(serviceName);
                logger.info("\u5b9e\u9645\u8bb8\u53ef\u5373\u5c06\u6d88\u8017\u91cf\uff1a{}", (Object)(countTimes * pageCount));
            }
            result = LicenseUtils.ensureCallNumToAlgo(true, null, taskId, countTimes * pageCount, sourceTypeEnum);
        }
        return result;
    }

    public static boolean ensureCallNumToAlgo(boolean reqSuc, String traceId, SourceTypeEnum sourceTypeEnum) {
        int callNum = -1;
        boolean resultFlag = true;
        try {
            boolean cvprnLicense;
            boolean hasRDLicense = LicenseUtils.checkHasRDLicense();
            if (!hasRDLicense && (cvprnLicense = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense().booleanValue())) {
                callNum = LicenseUtils.getAppCachePresetUseNumByTraceId(traceId);
                resultFlag = LicenseUtils.ensureCallNumToAlgo(reqSuc, traceId, callNum, sourceTypeEnum);
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u5f02\u5e38\u6838\u9500\u5931\u8d25\uff0ctraceId:%s,callNum:%d,sourceType:%s", new Object[]{traceId, callNum, SourceTypeEnum.FILEDIFFERENCE}), (Throwable)e);
        }
        return resultFlag;
    }

    private static int getAppCachePresetUseNum(String taskId) {
        IAppCache appCache = AppCache.get((String)APPNAME);
        String traceId = (String)appCache.get(taskId, String.class);
        String callNumStr = (String)appCache.get(traceId, String.class);
        logger.info(String.format("appCache:%s,traceId:%s,callNumStr:%s", appCache, traceId, callNumStr));
        if (!StringUtils.isEmpty((CharSequence)callNumStr)) {
            return Integer.parseInt(callNumStr);
        }
        logger.error(String.format("\u67e5\u8be2\u9884\u8c03\u7528\u91cf\u5f02\u5e38\uff0ctraceid\uff1a%s", traceId));
        throw new KDBizException("\u67e5\u8be2\u9884\u8c03\u7528\u6570\u636e\u5f02\u5e38");
    }

    private static int getAppCachePresetUseNumByTraceId(String traceId) {
        IAppCache appCache = AppCache.get((String)APPNAME);
        String callNumStr = (String)appCache.get(traceId, String.class);
        logger.info(String.format("appCache:%s,traceId:%s,callNumStr:%s", appCache, traceId, callNumStr));
        if (!kd.bos.util.StringUtils.isEmpty((String)callNumStr)) {
            return Integer.parseInt(callNumStr);
        }
        logger.error(String.format("\u67e5\u8be2\u9884\u8c03\u7528\u91cf\u5f02\u5e38\uff0ctraceid\uff1a%s", traceId));
        throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u67e5\u8be2\u9884\u8c03\u7528\u6570\u636e\u5f02\u5e38", (String)"LicenseUtils_09", (String)"", (Object[])new Object[0])), new Object[0]);
    }

    public static boolean validApiPermission() {
        logger.info("\u63a5\u53e3\u6743\u9650\u9a8c\u8bc1\u5f00\u59cb");
        long currUserId = RequestContext.get().getCurrUserId();
        String key_appId = "cvp";
        String appId = AppMetadataCache.getAppInfo((String)key_appId).getAppId();
        String entityNum = "cvp_apphome";
        boolean hasRight = PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)entityNum, (String)"4WJRLTE6NY56");
        logger.info("\u6743\u9650\u9a8c\u8bc1\u7ed3\u675f\uff0c\u7ed3\u679c\uff1a{}", (Object)hasRight);
        return hasRight;
    }
}

