/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import kd.ai.cvp.common.Enum.FileValidTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.bos.cache.tempfile.BaseTempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class LocalTempFileCache {
    private static final Log logger;
    private static String cachePath;
    private static final int temp_file_timeout = 600000;
    private static final int temp_file_schdule_period = 600000;
    private static final String temp_file_suffix = "temp";

    private LocalTempFileCache() {
        throw new KDBizException("init error");
    }

    public static String saveToLocalTempPath(InputStream in) {
        String id = "tempfile-" + UUID.randomUUID().toString();
        return LocalTempFileCache.saveToLocalTempPath(in, id);
    }

    public static String saveToLocalTempPathByAppendType(InputStream inputStream, String fileId) {
        try {
            LocalTempFileCache.validExistAndCreate();
            LocalTempFileCache.writeToFileByAppendType(LocalTempFileCache.getFile(fileId), inputStream);
            return fileId;
        }
        catch (Exception var7) {
            throw new KDBizException((Throwable)var7, BosErrorCode.uploadFailed, new Object[0]);
        }
    }

    public static String saveToLocalTempPath(InputStream in, String fileId) {
        try {
            LocalTempFileCache.validExistAndCreate();
            if (in == null) {
                throw new KDBizException("\u5f85\u5b58\u50a8\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            }
            LocalTempFileCache.doWriteToFile(LocalTempFileCache.getFile(fileId), in, false);
            return fileId;
        }
        catch (Exception var7) {
            throw new KDBizException((Throwable)var7, BosErrorCode.uploadFailed, new Object[0]);
        }
    }

    public static InputStream getInputStream(String id) {
        try {
            LocalTempFileCache.validExistAndCreate();
            File file = LocalTempFileCache.getFile(id);
            if (file.exists()) {
                return new FileInputStream(file);
            }
            return null;
        }
        catch (Exception var5) {
            throw new KDBizException(BosErrorCode.downloadFailed, new Object[]{"id: " + id, var5});
        }
    }

    public static boolean remove(String id) {
        try {
            LocalTempFileCache.validExistAndCreate();
            File file = LocalTempFileCache.getFile(id);
            logger.info("delete file id:{}", (Object)id);
            if (file.exists()) {
                Files.delete(file.toPath());
            }
            return true;
        }
        catch (Exception var4) {
            throw new KDException(BosErrorCode.deleteFailed, "delete id:" + id, (Throwable)var4);
        }
    }

    public static boolean batchRemove(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return true;
        }
        for (String id : ids) {
            try {
                LocalTempFileCache.remove(id);
            }
            catch (Exception e) {
                logger.error("\u79fb\u9664\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38id:{}", (Object)id, (Object)e);
                return false;
            }
        }
        return true;
    }

    private static void writeToFileByAppendType(File file, InputStream inputStream) {
        if (inputStream == null) {
            throw new KDBizException("\u5f85\u5b58\u50a8\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        LocalTempFileCache.doWriteToFile(file, inputStream, true);
    }

    private static void doWriteToFile(File file, InputStream input, boolean isAppend) {
        byte[] buffer = new byte[8192];
        try (FileOutputStream out = new FileOutputStream(file, isAppend);){
            int index;
            while ((index = input.read(buffer)) != -1) {
                out.write(buffer, 0, index);
            }
            out.flush();
        }
        catch (IOException var31) {
            throw new KDBizException("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
    }

    private static String getClientPath() {
        if (cachePath == null || cachePath.length() == 0) {
            URL resource = LocalTempFileCache.class.getClassLoader().getResource("");
            String string = cachePath = resource != null ? resource.getPath() : System.getProperty("user.dir");
        }
        if (!StringUtils.isEmpty((String)cachePath)) {
            cachePath = !cachePath.endsWith("/") && !cachePath.endsWith("\\") ? cachePath.concat("/") : cachePath;
        }
        return cachePath;
    }

    private static void validExistAndCreate() {
        boolean mkdirs;
        File parentFileInfo = LocalTempFileCache.getParentFileInfo();
        if (!parentFileInfo.exists() && !(mkdirs = parentFileInfo.mkdirs())) {
            throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
    }

    public static File getFile(String key) {
        return new File(LocalTempFileCache.getClientPath() + "temp/", LocalTempFileCache.getTempFileName(key));
    }

    private static String getTempFileName(String key) {
        return key + "." + temp_file_suffix;
    }

    private static File getParentFileInfo() {
        return new File(LocalTempFileCache.getClientPath(), LocalTempFileCache.getTempParentPath());
    }

    private static String getTempParentPath() {
        return "temp/";
    }

    private static String getFileId(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return StringUtils.getEmpty();
        }
        return path.substring(path.lastIndexOf(File.separatorChar) + 1, path.lastIndexOf(46));
    }

    private static void clearTimeoutKeys() {
        File[] fileDirs;
        File parentFileInfo = LocalTempFileCache.getParentFileInfo();
        if (parentFileInfo.isDirectory() && (fileDirs = parentFileInfo.listFiles()) != null && fileDirs.length > 0) {
            for (File file : fileDirs) {
                if (!file.exists() || !file.isFile() || !file.getName().endsWith(temp_file_suffix) || file.lastModified() + 600000L >= System.currentTimeMillis()) continue;
                String fileId = LocalTempFileCache.getFileId(file.getPath());
                try {
                    logger.info("fileid:{},lastmodified:{}", (Object)fileId, (Object)file.lastModified());
                    Files.delete(LocalTempFileCache.getFile(fileId).toPath());
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6id:{}\u5220\u9664\u5f02\u5e38\uff0cio\u5f02\u5e38", (Object)fileId, (Object)e);
                }
            }
        }
    }

    private static void startClearTimer() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    logger.info("\u6267\u884c\u6e05\u9664\u672c\u5730\u4e34\u65f6\u6587\u4ef6...");
                    LocalTempFileCache.clearTimeoutKeys();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        };
        Timer timer = new Timer("ai-cvp-localTempFile-cleaner");
        timer.schedule(task, 1000L, 600000L);
    }

    public static String updateTempFileId(String tempFileId, String cosmicUrl, FileValidTypeEnum fileValidTypeEnum, FileService attachmentFileService) {
        boolean localTempFlag = CvpFileServiceUtils.fileExist(StorageTypeEnum.TMP, tempFileId);
        logger.info("fileid:{}\uff0c\u5b58\u5728\u6027\uff1a{}", (Object)tempFileId, (Object)localTempFlag);
        if (!localTempFlag) {
            boolean exists = attachmentFileService.exists(cosmicUrl);
            if (!exists) {
                throw new KDBizException(ResManager.loadKDString((String)((fileValidTypeEnum == FileValidTypeEnum.BASE ? "\u539f\u6587\u6863" : "\u6bd4\u5bf9\u6587\u6863") + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u4e0a\u4f20\u540e\u91cd\u8bd5\uff01"), (String)"LocalTempFileCache_001", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            tempFileId = CvpFileServiceUtils.attFile2TempFile(cosmicUrl);
        }
        logger.info("\u66f4\u65b0\u7f13\u5b58\u7ed3\u675f");
        return tempFileId;
    }

    static {
        LocalTempFileCache.startClearTimer();
        logger = LogFactory.getLog(BaseTempFileCache.class);
        cachePath = "./";
    }
}

