/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.ai.cvp.common.Enum.DistingushComFileTypeEnum;
import kd.ai.cvp.common.Enum.code.AlgoInfoConvertRecognizeEnum;
import kd.ai.cvp.common.Enum.perset.IDCBEnum;
import kd.ai.cvp.common.Enum.perset.IDCFEnum;
import kd.ai.cvp.common.Enum.perset.PersetEnum;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.AlgoResultDataVO;
import kd.ai.cvp.entity.OcrPlanTemplateField;
import kd.ai.cvp.entity.distinguish.AlgoData;
import kd.ai.cvp.entity.distinguish.OcrAlgoDistingshInfo;
import kd.ai.cvp.entity.distinguish.OcrResult;
import kd.ai.cvp.entity.template.Table;
import kd.ai.cvp.entity.template.TemplateDistInfo;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.PresetTemplateUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class OcrDistinguisUtils {
    private static Log logger = LogFactory.getLog(OcrDistinguisUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgoResultDataVO distinguishOcrImage(String businessobject, String templateNumber, String imagePath) {
        AlgoResultDataVO resultData;
        String result = null;
        InputStream originInputStream = null;
        InputStream pdfFirstInputStream = null;
        InputStream imageInputStream = null;
        InputStream zipImageInputStream = null;
        try {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(3);
            if (StringUtils.isEmpty((CharSequence)imagePath)) {
                throw new KDBizException("\u5f85\u8bc6\u522b\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            String suffixStr = imagePath.substring(imagePath.lastIndexOf(46) + 1);
            String base64 = null;
            originInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(imagePath);
            if (suffixStr.equalsIgnoreCase(DistingushComFileTypeEnum.PDF.getVlaue())) {
                pdfFirstInputStream = OcrControlUtils.getPDFFirstInputStream(originInputStream);
                imageInputStream = OcrControlUtils.getImageInputStreamByPDFInputStream(pdfFirstInputStream);
                zipImageInputStream = OcrControlUtils.getZipImageInputStream(imageInputStream, false);
                base64 = OcrControlUtils.getFileBase64ByIO(zipImageInputStream);
            } else if (Arrays.asList(DistingushComFileTypeEnum.IMAGE.getVlaue().split(",")).contains(suffixStr.toLowerCase())) {
                zipImageInputStream = OcrControlUtils.getZipImageInputStream(originInputStream, true);
                base64 = OcrControlUtils.getFileBase64ByIO(zipImageInputStream);
            }
            DynamicObject template = OcrControlUtils.getBindingObjCacheByNumber("cvp_template", templateNumber);
            list.add(new BasicNameValuePair("imageBase64", base64));
            list.add(new BasicNameValuePair("ocrId", String.valueOf(template.get("algoid"))));
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
            result = OcrHttpClientUtils.kdCloudHttpClientPost("/template/recognize", (HttpEntity)httpEntity);
            OcrAlgoDistingshInfo info = (OcrAlgoDistingshInfo)JSON.parseObject((String)result, OcrAlgoDistingshInfo.class);
            if (info.getErrorCode() != 0) {
                String message = AlgoInfoConvertRecognizeEnum.getMessage(info.getErrorCode());
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    throw new KDBizException(message);
                }
                throw new KDBizException(info.getDescription());
            }
            resultData = OcrDistinguisUtils.setAlgoResultData(businessobject, template, info);
        }
        catch (Exception e) {
            try {
                resultData = AlgoResultDataVO.resultError(e.getMessage() != null ? e.getMessage() : "OCR Algo Exception");
                logger.error(String.format("\u6a21\u7248\u7f16\u53f7\uff1a%s - \u81ea\u5b9a\u4e49\u6a21\u677f\u7b97\u6cd5\u7aef\u8bc6\u522b\u5f02\u5e38,\u8bc6\u522b\u7ed3\u679c\u4e3a: %s", templateNumber, result));
            }
            catch (Throwable throwable) {
                StreamHandleUtils.closeResource(originInputStream);
                StreamHandleUtils.closeResource(pdfFirstInputStream);
                StreamHandleUtils.closeResource(imageInputStream);
                StreamHandleUtils.closeResource(zipImageInputStream);
                throw throwable;
            }
            StreamHandleUtils.closeResource(originInputStream);
            StreamHandleUtils.closeResource(pdfFirstInputStream);
            StreamHandleUtils.closeResource(imageInputStream);
            StreamHandleUtils.closeResource(zipImageInputStream);
        }
        StreamHandleUtils.closeResource(originInputStream);
        StreamHandleUtils.closeResource(pdfFirstInputStream);
        StreamHandleUtils.closeResource(imageInputStream);
        StreamHandleUtils.closeResource(zipImageInputStream);
        return resultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlgoResultDataVO distinguishPersetImage(String businessobject, String templateNumber, String imagePath, Map<String, String> bizParam, String api, Class<? extends PersetEnum> clazz) {
        AlgoResultDataVO resultData;
        String fileBase64 = null;
        InputStream originInputStream = null;
        InputStream pdfFirstInputStream = null;
        InputStream imageInputStream = null;
        InputStream zipImageInputStream = null;
        try {
            HttpEntity httpEntity;
            if (StringUtils.isEmpty((CharSequence)imagePath)) {
                throw new KDBizException("\u5f85\u8bc6\u522b\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            logger.info("imagePath:{}", (Object)imagePath);
            String suffixStr = imagePath.substring(imagePath.lastIndexOf(46) + 1);
            logger.info("suffixStr:{}", (Object)suffixStr);
            boolean isPdf = false;
            originInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(imagePath);
            if (suffixStr.equalsIgnoreCase(DistingushComFileTypeEnum.PDF.getVlaue())) {
                isPdf = true;
                pdfFirstInputStream = OcrControlUtils.getPDFFirstInputStream(originInputStream);
                imageInputStream = OcrControlUtils.getImageInputStreamByPDFInputStream(pdfFirstInputStream);
                zipImageInputStream = OcrControlUtils.getZipImageInputStream(imageInputStream, false);
            } else if (Arrays.asList(DistingushComFileTypeEnum.IMAGE.getVlaue().split(",")).contains(suffixStr.toLowerCase())) {
                zipImageInputStream = OcrControlUtils.getZipImageInputStream(originInputStream, true);
            }
            if ("/vatinvoice/recognition/five".equals(api)) {
                httpEntity = OcrHttpClientUtils.getHttpFileEntity(zipImageInputStream, "file");
            } else {
                ArrayList<Object> list = new ArrayList<Object>(2);
                if (zipImageInputStream == null) {
                    throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrDistinguishUtils_110", (String)"ai-cvp-common", (Object[])new Object[0])), new Object[0]);
                }
                fileBase64 = OcrControlUtils.getFileBase64ByIO(zipImageInputStream);
                if ("/presetocr/idcard/recognize".equals(api)) {
                    list.add(new BasicNameValuePair("imageData", fileBase64));
                    String cardSide = null;
                    if (IDCBEnum.class.equals(clazz)) {
                        cardSide = "FRONT";
                    } else if (IDCFEnum.class.equals(clazz)) {
                        cardSide = "BACK";
                    }
                    list.add(new BasicNameValuePair("cardSide", cardSide));
                } else if ("/template/bankTicket".equals(api) || "/presetocr/general/spotting".equals(api)) {
                    if ("/template/bankTicket".equals(api)) {
                        List<NameValuePair> allParam = CommonUtil.addBizParam(bizParam);
                        if (allParam != null && !allParam.isEmpty()) {
                            list.addAll(allParam);
                        }
                        logger.info("list\u989d\u5916\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(list));
                        if (isPdf) {
                            originInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(imagePath);
                            fileBase64 = OcrControlUtils.getFileBase64ByIO(originInputStream);
                        }
                    }
                    list.add(new BasicNameValuePair("imageBase64", fileBase64));
                } else {
                    list.add(new BasicNameValuePair("imageData", fileBase64));
                }
                httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
            }
            OcrAlgoDistingshInfo responseVO = PresetTemplateUtils.persetDataChangeByBase64(httpEntity, api, clazz);
            DynamicObject template = OcrControlUtils.getBindingObjCacheByNumber("cvp_template", templateNumber);
            resultData = OcrDistinguisUtils.setAlgoResultData(businessobject, template, responseVO);
        }
        catch (Exception e) {
            try {
                resultData = AlgoResultDataVO.resultError(ResManager.loadKDString((String)"OCR \u8bc6\u522b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"OcrDistinguisUtils_01", (String)"ai-cvp-common", (Object[])new Object[0]));
                logger.error("\u9884\u7f6e\u6a21\u677f\u8bc6\u522b\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamHandleUtils.closeResource(originInputStream);
                StreamHandleUtils.closeResource(pdfFirstInputStream);
                StreamHandleUtils.closeResource(imageInputStream);
                StreamHandleUtils.closeResource(zipImageInputStream);
                throw throwable;
            }
            StreamHandleUtils.closeResource(originInputStream);
            StreamHandleUtils.closeResource(pdfFirstInputStream);
            StreamHandleUtils.closeResource(imageInputStream);
            StreamHandleUtils.closeResource(zipImageInputStream);
        }
        StreamHandleUtils.closeResource(originInputStream);
        StreamHandleUtils.closeResource(pdfFirstInputStream);
        StreamHandleUtils.closeResource(imageInputStream);
        StreamHandleUtils.closeResource(zipImageInputStream);
        return resultData;
    }

    public static AlgoResultDataVO setAlgoResultData(String businessobject, DynamicObject template, OcrAlgoDistingshInfo info) {
        AlgoResultDataVO resultData;
        HashMap<String, Map<String, Object>> ocrInfo = new HashMap<String, Map<String, Object>>(16);
        if (info.getErrorCode() == 0) {
            List<Map<String, String>> value = OcrDistinguisUtils.getTempaltePlanConfig(businessobject, template);
            AlgoData data = info.getData();
            OcrResult ocrResult = data.getOcrResult();
            Map<String, Object> recognitionArea = ocrResult.getRecognitionArea();
            Map<String, Object> text = OcrDistinguisUtils.getDataMap(value, recognitionArea);
            ocrInfo.put("textOcr", text);
            Map<String, List<List<Object>>> tables = ocrResult.getTable();
            if (tables != null) {
                Map<String, List<Map<String, Object>>> table = OcrDistinguisUtils.ListToObj(businessobject, data, template, value);
                ocrInfo.put("tablesOcr", table);
            }
            resultData = new AlgoResultDataVO(0, "OCR success", ocrInfo);
        } else {
            resultData = new AlgoResultDataVO(info.getErrorCode(), info.getDescription());
        }
        return resultData;
    }

    public static List<Map<String, String>> getTempaltePlanConfig(String businessobject, DynamicObject template) {
        DynamicObject plan = OcrControlUtils.getObjByPlanBusinessObject(businessobject);
        String configStr = (String)plan.get("templateconfig");
        JSONObject configMap = JSON.parseObject((String)configStr);
        String templateNumber = String.valueOf(template.getPkValue());
        Map planConfig = (Map)configMap.get((Object)templateNumber);
        OcrPlanTemplateField ocrPlanConfigField = (OcrPlanTemplateField)JSON.parseObject((String)planConfig.toString(), OcrPlanTemplateField.class);
        return ocrPlanConfigField.getValue();
    }

    public static Map<String, Object> getDataMap(List<Map<String, String>> value, Map<String, Object> recognitionArea) {
        HashMap<String, Object> text = new HashMap<String, Object>(16);
        for (Map<String, String> obj : value) {
            String key = obj.keySet().toArray(new String[0])[0];
            boolean flag = recognitionArea.containsKey(key);
            if (!flag) continue;
            text.put(obj.get(key), recognitionArea.get(key));
        }
        text.remove("");
        return text;
    }

    private static Map<String, List<Map<String, Object>>> ListToObj(String businessobjectStr, AlgoData data, DynamicObject template, List<Map<String, String>> configs) {
        String templateConfigStr = template.getString("temptageinfo");
        TemplateDistInfo templateDistInfo = (TemplateDistInfo)JSON.parseObject((String)templateConfigStr, TemplateDistInfo.class);
        List<Table> templateTables = templateDistInfo.getDistinguishPos().getTable();
        HashMap<String, List<Map<String, Object>>> tables = new HashMap<String, List<Map<String, Object>>>(3);
        Map<String, List<List<Object>>> infoTables = data.getOcrResult().getTable();
        for (Table table : templateTables) {
            ArrayList list = new ArrayList(templateTables.size());
            List<List<Object>> hangValues = infoTables.get(table.getTableName());
            List<String> fields = table.getTableListName();
            for (int i = 0; i < hangValues.size(); ++i) {
                HashMap<String, Object> obj = new HashMap<String, Object>(templateTables.size());
                for (int j = 0; j < fields.size(); ++j) {
                    obj.put(table.getTableName() + "." + fields.get(j), hangValues.get(i).get(j));
                }
                HashMap configObj = new HashMap(fields.size());
                for (Map<String, String> configMap : configs) {
                    String key = configMap.keySet().toArray(new String[0])[0];
                    String fieldkey = configMap.get(key);
                    boolean flag = obj.containsKey(key);
                    if (!flag || !StringUtils.isNotEmpty((CharSequence)fieldkey)) continue;
                    configObj.put(fieldkey, obj.get(key));
                }
                Collection objValues = configObj.values();
                int nullCount = 0;
                for (Object v : objValues) {
                    if (!StringUtils.isBlank(v)) continue;
                    ++nullCount;
                }
                configObj.remove("");
                if (nullCount != objValues.size() && !configObj.isEmpty()) {
                    list.add(configObj);
                }
                nullCount = 0;
            }
            tables.put(table.getTableName(), list);
        }
        return tables;
    }

    public static AlgoResultData getAlgoResultData(String templateNumber, int requestType, String respStr) {
        AlgoResultData resultData = null;
        if (2 == requestType) {
            resultData = (AlgoResultData)JSON.parseObject((String)respStr, AlgoResultData.class);
        } else if (1 == requestType) {
            OcrAlgoDistingshInfo info = (OcrAlgoDistingshInfo)JSON.parseObject((String)respStr, OcrAlgoDistingshInfo.class);
            if (info.getErrorCode() != 0) {
                logger.error(String.format("\u7b97\u6cd5\u8bc6\u522b\u5f02\u5e38\uff1atraceId:%s ,\u7b97\u6cd5\u8fd4\u56de\u4fe1\u606f\uff1a%s", RequestContext.get().getTraceId(), respStr));
                return new AlgoResultData(info.getRequestId(), info.getErrorCode(), info.getDescription());
            }
            info.getData().getOcrResult().setOcrGeneralTableResultList(null);
            Map<String, List<List<Object>>> infoTables = info.getData().getOcrResult().getTable();
            if (infoTables != null) {
                DynamicObject template = OcrControlUtils.getBindingObjCacheByNumber("cvp_template", templateNumber);
                String templateConfigStr = template.getString("temptageinfo");
                TemplateDistInfo templateDistInfo = (TemplateDistInfo)JSON.parseObject((String)templateConfigStr, TemplateDistInfo.class);
                List<Table> templateTables = templateDistInfo.getDistinguishPos().getTable();
                for (Table table : templateTables) {
                    String tableName = table.getTableName();
                    List<String> headStrs = table.getTableListName();
                    ArrayList<String> headList = new ArrayList<String>(headStrs.size());
                    headList.addAll(headStrs);
                    List<List<Object>> tableData = infoTables.get(tableName);
                    int nullCount = 0;
                    ListIterator<List<Object>> it = tableData.listIterator();
                    while (it.hasNext()) {
                        List row = (List)it.next();
                        for (Object cell : row) {
                            if (!StringUtils.isBlank(cell)) continue;
                            ++nullCount;
                        }
                        if (nullCount == row.size()) {
                            it.remove();
                        }
                        nullCount = 0;
                    }
                    tableData.add(0, headList);
                }
            }
            resultData = new AlgoResultData(info.getRequestId(), info.getErrorCode(), info.getDescription(), info.getData().getOcrResult());
        }
        return resultData;
    }
}

