/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import kd.ai.cvp.entity.param.OcrParam;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.LocalTempFileCache;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrMCUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.FileNameUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class OcrHttpClientUtils {
    private static final Log logger = LogFactory.getLog(OcrHttpClientUtils.class);
    private static int default_connectionTimeout = 5000;
    private static int default_connectRequestTimeout = 5000;
    private static int default_readTimeout = 600000;
    private static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(default_connectionTimeout).setConnectionRequestTimeout(default_connectRequestTimeout).setSocketTimeout(default_readTimeout).build();
    private static HttpClientBuilder httpClientBuilder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(requestConfig).setMaxConnTotal(20).setMaxConnPerRoute(10);
    private static CloseableHttpClient httpClient = httpClientBuilder.build();

    public static String kdCloudHttpClientPost(String api, HttpEntity httpEntity) throws Exception {
        String traceId = RequestContext.get().getTraceId();
        return OcrHttpClientUtils.kdCloudHttpClientTraceIdPost(api, httpEntity, traceId);
    }

    public static String kdCloudHttpClientTraceIdPost(String api, HttpEntity httpEntity, String traceId) throws Exception {
        String method = "POST";
        Header[] headers = OcrHttpClientUtils.kdCloudPlatformHeader(method, api, null, traceId);
        String respStr = OcrHttpClientUtils.httpClientPostByHttpEntity(httpClient, api, httpEntity, headers);
        return OcrControlUtils.unicodeDecode(respStr);
    }

    public static byte[] kdCloudHttpClientPostForFile(String api, HttpEntity httpEntity) throws Exception {
        String traceId = RequestContext.get().getTraceId();
        String method = "POST";
        Header[] headers = OcrHttpClientUtils.kdCloudPlatformHeader(method, api, null, traceId);
        return OcrHttpClientUtils.httpClientPostForBytesByHttpEntity(httpClient, api, httpEntity, headers);
    }

    private static byte[] httpClientPostForBytesByHttpEntity(CloseableHttpClient httpClient, String api, HttpEntity httpEntity, Header[] headers) {
        byte[] resultByte;
        block15: {
            String url = OcrMCUtils.getOcrServiceIp();
            HttpPost httpPost = new HttpPost(url + api);
            httpPost.setConfig(OcrHttpClientUtils.getTimeOutConfig());
            httpPost.setEntity(httpEntity);
            httpPost.setHeaders(headers);
            logger.info(String.format("%s%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3\u83b7\u53d6 traceId: %s", url, api, RequestContext.get().getTraceId()));
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                logger.info(String.format("%s%s \u63a5\u53e3,POST \u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: traceId: %s", url, api, RequestContext.get().getTraceId()));
                StatusLine statusLine = httpResponse.getStatusLine();
                HttpEntity entity = httpResponse.getEntity();
                if (200 == statusLine.getStatusCode()) {
                    resultByte = EntityUtils.toByteArray((HttpEntity)entity);
                    break block15;
                }
                String message = ResManager.loadKDString((String)String.format("\u8bf7\u6c42\u5f02\u5e38\uff1aStatusLine: %s, Body: %s", SerializationUtils.toJsonString((Object)statusLine), EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8)), (String)"OcrHttpClientUtils_0", (String)"ai-cvp-commom", (Object[])new Object[0]);
                logger.error(String.format("%s%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3 traceId: %s,\u9519\u8bef\u4fe1\u606f\uff1a%s", url, api, RequestContext.get().getTraceId(), message));
                throw new KDBizException(new ErrorCode("30113", message), new Object[0]);
            }
            catch (IOException e) {
                logger.error(String.format("%s%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3 traceId: %s,\u9519\u8beferror\u4fe1\u606f\uff1a%s", url, api, RequestContext.get().getTraceId(), e.getMessage()), (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u91cd\u8bd5", (String)"OcrHttpClientUtils_0", (String)"ai-cvp-commom", (Object[])new Object[0]));
            }
        }
        return resultByte;
    }

    public static String kdCloudHttpClientGet(String api, List<OcrParam> params) throws Exception {
        String method = "GET";
        String traceId = RequestContext.get().getTraceId();
        Header[] headers = OcrHttpClientUtils.kdCloudPlatformHeader(method, api, params, traceId);
        return OcrHttpClientUtils.httpClientGet(httpClient, api, headers, params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String httpGetResponseFileForImageUpload(String api, List<OcrParam> params, String imageId, RequestContext rc) throws Exception {
        String url = OcrMCUtils.getOcrServiceIp() + api;
        HttpGet httpGet = OcrHttpClientUtils.getHttpGetObj(params, api, url);
        FileService imageFileService = FileServiceFactory.getImageFileService();
        String fullFileName = String.format("%s.%s", imageId, "png");
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        String path = FileNameUtils.getBillImageFileName((String)tenantId, (String)accountId, (String)"cvp_tda_task_image", (String)fullFileName);
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
            logger.info(String.format("%s \u63a5\u53e3,GET \u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: traceId: %s", url, RequestContext.get().getTraceId()));
            HttpEntity entity = httpResponse.getEntity();
            if (200 == httpResponse.getStatusLine().getStatusCode()) {
                InputStream content = entity.getContent();
                FileItem item = new FileItem(fullFileName, path, content);
                String string = imageFileService.upload(item);
                return string;
            }
            throw new KDBizException(ResManager.loadKDString((String)String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a%s, Body: %s", SerializationUtils.toJsonString((Object)httpResponse.getStatusLine()), EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8)), (String)"OcrHttpClientUtils_0", (String)"ai-cvp-commom", (Object[])new Object[0]));
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u91cd\u8bd5", (String)"OcrHttpClientUtils_1", (String)"ai-cvp-commom", (Object[])new Object[0]));
        }
    }

    public static byte[] httpGetImageUrl(String api, List<OcrParam> params) throws Exception {
        byte[] bytes;
        InputStream content;
        block17: {
            String url = OcrMCUtils.getOcrServiceIp() + api;
            HttpGet httpGet = OcrHttpClientUtils.getHttpGetObj(params, api, url);
            content = null;
            bytes = null;
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
                logger.info(String.format("%s \u63a5\u53e3,GET \u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: traceId: %s", url, RequestContext.get().getTraceId()));
                HttpEntity entity = httpResponse.getEntity();
                if (200 == httpResponse.getStatusLine().getStatusCode()) {
                    content = entity.getContent();
                    bytes = StreamHandleUtils.copyStream(content);
                    break block17;
                }
                throw new KDBizException(ResManager.loadKDString((String)String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a%s", SerializationUtils.toJsonString((Object)httpResponse.getStatusLine())), (String)"OcrHttpClientUtils_0", (String)"ai-cvp-commom", (Object[])new Object[0]));
            }
            catch (IOException e) {
                try {
                    throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u91cd\u8bd5", (String)"OcrHttpClientUtils_1", (String)"ai-cvp-commom", (Object[])new Object[0]));
                }
                catch (Throwable throwable) {
                    StreamHandleUtils.closeResource(content);
                    throw throwable;
                }
            }
        }
        StreamHandleUtils.closeResource(content);
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String httpGetResponseFileAndUploadCosmic(String api, List<OcrParam> params, String fileId) throws Exception {
        String url = OcrMCUtils.getOcrServiceIp() + api;
        HttpGet httpGet = OcrHttpClientUtils.getHttpGetObj(params, api, url);
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
            logger.info(String.format("%s \u63a5\u53e3,GET \u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: traceId: %s", url, RequestContext.get().getTraceId()));
            HttpEntity entity = httpResponse.getEntity();
            if (200 == httpResponse.getStatusLine().getStatusCode()) {
                InputStream content = entity.getContent();
                String string = LocalTempFileCache.saveToLocalTempPathByAppendType(content, fileId);
                return string;
            }
            throw new KDBizException(ResManager.loadKDString((String)String.format("\u8bf7\u6c42\u5f02\u5e38\uff1a%s, Body: %s", SerializationUtils.toJsonString((Object)httpResponse.getStatusLine()), EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8)), (String)"OcrHttpClientUtils_0", (String)"ai-cvp-commom", (Object[])new Object[0]));
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u91cd\u8bd5", (String)"OcrHttpClientUtils_1", (String)"ai-cvp-commom", (Object[])new Object[0]));
        }
    }

    private static HttpGet getHttpGetObj(List<OcrParam> params, String api, String url) throws Exception {
        StringBuilder paramBuilder = new StringBuilder();
        String method = "GET";
        String traceId = RequestContext.get().getTraceId();
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                if (i == 0) {
                    paramBuilder.append('?');
                } else {
                    paramBuilder.append('&');
                }
                params.get(i).setValue(URLEncoder.encode(params.get(i).getValue().toString(), "UTF-8"));
                paramBuilder.append(params.get(i).getkParam()).append('=').append(params.get(i).getValue());
            }
        }
        Header[] headers = OcrHttpClientUtils.kdCloudPlatformHeader(method, api, params, traceId);
        HttpGet httpGet = new HttpGet();
        httpGet.setConfig(OcrHttpClientUtils.getTimeOutConfig());
        httpGet.setURI(new URI(url.concat(paramBuilder.toString())));
        httpGet.setHeaders(headers);
        return httpGet;
    }

    public static String httpClientGet(CloseableHttpClient httpClient, String api, Header[] headers, List<OcrParam> params) throws Exception {
        String url;
        String result;
        block19: {
            result = "";
            url = OcrMCUtils.getOcrServiceIp() + api;
            StringBuilder requstUrl = new StringBuilder(url);
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    if (i == 0) {
                        requstUrl.append('?');
                    } else {
                        requstUrl.append('&');
                    }
                    requstUrl.append(params.get(i).getkParam()).append('=').append(params.get(i).getValue());
                }
            }
            HttpGet httpGet = new HttpGet();
            httpGet.setConfig(OcrHttpClientUtils.getTimeOutConfig());
            httpGet.setURI(new URI(requstUrl.toString()));
            httpGet.setHeaders(headers);
            logger.info(String.format("%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3 traceId: %s", url, RequestContext.get().getTraceId()));
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
                logger.info(String.format("%s \u63a5\u53e3,GET \u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: traceId: %s", url, RequestContext.get().getTraceId()));
                StatusLine statusLine = httpResponse.getStatusLine();
                HttpEntity entity = httpResponse.getEntity();
                if (200 == httpResponse.getStatusLine().getStatusCode()) {
                    result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    break block19;
                }
                String message = ResManager.loadKDString((String)String.format("\u8bf7\u6c42\u5f02\u5e38\uff1aStatusLine: %s, Body: %s", SerializationUtils.toJsonString((Object)statusLine), EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8)), (String)"OcrHttpClientUtils_0", (String)"ai-cvp-commom", (Object[])new Object[0]);
                logger.error(String.format("%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3 traceId: %s,\u9519\u8bef\u4fe1\u606f\uff1a%s", url, RequestContext.get().getTraceId(), message));
                throw new KDBizException(message);
            }
            catch (IOException e) {
                logger.error(String.format("%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3 traceId: %s,\u9519\u8bef\u4fe1\u606f\uff1a%s", url, RequestContext.get().getTraceId(), e.getMessage()), (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u91cd\u8bd5", (String)"OcrHttpClientUtils_1", (String)"ai-cvp-commom", (Object[])new Object[0]));
            }
        }
        logger.info(String.format("%s \u63a5\u53e3,GET \u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: traceId: %s", url, RequestContext.get().getTraceId()));
        return result;
    }

    public static HttpEntity getHttpFileEntity(InputStream fileIn, String paramName, String ocrId) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        InputStreamBody bin = new InputStreamBody(fileIn, new Date().getTime() + ".png");
        multipartEntityBuilder.addPart(paramName, (ContentBody)bin);
        if (kd.bos.util.StringUtils.isNotEmpty((String)ocrId)) {
            multipartEntityBuilder.addPart("ocrId", (ContentBody)new StringBody(ocrId, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        }
        HttpEntity httpEntity = multipartEntityBuilder.build();
        return httpEntity;
    }

    public static HttpEntity getHttpFileEntity(InputStream fileIn, String paramName) {
        return OcrHttpClientUtils.getHttpFileEntity(fileIn, paramName, null);
    }

    public static String httpClientPostByHttpEntity(CloseableHttpClient httpClient, String api, HttpEntity httpEntity, Header[] headers) {
        String result;
        block15: {
            String url = OcrMCUtils.getOcrServiceIp();
            HttpPost httpPost = new HttpPost(url + api);
            httpPost.setConfig(OcrHttpClientUtils.getTimeOutConfig());
            httpPost.setEntity(httpEntity);
            httpPost.setHeaders(headers);
            logger.info(String.format("%s%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3 traceId: %s", url, api, RequestContext.get().getTraceId()));
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                logger.info(String.format("%s%s \u63a5\u53e3,POST \u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: traceId: %s", url, api, RequestContext.get().getTraceId()));
                StatusLine statusLine = httpResponse.getStatusLine();
                HttpEntity entity = httpResponse.getEntity();
                if (200 == statusLine.getStatusCode()) {
                    result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                    break block15;
                }
                String message = ResManager.loadKDString((String)String.format("\u8bf7\u6c42\u5f02\u5e38\uff1aStatusLine: %s, Body: %s", SerializationUtils.toJsonString((Object)statusLine), EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8)), (String)"OcrHttpClientUtils_0", (String)"ai-cvp-commom", (Object[])new Object[0]);
                logger.error(String.format("%s%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3 traceId: %s,\u9519\u8bef\u4fe1\u606f\uff1a%s", url, api, RequestContext.get().getTraceId(), message));
                throw new KDBizException(new ErrorCode("30113", message), new Object[0]);
            }
            catch (IOException e) {
                logger.error(String.format("%s%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u63a5\u53e3 traceId: %s,\u9519\u8beferror\u4fe1\u606f\uff1a%s", url, api, RequestContext.get().getTraceId(), e.getMessage()), (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u91cd\u8bd5", (String)"OcrHttpClientUtils_0", (String)"ai-cvp-commom", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private static RequestConfig getTimeOutConfig() {
        return RequestConfig.custom().setConnectTimeout(default_connectionTimeout).setSocketTimeout(default_readTimeout).build();
    }

    private static Header[] kdCloudPlatformHeader(String method, String path, List<OcrParam> params, String traceId) throws Exception {
        path = OcrHttpClientUtils.getUri(path);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cvp_service_auth_config", (String)"id,clientid,publiccipher", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1)});
        if (Objects.isNull(dynamicObject)) {
            throw new KDBizException("\u9884\u7f6e\u79d8\u94a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u90e8\u7f72\u5143\u6570\u636e.");
        }
        String xApiClientID = dynamicObject.getString("clientid");
        String publicKeySecret = dynamicObject.getString("publiccipher");
        String CLIENT_SECRET = CommonUtil.decodeString(publicKeySecret);
        String xApiAuthVersion = "2.0";
        final String xApiTimeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        final String xApiNonce = UUID.randomUUID().toString().replace("-", "");
        TreeMap<String, String> xApiSignHeaders = new TreeMap<String, String>(){
            {
                this.put("X-Api-Nonce", xApiNonce);
                this.put("X-Api-TimeStamp", xApiTimeStamp);
            }
        };
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        if (params != null) {
            for (OcrParam param : params) {
                paramMap.put(param.getkParam(), String.valueOf(param.getValue()));
            }
        }
        String signature = URLEncoder.encode(CommonUtil.sign(method, path, paramMap, (SortedMap<String, String>)xApiSignHeaders, CLIENT_SECRET), "utf-8").replaceAll("%0D%0A", "%20");
        return new BasicHeader[]{new BasicHeader("X-Api-ClientID", xApiClientID), new BasicHeader("X-Api-Auth-Version", xApiAuthVersion), new BasicHeader("X-Api-TimeStamp", String.valueOf(xApiTimeStamp)), new BasicHeader("X-Api-Nonce", String.valueOf(xApiNonce)), new BasicHeader("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce"), new BasicHeader("X-Request-Id", traceId), new BasicHeader("X-Api-Signature", URLDecoder.decode(signature, "utf-8").replaceAll(" ", "")), new BasicHeader("accept", "*/*"), new BasicHeader("connection", "Keep-Alive")};
    }

    public static String getUri(String api) {
        String host = System.getProperty("cvp.ocr.service.host");
        String hostOld = System.getProperty("algo.ocr.service.ip");
        String string = host = kd.bos.util.StringUtils.isEmpty((String)host) ? hostOld : host;
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            String paths = "";
            String path = "";
            if ((host = host.trim()).contains("https")) {
                paths = host.replaceAll("https://", "");
            } else if (host.contains("http")) {
                paths = host.replaceAll("http://", "");
            }
            int index = paths.indexOf(47);
            if (index > -1 && (path = paths.substring(index)).endsWith("/")) {
                path = path.substring(0, path.lastIndexOf(47));
            }
            StringBuilder newpath = new StringBuilder(path);
            if (api.startsWith("/")) {
                newpath.append(api);
            } else {
                newpath.append('/').append(api);
            }
            return newpath.toString();
        }
        return api;
    }
}

