/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;

public class OcrSimilarityDictUtils {
    private static DistributeSessionlessCache chineseDictCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ai_cvp_cache");
    private static final String dictPath = "/dict/char_meta.txt";

    public static String getDictValue(String key) throws IOException {
        return (String)OcrSimilarityDictUtils.getDict().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributeSessionlessCache getDict() throws IOException {
        Class<OcrSimilarityDictUtils> clazz = OcrSimilarityDictUtils.class;
        synchronized (OcrSimilarityDictUtils.class) {
            if (chineseDictCache == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return OcrSimilarityDictUtils.initDictCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return chineseDictCache;
        }
    }

    private static DistributeSessionlessCache initDictCache() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(OcrSimilarityDictUtils.class.getResourceAsStream(dictPath), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] dicts = line.split("\\t");
                chineseDictCache.put(dicts[1], (Object)dicts[3], -1);
            }
        }
        return chineseDictCache;
    }
}

