/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import kd.ai.cvp.utils.Levenshtein;
import kd.bos.exception.KDBizException;

public class OcrStringSimilarityUitls {
    private final Levenshtein l = new Levenshtein();
    private static OcrStringSimilarityUitls stringSimilarity;

    private OcrStringSimilarityUitls() {
    }

    public static synchronized OcrStringSimilarityUitls getInstance() {
        if (stringSimilarity == null) {
            stringSimilarity = new OcrStringSimilarityUitls();
        }
        return stringSimilarity;
    }

    public final double distance(String origin, String target) {
        if (origin == null) {
            throw new KDBizException("origin must not be null");
        }
        if (target == null) {
            throw new KDBizException("target must not be null");
        }
        if (origin.equals(target)) {
            return 0.0;
        }
        int m_len = Math.max(origin.length(), target.length());
        if (m_len == 0) {
            return 0.0;
        }
        return this.l.distance(origin, target) / (double)m_len;
    }

    public final double similarity(String origin, String target) {
        return 1.0 - this.distance(origin, target);
    }
}

