/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kd.ai.cvp.common.Enum.perset.IDCBEnum;
import kd.ai.cvp.common.Enum.perset.IDCFEnum;
import kd.ai.cvp.common.Enum.perset.PersetEnum;
import kd.ai.cvp.entity.KdResultVO;
import kd.ai.cvp.entity.OcrPersetAlgoResponseVO;
import kd.ai.cvp.entity.OcrRecResponseVO;
import kd.ai.cvp.entity.distinguish.AlgoData;
import kd.ai.cvp.entity.distinguish.OcrAlgoDistingshInfo;
import kd.ai.cvp.entity.distinguish.OcrResult;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class PresetTemplateUtils {
    private static Log log = LogFactory.getLog(PresetTemplateUtils.class);
    private static final String ENUM_NAME_GENERALTABLEPRESETENUM = "kd.ai.cvp.common.Enum.perset.GeneralTablePresetEnum";

    private PresetTemplateUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OcrRecResponseVO presetDistinguishTestNew(String api, Class<? extends PersetEnum> clazz, String base64Str, Map<String, String> bizParam) throws Exception {
        OcrRecResponseVO ocrRecResponseVO = new OcrRecResponseVO();
        ByteArrayInputStream in = null;
        try {
            HttpEntity httpEntity;
            if ("/vatinvoice/recognition/five".equals(api)) {
                in = OcrControlUtils.getByteArrayInputStreamByBase64(base64Str);
                httpEntity = OcrHttpClientUtils.getHttpFileEntity(in, "file");
            } else {
                ArrayList<Object> list = new ArrayList<Object>(2);
                if ("/presetocr/idcard/recognize".equals(api)) {
                    list.add(new BasicNameValuePair("imageData", base64Str));
                    String cardSide = null;
                    if (IDCBEnum.class.equals(clazz)) {
                        cardSide = "FRONT";
                    } else if (IDCFEnum.class.equals(clazz)) {
                        cardSide = "BACK";
                    }
                    list.add(new BasicNameValuePair("cardSide", cardSide));
                } else if ("/template/bankTicket".equals(api)) {
                    List<NameValuePair> bizList;
                    if (bizParam != null && !bizParam.isEmpty() && !(bizList = CommonUtil.addBizParam(bizParam)).isEmpty()) {
                        list.addAll(bizList);
                    }
                    log.info("list\u989d\u5916\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(list));
                    list.add(new BasicNameValuePair("imageBase64", base64Str));
                } else if ("/presetocr/general/spotting".equals(api)) {
                    list.add(new BasicNameValuePair("imageBase64", base64Str));
                } else {
                    list.add(new BasicNameValuePair("imageData", base64Str));
                }
                httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
            }
            OcrAlgoDistingshInfo reps = PresetTemplateUtils.persetDataChangeByBase64(httpEntity, api, clazz);
            int errorCode = reps.getErrorCode();
            if (0 != errorCode) {
                log.error(String.format("OCR \u9884\u7f6e\u6a21\u7248\u6d4b\u8bd5\u529f\u80fd\uff0c\u7b97\u6cd5\u8fd4\u56de\u5f02\u5e38,traceId:%s ,\u4fe1\u606f\uff1a%s", RequestContext.get().getTraceId(), SerializationUtils.toJsonString((Object)reps)));
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7f6e\u6a21\u677f\u6d4b\u8bd5\u5f02\u5e38\uff0c\u7b97\u6cd5\u63a5\u53e3\u5f02\u5e38\u3002", (String)"PresetTemplateUtils_03", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            ocrRecResponseVO.setJsonData(reps.getData().getOriginalData());
            reps.getData().setOriginalData("");
            ocrRecResponseVO.setOcrData(reps.getData());
        }
        catch (Throwable throwable) {
            StreamHandleUtils.closeResource(in);
            throw throwable;
        }
        StreamHandleUtils.closeResource(in);
        return ocrRecResponseVO;
    }

    public static OcrAlgoDistingshInfo persetDataChangeByBase64(HttpEntity httpEntity, String api, Class<? extends PersetEnum> clazz) throws Exception {
        String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost(api, httpEntity);
        Object originData = PresetTemplateUtils.preHandleJsonData(resultStr);
        OcrAlgoDistingshInfo algoInfo = PresetTemplateUtils.algoInfoConvert(clazz, resultStr);
        if (algoInfo.getErrorCode() == 0 && algoInfo.getData() != null) {
            algoInfo.getData().setOriginalData(originData);
        }
        return algoInfo;
    }

    private static Object preHandleJsonData(String resultStr) {
        OcrPersetAlgoResponseVO algoVO = (OcrPersetAlgoResponseVO)JSON.parseObject((String)resultStr, OcrPersetAlgoResponseVO.class);
        int errorCode = algoVO.getErrorCode();
        if (0 == errorCode) {
            return algoVO.getData();
        }
        return null;
    }

    public static OcrAlgoDistingshInfo algoInfoConvert(Class<? extends PersetEnum> clazz, String resultStr) {
        BiFunction<Object, Class<? extends PersetEnum>, OcrAlgoDistingshInfo> gtpFunc;
        switch (clazz.getTypeName()) {
            case "kd.ai.cvp.common.Enum.perset.GeneralTablePresetEnum": {
                gtpFunc = PresetTemplateUtils::algoInfoConvertForGTPFunc;
                break;
            }
            default: {
                gtpFunc = PresetTemplateUtils::algoInfoConvertDefault;
            }
        }
        return PresetTemplateUtils.handleAlgoResultFunc(gtpFunc, resultStr, clazz);
    }

    private static OcrAlgoDistingshInfo algoInfoConvertForGTPFunc(Object algoVOObj, Class<? extends PersetEnum> clazz) {
        AlgoData algoData = null;
        OcrPersetAlgoResponseVO algoVO = (OcrPersetAlgoResponseVO)algoVOObj;
        try {
            Object data = algoVO.getData();
            OcrResult ocrResult = new OcrResult();
            ocrResult.setOcrGeneralTableResultList((List)data);
            algoData = new AlgoData();
            algoData.setOcrResult(ocrResult);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PresetTemplateUtils_02", (String)"ai-cvp", (Object[])new Object[0]));
        }
        return new OcrAlgoDistingshInfo(algoVO.getRequestId(), algoVO.getDescription(), algoData, algoVO.getErrorCode());
    }

    private static OcrAlgoDistingshInfo algoInfoConvertDefault(Object algoVOObj, Class<? extends PersetEnum> clazz) {
        AlgoData algoData = null;
        OcrPersetAlgoResponseVO algoVO = (OcrPersetAlgoResponseVO)algoVOObj;
        try {
            Object data = algoVO.getData();
            if (data instanceof JSONObject) {
                JSONObject dataMap = (JSONObject)data;
                boolean flag = dataMap.containsKey((Object)"resource");
                if (flag) {
                    JSONObject resource = (JSONObject)dataMap.get((Object)"resource");
                    PresetTemplateUtils.getOneData(algoVO, clazz, resource);
                } else {
                    PresetTemplateUtils.getOneData(algoVO, clazz, dataMap);
                }
            } else if (data instanceof JSONArray) {
                JSONArray dataArray = (JSONArray)data;
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject obj = (JSONObject)dataArray.get(i);
                    PresetTemplateUtils.getOneData(algoVO, clazz, obj);
                }
            }
            algoData = (AlgoData)algoVO.getData();
        }
        catch (Exception e) {
            throw new KDBizException("\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        return new OcrAlgoDistingshInfo(algoVO.getRequestId(), algoVO.getDescription(), algoData, algoVO.getErrorCode());
    }

    private static OcrAlgoDistingshInfo handleAlgoResultFunc(BiFunction<Object, Class<? extends PersetEnum>, OcrAlgoDistingshInfo> func, String resultStr, Class<? extends PersetEnum> clazz) {
        OcrPersetAlgoResponseVO algoVO = (OcrPersetAlgoResponseVO)JSON.parseObject((String)resultStr, OcrPersetAlgoResponseVO.class);
        int errorCode = algoVO.getErrorCode();
        if (0 == errorCode) {
            log.info(String.format("OCR \u4e91\u5e73\u53f0\u8c03\u7528\u7b97\u6cd5\u8bc6\u522b\u670d\u52a1\u6210\u529f: serverName\uff1a%s,traceId:%s , errorCode:%s : message:%s", clazz != null ? clazz.getName() : "GTPEnum", algoVO.getRequestId(), algoVO.getErrorCode(), algoVO.getDescription()));
            return func.apply(algoVO, clazz);
        }
        if (-1 == errorCode) {
            log.error(String.format("OCR \u4e91\u5e73\u53f0\u8c03\u7528\u7b97\u6cd5\u8bc6\u522b\u670d\u52a1\u5f02\u5e38-KDCloud\uff1atraceId:%s , %s : %s", RequestContext.get().getTraceId(), clazz.getName(), resultStr));
            KdResultVO kd = (KdResultVO)JSON.parseObject((String)resultStr, KdResultVO.class);
            return new OcrAlgoDistingshInfo(RequestContext.get().getTraceId(), "KDCloud info:" + kd.getDescription(), null, kd.getErrcode());
        }
        log.error(String.format("OCR \u7b97\u6cd5\u8bc6\u522b\u670d\u52a1\u5f02\u5e38\uff1atraceId:%s, %s : %s", RequestContext.get().getTraceId(), clazz.getName(), resultStr));
        return new OcrAlgoDistingshInfo(algoVO.getRequestId(), algoVO.getDescription(), null, algoVO.getErrorCode());
    }

    public static OcrPersetAlgoResponseVO getOneData(OcrPersetAlgoResponseVO responseVO, Class<? extends PersetEnum> clazz, JSONObject oneObj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (oneObj.containsKey((Object)"recongnizeDetail")) {
            oneObj = (JSONObject)oneObj.get((Object)"recongnizeDetail");
        }
        oneObj.remove((Object)"invoiceType");
        oneObj.remove((Object)"sealFlag");
        Set keys = oneObj.keySet();
        HashMap<String, Object> ocrData = new HashMap<String, Object>(keys.size());
        if (clazz != null) {
            Method method = clazz.getDeclaredMethod("getValue", String.class);
            PersetEnum enumConstants = clazz.getEnumConstants()[0];
            for (String key : keys) {
                Object value = method.invoke((Object)enumConstants, key);
                if (value == null) continue;
                ocrData.put(String.valueOf(value), oneObj.get((Object)key));
            }
            if (ocrData.size() <= 0) {
                for (PersetEnum e : clazz.getEnumConstants()) {
                    ocrData.put(e.getValue(), null);
                }
            }
        }
        OcrResult ocrResult = new OcrResult(ocrData);
        AlgoData algoData = new AlgoData(ocrResult);
        responseVO.setData(algoData);
        return responseVO;
    }

    public static void persetDistinguish(IFormView view, String rImageBase64, String api, Class<? extends PersetEnum> clazz) throws Exception {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(2);
        list.add(new BasicNameValuePair("imageData", rImageBase64));
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
        String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost(api, (HttpEntity)httpEntity);
        String unicodeDecode = OcrControlUtils.unicodeDecode(resultStr);
        OcrPersetAlgoResponseVO reps = (OcrPersetAlgoResponseVO)JSON.parseObject((String)unicodeDecode, OcrPersetAlgoResponseVO.class);
        int errorCode = reps.getErrorCode();
        if (0 == errorCode) {
            Object data = reps.getData();
            HashMap<String, AlgoData> toWeb = new HashMap<String, AlgoData>(2);
            if (data instanceof JSONObject) {
                JSONObject dataMap = (JSONObject)data;
                Set keys = dataMap.keySet();
                HashMap<String, Object> ocrData = new HashMap<String, Object>(keys.size());
                Method method = clazz.getDeclaredMethod("getValue", String.class);
                PersetEnum enumConstants = clazz.getEnumConstants()[0];
                for (String key : keys) {
                    Object value = method.invoke((Object)enumConstants, key);
                    ocrData.put(String.valueOf(value), dataMap.get((Object)key));
                }
                OcrResult ocrResult = new OcrResult(ocrData);
                toWeb.put("ocrData", new AlgoData(ocrResult));
            }
            OcrControlUtils.setCustomcontrolData(view, "customtexttable", "modelTest", toWeb);
        } else {
            String description = reps.getDescription();
            OcrControlUtils.setCustomcontrolData(view, "customtexttable", "errorMessage", description);
        }
    }
}

