/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import kd.ai.cvp.common.Enum.FileTypeValidEnum;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class StreamHandleUtils {
    private static final Log logger = LogFactory.getLog(StreamHandleUtils.class);
    private static final String bmpStartCode = "424D";

    public static void closeResource(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                closeable = null;
            }
        }
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder builder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            String hv = Integer.toHexString(src[i] & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        return builder.toString();
    }

    public static String validFileType(InputStream in, String typeName) throws IOException {
        String result = StreamHandleUtils.getTypeResult(in);
        logger.info("\u6d41\u7c7b\u578b\uff1a{}", (Object)result);
        if (!StringUtils.isEmpty((CharSequence)result)) {
            List<String> suitableTypeByName = FileTypeValidEnum.getSuitableTypeByName(typeName);
            logger.info("\u56fe\u7247\u7c7b\u578b\uff1a{}", (Object)JSON.toJSONString(suitableTypeByName));
            if (suitableTypeByName != null && !suitableTypeByName.isEmpty() && !suitableTypeByName.contains(result)) {
                return ResManager.loadKDString((String)"\u6587\u4ef6\u6d41\u683c\u5f0f\u4e0e\u6587\u4ef6\u540e\u7f00\u683c\u5f0f\u4e0d\u4e00\u81f4\uff0c\u6587\u4ef6\u6821\u9a8c\u5931\u8d25", (String)"StreamHandleUtils_001", (String)"ai-cvp-common", (Object[])new Object[0]);
            }
            return "";
        }
        return ResManager.loadKDString((String)"\u6587\u4ef6\u6d41\u683c\u5f0f\u9519\u8bef\uff0c\u6587\u4ef6\u6821\u9a8c\u5931\u8d25", (String)"StreamHandleUtils_002", (String)"ai-cvp-common", (Object[])new Object[0]);
    }

    public static String getTypeResult(InputStream in) throws IOException {
        return StreamHandleUtils.getTypeResultByLength(in, 4);
    }

    public static String getTypeResultByLength(InputStream in, int headLenth) throws IOException {
        byte[] b = new byte[headLenth];
        if (in.read(b) != -1) {
            return StreamHandleUtils.bytesToHexString(b);
        }
        return "";
    }

    public static boolean validFileTypeInTypes(String streamHead, List<String> types) {
        if (!StringUtils.isEmpty((CharSequence)streamHead) && types != null && !types.isEmpty()) {
            HashSet suitableSet = new HashSet();
            types.forEach(t -> {
                List<String> suitTypes = FileTypeValidEnum.getSuitableTypeByName(t);
                suitableSet.addAll(suitTypes);
            });
            if (!suitableSet.isEmpty() && suitableSet.contains(streamHead)) {
                return true;
            }
            if (types.contains("bmp") && streamHead.startsWith(bmpStartCode)) {
                return true;
            }
        }
        return false;
    }

    public static boolean validFileTypeInTypes(InputStream in, List<String> types) throws IOException {
        String result = StreamHandleUtils.getTypeResult(in);
        return StreamHandleUtils.validFileTypeInTypes(result, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] copyStream(InputStream inputStream) {
        try {
            byte[] byArray;
            Object object;
            ByteArrayOutputStream outputStream;
            block19: {
                block20: {
                    outputStream = new ByteArrayOutputStream();
                    object = null;
                    if (inputStream != null) {
                        int len;
                        byte[] buf = new byte[1024];
                        while ((len = inputStream.read(buf)) != -1) {
                            outputStream.write(buf, 0, len);
                        }
                        outputStream.flush();
                    }
                    byArray = outputStream.toByteArray();
                    if (outputStream == null) break block19;
                    if (object == null) break block20;
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable) {
                        object.addSuppressed(throwable);
                    }
                    break block19;
                }
                outputStream.close();
            }
            return byArray;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (outputStream != null) {
                            if (object != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    object.addSuppressed(throwable3);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (IOException ie) {
                    logger.error("io exception", (Throwable)ie);
                    object = new byte[]{};
                    return object;
                }
            }
        }
        finally {
            StreamHandleUtils.closeResource(inputStream);
        }
    }

    public static String getFileTypeWithByteArr(byte[] bytes) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            String type;
            String headStr = StreamHandleUtils.getTypeResult(inputStream);
            logger.info("\u6587\u4ef6\u5934\u5b57\u7b26\u4e32\uff1a{}", (Object)headStr);
            if (StringUtils.isNotEmpty((CharSequence)headStr) && StringUtils.isNotEmpty((CharSequence)(type = FileTypeValidEnum.getFileTypeDetail(headStr, bytes)))) {
                logger.info("\u6587\u4ef6\u7c7b\u578b\uff1a{}", (Object)type);
                String string = type;
                return string;
            }
        }
        return null;
    }

    public static long getStreamSize(InputStream in) throws IOException {
        int len;
        if (in == null) {
            return -1L;
        }
        int perSize = 8192;
        byte[] bs = new byte[perSize];
        long total = 0L;
        while ((len = in.read(bs)) != -1) {
            total += (long)len;
        }
        return total;
    }
}

