/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.ai.cvp.common.Enum.AlgoApiEnum;
import kd.ai.cvp.common.Enum.AlgoMapClassEnum;
import kd.ai.cvp.common.Enum.DistingushFileTypeEnum;
import kd.ai.cvp.common.Enum.FileServiceTypeEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.entity.AlgoResultDataVO;
import kd.ai.cvp.entity.OcrPlanTemplateField;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrDistinguisUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.pdfbox.io.IOUtils;

public class OcrUploadPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private static Log logger = LogFactory.getLog(OcrUploadPlugin.class);
    private static final String PLAN_CONFIG = "templateconfig";
    private static final String OCR_DISTINGUISH_TEMPLATE = "ocrtemplate";
    private static final String CONTROL_BANKRECEIPT = "flexpanelap5";
    private static final String IMAGE_PATH = "imagepath";
    private static final String ATTATCH_KEY = "attachmentfield";
    private static final String BTN_DISTINGUISH = "btnok";
    private static final String F_BANKRULE = "banckrule";
    private static final String F_BANKACCOUNTS = "bankaccounts";
    private static final String F_ACCOUNTNAMES = "accountnames";
    private static final String BIZ_OPEN = "1";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btncancel", BTN_DISTINGUISH});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String businessObjectStr = (String)customParams.get("businessobject");
        DynamicObject plan = OcrControlUtils.getObjByPlanBusinessObject((String)businessObjectStr);
        if (plan == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61,\u672a\u914d\u7f6e\u65b9\u6848,\u8bf7\u5148\u914d\u7f6e", (String)"OcrUploadPlugin_0", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return;
        }
        this.setComboEdit(view, plan);
        this.updateView(view);
        try {
            LicenseUtils.checkLicenseAndDosage((IFormView)view);
        }
        catch (KDBizException ex) {
            logger.error("\u8bf7\u6c42\u68c0\u67e5\u8bb8\u53ef\u5931\u8d25", (Throwable)ex);
            view.showErrorNotification(String.format("\u8bf7\u6c42\u5931\u8d25\uff0c%s", ex.getMessage()));
        }
    }

    private void updateView(IFormView view) {
        Object value = this.getModel().getValue(OCR_DISTINGUISH_TEMPLATE);
        if (value != null) {
            Long templateID = Long.valueOf(value.toString());
            DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)templateID, (String)"cvp_template");
            String templateNumber = template.getString("number");
            boolean flag = templateNumber.equals("OPM-BankReceipt");
            view.setVisible(Boolean.valueOf(flag), new String[]{CONTROL_BANKRECEIPT});
            this.getModel().setValue(F_BANKRULE, (Object)"0");
            view.setVisible(Boolean.FALSE, new String[]{F_BANKACCOUNTS, F_ACCOUNTNAMES});
            this.getModel().setValue(F_BANKACCOUNTS, (Object)"");
            this.getModel().setValue(F_ACCOUNTNAMES, (Object)"");
            view.updateView();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        IFormView view = this.getView();
        ChangeData[] changeSet = e.getChangeSet();
        try {
            block10: for (ChangeData changeData : changeSet) {
                Object oldValue = changeData.getOldValue();
                Object newValue = changeData.getNewValue();
                switch (key) {
                    case "ocrtemplate": {
                        this.updateView(view);
                        continue block10;
                    }
                    case "banckrule": {
                        this.updateBizView(view);
                    }
                }
            }
        }
        catch (KDBizException kde) {
            logger.error("\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)kde);
            this.getView().showTipNotification(!StringUtils.isEmpty((String)kde.getMessage()) ? kde.getMessage() : ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrUploadPlugin_01", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
    }

    private void updateBizView(IFormView view) {
        Object value = this.getModel().getValue(F_BANKRULE);
        if (value != null && BIZ_OPEN.equals(value.toString())) {
            view.setVisible(Boolean.TRUE, new String[]{F_ACCOUNTNAMES, F_BANKACCOUNTS});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{F_BANKACCOUNTS, F_ACCOUNTNAMES});
            this.getModel().setValue(F_BANKACCOUNTS, (Object)"");
            this.getModel().setValue(F_ACCOUNTNAMES, (Object)"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String imagePath = "";
        boolean clearFlag = false;
        try {
            if (BTN_DISTINGUISH.equals(key)) {
                String templateNumber = (String)model.getValue(OCR_DISTINGUISH_TEMPLATE);
                if (StringUtils.isEmpty((String)templateNumber)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u8bc6\u522b\u6a21\u677f,\u8bf7\u5148\u9009\u62e9\u3002", (String)"OcrUploadPlugin_0", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                    return;
                }
                Map<String, String> urlMap = this.getFileUrl(view);
                if (urlMap == null || urlMap.isEmpty() || StringUtils.isEmpty((String)urlMap.get("filePath"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672a\u4e0a\u4f20\u8bc6\u522b\u56fe\u7247,\u8bf7\u5148\u4e0a\u4f20\u56fe\u7247\u3002", (String)"OcrUploadPlugin_1", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                    return;
                }
                String fileName = urlMap.get("fileName");
                imagePath = urlMap.get("filePath");
                String msg = this.alertError(imagePath, fileName);
                if (StringUtils.isNotEmpty((String)msg)) {
                    view.showTipNotification(msg);
                }
                Map<String, String> bizParam = this.buildBizParam(view);
                clearFlag = this.ocrDistinguish(imagePath, bizParam, view, templateNumber);
            }
        }
        catch (Exception e) {
            logger.error("OCR,\u667a\u80fd\u8bc6\u522b\u5f02\u5e38,\u64cd\u4f5c\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bc6\u522b\u5f02\u5e38,\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u95ee\u9898\u3002", (String)"OcrUploadPlugin_01", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        finally {
            if (clearFlag) {
                CommonUtil.clearUploadFile((String)imagePath, (FileServiceTypeEnum)FileServiceTypeEnum.ATTACHMENT_FILE_SERVICE);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String alertError(String imagePath, String fileName) {
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        if (!StringUtils.isNotEmpty((String)imagePath)) return null;
        String realPath = attachmentFileService.getFileServiceExt().getRealPath(imagePath);
        if (!StringUtils.isNotEmpty((String)realPath)) return null;
        String suffix = realPath.substring(realPath.lastIndexOf(46) + 1);
        if (!suffix.equalsIgnoreCase(DistingushFileTypeEnum.PDF.getVlaue())) return null;
        try (InputStream inputStream = attachmentFileService.getInputStream(realPath);){
            PdfReader pdfReader = new PdfReader(inputStream);
            int numberOfPages = pdfReader.getNumberOfPages();
            pdfReader.close();
            if (numberOfPages <= 1) return null;
            String string = ResManager.loadKDString((String)String.format("\u6587\u4ef6\u201c%s\u201d\u4e0a\u4f20\u6210\u529f\uff0c\u591a\u9875pdf\u4ec5\u652f\u6301\u8bc6\u522b\u9996\u9875\u5185\u5bb9\u3002", fileName), (String)"OcrPersetTemplateTestPlugin_005", (String)"ai-cvp-plugin", (Object[])new Object[0]);
            return string;
        }
        catch (IOException ie) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrUploadPlugin_02", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
    }

    private Map<String, String> buildBizParam(IFormView view) {
        Long templateID;
        DynamicObject template;
        String templateNumber;
        boolean flag;
        HashMap<String, String> map = new HashMap<String, String>(2);
        IDataModel model = view.getModel();
        Object banckrule = model.getValue(F_BANKRULE);
        Object bankaccounts = model.getValue(F_BANKACCOUNTS);
        Object accountnames = model.getValue(F_ACCOUNTNAMES);
        Object ocrtemplate = model.getValue(OCR_DISTINGUISH_TEMPLATE);
        if (ocrtemplate != null && banckrule != null && bankaccounts != null && accountnames != null && (flag = (templateNumber = (template = BusinessDataServiceHelper.loadSingleFromCache((Object)(templateID = Long.valueOf(ocrtemplate.toString())), (String)"cvp_template")).getString("number")).equals("OPM-BankReceipt")) && BIZ_OPEN.equals(banckrule.toString()) && (StringUtils.isNotEmpty((String)accountnames.toString()) || StringUtils.isNotEmpty((String)bankaccounts.toString()))) {
            if (StringUtils.isNotEmpty((String)accountnames.toString())) {
                String accTrim = accountnames.toString().trim();
                logger.info("acc:{}", (Object)accTrim);
                if (accTrim.contains("\uff0c")) {
                    accTrim = accTrim.replace("\uff0c", ",");
                }
                if (StringUtils.isNotEmpty((String)accTrim)) {
                    map.put("accountNames", accTrim);
                }
            }
            if (StringUtils.isNotEmpty((String)bankaccounts.toString())) {
                String bankTrim = bankaccounts.toString().trim();
                logger.info("bankacc:{}", (Object)bankTrim);
                if (bankTrim.contains("\uff0c")) {
                    bankTrim = bankTrim.replace("\uff0c", ",");
                }
                if (StringUtils.isNotEmpty((String)bankTrim)) {
                    map.put("bankAccounts", bankTrim);
                }
            }
        }
        return map;
    }

    private Map<String, String> getFileUrl(IFormView view) {
        DynamicObject bdAtta;
        HashMap<String, String> map = new HashMap<String, String>(2);
        String filePath = "";
        String fileName = "";
        Object attachmentfield = view.getModel().getValue(ATTATCH_KEY);
        if (attachmentfield != null && !((MulBasedataDynamicObjectCollection)attachmentfield).isEmpty() && (bdAtta = ((DynamicObject)((MulBasedataDynamicObjectCollection)attachmentfield).get(0)).getDynamicObject("fbasedataid")) != null) {
            filePath = bdAtta.getString("url");
            fileName = bdAtta.getString("name");
            map.put("fileName", fileName);
        }
        if (StringUtils.isNotEmpty((String)filePath)) {
            try {
                logger.info("filePath:{}\uff0cexist:{}", (Object)filePath, (Object)CacheFactory.getCommonCacheFactory().getTempFileCache().exists(filePath));
                try (InputStream in = CvpFileServiceUtils.getFileIn((StorageTypeEnum)StorageTypeEnum.TMP, (String)filePath);){
                    byte[] bytes = IOUtils.toByteArray((InputStream)in);
                    filePath = CvpFileServiceUtils.saveFile((StorageTypeEnum)StorageTypeEnum.ATTACHMENT, (String)fileName, (byte[])bytes);
                    logger.info("result url:{}", (Object)filePath);
                    filePath = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(filePath);
                    logger.info("realPath:{}", (Object)filePath);
                    view.getModel().setValue(IMAGE_PATH, (Object)filePath);
                }
            }
            catch (Exception e) {
                logger.error("\u4e0d\u5b58\u5728\u8def\u5f84");
                filePath = "";
            }
            map.put("filePath", filePath);
        }
        return map;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object imagePathObj = this.getModel().getValue(IMAGE_PATH);
        if (imagePathObj != null && !StringUtils.isEmpty((String)imagePathObj.toString())) {
            CommonUtil.clearUploadFile((String)imagePathObj.toString(), (FileServiceTypeEnum)FileServiceTypeEnum.ATTACHMENT_FILE_SERVICE);
        }
    }

    public boolean ocrDistinguish(String imagePath, Map<String, String> bizParam, IFormView view, String templateId) {
        AlgoResultDataVO info;
        logger.info("OCR\u8bc6\u522b - start\uff1b \u5165\u53e3\uff1a\u64cd\u4f5c\u7c7b\u578b\uff0c\u5f39\u6846\u4e0a\u4f20");
        boolean distinguishStatus = false;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String businessobject = (String)customParams.get("businessobject");
        Long templateID = Long.valueOf(templateId);
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)templateID, (String)"cvp_template");
        String templateNumber = template.getString("number");
        String api = AlgoApiEnum.getValue((String)templateNumber);
        SourceTypeEnum sourceTypeEnum = SourceTypeEnum.PRESETTEMPLATE;
        String countKey = UUID.randomUUID().toString();
        Boolean licenseCheckFlag = this.pluginChcekLicense(countKey, view);
        if (!licenseCheckFlag.booleanValue()) {
            return false;
        }
        long start = System.currentTimeMillis();
        if (StringUtils.isNotEmpty((String)api)) {
            Class clazz = AlgoMapClassEnum.getValue((String)templateNumber);
            info = OcrDistinguisUtils.distinguishPersetImage((String)businessobject, (String)templateNumber, (String)imagePath, bizParam, (String)api, (Class)clazz);
        } else {
            sourceTypeEnum = SourceTypeEnum.SELFDESIGNTEMPLATE;
            info = OcrDistinguisUtils.distinguishOcrImage((String)businessobject, (String)templateNumber, (String)imagePath);
        }
        long end = System.currentTimeMillis();
        boolean ensureSuc = false;
        if (0 == info.getRepCode()) {
            ensureSuc = LicenseUtils.ensureCallNumToAlgo((boolean)true, (String)countKey, (SourceTypeEnum)sourceTypeEnum);
            if (ensureSuc) {
                view.returnDataToParent((Object)SerializationUtils.toJsonString((Object)info));
                view.close();
                distinguishStatus = true;
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u82e5\u8fde\u7eed\u591a\u6b21\u51fa\u73b0\u672c\u63d0\u793a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"OcrUploadPlugin_09", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            }
        } else {
            LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)countKey, (SourceTypeEnum)sourceTypeEnum);
            view.showTipNotification(info.getRepMessage());
        }
        this.setApiInfo(view, info, templateID, template.getString("name"), end - start);
        logger.info(String.format("OCR\u8bc6\u522b - end\uff1b \u5165\u53e3\uff1a\u64cd\u4f5c\u7c7b\u578b\uff0c\u5f39\u6846\u4e0a\u4f20\uff1b traceId:%s, errorCode:%s, message:%s,", RequestContext.get().getTraceId(), info.getRepCode(), info.getRepMessage()));
        return distinguishStatus;
    }

    private Boolean pluginChcekLicense(String countKey, IFormView view) {
        Boolean licenseCheckFlag = Boolean.FALSE;
        try {
            licenseCheckFlag = LicenseUtils.checkLicense((int)1, (String)"ocr", (String)countKey);
        }
        catch (KDBizException be) {
            logger.error("\u8bb8\u53ef\u6821\u9a8c\u5931\u8d25\uff0c\u4e1a\u52a1\u5f02\u5e38", (Throwable)be);
            view.showTipNotification(be.getMessage());
        }
        catch (Exception e) {
            logger.error("\u8bb8\u53ef\u68c0\u67e5\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6b64\u5904\u65e5\u5fd7\u3002", (Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u82e5\u4f9d\u65e7\u51fa\u73b0\u672c\u63d0\u793a\uff0c\u5219\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrUploadPlugin_10", (String)"ai-cvp-Plugin", (Object[])new Object[0]));
        }
        return licenseCheckFlag;
    }

    private void setApiInfo(IFormView view, AlgoResultDataVO info, long templateID, String templateName, long callTime) {
        RequestContext rc = RequestContext.get();
        DynamicObject apiInfo = ORM.create().newDynamicObject("cvp_api_invoke_info");
        Map customParams = view.getFormShowParameter().getCustomParams();
        String businessObject = (String)customParams.get("businessobject");
        String businessName = MetadataServiceHelper.getDataEntityType((String)businessObject).getDisplayName().getLocaleValue();
        apiInfo.set("createdate", (Object)new Date());
        apiInfo.set("calltime", (Object)callTime);
        apiInfo.set("errorcode", (Object)info.getRepCode());
        apiInfo.set("traceid", (Object)rc.getTraceId());
        apiInfo.set("templateid", (Object)templateID);
        apiInfo.set("templatename", (Object)templateName);
        apiInfo.set("callobjectid", (Object)businessObject);
        apiInfo.set("callobjectname", (Object)businessName);
        apiInfo.set("userid", (Object)String.valueOf(rc.getCurrUserId()));
        apiInfo.set("username", (Object)rc.getUserName());
        apiInfo.set("status", (Object)"A");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apiInfo});
    }

    private void setComboEdit(IFormView view, DynamicObject plan) {
        String configStr = (String)plan.get(PLAN_CONFIG);
        JSONObject config = JSON.parseObject((String)configStr);
        List<ComboItem> comboItem = this.createComboItem(config);
        ComboEdit ocrtemplate = (ComboEdit)view.getControl(OCR_DISTINGUISH_TEMPLATE);
        ocrtemplate.setComboItems(comboItem);
        if (comboItem != null && comboItem.size() > 0) {
            ComboItem c = comboItem.get(0);
            this.getModel().setValue(OCR_DISTINGUISH_TEMPLATE, (Object)c.getValue());
        }
    }

    private List<ComboItem> createComboItem(JSONObject config) {
        if (config == null) {
            return null;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(config.size());
        Set entries = config.entrySet();
        for (Map.Entry map : entries) {
            ComboItem comboItem = new ComboItem();
            OcrPlanTemplateField planTemplateField = (OcrPlanTemplateField)JSON.parseObject((String)map.getValue().toString(), OcrPlanTemplateField.class);
            comboItem.setCaption(new LocaleString(planTemplateField.getName()));
            comboItem.setValue((String)map.getKey());
            list.add(comboItem);
        }
        return list;
    }
}

