/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.opplugin;

import java.util.Arrays;
import kd.ai.cvp.opplugin.validator.TdaPlanSaveValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TdaPlanSaveOp
extends AbstractOperationServicePlugIn {
    public static final String FIELD_BUSINESSOBJ = "businessobject";
    public static final String FIELD_PLANNAME = "name";
    public static final String FIELD_ID = "id";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(FIELD_PLANNAME);
        e.getFieldKeys().add(FIELD_BUSINESSOBJ);
        e.getFieldKeys().add(FIELD_ID);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TdaPlanSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject obj : dataEntities = e.getDataEntities()) {
            DynamicObject businessObj = obj.getDynamicObject(FIELD_BUSINESSOBJ);
            String planName = obj.getString(FIELD_PLANNAME);
            QFilter qFilter = new QFilter("businessobj.id", "=", businessObj.getPkValue());
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"cvp_tda_task_history", (String)"id,planname", (QFilter[])new QFilter[]{qFilter});
            if (objs == null || objs.length <= 0) continue;
            Arrays.stream(objs).forEach(o -> o.set("planname", (Object)planName));
            SaveServiceHelper.update((DynamicObject[])objs);
        }
    }
}

