/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.ai.cvp.utils.DateUtils;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.StringUtils;

public class OcrCurrentOrderDatePlugin
extends AbstractFormPlugin {
    private static String KEY_DATE = "subscriptiondate";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.queryCurrentLicenseDate();
    }

    private void queryCurrentLicenseDate() {
        Label dateLabel = (Label)this.getView().getControl(KEY_DATE);
        Date beginDate = null;
        Date expireDate = null;
        Date currentDate = new Date();
        Boolean cvpd_License = LicenseServiceHelper.checkPerformGroup((String)"PROCVPD").getHasLicense();
        String productVersion = LicenseServiceHelper.getProductVersion();
        boolean firstVersion = "1.0".equalsIgnoreCase(productVersion);
        if (firstVersion || cvpd_License.booleanValue()) {
            Map groupTimeRange = LicenseServiceHelper.getGroupTimeRange((Long)126L);
            if (groupTimeRange != null && groupTimeRange.size() > 0) {
                beginDate = (Date)groupTimeRange.get("beginDate");
                expireDate = (Date)groupTimeRange.get("expireDate");
            }
            if (beginDate == null || expireDate == null) {
                dateLabel.setText(DateUtils.dateToStringByYYYY_MM_DD((Date)currentDate));
                return;
            }
            String beginDateStr = DateUtils.dateToStringByYYYY_MM_DD(beginDate);
            String expireDateStr = DateUtils.dateToStringByYYYY_MM_DD(expireDate);
            dateLabel.setText(beginDateStr.concat("~").concat(expireDateStr));
            return;
        }
        Boolean cvprn_License = LicenseServiceHelper.checkPerformGroup((String)"PROCVPRN").getHasLicense();
        if (cvprn_License.booleanValue()) {
            Map groupTimeRange = LicenseServiceHelper.getGroupTimeRange((Long)506L);
            if (groupTimeRange != null && groupTimeRange.size() > 0) {
                beginDate = (Date)groupTimeRange.get("beginDate");
                expireDate = (Date)groupTimeRange.get("expireDate");
            }
            if (beginDate == null || expireDate == null) {
                dateLabel.setText(DateUtils.dateToStringByYYYY_MM_DD((Date)currentDate));
                return;
            }
            Map dateMap = DateUtils.getCurrentSubscriptionDateStr((Date)beginDate, (Date)expireDate);
            String beginDateStr = (String)dateMap.get("beginTimeStr");
            String endDateStr = (String)dateMap.get("expireStr");
            if (!StringUtils.isEmpty((String)beginDateStr) && !StringUtils.isEmpty((String)endDateStr)) {
                dateLabel.setText(beginDateStr.concat("~").concat(endDateStr));
            } else {
                dateLabel.setText(DateUtils.dateToStringByYYYY_MM_DD((Date)currentDate));
            }
        }
    }
}

