/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.cvp.common.Enum.DistingushFileTypeEnum;
import kd.ai.cvp.common.Enum.OcrRecEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.common.Enum.perset.BRNlpEnum;
import kd.ai.cvp.common.Enum.perset.BankCardEnum;
import kd.ai.cvp.common.Enum.perset.CODEnum;
import kd.ai.cvp.common.Enum.perset.COREnum;
import kd.ai.cvp.common.Enum.perset.DLFEnum;
import kd.ai.cvp.common.Enum.perset.DiplomaEnum;
import kd.ai.cvp.common.Enum.perset.GSEnum;
import kd.ai.cvp.common.Enum.perset.GeneralTablePresetEnum;
import kd.ai.cvp.common.Enum.perset.IDCBEnum;
import kd.ai.cvp.common.Enum.perset.IDCFEnum;
import kd.ai.cvp.common.Enum.perset.InvoiceFivEnum;
import kd.ai.cvp.common.Enum.perset.PassportEnum;
import kd.ai.cvp.common.Enum.perset.PaymentRecordEnum;
import kd.ai.cvp.entity.OCRRecVO;
import kd.ai.cvp.entity.OcrRecFile;
import kd.ai.cvp.entity.OcrRecResponseVO;
import kd.ai.cvp.plugin.OcrTemplateCommon;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.PresetTemplateUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class OcrPersetTemplateTestPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private static final Log log = LogFactory.getLog(OcrPersetTemplateTestPlugin.class);
    private static final String APPID_NAME = "ai-cvp-plugin";
    private static final String FILE_URL = "fileUrl";
    private static final String ALERT_MSG = "alertMsg";
    private static final String BASE64_STR = "base64Str";
    private static final String ORIGIN_FILE_URL = "originFileUrl";
    private static final String TEMPLATE_NOT_EXIST = "\u9884\u7f6e\u6a21\u7248\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8be5\u9884\u7f6e\u6a21\u7248\u662f\u5426\u6b63\u5e38";

    public void customEvent(CustomEventArgs e) {
        String args;
        String eventName;
        IFormView view = this.getView();
        if (OcrControlUtils.checkWebStatus((IFormView)view, (String)(eventName = e.getEventName()), (String)(args = e.getEventArgs()))) {
            return;
        }
        long templatePkid = (Long)this.getView().getFormShowParameter().getCustomParam("pkId");
        String fileUrl = "";
        String templateName = "";
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cvp_template");
            DynamicObject currenTemplate = BusinessDataServiceHelper.loadSingle((Object)templatePkid, (DynamicObjectType)dataEntityType);
            if (null == currenTemplate) {
                throw new KDBizException(ResManager.loadKDString((String)TEMPLATE_NOT_EXIST, (String)"OcrPersetTemplateTestPlugin_001", (String)APPID_NAME, (Object[])new Object[0]));
            }
            ILocaleString name = currenTemplate.getLocaleString("name");
            templateName = name.getLocaleValue();
            switch (eventName) {
                case "operate_test": {
                    OcrRecFile ocrRecFile = (OcrRecFile)JSON.parseObject((String)args, OcrRecFile.class);
                    if (ocrRecFile == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6a21\u677f\u6d4b\u8bd5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrPersetTemplateTestPlugin_007", (String)APPID_NAME, (Object[])new Object[0]));
                    }
                    Map<String, String> paramMap = OcrTemplateCommon.preRequest(ocrRecFile);
                    if (paramMap.isEmpty() || !paramMap.containsKey(BASE64_STR) || !paramMap.containsKey(FILE_URL)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrPersetTemplateTestPlugin_003", (String)APPID_NAME, (Object[])new Object[0]));
                    }
                    fileUrl = paramMap.get(FILE_URL);
                    if (StringUtils.isNotEmpty((String)paramMap.get(ALERT_MSG))) {
                        this.getView().showTipNotification(paramMap.get(ALERT_MSG));
                    }
                    OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customtexttable", (String)eventName, (Object)this.ocrPresetTemplateTest(paramMap, currenTemplate, ocrRecFile));
                    break;
                }
                case "init": {
                    this.initCallExampleTab();
                    break;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7f6e\u6a21\u677f-\u975e\u6cd5\u6307\u4ee4\u64cd\u4f5c", (String)"OcrPersetTemplateTestPlugin_006", (String)APPID_NAME, (Object[])new Object[0]));
                }
            }
        }
        catch (Exception ex) {
            String message = ResManager.loadKDString((String)String.format("\u9884\u7f6e\u6a21\u677f%s\u6d4b\u8bd5\u5f02\u5e38:%s", templateName, ex.getMessage()), (String)"OcrPersetTemplateTestPlugin_002", (String)APPID_NAME, (Object[])new Object[0]);
            log.error("\u9884\u7f6e\u6a21\u677f\u8bc6\u522b-\u81ea\u5b9a\u4e49\u63a7\u4ef6\u533a\u5f02\u5e38 \u64cd\u4f5c:" + eventName + "\u64cd\u4f5c\u5f02\u5e38 " + ex.getMessage(), (Throwable)ex);
            HashMap<String, String> toWeb = new HashMap<String, String>(3);
            toWeb.put("url", fileUrl);
            toWeb.put("message", message);
            OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customtexttable", (String)"error", toWeb);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        try {
            long pkId = (Long)view.getFormShowParameter().getCustomParam("pkId");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cvp_template");
            DynamicObject currenTemplate = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)dataEntityType);
            if (null == currenTemplate) {
                this.getView().getParentView().showTipNotification(TEMPLATE_NOT_EXIST);
                return;
            }
            String name = currenTemplate.getString("name");
            LocaleString templateName = new LocaleString();
            templateName.setLocaleValue(name);
            Label templatenameLabel = (Label)view.getControl("templatename");
            if (templatenameLabel != null) {
                templatenameLabel.setText(templateName.getLocaleValue());
            }
            this.initCallExampleTab();
        }
        catch (Exception ex) {
            log.error("\u6d4b\u8bd5\u9875\u9762\u521d\u59cb\u5316\u5931\u8d25", (Throwable)ex);
            IFormView parentView = this.getView().getParentView();
            view.getViewNoPlugin(parentView.getPageId()).showTipNotification("\u9884\u7f6e\u6a21\u677f\u6d4b\u8bd5\u9875\u9762\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            view.sendFormAction(parentView);
        }
    }

    private void initCallExampleTab() {
        IFormView view = this.getView();
        long pkId = (Long)view.getFormShowParameter().getCustomParam("pkId");
        String operateKey = (String)view.getFormShowParameter().getCustomParam("operate_key");
        log.info(String.format("OCR \u521d\u59cb\u5316\u8c03\u7528\u793a\u4f8b,\u6a21\u7248pkId:%s", pkId));
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cvp_template");
        DynamicObject currenTemplate = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)dataEntityType);
        OCRRecVO ocrRecVO = new OCRRecVO();
        String attUrl = String.format("%s/attachment/upload.do", UrlService.getDomainContextUrl());
        int fileSizeMax = 1;
        ocrRecVO.setUrl(attUrl);
        ocrRecVO.setBillid(pkId);
        ocrRecVO.setFileSizeMax(fileSizeMax);
        ocrRecVO.setTraceId(RequestContext.get().getTraceId());
        ocrRecVO.setViewType(operateKey);
        ocrRecVO.setType(OcrRecEnum.PRETMP.getType());
        ocrRecVO.setMarkdownName(currenTemplate.getString("number"));
        OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customtexttable", (String)"init", (Object)ocrRecVO);
    }

    private OcrRecResponseVO ocrPresetTemplateTest(Map<String, String> paramMap, DynamicObject template, OcrRecFile ocrRecFile) throws Exception {
        if (ocrRecFile == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e22\u5931\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrPersetTemplateTestPlugin_010", (String)APPID_NAME, (Object[])new Object[0]));
        }
        Map bizParam = ocrRecFile.getBizParam();
        String fileType = ocrRecFile.getFileType();
        String originFileUrl = paramMap.get(ORIGIN_FILE_URL);
        String fileBase64 = paramMap.get(BASE64_STR);
        String fileUrl = paramMap.get(FILE_URL);
        if (null == template) {
            throw new KDBizException(ResManager.loadKDString((String)TEMPLATE_NOT_EXIST, (String)"OcrPersetTemplateTestPlugin_001", (String)APPID_NAME, (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)fileType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrPersetTemplateTestPlugin_007", (String)APPID_NAME, (Object[])new Object[0]));
        }
        boolean isPdf = false;
        if (fileType.equalsIgnoreCase(DistingushFileTypeEnum.PDF.getVlaue())) {
            log.info("\u4e0a\u4f20\u4e86pdf\u6587\u4ef6\u7684\u9884\u7f6e\u6a21\u677f\u6d4b\u8bd5\u3002\u3002\u3002");
            isPdf = true;
        }
        String number = template.getString("number");
        String api = "";
        Class<COREnum> clazz = null;
        switch (number) {
            case "OPM-CertificateOfResignation": {
                api = "/demission/recognize";
                clazz = COREnum.class;
                break;
            }
            case "OPM-CertificateOfDegree": {
                api = "/education/recognize";
                clazz = CODEnum.class;
                break;
            }
            case "OPM-Diploma": {
                api = "/diploma/recognize";
                clazz = DiplomaEnum.class;
                break;
            }
            case "OPM-Invoice": {
                api = "/vatinvoice/recognition/five";
                clazz = InvoiceFivEnum.class;
                break;
            }
            case "OPM-BankReceipt": {
                if (isPdf) {
                    fileBase64 = OcrControlUtils.getFileBase64ByIO((InputStream)CvpFileServiceUtils.getFileIn((StorageTypeEnum)StorageTypeEnum.TMP, (String)originFileUrl));
                }
                api = "/template/bankTicket";
                clazz = BRNlpEnum.class;
                break;
            }
            case "OPM-BankCard": {
                api = "/presetocr/bankcard/recognize";
                clazz = BankCardEnum.class;
                break;
            }
            case "OPM-IDCardFront": {
                api = "/presetocr/idcard/recognize";
                clazz = IDCFEnum.class;
                break;
            }
            case "OPM-IdCardBack": {
                api = "/presetocr/idcard/recognize";
                clazz = IDCBEnum.class;
                break;
            }
            case "OPM-DrivingLicenseFront": {
                api = "/presetocr/drivingLicense/recognize/front";
                clazz = DLFEnum.class;
                break;
            }
            case "OPM-Passport": {
                api = "/presetocr/passport/recognize";
                clazz = PassportEnum.class;
                break;
            }
            case "OPM-GeneralSpotting": {
                api = "/presetocr/general/spotting";
                clazz = GSEnum.class;
                break;
            }
            case "OPM-GeneralTablePreset": {
                api = "/table/generalTableRec/rec";
                clazz = GeneralTablePresetEnum.class;
                break;
            }
            case "OPM-PaymentRecord": {
                api = "/nlpservice/paymentExtract";
                clazz = PaymentRecordEnum.class;
                break;
            }
            default: {
                String message = ResManager.loadKDString((String)String.format("\u8be5\u9884\u7f6e\u6a21\u7248\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8be5\u9884\u7f6e\u6a21\u7248\u662f\u5426\u6b63\u5e38", number), (String)"OcrPersetTemplateTestPlugin_005", (String)APPID_NAME, (Object[])new Object[0]);
                log.error(String.format("OCR \u9884\u7f6e\u6a21\u7248\u6d4b\u8bd5\u5f02\u5e38 traceId:%s , \u5f02\u5e38\u4fe1\u606f\uff1a%s", RequestContext.get().getTraceId(), message));
                throw new KDBizException(message);
            }
        }
        OcrRecResponseVO responseVO = PresetTemplateUtils.presetDistinguishTestNew((String)api, clazz, (String)fileBase64, (Map)bizParam);
        if (responseVO == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrPersetTemplateTestPlugin_008", (String)APPID_NAME, (Object[])new Object[0]));
        }
        responseVO.setUrl(fileUrl);
        return responseVO;
    }
}

