/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class OcrPlanListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(OcrPlanListPlugin.class);
    private static final String ALGO_KEY = "ai_cvp_algo";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            log.info("OcrPlanListPlugin operation start");
            String operateKey = args.getOperateKey();
            if ("new".equals(operateKey) || "modify".equals(operateKey) || "copy".equals(operateKey)) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("cvp_plan");
                showParameter.getOpenStyle().setTargetKey("tabap");
                if ("new".equals(operateKey)) {
                    showParameter.setStatus(OperationStatus.ADDNEW);
                } else if ("modify".equals(operateKey)) {
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    showParameter.setCustomParam("ismodify", (Object)Boolean.TRUE);
                    Object pkValue = this.getPkValue(args);
                    if (pkValue == null) {
                        return;
                    }
                    showParameter.setCustomParam("billId", pkValue);
                } else {
                    showParameter.setStatus(OperationStatus.VIEW);
                }
                CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
                showParameter.setCloseCallBack(closeCallBack);
            } else if ("delete".equals(operateKey)) {
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                Object[] pks = selectedRows.getPrimaryKeyValues();
                log.info(String.format("\u5173\u8054\u65b9\u6848\u5220\u9664 - \u9009\u4e2d\u7684\u6570\u636e\uff1a%s", Arrays.toString(pks)));
                QFilter planConfigfilter = new QFilter("plannumber", "in", (Object)pks);
                QFilter[] planConfigfilters = new QFilter[]{planConfigfilter};
                DynamicObjectCollection businessConfigs = QueryServiceHelper.query((String)"cvp_plan_syn_business", (String)"entitynumber", (QFilter[])planConfigfilters);
                ArrayList entityNumbers = new ArrayList(businessConfigs.size());
                businessConfigs.stream().forEach(o -> entityNumbers.add(o.getString("entitynumber")));
                QFilter businessConfigfilter = new QFilter("entitynumber", "in", entityNumbers);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"cvp_plan_syn_business", (String)"entitynumber", (QFilter[])new QFilter[]{businessConfigfilter}, (String)"entitynumber").groupBy(new String[]{"entitynumber"}).count().finish();
                ArrayList<String> delDtsEntityNumbers = new ArrayList<String>(10);
                for (Row data : dataSet) {
                    int count = (Integer)data.get("count");
                    if (count > pks.length) continue;
                    delDtsEntityNumbers.add(data.getString("entitynumber"));
                }
                if (delDtsEntityNumbers.size() > 0) {
                    log.info(String.format("\u5173\u8054\u65b9\u6848\u5220\u9664 - \u5220\u9664 DTS \u540c\u6b65\u6570\u636e\uff1a%s", Arrays.toString(delDtsEntityNumbers.toArray())));
                    QFilter delFilter = new QFilter("destinationtype", "=", (Object)"fulltext").and("region", "=", (Object)"cvpsearch").and("businesstype", "=", (Object)"cvpsearch").and("entitynumber", "in", delDtsEntityNumbers);
                    DeleteServiceHelper.delete((String)"data_sync_config", (QFilter[])new QFilter[]{delFilter});
                }
                DeleteServiceHelper.delete((String)"cvp_plan_syn_business", (QFilter[])planConfigfilters);
                DeleteServiceHelper.delete((String)"cvp_plan_config", (QFilter[])planConfigfilters);
            }
            log.info("OcrPlanListPlugin operation end");
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u5355\u636e\u5217\u8868\u64cd\u4f5c\u5f02\u5e38", (String)"OcrPlanListPlugin_16", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            log.error("OcrPlanListPlugin operation Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    private Object getPkValue(AfterDoOperationEventArgs args) {
        FormOperate formOperate;
        ListSelectedRow row;
        Object source = args.getSource();
        if (source instanceof FormOperate && (row = (formOperate = (FormOperate)source).getListFocusRow()) != null) {
            return row.getPrimaryKeyValue();
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        ((IListView)this.getView()).refresh();
    }
}

