/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.cvp.entity.OcrPlanTemplateField;
import kd.ai.cvp.entity.template.DistinguishPos;
import kd.ai.cvp.entity.template.Table;
import kd.ai.cvp.entity.template.TemplateDistInfo;
import kd.ai.cvp.entity.template.Text;
import kd.ai.cvp.utils.DtsManage;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.ThreadUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class OcrPlanPlugin
extends AbstractBillPlugIn
implements ItemClickListener {
    private static Log log = LogFactory.getLog(OcrPlanPlugin.class);
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_BUSINESSFILED = "businessfiled";
    private static final String KEY_RECFILED = "recfiled";
    private static final String MARK_BUSINESSLIST = "businessList";
    private static final String MARK_DISTINGUISHFIELDS = "distinguishFields";
    private static final String MARK_CVP = "ai-cvp-plugin";
    private static final String KEY_PLANNAME = "planName";
    private static final String KEY_TIPS = "tips";
    private static final String KEY_PAGECACHE_PLANCONFIG = "planConfig";
    private static final String KEY_PAGECACHE_TEMPLATECONFIG = "templateConfig";
    private static final String KEY_PAGECACHE_CLSCONFIG = "clsConfig";
    private static final String KEY_BIGOBJ = "bizEntityObjKeys";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarap = (Toolbar)this.getView().getControl("toolbarap");
        toolbarap.addItemClickListener((ItemClickListener)this);
        Toolbar entityToolbar = (Toolbar)this.getView().getControl("advcontoolbarap");
        entityToolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterLoadData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject plan = model.getDataEntity();
        String config = (String)plan.get("templateconfig");
        Boolean isCopy = (Boolean)view.getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            long number = new Date().getTime();
            this.getModel().setValue("number", (Object)("OCRPLAN-" + number));
        }
        if (StringUtils.isNotEmpty((String)config)) {
            this.setPlanCustom(view, plan);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean useClassifierFlag = (Boolean)model.getValue("useclassifier");
        view.setEnable(Boolean.valueOf(useClassifierFlag), new String[]{"classifier"});
        view.setEnable(Boolean.valueOf(!useClassifierFlag), new String[]{"choosetemplatebase"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object oldValue = changeData.getOldValue();
            if ("choosetemplatebase".equals(key) || "classifier".equals(key)) {
                this.rebuildPlanConfigStr(true);
                this.setPlanCustomByModel(view, model, true);
                continue;
            }
            if ("businessobject".equals(key)) {
                this.rebuildPlanConfigStr(true);
                this.setPlanCustomByModel(view, model, false);
                continue;
            }
            if (oldValue != null && changeData.getNewValue() != null && StringUtils.isNotEmpty((String)changeData.getNewValue().toString()) && "currenttemplatenum".equals(key) && !changeData.getNewValue().equals(oldValue)) {
                HashMap<Object, Object> templates = new HashMap<Object, Object>(10);
                this.getAllTemplate(model, templates);
                if (StringUtils.isNotEmpty((String)oldValue.toString()) && templates.containsKey(Long.parseLong(oldValue.toString()))) {
                    HashMap<String, Object> tipsMap = new HashMap<String, Object>(10);
                    this.validTheEntry(oldValue, tipsMap);
                    this.saveEntryByField(oldValue);
                    if (!tipsMap.isEmpty()) {
                        this.alertTips(view, tipsMap);
                    }
                }
                this.setPlanCustomByModel(view, model, false);
                continue;
            }
            if ("useclassifier".equals(key)) {
                boolean newValue = (Boolean)changeData.getNewValue();
                view.setEnable(Boolean.valueOf(newValue), new String[]{"classifier"});
                view.setEnable(Boolean.valueOf(!newValue), new String[]{"choosetemplatebase"});
                this.setPlanCustomByModel(view, model, true);
                continue;
            }
            if (!KEY_RECFILED.equals(key) && !KEY_BUSINESSFILED.equals(key)) continue;
            Object newValue = changeData.getNewValue();
            if (oldValue == null && newValue != null) {
                return;
            }
            this.entryChangeValid();
        }
    }

    private void entryChangeValid() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRYENTITY);
        Object currentTemplatePK = model.getValue("currenttemplatenum");
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)currentTemplatePK, (String)"cvp_template");
        String planName = "";
        if (planObj != null) {
            planName = planObj.getString("name");
        }
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        IPageCache pageCache = view.getPageCache();
        String bizEntityObjStr = pageCache.getBigObject(KEY_BIGOBJ);
        JSONObject bizEntityMap = JSON.parseObject((String)bizEntityObjStr);
        HashSet bizFieldSet = new HashSet();
        String planNameStr = planName;
        entryEntity.forEach(entry -> {
            Object bizObj = entry.get(KEY_BUSINESSFILED);
            Object recObj = entry.get(KEY_RECFILED);
            if (recObj == null || StringUtils.isEmpty((String)recObj.toString())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u4e2d\uff0c\u8bc6\u522b\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u540e\u518d\u8bd5\u3002", (String)"OcrPlanPlugin_004", (String)MARK_CVP, (Object[])new Object[0]));
                return;
            }
            if (bizObj != null && StringUtils.isNotEmpty((String)bizObj.toString())) {
                String bizObjStr = bizObj.toString();
                if (!bizEntityMap.containsKey((Object)bizObjStr)) {
                    throw new KDBizException("\u5f02\u5e38...");
                }
                Object entityKey = bizEntityMap.get((Object)bizObjStr);
                if (!bizFieldSet.add(entityKey.toString())) {
                    view.showTipNotification(ResManager.loadKDString((String)String.format("\u68c0\u6d4b\u5230\u3010%s\u3011\u6a21\u677f\u4e2d\u7b2c\u3010%s\u3011\u884c\uff0c\u4e0d\u5141\u8bb8\u914d\u7f6e\u591a\u4e2a\u8bc6\u522b\u5b57\u6bb5\u6620\u5c04\u5230\u76f8\u540c\u7684\u4e1a\u52a1\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u3002", planNameStr, entry.get("seq")), (String)"OcrPlanPlugin_002", (String)MARK_CVP, (Object[])new Object[0]));
                }
            }
        });
    }

    private void alertTips(IFormView view, Map<String, Object> tipsMap) {
        if (tipsMap.isEmpty()) {
            return;
        }
        String planName = (String)tipsMap.get(KEY_PLANNAME);
        Set tipsList = (Set)tipsMap.get(KEY_TIPS);
        if (tipsList != null && !tipsList.isEmpty()) {
            tipsList.forEach(tips -> {
                String formatTips = String.format(tips, "\u3010" + planName + "\u3011");
                view.showTipNotification(formatTips);
            });
        }
    }

    private boolean validTheEntry(Object oldValue, Map<String, Object> tipsMap) {
        List unblankEntry;
        String businessName;
        DynamicObject businessObject;
        boolean flag;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject currenPlan = model.getDataEntity();
        String code = (String)currenPlan.get("number");
        long pkValue = (Long)currenPlan.getPkValue();
        if (StringUtils.isEmpty((String)code)) {
            view.showTipNotification(code + ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u3002", (String)"OcrPlanPlugin_7", (String)MARK_CVP, (Object[])new Object[0]));
            return false;
        }
        Object value = model.getValue("currenttemplatenum");
        if (value == null) {
            view.showTipNotification(code + ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f53\u524d\u6a21\u677f\u540d\u79f0\u201d\u5e76\u6dfb\u52a0\u5173\u8054\u914d\u7f6e\u540e\u518d\u4fdd\u5b58\u3002", (String)"OcrPlanPlugin_8", (String)MARK_CVP, (Object[])new Object[0]));
            return false;
        }
        boolean exists = QueryServiceHelper.exists((String)"cvp_plan", (Object)pkValue);
        if (!exists && (flag = OcrControlUtils.objByPlanNumberExit((String)code))) {
            view.showTipNotification(code + ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"OcrPlanPlugin_3", (String)MARK_CVP, (Object[])new Object[0]));
            return false;
        }
        DynamicObject business = (DynamicObject)model.getValue("businessobject");
        if (business != null && (businessObject = OcrControlUtils.getObjByPlanBusinessObject((String)(businessName = (String)business.getPkValue()))) != null && (Long)businessObject.get("id") != pkValue) {
            view.showTipNotification(ResManager.loadKDString((String)("\u8be5\u4e1a\u52a1\u5bf9\u8c61\u3010" + business.getString("name") + "\u3011\u5df2\u914d\u7f6e\u65b9\u6848,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002"), (String)"OcrPlanPlugin_6", (String)MARK_CVP, (Object[])new Object[0]));
            return false;
        }
        boolean validFlag = true;
        HashSet<String> tips = new HashSet<String>();
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)oldValue, (String)"cvp_template");
        if (planObj != null) {
            String planName = planObj.getString("name");
            tipsMap.put(KEY_PLANNAME, planName);
        } else {
            tipsMap.put(KEY_PLANNAME, "\u672a\u77e5\u6a21\u677f");
        }
        DynamicObjectCollection entryentity = model.getEntryEntity(KEY_ENTRYENTITY);
        if (entryentity == null || entryentity.isEmpty()) {
            tips.add("%s\u6a21\u677f\u672a\u914d\u7f6e\u4efb\u4f55\u8bc6\u522b\u5173\u8054\u914d\u7f6e\uff0c\u8bf7\u5173\u8054\u914d\u7f6e\u3002");
            tipsMap.put(KEY_TIPS, tips);
            return false;
        }
        long recFieldCount = entryentity.stream().filter(entry -> entry.get(KEY_RECFILED) == null || StringUtils.isEmpty((String)entry.get(KEY_RECFILED).toString())).count();
        if (recFieldCount > 0L) {
            tips.add("%s\u6a21\u677f\u4e2d\u5b58\u5728\u672a\u914d\u7f6e\u8bc6\u522b\u5b57\u6bb5\u7684\u7a7a\u884c\uff0c\u8bf7\u5173\u8054\u914d\u7f6e\u6216\u5220\u9664\u8be5\u884c\u3002");
            validFlag = false;
        }
        if ((unblankEntry = entryentity.stream().filter(entry -> entry.get(KEY_BUSINESSFILED) != null && !StringUtils.isEmpty((String)entry.get(KEY_BUSINESSFILED).toString())).collect(Collectors.toList())).isEmpty()) {
            tips.add("%s\u6a21\u677f\u672a\u914d\u7f6e\u4efb\u4f55\u4e1a\u52a1\u5b57\u6bb5\uff0c\u8bf7\u5173\u8054\u914d\u7f6e\u3002");
            validFlag = false;
        }
        List<Map<String, String>> objInfoList = this.getObjInfoList();
        HashSet<String> set = new HashSet<String>();
        IPageCache pageCache = view.getPageCache();
        String bizEntityObjStr = pageCache.getBigObject(KEY_BIGOBJ);
        JSONObject bizEntityMap = JSON.parseObject((String)bizEntityObjStr);
        ArrayList nameList = new ArrayList(16);
        boolean repeateFlag = false;
        if (unblankEntry.size() > 1) {
            for (DynamicObject obj : unblankEntry) {
                List names;
                Object entityKey = bizEntityMap.get((Object)obj.getString(KEY_BUSINESSFILED));
                if (set.add(entityKey.toString())) continue;
                if (objInfoList != null && !objInfoList.isEmpty() && !nameList.contains((names = objInfoList.stream().filter(objInfo -> objInfo.containsKey(obj.get(KEY_BUSINESSFILED).toString())).map(objInfo -> (String)objInfo.get(obj.get(KEY_BUSINESSFILED).toString())).collect(Collectors.toList())).get(0))) {
                    nameList.add(names.get(0));
                }
                validFlag = false;
                repeateFlag = true;
            }
        }
        if (!validFlag) {
            if (repeateFlag) {
                tips.add("\u68c0\u6d4b\u5230%s\u6a21\u677f\u4e2d\u5b58\u5728\u4e1a\u52a1\u5b57\u6bb5\u3010" + (!nameList.isEmpty() ? String.join((CharSequence)",", nameList) : "") + "\u3011\u5bf9\u5e94\u591a\u6761\u8bc6\u522b\u5b57\u6bb5\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u540e\u4fdd\u5b58\u3002");
            }
            tipsMap.put(KEY_TIPS, tips);
            return false;
        }
        tipsMap.clear();
        return true;
    }

    private void rebuildPlanConfigStr(boolean forceRebuild) {
        if (forceRebuild) {
            this.getModel().setValue("templateconfig", (Object)"");
        }
    }

    private boolean saveEntryByField(Object oldValue) {
        this.buildConfigAndUpdate(oldValue);
        return true;
    }

    private void buildConfigAndUpdate(Object templateId) {
        if (templateId == null) {
            throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (entryEntity != null && !entryEntity.isEmpty()) {
            Map<Object, Object> planConfigMap = this.buildPlanConfigMap(templateId, entryEntity);
            boolean useClsFlag = (Boolean)this.getModel().getValue("useclassifier");
            IPageCache pageCache = this.getView().getPageCache();
            String planConfig = pageCache.get(KEY_PAGECACHE_PLANCONFIG);
            JSONObject planConfigObj = JSON.parseObject((String)planConfig);
            String planConfigStr = planConfigObj.getString(KEY_PAGECACHE_TEMPLATECONFIG);
            String classifierConfigStr = planConfigObj.getString(KEY_PAGECACHE_CLSCONFIG);
            String templateIdStr = templateId.toString();
            if (!useClsFlag && StringUtils.isNotEmpty((String)planConfigStr) || useClsFlag && StringUtils.isNotEmpty((String)classifierConfigStr)) {
                JSONObject jsonObject = null;
                jsonObject = !useClsFlag ? JSON.parseObject((String)planConfigStr) : JSON.parseObject((String)classifierConfigStr);
                if (jsonObject.get((Object)templateIdStr) != null) {
                    jsonObject.remove((Object)templateIdStr);
                }
                jsonObject.put(templateIdStr, planConfigMap.get(templateId));
                this.setPageConfig(useClsFlag, jsonObject.toJSONString());
                this.getModel().setValue("templateconfig", (Object)jsonObject.toJSONString());
            } else {
                this.setPageConfig(useClsFlag, JSON.toJSONString(planConfigMap));
                this.getModel().setValue("templateconfig", (Object)JSON.toJSONString(planConfigMap));
            }
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            int planConfigOrdinal = dataEntityType.getProperty("templateconfig").getOrdinal();
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(planConfigOrdinal, false);
        }
    }

    private Map<Object, Object> buildPlanConfigMap(Object templateId, DynamicObjectCollection entryEntity) {
        HashMap<Object, Object> planConfigMap = new HashMap<Object, Object>(10);
        OcrPlanTemplateField templateField = new OcrPlanTemplateField();
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(templateId.toString()), (String)"cvp_template");
        OrmLocaleValue templateNameLocale = (OrmLocaleValue)templateObj.get("name");
        String templateName = templateNameLocale.getLocaleValue();
        templateField.setName(templateName);
        ArrayList list = new ArrayList(entryEntity.size());
        ArrayList recList = new ArrayList(16);
        entryEntity.forEach(entry -> {
            HashMap<String, String> valueMap = new HashMap<String, String>(10);
            Object recfiled = entry.get(KEY_RECFILED);
            Object businessfiled = entry.get(KEY_BUSINESSFILED);
            String recfiledStr = recfiled.toString();
            recList.add(recfiledStr);
            valueMap.put(recfiledStr, businessfiled != null ? businessfiled.toString() : "");
            list.add(valueMap);
        });
        templateField.setValue(list);
        templateField.setDistinguishFields(recList);
        planConfigMap.put(templateId, templateField);
        return planConfigMap;
    }

    private void synDts(IDataModel model) {
        try {
            Object businessObject = model.getValue("businessobject");
            if (businessObject != null) {
                String businessStr = ((DynamicObject)businessObject).getString("number");
                long planId = (Long)model.getValue("id");
                DtsManage.saveDtsCfg((long)planId, (String)businessStr);
            }
        }
        catch (Exception ex) {
            log.warn("DTS \u65b0\u589e\u914d\u7f6e\u5f02\u5e38:" + ex.getMessage(), (Throwable)ex);
        }
    }

    private void savePlan(IFormView view, IDataModel model) {
        RequestContext rc = RequestContext.get();
        DynamicObject plan = model.getDataEntity();
        long pkValue = (Long)plan.getPkValue();
        Object planConfigObj = model.getValue("templateconfig");
        String planConfigStr = null;
        planConfigStr = planConfigObj != null ? model.getValue("templateconfig").toString() : "";
        JSONObject configMap = JSON.parseObject((String)planConfigStr);
        int size = configMap.size();
        model.setValue("templateconfig", (Object)planConfigStr);
        model.setValue("templatenumber", (Object)size);
        model.setValue("modifierid", (Object)String.valueOf(rc.getCurrUserId()));
        model.setValue("modifydate", (Object)new Date());
        boolean exists = QueryServiceHelper.exists((String)"cvp_plan", (Object)pkValue);
        if (exists) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plan});
            this.updateConfig(model);
        } else {
            Object[] plans = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plan});
            DynamicObject object = (DynamicObject)plans[0];
            Object id = object.getPkValue();
            DynamicObject[] config = this.mapToObj(id, configMap);
            SaveServiceHelper.save((DynamicObject[])config);
        }
        model.setDataChanged(false);
        model.updateCache();
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OcrPlanPlugin_1", (String)MARK_CVP, (Object[])new Object[0]));
    }

    private void updateConfig(IDataModel model) {
        DynamicObject plan = model.getDataEntity();
        Object planId = plan.getPkValue();
        String configMapStr = plan.getString("templateconfig");
        JSONObject currenConfigMap = JSON.parseObject((String)configMapStr);
        Set currenConfigCodes = currenConfigMap.keySet();
        DynamicObjectCollection oldConfigs = OcrControlUtils.getPlanConfigObjList((Object)planId);
        List removeObjs = oldConfigs.stream().filter(o -> !currenConfigCodes.contains(String.valueOf(o.get("templatenumber")))).collect(Collectors.toList());
        List retainObj = oldConfigs.stream().filter(o -> currenConfigCodes.contains(String.valueOf(o.get("templatenumber")))).collect(Collectors.toList());
        ArrayList<Object> removeKey = new ArrayList<Object>(removeObjs.size());
        for (Object obj : removeObjs) {
            removeKey.add(obj.get("id"));
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cvp_plan_config");
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])removeKey.toArray());
        for (DynamicObject obj : retainObj) {
            currenConfigMap.remove(obj.get("templatenumber"));
        }
        DynamicObject[] config = this.mapToObj(planId, currenConfigMap);
        SaveServiceHelper.save((DynamicObject[])config);
    }

    private DynamicObject[] mapToObj(Object planNumber, JSONObject configMap) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(configMap.size());
        for (Map.Entry config : configMap.entrySet()) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cvp_plan_config");
            DynamicObject configObj = new DynamicObject((DynamicObjectType)dataEntityType);
            configObj.set("plannumber", planNumber);
            configObj.set("templatenumber", (Object)Long.valueOf((String)config.getKey()));
            configObj.set("templateconfig", config.getValue());
            list.add(configObj);
        }
        return list.toArray(new DynamicObject[0]);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        try {
            switch (key) {
                case "saveplan": {
                    if (!this.validPlanInfo(view, model)) {
                        return;
                    }
                    this.prepareToSavePlan();
                    break;
                }
                case "refreshplan": {
                    break;
                }
                case "quit": {
                    break;
                }
                case "tb_new": 
                case "tb_del": {
                    break;
                }
                default: {
                    view.showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u5b58\u5728", (String)"OcrPlanPlugin_5", (String)MARK_CVP, (Object[])new Object[0]));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)(key + "\u65b9\u6848\u64cd\u4f5c\u6309\u94ae\u533a\u5f02\u5e38"), (String)"OcrPlanPlugin_4", (String)MARK_CVP, (Object[])new Object[0]));
            log.error("\u65b9\u6848" + key + "\u64cd\u4f5c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
    }

    private void prepareToSavePlan() {
        Object value = this.getModel().getValue("currenttemplatenum");
        this.saveEntryByField(value);
        this.savePlan(this.getView(), this.getModel());
        ThreadUtils.get().execute(() -> this.synDts(this.getModel()));
    }

    public boolean validPlanInfo(IFormView view, IDataModel model) {
        Object value = model.getValue("currenttemplatenum");
        ArrayList<Map<String, Object>> listTipsMap = new ArrayList<Map<String, Object>>(16);
        HashMap<String, Object> tipsMap = new HashMap<String, Object>(10);
        boolean validEntryFlag = this.validTheEntry(value, tipsMap);
        if (!tipsMap.isEmpty()) {
            listTipsMap.add(tipsMap);
        }
        Object planConfig = model.getValue("templateconfig");
        long count = 0L;
        if (planConfig != null) {
            JSONObject jsonObject = JSON.parseObject((String)planConfig.toString());
            IPageCache pageCache = view.getPageCache();
            String bizEntityObjStr = pageCache.getBigObject(KEY_BIGOBJ);
            JSONObject bizEntityMap = JSON.parseObject((String)bizEntityObjStr);
            count = jsonObject.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(value)).filter(entry -> !this.validEntryByPlanConfig((Map.Entry<String, Object>)entry, bizEntityMap, (List<Map<String, Object>>)listTipsMap)).count();
        }
        if (!validEntryFlag || count > 0L) {
            this.alertTipsTotal(view, listTipsMap);
            return false;
        }
        return true;
    }

    private void alertTipsTotal(IFormView view, List<Map<String, Object>> listTipsMap) {
        if (listTipsMap.isEmpty()) {
            log.info("\u6821\u9a8c\u6b63\u5e38\u3002\u3002\u3002");
            return;
        }
        HashSet sets = new HashSet();
        listTipsMap.forEach(tipsMap -> sets.addAll((Set)tipsMap.get(KEY_TIPS)));
        sets.forEach(str -> {
            StringBuilder planNameBuilder = new StringBuilder();
            for (Map map : listTipsMap) {
                if (!((Set)map.get(KEY_TIPS)).contains(str)) continue;
                planNameBuilder.append('\u3010');
                planNameBuilder.append(map.get(KEY_PLANNAME));
                planNameBuilder.append("\u3011\u3001");
            }
            if (planNameBuilder.length() > 0) {
                String formatString = String.format(str, planNameBuilder.substring(0, planNameBuilder.length() - 1));
                view.showTipNotification(formatString);
            }
        });
    }

    private boolean validEntryByPlanConfig(Map.Entry<String, Object> entry, JSONObject bizEntityMap, List<Map<String, Object>> tipsMapList) {
        Object value = entry.getValue();
        HashMap<String, Object> tipsMap = new HashMap<String, Object>(10);
        HashSet<String> tips = new HashSet<String>();
        if (value != null) {
            boolean validFlag = true;
            JSONObject jsonObject = JSON.parseObject((String)value.toString());
            if (jsonObject != null) {
                List collect;
                Object name = jsonObject.get((Object)"name");
                Object valueObj = jsonObject.get((Object)"value");
                tipsMap.put(KEY_PLANNAME, name != null && !StringUtils.isEmpty((String)name.toString()) ? name : "\u672a\u77e5\u6a21\u677f");
                if (valueObj == null) {
                    tips.add("%s\u6a21\u677f\u672a\u914d\u7f6e\u4efb\u4f55\u8bc6\u522b\u5173\u8054\u914d\u7f6e\uff0c\u8bf7\u5173\u8054\u914d\u7f6e\u3002");
                    tipsMap.put(KEY_TIPS, tips);
                    tipsMapList.add(tipsMap);
                    return false;
                }
                JSONArray arrayValue = jsonObject.getJSONArray("value");
                long notEmptyCount = arrayValue.stream().filter(a -> ((Map)a).entrySet().stream().anyMatch(en -> !StringUtils.isEmpty((String)((String)en.getValue())))).count();
                if (notEmptyCount < 1L) {
                    tips.add("%s\u6a21\u677f\u672a\u914d\u7f6e\u4efb\u4f55\u4e1a\u52a1\u5b57\u6bb5\uff0c\u8bf7\u5173\u8054\u914d\u7f6e\u3002");
                    validFlag = false;
                }
                if (!(collect = arrayValue.stream().filter(a -> ((Map)a).entrySet().stream().anyMatch(en -> !StringUtils.isEmpty((String)((String)en.getValue())))).collect(Collectors.toList())).isEmpty() && collect.size() > 1) {
                    HashSet<Object> set = new HashSet<Object>();
                    for (Object arrMapObj : collect) {
                        for (Map.Entry en : ((Map)arrMapObj).entrySet()) {
                            if (set.add(bizEntityMap.get(en.getValue()))) continue;
                            tips.add("\u68c0\u6d4b\u5230%s\u6a21\u677f\u4e2d\u5b58\u5728\u4e00\u6761\u4e1a\u52a1\u5b57\u6bb5\u5bf9\u5e94\u591a\u6761\u8bc6\u522b\u5b57\u6bb5\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u540e\u4fdd\u5b58\u3002");
                            validFlag = false;
                        }
                    }
                }
            }
            if (!validFlag) {
                if (!tips.isEmpty()) {
                    tipsMap.put(KEY_TIPS, tips);
                    tipsMapList.add(tipsMap);
                }
                return false;
            }
            return true;
        }
        log.error("\u6821\u9a8c\u5931\u8d25\uff0c\u8bc6\u522b\u914d\u7f6e\u5b57\u6bb5planConfig\u4e3a\u7a7a\u3002");
        return false;
    }

    private Map<Object, Object> getOnePlun(Map<Object, Object> templates, Object pkvalue) {
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)pkvalue, (String)"cvp_template");
        OcrPlanTemplateField planConfig = this.getPlanConfig(templateObj);
        Object id = templateObj.getPkValue();
        templates.put(id, planConfig);
        return templates;
    }

    private OcrPlanTemplateField getPlanConfig(DynamicObject templateObj) {
        OrmLocaleValue templateNameLocale = (OrmLocaleValue)templateObj.get("name");
        String templateName = templateNameLocale.getLocaleValue();
        String infoStr = (String)templateObj.get("temptageinfo");
        TemplateDistInfo templateDistInfo = (TemplateDistInfo)JSON.parseObject((String)infoStr, TemplateDistInfo.class);
        DistinguishPos distPos = templateDistInfo.getDistinguishPos();
        List texts = distPos.getRecognitionArea();
        List tables = distPos.getTable();
        ArrayList<String> distinguishFields = new ArrayList<String>(10);
        ArrayList<Map<String, String>> value = new ArrayList<Map<String, String>>(10);
        for (Text text : texts) {
            List nameList = text.getNameList();
            if (nameList != null && !nameList.isEmpty()) {
                for (String name : nameList) {
                    this.setFieldsMap(distinguishFields, value, name);
                }
                continue;
            }
            this.setFieldsMap(distinguishFields, value, text.getFieldName());
        }
        for (Table table : tables) {
            String tableName = table.getTableName();
            List tableListName = table.getTableListName();
            for (String s : tableListName) {
                HashMap<String, String> va = new HashMap<String, String>(tableListName.size());
                va.put(tableName + "." + s, "");
                value.add(va);
                distinguishFields.add(tableName + "." + s);
            }
        }
        return new OcrPlanTemplateField(templateName, value, distinguishFields);
    }

    private void setFieldsMap(List<String> distinguishFields, List<Map<String, String>> value, String name) {
        HashMap<String, String> va = new HashMap<String, String>(2);
        va.put(name, "");
        value.add(va);
        distinguishFields.add(name);
    }

    private List<Map<String, String>> getObjInfoList() {
        MainEntityType businessObjType = this.getBusinessObjType();
        List<Map<String, String>> businessFields = null;
        if (businessObjType != null) {
            EntityTypeUtil helper = new EntityTypeUtil();
            List catalogs = helper.getFilterColumns((IDataEntityType)businessObjType, false);
            this.buildEntitiesInPageCache(businessObjType.getName(), catalogs);
            businessFields = this.createBusinessFields("cvp_plan", businessObjType.getName(), catalogs);
        }
        return businessFields;
    }

    private void buildEntitiesInPageCache(String bizObjName, List<Map<String, Object>> catalogs) {
        IPageCache pageCache = this.getView().getPageCache();
        if (catalogs == null || catalogs.isEmpty()) {
            return;
        }
        HashMap<String, String> keyEntityMap = new HashMap<String, String>(catalogs.size());
        for (Map<String, Object> map : catalogs) {
            String entryEntity = String.valueOf(map.get("entryEntity"));
            String fieldType = String.valueOf(map.get("type"));
            String fieldName = String.valueOf(map.get("fieldName"));
            List<String> basedataTypeList = Arrays.asList("basedata,user,org".split(","));
            String bizEntityKey = null;
            if (entryEntity.equals(bizObjName)) {
                bizEntityKey = basedataTypeList.contains(fieldType) || fieldName.contains(".") ? fieldName.substring(0, fieldName.lastIndexOf(46)) : fieldName;
            } else if (basedataTypeList.contains(fieldType) || fieldName.contains(".")) {
                String basedataName = fieldName.substring(0, fieldName.lastIndexOf(46));
                bizEntityKey = entryEntity + "." + basedataName;
            } else {
                bizEntityKey = entryEntity + "." + fieldName;
            }
            String mappingFieldKey = fieldName;
            if (!StringUtils.isEmpty((String)entryEntity) && !bizObjName.equals(entryEntity)) {
                mappingFieldKey = entryEntity + "." + fieldName;
            }
            keyEntityMap.put(mappingFieldKey, bizEntityKey);
        }
        if (!keyEntityMap.isEmpty()) {
            log.info("\u6784\u5efa\u754c\u9762\u7f13\u5b58\u5b9e\u4f53\u5bf9\u8c61");
            pageCache.putBigObject(KEY_BIGOBJ, JSON.toJSONString(keyEntityMap));
        }
    }

    private List<Map<String, String>> createBusinessFields(String entityNumber, String businessObjName, List<Map<String, Object>> listNodes) {
        if (listNodes == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(listNodes.size());
        for (Map<String, Object> map : listNodes) {
            int fieldType = (Integer)map.get("fieldType");
            if (fieldType != -9 && fieldType != 3 && fieldType != 4 && fieldType != 91 && fieldType != 93) continue;
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            String key = fieldName;
            if (!(StringUtils.isEmpty((String)entryEntity) || entityNumber.equals(entryEntity) || businessObjName.equals(entryEntity))) {
                key = entryEntity + "." + fieldName;
            }
            LinkedHashMap<String, String> bussinesMap = new LinkedHashMap<String, String>(2);
            bussinesMap.put(key, fieldCaption);
            list.add(bussinesMap);
        }
        return list;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IPageCache pageCache = this.getView().getPageCache();
        String bigObject = pageCache.getBigObject(KEY_BIGOBJ);
        if (bigObject != null && StringUtils.isNotEmpty((String)bigObject)) {
            pageCache.removeBigObject(KEY_BIGOBJ);
        }
    }

    private MainEntityType getBusinessObjType() {
        DynamicObject target = (DynamicObject)this.getModel().getValue("businessobject");
        if (target == null) {
            return null;
        }
        String entityNumber = (String)target.getPkValue();
        return EntityMetadataCache.getDataEntityType((String)entityNumber);
    }

    private void setPlanCustom(IFormView view, DynamicObject plan) {
        boolean flag = (Boolean)view.getModel().getValue("useclassifier");
        log.info(flag ? "\u7ec4\u5408\u8bc6\u522b\u5668\u914d\u7f6e\u9879\u751f\u6548." : "\u6a21\u677f\u975e\u7ec4\u5408\u8bc6\u522b\u5668\u914d\u7f6e\u9879\u751f\u6548.");
        Object planConfigObj = plan.get("templateconfig");
        JSONObject templates = planConfigObj != null ? JSON.parseObject((String)planConfigObj.toString()) : new JSONObject();
        HashMap newTemplate = new HashMap(16);
        for (Map.Entry entry : templates.entrySet()) {
            JSONObject oldConfigStr = (JSONObject)entry.getValue();
            OcrPlanTemplateField oldConfig = (OcrPlanTemplateField)JSON.parseObject((String)oldConfigStr.toString(), OcrPlanTemplateField.class);
            List oldFields = oldConfig.getDistinguishFields();
            List oldValue = oldConfig.getValue();
            DynamicObject templateObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf((String)entry.getKey()), (String)"cvp_template");
            OcrPlanTemplateField currenPlanConfig = this.getPlanConfig(templateObj);
            List currenFields = currenPlanConfig.getDistinguishFields();
            List retainKey = oldFields.stream().filter(currenFields::contains).collect(Collectors.toList());
            List retainValue = oldValue.stream().filter(m -> retainKey.contains(m.keySet().toArray()[0])).collect(Collectors.toList());
            OcrPlanTemplateField field = new OcrPlanTemplateField(currenPlanConfig.getName(), retainValue, currenFields);
            newTemplate.put(entry.getKey(), field);
        }
        if (!newTemplate.isEmpty()) {
            this.setPageConfig(flag, JSON.toJSONString(newTemplate));
        }
        this.getModel().setValue("templateconfig", (Object)JSON.toJSONString(newTemplate));
        this.getModel().setDataChanged(false);
        this.setPlanCustomByModel(view, this.getModel(), true);
    }

    private void setPageConfig(boolean flag, String str) {
        IPageCache pageCache = this.getView().getPageCache();
        String planConfigStr = pageCache.get(KEY_PAGECACHE_PLANCONFIG);
        JSONObject jsonObject = null;
        jsonObject = StringUtils.isNotEmpty((String)planConfigStr) ? JSON.parseObject((String)planConfigStr) : new JSONObject();
        jsonObject.put(!flag ? KEY_PAGECACHE_TEMPLATECONFIG : KEY_PAGECACHE_CLSCONFIG, (Object)str);
        pageCache.put(KEY_PAGECACHE_PLANCONFIG, jsonObject.toJSONString());
    }

    private void setPlanCustomByModel(IFormView view, IDataModel model, boolean genCurrentTemp) {
        Map<Object, Object> templates = this.queryBusinessAndTemplate(model);
        this.paddingEntity(view, templates, genCurrentTemp);
        Map<String, Object> map = this.genEntry(templates);
        if (map.get(MARK_BUSINESSLIST) != null) {
            if (map.get(MARK_DISTINGUISHFIELDS) != null) {
                this.setEntryComboEdit((List)map.get(MARK_DISTINGUISHFIELDS), (List)map.get(MARK_BUSINESSLIST));
                this.fillInValue((List)map.get(MARK_DISTINGUISHFIELDS));
                this.updateModelPlanConfig(templates);
            } else {
                this.clearComboEdit();
            }
        }
    }

    private void clearComboEdit() {
        ComboEdit recfiled = (ComboEdit)this.getView().getControl(KEY_RECFILED);
        ComboEdit businessfield = (ComboEdit)this.getView().getControl(KEY_BUSINESSFILED);
        recfiled.setComboItems(new ArrayList(1));
        businessfield.setComboItems(new ArrayList(1));
    }

    private void updateModelPlanConfig(Map<Object, Object> templates) {
        Object value = this.getModel().getValue("templateconfig");
        boolean useClsFlag = (Boolean)this.getModel().getValue("useclassifier");
        if (templates != null && !templates.isEmpty()) {
            String tempStr = this.getPlanConfigByNewTemplates(templates);
            if (value != null && StringUtils.isNotEmpty((String)value.toString())) {
                String valueStr = value.toString();
                JSONObject jsonObject = JSON.parseObject((String)valueStr);
                JSONObject dbJsonObject = JSON.parseObject((String)tempStr);
                Set dbKey = dbJsonObject.keySet();
                JSONObject resultObj = new JSONObject();
                if (!dbKey.isEmpty()) {
                    dbKey.forEach(k -> {
                        if (jsonObject.get(k) == null) {
                            resultObj.put(k, dbJsonObject.get(k));
                        } else {
                            resultObj.put(k, jsonObject.get(k));
                        }
                    });
                }
                tempStr = this.getFromPageCache(useClsFlag, resultObj);
            }
            this.setPageConfig(useClsFlag, tempStr);
            this.getModel().setValue("templateconfig", (Object)tempStr);
            this.getModel().setDataChanged(false);
        }
    }

    private String getFromPageCache(boolean useClsFlag, JSONObject resultObj) {
        IPageCache pageCache = this.getView().getPageCache();
        String planConfigStr = pageCache.get(KEY_PAGECACHE_PLANCONFIG);
        JSONObject jsonObject = null;
        jsonObject = StringUtils.isNotEmpty((String)planConfigStr) ? JSON.parseObject((String)planConfigStr) : new JSONObject();
        String cacheStr = jsonObject.getString(!useClsFlag ? KEY_PAGECACHE_TEMPLATECONFIG : KEY_PAGECACHE_CLSCONFIG);
        JSONObject cacheObj = JSON.parseObject((String)cacheStr);
        JSONObject resObj = new JSONObject();
        if (cacheObj != null) {
            resultObj.keySet().forEach(k -> {
                if (cacheObj.get(k) == null) {
                    resObj.put(k, resultObj.get(k));
                } else {
                    resObj.put(k, cacheObj.get(k));
                }
            });
            return resObj.toJSONString();
        }
        return resultObj.toJSONString();
    }

    private String getPlanConfigByNewTemplates(Map<Object, Object> templates) {
        HashMap tempMap = new HashMap(templates.size() - 1);
        templates.forEach((k, v) -> {
            if (!"businessFields".equals(k)) {
                tempMap.put(k, v);
            }
        });
        return JSON.toJSONString(tempMap);
    }

    private Map<Object, Object> queryBusinessAndTemplate(IDataModel model) {
        HashMap<Object, Object> templates = new HashMap<Object, Object>(16);
        List<Map<String, String>> objInfoList = this.getObjInfoList();
        templates.put("businessFields", objInfoList);
        this.getAllTemplate(model, templates);
        return templates;
    }

    private void getAllTemplate(IDataModel model, Map<Object, Object> templates) {
        DynamicObjectCollection rows;
        boolean useClassifierFlag = (Boolean)model.getValue("useclassifier");
        DynamicObjectCollection dynamicObjectCollection = rows = useClassifierFlag ? this.getAllTemplateByClassifierBase(model) : (DynamicObjectCollection)model.getValue("choosetemplatebase");
        if (rows != null && !rows.isEmpty()) {
            for (DynamicObject base : rows) {
                this.getOnePlun(templates, useClassifierFlag ? base.getPkValue() : base.getDynamicObject("fbasedataid").getPkValue());
            }
        }
    }

    private DynamicObjectCollection getAllTemplateByClassifierBase(IDataModel model) {
        DynamicObject classifier = (DynamicObject)model.getValue("classifier");
        String planConfigStr = (String)model.getValue("templateconfig");
        boolean useClsFlag = (Boolean)model.getValue("useclassifier");
        if (useClsFlag && classifier != null) {
            JSONObject configObj;
            Set keys;
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            DynamicObject classifierDBObj = BusinessDataServiceHelper.loadSingle((Object)classifier.getPkValue(), (DynamicObjectType)classifier.getDynamicObjectType());
            if (classifierDBObj != null && !"C".equals(classifierDBObj.getString("status")) && !(keys = (configObj = JSON.parseObject((String)planConfigStr)).keySet()).isEmpty()) {
                DynamicObject dynamicObject = null;
                for (String templateId : keys) {
                    dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cvp_cls_info");
                    dynamicObject.set("id", (Object)Long.parseLong(templateId));
                    dynamicObjects.add((Object)dynamicObject);
                }
                return dynamicObjects;
            }
            classifier.getDynamicObjectCollection("template_infos").forEach(obj -> {
                if (obj != null && obj.getDynamicObject("included_template") != null) {
                    dynamicObjects.add((Object)obj.getDynamicObject("included_template"));
                }
            });
            return dynamicObjects;
        }
        return null;
    }

    private void setComboEdit(IFormView view, String comboKey, JSONObject config) {
        List<ComboItem> comboItem = this.createComboItem(config);
        ComboEdit ocrtemplate = (ComboEdit)view.getControl(comboKey);
        if (comboItem == null || !comboItem.isEmpty()) {
            ocrtemplate.setComboItems(comboItem);
        } else {
            ocrtemplate.setComboItems(new ArrayList(1));
        }
        if (comboItem != null && !comboItem.isEmpty()) {
            ComboItem c = comboItem.get(0);
            this.getModel().setValue("currenttemplatenum", (Object)c.getValue());
            view.getModel().setDataChanged(false);
        }
    }

    private List<ComboItem> createComboItem(JSONObject config) {
        if (config == null) {
            return Collections.emptyList();
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(config.size());
        Set entries = config.entrySet();
        for (Map.Entry map : entries) {
            ComboItem comboItem = new ComboItem();
            OcrPlanTemplateField planTemplateField = (OcrPlanTemplateField)JSON.parseObject((String)map.getValue().toString(), OcrPlanTemplateField.class);
            comboItem.setCaption(new LocaleString(planTemplateField.getName()));
            comboItem.setValue((String)map.getKey());
            list.add(comboItem);
        }
        return list;
    }

    private void paddingEntity(IFormView view, Map<Object, Object> templates, boolean genCurrentTemp) {
        if (!genCurrentTemp) {
            log.info("\u4e0d\u9700\u8981\u5904\u7406\u5f53\u524d\u6a21\u677f\u4e0b\u62c9\u6570\u636e\u3002\u3002");
            return;
        }
        boolean useClsFlag = (Boolean)view.getModel().getValue("useclassifier");
        DynamicObjectCollection templateobjCollect = (DynamicObjectCollection)view.getModel().getValue("choosetemplatebase");
        DynamicObjectCollection allTemplateByClassifierBase = this.getAllTemplateByClassifierBase(view.getModel());
        if (!useClsFlag && (templateobjCollect == null || templateobjCollect.isEmpty()) || useClsFlag && (allTemplateByClassifierBase == null || allTemplateByClassifierBase.isEmpty())) {
            log.info("\u5bf9\u5e94\u7684\u6a21\u677f\u4e3a\u7a7a\u3002\u3002\u3002\u6e05\u7a7a\u4e0b\u62c9\u5185\u5bb9\u3002");
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
            this.getModel().setValue("currenttemplatenum", (Object)"");
        }
        this.genCurrentTemplateCombo(view, templates);
    }

    private Map<String, Object> genEntry(Map<Object, Object> templates) {
        String valueStr;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(10);
        Object value = this.getModel().getValue("currenttemplatenum");
        OcrPlanTemplateField templateField = null;
        List distinguishFields = null;
        List businessList = (List)templates.get("businessFields");
        resultMap.put(MARK_BUSINESSLIST, businessList);
        if (value != null && StringUtils.isNotEmpty((String)value.toString()) && (templateField = (OcrPlanTemplateField)templates.get(Long.parseLong(valueStr = value.toString()))) != null) {
            distinguishFields = templateField.getDistinguishFields();
            resultMap.put(MARK_DISTINGUISHFIELDS, distinguishFields);
        }
        return resultMap;
    }

    private void fillInValue(List<String> distinguishFields) {
        if (distinguishFields != null && !distinguishFields.isEmpty()) {
            JSONObject jsonObject;
            Object planConfigObj;
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
            String planConfig = this.getView().getPageCache().get(KEY_PAGECACHE_PLANCONFIG);
            JSONObject totalConfigObj = JSON.parseObject((String)planConfig);
            boolean useClsFlag = (Boolean)this.getModel().getValue("useclassifier");
            String planConfigStr = "";
            if (totalConfigObj != null) {
                planConfigStr = !useClsFlag ? totalConfigObj.getString(KEY_PAGECACHE_TEMPLATECONFIG) : totalConfigObj.getString(KEY_PAGECACHE_CLSCONFIG);
            }
            List value = new ArrayList(16);
            Object currentTempId = this.getModel().getValue("currenttemplatenum");
            if (!StringUtils.isEmpty((String)planConfigStr) && (planConfigObj = (jsonObject = JSON.parseObject((String)planConfigStr)).get((Object)currentTempId.toString())) != null) {
                OcrPlanTemplateField templateField = (OcrPlanTemplateField)JSON.parseObject((String)planConfigObj.toString(), OcrPlanTemplateField.class);
                value = templateField.getValue();
                this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, value.size());
            }
            if (value.isEmpty()) {
                this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, distinguishFields.size());
            }
            int count = !value.isEmpty() ? value.size() : distinguishFields.size();
            for (int i = 0; i < count; ++i) {
                if (!value.isEmpty()) {
                    Map map = (Map)value.get(i);
                    for (Map.Entry next : map.entrySet()) {
                        this.getModel().setValue(KEY_RECFILED, next.getKey(), i);
                        this.getModel().setValue(KEY_BUSINESSFILED, next.getValue(), i);
                    }
                    continue;
                }
                this.getModel().setValue(KEY_RECFILED, (Object)distinguishFields.get(i), i);
                this.getModel().setValue(KEY_BUSINESSFILED, (Object)"", i);
            }
        }
    }

    private void setEntryComboEdit(List<String> distinguishFields, List<Map<String, Object>> businessList) {
        ComboEdit recfiled = (ComboEdit)this.getView().getControl(KEY_RECFILED);
        ComboEdit businessfield = (ComboEdit)this.getView().getControl(KEY_BUSINESSFILED);
        ArrayList<ComboItem> distList = new ArrayList<ComboItem>(distinguishFields.size());
        for (String disStr : distinguishFields) {
            ComboItem disComboItem = new ComboItem();
            disComboItem.setCaption(new LocaleString(disStr));
            disComboItem.setValue(disStr);
            distList.add(disComboItem);
        }
        recfiled.setComboItems(distList);
        ArrayList<ComboItem> busList = new ArrayList<ComboItem>(businessList.size());
        for (Map<String, Object> map : businessList) {
            for (Map.Entry<String, Object> next : map.entrySet()) {
                ComboItem busComboItem = new ComboItem();
                busComboItem.setCaption(new LocaleString(next.getValue().toString()));
                busComboItem.setValue(next.getKey());
                busList.add(busComboItem);
            }
        }
        businessfield.setComboItems(busList);
    }

    private void genCurrentTemplateCombo(IFormView view, Map<Object, Object> templates) {
        HashMap tempMap = new HashMap(10);
        if (templates != null && templates.size() > 0) {
            HashMap tMap = new HashMap(templates.size() - 1);
            templates.forEach((k, v) -> {
                if (!"businessFields".equals(k)) {
                    tMap.put(k, v);
                }
            });
            tempMap.putAll(tMap);
        }
        if (tempMap.size() > 0) {
            this.setComboEdit(view, "currenttemplatenum", JSON.parseObject((String)JSON.toJSONString(tempMap)));
        } else {
            ComboEdit ocrtemplate = (ComboEdit)view.getControl("currenttemplatenum");
            ocrtemplate.setComboItems(new ArrayList(1));
        }
    }
}

