/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.Map;
import kd.ai.cvp.task.TdaFlushDataExcutors;
import kd.ai.cvp.task.TiePullResultService;
import kd.ai.cvp.utils.LicenseDosageReqUtils;
import kd.ai.cvp.utils.LicenseUtils;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class OcrRemainDosagePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(OcrRemainDosagePlugin.class);
    private static String KEY_TOTAL_USED = "total";
    private static String KEY_REMAIN = "labelap";
    private static String KEY_TOTAL = "labelap2";
    private static String KEY_UNLIMIT = "flexpanelap4";
    private static String KEY_LIMIT = "flexpanelap3";

    public void beforeBindData(EventObject e) {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5269\u4f59\u4f7f\u7528\u91cf\u5361\u7247\u3002\u3002\u3002");
        super.beforeBindData(e);
        IFormView view = this.getView();
        try {
            boolean hasRDLicense = LicenseUtils.checkHasRDLicense();
            if (hasRDLicense) {
                view.setVisible(Boolean.FALSE, new String[]{KEY_LIMIT});
                view.setVisible(Boolean.TRUE, new String[]{KEY_UNLIMIT});
            } else {
                int totalNumber = LicenseServiceHelper.getTotalNumber((Object)506L);
                logger.info("\u6d41\u91cf\u8bb8\u53ef\u3002\u3002\u3002totalNumber:" + totalNumber);
                Map map = LicenseDosageReqUtils.queryLicenseRemainCount((IFormView)view, (Boolean)Boolean.TRUE);
                long totalUsed = 0L;
                if (map != null && map.size() > 0) {
                    logger.info("\u67e5\u8be2\u5230\u7684\u6570\u91cf\uff1a" + JSON.toJSONString((Object)map));
                    totalUsed = (Long)map.get(KEY_TOTAL_USED);
                }
                this.remind(view, totalNumber, totalUsed);
                long remainTotal = (long)totalNumber - totalUsed;
                Label remainLabel = (Label)view.getControl(KEY_REMAIN);
                remainLabel.setText(String.valueOf(remainTotal));
                Label totalLabel = (Label)view.getControl(KEY_TOTAL);
                totalLabel.setText(String.valueOf(totalNumber));
                view.setVisible(Boolean.FALSE, new String[]{KEY_UNLIMIT});
                view.setVisible(Boolean.TRUE, new String[]{KEY_LIMIT});
            }
            TdaFlushDataExcutors.excuteTask((RequestContext)RequestContext.get());
            TiePullResultService.syncPullTieResult((RequestContext)RequestContext.get());
        }
        catch (Exception ex) {
            String msg = "\u67e5\u8be2\u5269\u4f59\u6b21\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            logger.error(msg + ex.getMessage(), (Throwable)ex);
            view.showErrorNotification(msg);
            view.setVisible(Boolean.FALSE, new String[]{KEY_UNLIMIT});
            view.setVisible(Boolean.TRUE, new String[]{KEY_LIMIT});
        }
    }

    private void remind(IFormView view, int totalNumber, long totalUsed) {
        if ((long)totalNumber > totalUsed && (double)totalNumber * 0.9 < (double)totalUsed) {
            view.showTipNotification("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5f53\u5e74\u8ba2\u9605\u671f\u5185\u5269\u4f59\u7528\u91cf\u4e0d\u8db3\uff08<10%\uff09\uff0c\u8bf7\u53ca\u65f6\u52a0\u8d2d\u6d41\u91cf\u3002");
            return;
        }
        if ((long)totalNumber <= totalUsed) {
            view.showErrorNotification("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u7528\u91cf\u5df2\u7528\u5b8c\uff0c\u8bf7\u7acb\u5373\u52a0\u8d2d\u6d41\u91cf\u3002");
            return;
        }
    }
}

