/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.ai.cvp.common.Enum.DistingushFileTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.entity.OcrRecFile;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class OcrTemplateCommon {
    private static final Log log = LogFactory.getLog(OcrTemplateCommon.class);
    private static final String APPID_NAME = "ai-cvp-plugin";
    public static final String FILE_URL = "fileUrl";
    public static final String ALERT_MSG = "alertMsg";
    public static final String BASE64_STR = "base64Str";
    public static final String ORIGIN_FILE_URL = "originFileUrl";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> preRequest(OcrRecFile ocrRecFile) throws IOException {
        String result;
        String fileName = ocrRecFile.getFileName();
        String fileSize = ocrRecFile.getFileSize();
        String fileType = ocrRecFile.getFileType();
        String url = ocrRecFile.getUrl();
        boolean exists = FileServiceFactory.getAttachmentFileService().exists(url);
        if (StringUtils.isEmpty((String)url) || !exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"OcrTemplateCommon_001", (String)APPID_NAME, (Object[])new Object[0]));
        }
        if (!DistingushFileTypeEnum.existValue((String)fileType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"OcrTemplateCommon_003", (String)APPID_NAME, (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)fileSize) && Integer.parseInt(fileSize) > 0x800000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8d85\u8fc7\u9ed8\u8ba4\u652f\u6301\u5927\u5c0f\uff0c\u8bf7\u4e0a\u4f20\u5408\u9002\u5927\u5c0f\u7684\u6587\u4ef6\u8fdb\u884c\u6d4b\u8bd5\u3002", (String)"OcrTemplateCommon_002", (String)APPID_NAME, (Object[])new Object[0]));
        }
        String tempPath = CvpFileServiceUtils.attFile2TempFile((String)url);
        FileServiceFactory.getAttachmentFileService().delete(url);
        log.info("tempUrl:{},suffixStr:{},fileName:{}", new Object[]{tempPath, fileType, fileName});
        InputStream inputStream = null;
        try {
            inputStream = CvpFileServiceUtils.getFileIn((StorageTypeEnum)StorageTypeEnum.TMP, (String)tempPath);
            result = StreamHandleUtils.validFileType((InputStream)inputStream, (String)fileType);
        }
        finally {
            StreamHandleUtils.closeResource((Closeable)inputStream);
        }
        if (!StringUtils.isEmpty((String)result)) {
            log.error("result:{}", (Object)result);
            throw new KDBizException(result);
        }
        Map<String, String> resultMap = OcrTemplateCommon.handleFile(fileType, tempPath, fileName);
        if (!resultMap.isEmpty()) {
            resultMap.put(ORIGIN_FILE_URL, tempPath);
        }
        return resultMap;
    }

    public static Map<String, String> handleFile(String suffixStr, String tempPath, String fileName) {
        ByteArrayInputStream imageInput;
        InputStream zipImageInputStream;
        InputStream imageInputStream;
        InputStream pdfFirstInputStream;
        InputStream originInputStream;
        PdfReader pdfReader;
        HashMap<String, String> resultMap;
        block8: {
            resultMap = new HashMap<String, String>(10);
            pdfReader = null;
            originInputStream = null;
            pdfFirstInputStream = null;
            imageInputStream = null;
            zipImageInputStream = null;
            imageInput = null;
            try {
                originInputStream = CvpFileServiceUtils.getFileIn((StorageTypeEnum)StorageTypeEnum.TMP, (String)tempPath);
                if (suffixStr.equalsIgnoreCase(DistingushFileTypeEnum.PDF.getVlaue())) {
                    pdfReader = new PdfReader(originInputStream);
                    int numberOfPages = pdfReader.getNumberOfPages();
                    pdfReader.close();
                    if (numberOfPages > 1) {
                        resultMap.put(ALERT_MSG, ResManager.loadKDString((String)String.format("\u6587\u4ef6\u201c%s\u201d\u4e0a\u4f20\u6210\u529f\uff0c\u591a\u9875pdf\u4ec5\u652f\u6301\u8bc6\u522b\u9996\u9875\u5185\u5bb9\u3002", fileName), (String)"OcrPersetTemplateTestPlugin_005", (String)APPID_NAME, (Object[])new Object[0]));
                    }
                    originInputStream = CvpFileServiceUtils.getFileIn((StorageTypeEnum)StorageTypeEnum.TMP, (String)tempPath);
                    pdfFirstInputStream = OcrControlUtils.getPDFFirstInputStream((InputStream)originInputStream);
                    StreamHandleUtils.closeResource((Closeable)originInputStream);
                    imageInputStream = OcrControlUtils.getImageInputStreamByPDFInputStream((InputStream)pdfFirstInputStream);
                    StreamHandleUtils.closeResource((Closeable)pdfFirstInputStream);
                    zipImageInputStream = OcrControlUtils.getZipImageInputStream((InputStream)imageInputStream, (boolean)false);
                    StreamHandleUtils.closeResource((Closeable)imageInputStream);
                    byte[] bytes = StreamHandleUtils.copyStream((InputStream)zipImageInputStream);
                    StreamHandleUtils.closeResource((Closeable)zipImageInputStream);
                    String newTempImagePath = CvpFileServiceUtils.saveFile((StorageTypeEnum)StorageTypeEnum.TMP, (String)fileName, (byte[])bytes);
                    imageInput = new ByteArrayInputStream(bytes);
                    String base64Str = OcrControlUtils.getFileBase64ByIO((InputStream)imageInput);
                    StreamHandleUtils.closeResource((Closeable)imageInput);
                    resultMap.put(BASE64_STR, base64Str);
                    resultMap.put(FILE_URL, newTempImagePath);
                    break block8;
                }
                if (!Arrays.asList(DistingushFileTypeEnum.IMAGE.getVlaue().split(",")).contains(suffixStr.toLowerCase())) break block8;
                zipImageInputStream = OcrControlUtils.getZipImageInputStream((InputStream)originInputStream, (boolean)true);
                StreamHandleUtils.closeResource((Closeable)originInputStream);
                byte[] bytes = StreamHandleUtils.copyStream((InputStream)zipImageInputStream);
                StreamHandleUtils.closeResource((Closeable)zipImageInputStream);
                String newTempImagePath = CvpFileServiceUtils.saveFile((StorageTypeEnum)StorageTypeEnum.TMP, (String)fileName, (byte[])bytes);
                imageInput = new ByteArrayInputStream(bytes);
                String imageBase64ByIO = OcrControlUtils.getFileBase64ByIO((InputStream)imageInput);
                StreamHandleUtils.closeResource((Closeable)imageInput);
                resultMap.put(BASE64_STR, imageBase64ByIO);
                resultMap.put(FILE_URL, newTempImagePath);
            }
            catch (Exception ex) {
                try {
                    log.error("\u672a\u77e5\u7684\u5f02\u5e38", (Throwable)ex);
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6d4b\u8bd5\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"OcrPersetTemplateTestPlugin_002", (String)APPID_NAME, (Object[])new Object[0]));
                }
                catch (Throwable throwable) {
                    StreamHandleUtils.closeResource((Closeable)originInputStream);
                    StreamHandleUtils.closeResource(pdfFirstInputStream);
                    StreamHandleUtils.closeResource(imageInputStream);
                    StreamHandleUtils.closeResource(zipImageInputStream);
                    StreamHandleUtils.closeResource(imageInput);
                    if (pdfReader != null) {
                        pdfReader.close();
                    }
                    throw throwable;
                }
            }
        }
        StreamHandleUtils.closeResource((Closeable)originInputStream);
        StreamHandleUtils.closeResource(pdfFirstInputStream);
        StreamHandleUtils.closeResource(imageInputStream);
        StreamHandleUtils.closeResource((Closeable)zipImageInputStream);
        StreamHandleUtils.closeResource(imageInput);
        if (pdfReader != null) {
            pdfReader.close();
        }
        return resultMap;
    }
}

