/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.cvp.entity.OcrPlanTemplateField;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OcrTemplateListPlugin
extends AbstractListPlugin
implements ItemClickListener,
ICloseCallBack {
    private static Log log = LogFactory.getLog(OcrTemplateListPlugin.class);
    private static final String APPID = "ai-cvp-plugin";
    private static final String OCR_IMPORT_PLUGIN = "kd.ai.cvp.plugin.OcrTemplateImportHandlerPlugin";

    public void itemClick(ItemClickEvent evt) {
        ListView view = (ListView)this.getView();
        IDataModel model = this.getModel();
        boolean clearSelection = true;
        String itemKey = evt.getItemKey();
        Object[] allPks = new Object[]{};
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cvp_template");
        DynamicObjectCollection currenObjs = null;
        Object[] currenPks = null;
        Object[] bindingPks = null;
        ArrayList<String> itemKeys = new ArrayList<String>(16);
        itemKeys.add("tbldel");
        itemKeys.add("tbldisable");
        itemKeys.add("btnenable");
        itemKeys.add("exportdata");
        if (!StringUtils.isEmpty((CharSequence)itemKey) && itemKeys.contains(itemKey)) {
            currenPks = view.getSelectedRows().getPrimaryKeyValues();
            Object filter = new QFilter("id", "in", (Object)currenPks);
            QFilter[] filters = new QFilter[]{filter};
            String selectFields = "id,bindingid,status,templateimg,referenceimg";
            currenObjs = QueryServiceHelper.query((String)"cvp_template", (String)selectFields, (QFilter[])filters);
            bindingPks = new Object[currenObjs.size()];
            for (int i = 0; i < currenObjs.size(); ++i) {
                Object binding;
                bindingPks[i] = binding = ((DynamicObject)currenObjs.get(i)).get("bindingid");
            }
            allPks = ArrayUtils.addAll((Object[])currenPks, (Object[])bindingPks);
        }
        log.info(String.format("%s - \u5217\u8868\u64cd\u4f5c\u6570\u636eID: %s", itemKey, Arrays.toString(allPks)));
        try {
            switch (itemKey) {
                case "tbldel": {
                    this.doDelete((IListView)view, dataEntityType, allPks, bindingPks, currenObjs);
                    break;
                }
                case "tbldisable": {
                    this.disableOrEnable(allPks, (IListView)view, dataEntityType, "C");
                    break;
                }
                case "btnenable": {
                    this.disableOrEnable(allPks, (IListView)view, dataEntityType, "A");
                    break;
                }
                case "exportdata": {
                    if (this.isNotSelectRow(view, currenPks)) {
                        return;
                    }
                    clearSelection = this.doExport(currenObjs);
                    break;
                }
                case "importdata": {
                    this.openOcrImportStart((IListView)view);
                    break;
                }
            }
            view.refresh();
            if (clearSelection) {
                view.clearSelection();
            }
            view.updateView();
            model.updateCache();
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)(itemKey + " - \u6a21\u677f\u5217\u8868\u64cd\u4f5c\u6309\u94ae\u533a\u5f02\u5e38 "), (String)"OcrTempPlugin_2", (String)APPID, (Object[])new Object[0]));
            log.error("\u6a21\u677f\u5217\u8868 \u64cd\u4f5c:" + itemKey + " - \u6570\u636eID: " + Arrays.toString(allPks) + ",\u64cd\u4f5c\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isNotSelectRow(ListView view, Object[] currenPks) {
        if (currenPks == null || currenPks.length < 1) {
            view.showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002");
            return true;
        }
        return false;
    }

    private boolean doExport(DynamicObjectCollection currenPks) throws IOException {
        return !this.validDataAndCallExport(currenPks);
    }

    private void doDelete(IListView view, MainEntityType dataEntityType, Object[] allPks, Object[] bindingPks, DynamicObjectCollection currenObjs) {
        if (allPks.length < 1 || currenObjs.isEmpty()) {
            return;
        }
        List deleteObjs = OcrControlUtils.getPlanConfigObjByTemplateKey((String)"in", (String)"templatenumber", (Object[])bindingPks);
        if (!deleteObjs.isEmpty()) {
            StringBuilder tempalteName = new StringBuilder();
            tempalteName.append('\u3010');
            int maxIndex = deleteObjs.size() - 1;
            if (maxIndex > 1) {
                for (int i = 0; i < maxIndex; ++i) {
                    OcrPlanTemplateField field = (OcrPlanTemplateField)JSON.parseObject((String)((DynamicObject)deleteObjs.get(i)).get("templateconfig").toString(), OcrPlanTemplateField.class);
                    tempalteName.append(field.getName()).append(';');
                }
            }
            String config = ((DynamicObject)deleteObjs.get(maxIndex)).get("templateconfig").toString();
            String name = ((OcrPlanTemplateField)JSON.parseObject((String)config, OcrPlanTemplateField.class)).getName();
            tempalteName.append(name).append('\u3011');
            this.getView().showTipNotification(tempalteName + ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u65b9\u6848\u5173\u8054\u4f7f\u7528\u4e0d\u53ef\u4ee5\u88ab\u5220\u9664,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"OcrTemplateListPlugin_0", (String)APPID, (Object[])new Object[0]));
            return;
        }
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])allPks);
        FileService imageFileService = FileServiceFactory.getImageFileService();
        for (DynamicObject obj : currenObjs) {
            String imagePath = obj.getString("templateimg");
            String refencePath = obj.getString("referenceimg");
            imageFileService.delete(imagePath);
            if (imagePath.equals(refencePath)) continue;
            imageFileService.delete(refencePath);
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"OcrTemplateListPlugin_17", (String)APPID, (Object[])new Object[0]));
    }

    private void openOcrImportStart(IListView view) {
        FormConfig config = FormMetadataCache.getFormConfig((String)view.getBillFormId());
        String billFormId = config.getEntityTypeId();
        String listName = config.getCaption().toString();
        FormShowParameter formShowParameter = new FormShowParameter();
        HashMap pluginsMap = new HashMap(10);
        HashMap<String, Object> pluginDetails = new HashMap<String, Object>(10);
        ArrayList<HashMap<String, Object>> plugins = new ArrayList<HashMap<String, Object>>(16);
        pluginDetails.put("ClassName", OCR_IMPORT_PLUGIN);
        pluginDetails.put("Enabled", Boolean.TRUE);
        pluginDetails.put("Inherit", Boolean.FALSE);
        plugins.add(pluginDetails);
        pluginsMap.put("plugins", plugins);
        formShowParameter.setCustomParams(pluginsMap);
        formShowParameter.setFormId("cvp_batch_bos_importstart");
        formShowParameter.setCustomParam("BillTypeId", (Object)((ListShowParameter)view.getFormShowParameter()).getBillTypeId());
        formShowParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        formShowParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        formShowParameter.setCustomParam("BillFormId", (Object)billFormId);
        formShowParameter.setCustomParam("ListName", (Object)listName);
        formShowParameter.setCustomParam("RealPermissionEntityId", (Object)"cvp_template");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private boolean validDataAndCallExport(DynamicObjectCollection selectedDObj) throws IOException {
        IFormView view = this.getView();
        if (selectedDObj != null) {
            boolean bigFlag = this.isBigThanExpectSize(selectedDObj);
            if (bigFlag) {
                view.showTipNotification(String.format("\u5bfc\u51fa\u7684\u6570\u636e\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7%dM\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", 30L));
                return false;
            }
        } else {
            view.showTipNotification("\u672a\u9009\u4e2d\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u540e\u518d\u8bd5\u3002");
            return false;
        }
        long notBStatus = selectedDObj.stream().filter(obj -> !"B".equals(obj.getString("status"))).count();
        FileService imageFileService = FileServiceFactory.getImageFileService();
        long noPicCount = selectedDObj.stream().filter(obj -> !imageFileService.exists(obj.getString("referenceimg")) && !imageFileService.exists(obj.getString("templateimg"))).count();
        StringBuilder sb = new StringBuilder();
        if (notBStatus > 0L) {
            sb.append("\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u4e2d\u5305\u542b\u975e\u53ef\u7528\u72b6\u6001\u7684\u6a21\u677f\uff0c\u5c06\u4e0d\u4f1a\u5728\u5bfc\u51fa\u7684excel\u4e2d\u51fa\u73b0\u3002");
        }
        if (noPicCount > 0L) {
            sb.append("\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u4e2d\u5305\u542b\u56fe\u7247\u4e22\u5931\u7684\u6a21\u677f\uff0c\u5c06\u4e0d\u4f1a\u5728\u5bfc\u51fa\u7684excel\u4e2d\u51fa\u73b0\u3002");
        }
        if (!StringUtils.isEmpty((CharSequence)sb)) {
            view.showTipNotification(sb.toString());
        }
        view.invokeOperation("exportlist", OperateOption.create());
        return true;
    }

    private boolean isBigThanExpectSize(DynamicObjectCollection selectedDObj) throws IOException {
        FileService imageFileService = FileServiceFactory.getImageFileService();
        HashSet imgSet = new HashSet();
        Set templateimgSet = selectedDObj.stream().filter(obj -> "B".equals(obj.getString("status")) && !StringUtils.isEmpty((CharSequence)obj.getString("templateimg"))).map(obj -> obj.getString("templateimg")).collect(Collectors.toSet());
        Set referenceimgSet = selectedDObj.stream().filter(obj -> "B".equals(obj.getString("status")) && !StringUtils.isEmpty((CharSequence)obj.getString("referenceimg"))).map(obj -> obj.getString("referenceimg")).collect(Collectors.toSet());
        imgSet.addAll(templateimgSet);
        imgSet.addAll(referenceimgSet);
        long totalSize = 0L;
        for (String imgUrl : imgSet) {
            if (!imageFileService.exists(imgUrl)) continue;
            InputStream inputStream = imageFileService.getInputStream(imgUrl);
            long size = StreamHandleUtils.getStreamSize((InputStream)inputStream);
            if (size < 0L) {
                throw new KDBizException("\u83b7\u53d6\u56fe\u7247\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            }
            if ((totalSize += size) <= 0x1E00000L) continue;
            return true;
        }
        return false;
    }

    private void disableOrEnable(Object[] allPks, IListView view, MainEntityType dataEntityType, String status) {
        DynamicObject[] cobj = BusinessDataServiceHelper.load((Object[])allPks, (DynamicObjectType)dataEntityType);
        if (cobj != null && cobj.length > 0) {
            for (DynamicObject obj : cobj) {
                obj.set("status", (Object)status);
            }
            SaveServiceHelper.update((DynamicObject[])cobj);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"OcrTemplateListPlugin_17", (String)APPID, (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        try {
            String operateKey = args.getOperateKey();
            if ("new".equals(operateKey) || "modify".equals(operateKey) || "copy".equals(operateKey)) {
                FormShowParameter showParameter = new FormShowParameter();
                Object pkValue = this.getSelectedPkValue();
                log.info("OcrListPlugin operation: " + operateKey + " - start pkId: " + pkValue);
                showParameter.setFormId("cvp_template");
                showParameter.getOpenStyle().setTargetKey("tabap");
                if ("new".equals(operateKey)) {
                    showParameter.setStatus(OperationStatus.ADDNEW);
                } else if ("copy".equals(operateKey)) {
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    showParameter.setCustomParam("iscopy", (Object)Boolean.TRUE);
                    if (pkValue == null) {
                        return;
                    }
                    showParameter.setCustomParam("billId", pkValue);
                } else if ("modify".equals(operateKey)) {
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    showParameter.setCustomParam("ismodify", (Object)Boolean.TRUE);
                    pkValue = this.getPkValue(args);
                    if (pkValue == null) {
                        return;
                    }
                    showParameter.setCustomParam("billId", pkValue);
                } else {
                    showParameter.setStatus(OperationStatus.VIEW);
                }
                CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            }
            log.info("OcrTemplateListPlugin operation end");
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u5355\u636e\u5217\u8868\u64cd\u4f5c\u5f02\u5e38", (String)"OcrTemplateListPlugin_16", (String)APPID, (Object[])new Object[0]));
            log.error("OcrTemplateListPlugin operation Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    private Object getPkValue(AfterDoOperationEventArgs args) {
        FormOperate formOperate;
        ListSelectedRow row;
        Object source = args.getSource();
        if (source instanceof FormOperate && (row = (formOperate = (FormOperate)source).getListFocusRow()) != null) {
            return row.getPrimaryKeyValue();
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        if (closedcallbackevent.getActionId().equals("listoperation")) {
            ((IListView)this.getView()).refresh();
        }
    }

    private Object getSelectedPkValue() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u6570\u636e\uff0c\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff01", (String)"OcrTemplateListPlugin_8", (String)APPID, (Object[])new Object[0]));
            return null;
        }
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if (pks.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u6570\u636e\uff0c\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff01", (String)"OcrTemplateListPlugin_8", (String)APPID, (Object[])new Object[0]));
            return null;
        }
        if (pks.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"OcrTemplateListPlugin_9", (String)APPID, (Object[])new Object[0]));
            return null;
        }
        if (!QueryServiceHelper.exists((String)"cvp_template", (Object)pks[0])) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86", (String)"OcrTemplateListPlugin_10", (String)APPID, (Object[])new Object[0]));
            return null;
        }
        return pks[0];
    }
}

