/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.ai.cvp.common.Enum.OcrRecEnum;
import kd.ai.cvp.common.Enum.code.AlgoInfoConvertCompleteEnum;
import kd.ai.cvp.common.Enum.code.AlgoInfoConvertTestEnum;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.CustomTableInfo;
import kd.ai.cvp.entity.CvpResultData;
import kd.ai.cvp.entity.OCRRecVO;
import kd.ai.cvp.entity.OcrCustomTempRecResponse;
import kd.ai.cvp.entity.OcrRecFile;
import kd.ai.cvp.entity.ReferenceAutoDataVO;
import kd.ai.cvp.entity.distinguish.AlgoData;
import kd.ai.cvp.entity.distinguish.OcrAlgoDistingshInfo;
import kd.ai.cvp.entity.param.OcrParam;
import kd.ai.cvp.entity.renfence.RenfenceInfoVO;
import kd.ai.cvp.entity.template.TemplateDistInfoVO;
import kd.ai.cvp.plugin.OcrTemplateCommon;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class OcrTemplatePlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener,
UploadListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(OcrTemplatePlugin.class);
    private static final String[] OCR_TEMP_MATES = new String[]{"templateimg", "referenceimg", "name", "description", "temptageinfo", "temprenfenceinfo", "templatemap"};
    private static final String[] OCR_TEMP_MATES_MODI = new String[]{"number", "creatorid", "name", "templateimg", "description", "temptageinfo", "temprenfenceinfo", "templatemap", "referenceimg"};
    private static final String[] OCR_TEMP_MATES_BIDING = new String[]{"number", "name", "modifierid", "modifydate", "isvalid", "status", "creatorid", "createdate", "templateimg", "description", "temptageinfo", "temprenfenceinfo", "templatemap", "referenceimg", "algoid"};
    private static final String KEY_GUIDE = "wizardap";
    private static final String KEY_GUIDECONTENT = "guidecontent";
    private static final String BILL_PLUGIN_NAME = "ai-cvp-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnsave", "btncancel", "templateimg", "testimage", "btncomplete", "templateinfo", "renfencefiled", "distinguishfiled", "templatetest", "templatecomplete", "btnimagetestagain"});
        Image image = (Image)this.getView().getControl("imageap");
        Button btnImageAgain = (Button)this.getView().getControl("btnimageagain");
        Button btnImageTestAgain = (Button)this.getView().getControl("btnimagetestagain");
        Image testimageap = (Image)this.getView().getControl("testimageap");
        Wizard wizard = (Wizard)this.getView().getControl(KEY_GUIDE);
        Tab guide = (Tab)this.getView().getControl(KEY_GUIDECONTENT);
        image.addClickListener((ClickListener)this);
        image.addUploadListener((UploadListener)this);
        testimageap.addClickListener((ClickListener)this);
        testimageap.addUploadListener((UploadListener)this);
        btnImageAgain.addClickListener((ClickListener)this);
        btnImageAgain.addUploadListener((UploadListener)this);
        btnImageTestAgain.addClickListener((ClickListener)this);
        btnImageTestAgain.addUploadListener((UploadListener)this);
        wizard.addClickListener((ClickListener)this);
        guide.addItemClickListener((ItemClickListener)this);
        wizard.addItemClickListener((ItemClickListener)this);
        guide.addTabSelectListener((TabSelectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            InputStream inputStream = null;
            try {
                String tempUrl = urls[0].toString();
                String suffixStr = tempUrl.substring(tempUrl.lastIndexOf(46) + 1);
                if ("templateinfo".equals(OcrControlUtils.getGuideCurrenName((IFormView)view))) {
                    log.info("\u6587\u4ef6\u670d\u52a1\u5668\u83b7\u53d6\u56fe\u7247\u8def\u5f84\u3002");
                    String imageFullUrl = UrlService.getImageFullUrl((String)urls[0].toString());
                    DynamicObject template = model.getDataEntity();
                    long pkValue = (Long)template.getPkValue();
                    String imagePath = (String)model.getValue("templateimg");
                    boolean exists = QueryServiceHelper.exists((String)"cvp_template", (Object)pkValue);
                    if (!exists && kd.bos.util.StringUtils.isNotEmpty((String)imagePath)) {
                        FileService imageFileService = FileServiceFactory.getImageFileService();
                        imageFileService.delete(imagePath);
                    }
                    inputStream = FileServiceFactory.getImageFileService().getInputStream(urls[0].toString());
                    String result = StreamHandleUtils.validFileType((InputStream)inputStream, (String)suffixStr);
                    StreamHandleUtils.closeResource((Closeable)inputStream);
                    if (!kd.bos.util.StringUtils.isEmpty((String)result)) {
                        evt.setCancel(true);
                        view.showTipNotification(result);
                        StreamHandleUtils.closeResource((Closeable)inputStream);
                        return;
                    }
                    Image imageap = (Image)this.getControl("imageap");
                    imageap.setUrl(imageFullUrl);
                    model.setValue("templateimg", urls[0]);
                }
            }
            catch (IOException e) {
                log.error("io exception", (Throwable)e);
                view.showErrorNotification("\u4e0a\u4f20\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                evt.setCancel(true);
            }
            finally {
                StreamHandleUtils.closeResource(inputStream);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initCopyOrModify();
    }

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btncomplete"});
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        String url = (String)model.getValue("templateimg");
        if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
            Image imageap = (Image)this.getControl("imageap");
            String imageFullUrl = CommonUtil.getAccountUrl((String)UrlService.getImageFullUrl((String)url));
            imageap.setUrl(imageFullUrl);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnimagetestagain"});
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        try {
            log.info("\u6a21\u677f\u7f16\u7801\uff1a{} -\u63a7\u4ef6key:{},\u63a7\u4ef6\u53c2\u6570: args:{}", new Object[]{model.getValue("number"), key, args});
            if (OcrControlUtils.checkWebStatus((IFormView)view, (String)eventName, (String)args)) {
                return;
            }
            if ("customrenfence".equals(key)) {
                if ("init".equals(eventName)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"btnprev"});
                }
                if ("rotate".equals(eventName)) {
                    this.saveRotate(view, model, args);
                    model.setDataChanged(false);
                } else if ("updateFieldByBase64".equals(eventName)) {
                    this.renfenceTemplate(args, view);
                    model.setDataChanged(false);
                } else if ("saveReferenceData".equals(eventName)) {
                    this.saveRenfence(args, model);
                    model.setDataChanged(false);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OcrTempPlugin_12", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
                } else if ("saveStep2HelperStatus".equals(eventName)) {
                    this.updateHelperStatus("saveStep2HelperStatus", args);
                    model.setDataChanged(false);
                } else if ("closeReferenceData".equals(eventName)) {
                    DynamicObject oldObj = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
                    String oldRenfenceInfoStr = oldObj.getString("temprenfenceinfo");
                    RenfenceInfoVO oldRenfenceInfo = (RenfenceInfoVO)JSON.parseObject((String)oldRenfenceInfoStr, RenfenceInfoVO.class);
                    RenfenceInfoVO renfenceInfoVO = (RenfenceInfoVO)JSON.parseObject((String)args, RenfenceInfoVO.class);
                    if (kd.bos.util.StringUtils.isEmpty((String)args) && kd.bos.util.StringUtils.isEmpty((String)oldRenfenceInfoStr) || kd.bos.util.StringUtils.isNotEmpty((String)args) && kd.bos.util.StringUtils.isNotEmpty((String)oldRenfenceInfoStr) && renfenceInfoVO.getAnchor().equals(oldRenfenceInfo.getAnchor())) {
                        model.setDataChanged(false);
                    } else {
                        model.setValue("temprenfenceinfo", (Object)args);
                        MainEntityType dataEntityType = model.getDataEntityType();
                        DataEntityState dataEntityState = model.getDataEntity().getDataEntityState();
                        int numberOrdinal = dataEntityType.getProperty("number").getOrdinal();
                        int ocrRenfenceInfoOrdinal = dataEntityType.getProperty("temprenfenceinfo").getOrdinal();
                        dataEntityState.setBizChanged(numberOrdinal, false);
                        dataEntityState.setBizChanged(ocrRenfenceInfoOrdinal, true);
                    }
                    view.close();
                }
            } else if ("customdistinguish".equals(key)) {
                if ("saveDistinguishData".equals(eventName)) {
                    this.saveDistinguishInfo(args, model);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OcrTempPlugin_12", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
                } else if ("saveStep3HelperStatus".equals(eventName)) {
                    this.updateHelperStatus("saveStep3HelperStatus", args);
                } else if ("closeDistinguishData".equals(eventName)) {
                    TemplateDistInfoVO newDistInfo = (TemplateDistInfoVO)JSON.parseObject((String)args, TemplateDistInfoVO.class);
                    DynamicObject oldObj = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
                    String oldDistInfoStr = oldObj.getString("temptageinfo");
                    TemplateDistInfoVO oldDistInfo = (TemplateDistInfoVO)JSON.parseObject((String)oldDistInfoStr, TemplateDistInfoVO.class);
                    if (kd.bos.util.StringUtils.isEmpty((String)args) && kd.bos.util.StringUtils.isEmpty((String)oldDistInfoStr) || kd.bos.util.StringUtils.isNotEmpty((String)args) && kd.bos.util.StringUtils.isNotEmpty((String)oldDistInfoStr) && newDistInfo.getDistinguishPos().equals(oldDistInfo.getDistinguishPos())) {
                        model.setDataChanged(false);
                    } else {
                        model.setDataChanged(true);
                        model.setValue("temptageinfo", (Object)args);
                    }
                    view.close();
                } else if ("algoOperateType".equals(eventName)) {
                    String resultQuery = OcrHttpClientUtils.kdCloudHttpClientGet((String)"/template/postCorrectType", null);
                    log.info(model.getValue("number") + " - algo API:" + "/template/postCorrectType" + " - \u8fd4\u56de\u7ed3\u679c:" + resultQuery);
                    AlgoResultData t = (AlgoResultData)JSON.parseObject((String)resultQuery, AlgoResultData.class);
                    if (0 == t.getErrorCode()) {
                        OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customdistinguish", (String)"algoOperateType", (Object)t.getData());
                    } else {
                        view.showTipNotification(t.getDescription());
                    }
                }
            } else if ("customtexttable".equals(key)) {
                if ("operate_test".equals(eventName)) {
                    this.doTest(eventName, args, view);
                } else if ("init".equals(eventName)) {
                    this.showCallExample();
                }
            }
            model.updateCache();
        }
        catch (Exception e1) {
            view.showErrMessage(e1.getMessage(), ResManager.loadKDString((String)"\u8bc6\u522b\u5f02\u5e38:", (String)"OcrTempPlugin_11", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
            log.error(model.getValue("number") + " - \u63a7\u4ef6: " + key + "\u64cd\u4f5c\u7801: " + eventName + "\u8bc6\u522b\u5f02\u5e38: " + e1.getMessage() + "agrs\u53c2\u6570: " + args, (Throwable)e1);
        }
    }

    private void doTest(String eventName, String args, IFormView view) {
        String fileUrl = "";
        String number = "";
        DynamicObject currenObjTemp = null;
        try {
            OcrCustomTempRecResponse responseVO;
            IDataModel model = view.getModel();
            number = (String)model.getValue("number");
            currenObjTemp = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
            if (currenObjTemp == null) {
                throw new KDBizException(ResManager.loadKDString((String)String.format("\u7f16\u7801\u4e3a\uff1a%s\u7684\u81ea\u5b9a\u4e49\u6a21\u7248\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8be5\u6a21\u7248\u662f\u5426\u6b63\u5e38", number), (String)"OcrTemplatePlugin_001", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
            }
            OcrRecFile ocrRecFile = (OcrRecFile)JSON.parseObject((String)args, OcrRecFile.class);
            if (ocrRecFile == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7f6e\u6a21\u677f\u6d4b\u8bd5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrPersetTemplateTestPlugin_007", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
            }
            Map<String, String> paramMap = OcrTemplateCommon.preRequest(ocrRecFile);
            if (paramMap.isEmpty() || !paramMap.containsKey("base64Str") || !paramMap.containsKey("fileUrl")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrPersetTemplateTestPlugin_003", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
            }
            fileUrl = paramMap.get("fileUrl");
            if (kd.bos.util.StringUtils.isNotEmpty((String)paramMap.get("alertMsg"))) {
                this.getView().showTipNotification(paramMap.get("alertMsg"));
            }
            if ((responseVO = this.ocrCustomTemplateTest(paramMap, currenObjTemp)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrTemplatePlugin_007", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
            }
            responseVO.setUrl(fileUrl);
            OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customtexttable", (String)eventName, (Object)responseVO);
        }
        catch (IOException | KDBizException kde) {
            log.error("\u81ea\u5b9a\u4e49\u6a21\u677f\u6d4b\u8bd5\uff0c\u4e1a\u52a1\u5f02\u5e38", kde);
            String message = kde.getMessage();
            HashMap<String, String> toWeb = new HashMap<String, String>(3);
            toWeb.put("url", fileUrl);
            toWeb.put("message", message);
            OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customtexttable", (String)"error", toWeb);
        }
        catch (Exception e) {
            log.error("\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            String message = e.getMessage();
            view.showErrorNotification(message);
            HashMap<String, String> toWeb = new HashMap<String, String>(3);
            toWeb.put("url", fileUrl);
            toWeb.put("message", message);
            OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customtexttable", (String)"error", toWeb);
        }
    }

    private OcrCustomTempRecResponse ocrCustomTemplateTest(Map<String, String> paramMap, DynamicObject template) throws Exception {
        AlgoData data;
        String tempRenfenceInfo;
        OcrCustomTempRecResponse response = new OcrCustomTempRecResponse();
        String fileBase64 = paramMap.get("base64Str");
        String tempPath = template.getString("referenceimg");
        String tImageBase64 = OcrControlUtils.imageToBase64((String)tempPath).replaceAll("data:image/png;base64,", "");
        String disStr = template.getString("temptageinfo");
        Map<String, Object> templateData = new HashMap(4);
        if (kd.bos.util.StringUtils.isNotEmpty((String)disStr)) {
            JSONObject disMap = JSON.parseObject((String)disStr);
            disMap.remove("distinguishData");
            templateData = (Map)disMap.get("distinguishPos");
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(tempRenfenceInfo = (String)template.get("temprenfenceinfo")))) {
            JSONObject jsonObject = JSON.parseObject((String)tempRenfenceInfo);
            Object anchor = jsonObject.get((Object)"anchor");
            templateData.put("anchor", anchor);
        }
        log.info("\u81ea\u5b9a\u4e49\u6a21\u677f\u7f16\u7801\uff1a{},\u6a21\u677f\u951a\u70b9\u548c\u8bc6\u522b\u4fe1\u606fjson:{}", (Object)template.getString("number"), JSON.toJSON(templateData));
        String templateDataStr = JSON.toJSONString(templateData);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(4);
        if (kd.bos.util.StringUtils.isNotEmpty((String)fileBase64)) {
            list.add(new BasicNameValuePair("templateData", templateDataStr));
            list.add(new BasicNameValuePair("rImageBase64", fileBase64));
            list.add(new BasicNameValuePair("tImageBase64", tImageBase64));
        }
        RequestContext rc = RequestContext.get();
        log.info(template.get("number") + " - traceId: " + rc.getTraceId() + " - \u6d4b\u8bd5\u8bf7\u6c42\u6570\u636e - templateData :" + templateDataStr);
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
        String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost((String)"/template/test", (HttpEntity)httpEntity);
        log.info(template.get("number") + " \u6a21\u677f - \u63a5\u53e3:" + "/template/test" + " - traceId: " + RequestContext.get().getTraceId());
        OcrAlgoDistingshInfo info = (OcrAlgoDistingshInfo)JSON.parseObject((String)resultStr, OcrAlgoDistingshInfo.class);
        int errorCode = info.getErrorCode();
        if (0 == errorCode) {
            String tageInfoStr = template.getString("temptageinfo");
            JSONObject tageInfo = JSON.parseObject((String)tageInfoStr);
            Map distinguishData = (Map)tageInfo.get("distinguishPos");
            Object tableField = distinguishData.get("table");
            data = info.getData();
            Map tables = data.getOcrResult().getTable();
            if (tables != null) {
                for (List table : tables.values()) {
                    int nullCount = 0;
                    ListIterator rowsIt = table.listIterator();
                    while (rowsIt.hasNext()) {
                        List row = (List)rowsIt.next();
                        for (Object cell : row) {
                            if (!StringUtils.isBlank(cell)) continue;
                            ++nullCount;
                        }
                        if (nullCount == row.size()) {
                            rowsIt.remove();
                        }
                        nullCount = 0;
                    }
                }
            }
            if (tableField != null) {
                List customTableInfos = JSON.parseArray((String)tableField.toString(), CustomTableInfo.class);
                response.setTableField(customTableInfos);
            }
        } else {
            String description = info.getDescription();
            String message = AlgoInfoConvertTestEnum.getMessage((int)errorCode);
            if (kd.bos.util.StringUtils.isNotEmpty((String)message)) {
                description = message;
            }
            throw new KDBizException(description);
        }
        response.setOcrData(data);
        response.setJsonData((Object)data.getOcrResult());
        return response;
    }

    private void updateHelperStatus(String key, String args) {
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        DynamicObject config = OcrControlUtils.getStatusByTemplateConfig((String)userId);
        if (config == null) {
            MainEntityType templateConfig = MetadataServiceHelper.getDataEntityType((String)"cvp_template_config");
            config = new DynamicObject((DynamicObjectType)templateConfig);
            if ("saveStep2HelperStatus".equals(key)) {
                config.set("userid", (Object)userId);
                config.set("step2HelperStatus", (Object)args);
                config.set("step3HelperStatus", (Object)"1");
                config.set("modifydate", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
        } else {
            if ("saveStep2HelperStatus".equals(key)) {
                config.set("step2HelperStatus", (Object)args);
            } else if ("saveStep3HelperStatus".equals(key)) {
                config.set("step3HelperStatus", (Object)args);
            }
            config.set("modifydate", (Object)new Date());
            SaveServiceHelper.update((DynamicObject)config);
        }
    }

    public void saveRenfence(String renfenceInfo, IDataModel model) {
        DynamicObject oldObj = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
        RenfenceInfoVO renfenceInfoVO = (RenfenceInfoVO)JSON.parseObject((String)renfenceInfo, RenfenceInfoVO.class);
        RenfenceInfoVO oldRenfenceInfo = (RenfenceInfoVO)JSON.parseObject((String)oldObj.getString("temprenfenceinfo"), RenfenceInfoVO.class);
        String status = (String)model.getValue("status");
        if (!("C".equals(status) || oldRenfenceInfo != null && renfenceInfoVO != null && renfenceInfoVO.getAnchor().equals(oldRenfenceInfo.getAnchor()))) {
            String imgeReferenceUrl = String.valueOf(model.getValue("referenceimg"));
            if (kd.bos.util.StringUtils.isEmpty((String)imgeReferenceUrl)) {
                imgeReferenceUrl = (String)model.getValue("templateimg");
            }
            model.setValue("referenceimg", (Object)imgeReferenceUrl);
            model.setValue("temprenfenceinfo", (Object)renfenceInfo);
            this.updateTemplate(model);
        }
    }

    public void saveDistinguishInfo(String distinguishInfo, IDataModel model) {
        DynamicObject oldObj = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
        TemplateDistInfoVO newDistInfo = (TemplateDistInfoVO)JSON.parseObject((String)distinguishInfo, TemplateDistInfoVO.class);
        TemplateDistInfoVO oldDistInfo = (TemplateDistInfoVO)JSON.parseObject((String)oldObj.getString("temptageinfo"), TemplateDistInfoVO.class);
        String status = (String)model.getValue("status");
        if (!("C".equals(status) || oldDistInfo != null && newDistInfo != null && newDistInfo.getDistinguishPos().equals(oldDistInfo.getDistinguishPos()))) {
            model.setValue("temptageinfo", (Object)distinguishInfo);
            this.updateTemplate(model);
            model.setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        IDataModel model = this.getModel();
        long pkValue = (Long)model.getDataEntity().getPkValue();
        log.info(model.getValue("number") + " \u6a21\u677f\u4fe1\u606f\u53d1\u751f\u53d8\u66f4 \u4e3b\u952ePKID : " + pkValue);
        String renfence = (String)model.getValue("temprenfenceinfo");
        boolean exists = QueryServiceHelper.exists((String)"cvp_template", (Object)pkValue);
        if (exists && kd.bos.util.StringUtils.isNotEmpty((String)renfence) && "templateimg".equals(key)) {
            this.isOkUpdateImage(this.getView(), model);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        try {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            String guideKey = OcrControlUtils.getGuideCurrenName((IFormView)view);
            String status = (String)model.getValue("status");
            switch (key) {
                case "btnsave": {
                    if ("templateinfo".equals(guideKey) && !"C".equals(status)) {
                        CvpResultData cvpResultData = this.save(view, model);
                        String code = cvpResultData.getCode();
                        String message = cvpResultData.getMessage();
                        if ("100".equals(code)) {
                            view.showSuccessNotification(cvpResultData.getMessage());
                            break;
                        }
                        if ("0".equals(code)) {
                            view.showTipNotification(message);
                        }
                    } else {
                        if ("renfencefiled".equals(guideKey)) {
                            OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customrenfence", (String)"saveReferenceData", (Object)"");
                            break;
                        }
                        if ("distinguishfiled".equals(guideKey)) {
                            OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customdistinguish", (String)"saveDistinguishData", (Object)"");
                        }
                    }
                    break;
                }
                case "btncancel": {
                    if ("renfencefiled".equals(guideKey)) {
                        OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customrenfence", (String)"closeReferenceData", (Object)"");
                        break;
                    }
                    if ("distinguishfiled".equals(guideKey)) {
                        OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customdistinguish", (String)"closeDistinguishData", (Object)"");
                        break;
                    }
                    view.close();
                    break;
                }
                case "btncomplete": {
                    this.ocrTempLateComplete(view, model);
                    break;
                }
                default: {
                    view.showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u5b58\u5728", (String)"OcrTempPlugin_17", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)(key + " - \u6a21\u677f\u64cd\u4f5c\u6309\u94ae\u533a\u5f02\u5e38 "), (String)"OcrTempPlugin_2", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
            log.error(this.getModel().getValue("number") + " - \u6a21\u677f" + key + "\u64cd\u4f5c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
    }

    private void renfenceTemplate(String args, IFormView view) throws Exception {
        ReferenceAutoDataVO referenceDataVO = (ReferenceAutoDataVO)JSON.parseObject((String)args, ReferenceAutoDataVO.class);
        String requestData = referenceDataVO.getRequestData().replaceAll("data:image/png;base64,", "");
        if (kd.bos.util.StringUtils.isNotEmpty((String)requestData)) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(4);
            list.add(new BasicNameValuePair("imageBase64", requestData));
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
            String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost((String)"/template/textRecognize", (HttpEntity)httpEntity);
            IDataModel model = view.getModel();
            log.info(model.getValue("number") + " \u6a21\u677f - \u63a5\u53e3:" + "/template/textRecognize" + " - traceId: " + RequestContext.get().getTraceId());
            JSONObject obj = JSON.parseObject((String)resultStr);
            StringBuilder objStr = new StringBuilder();
            objStr.append(obj);
            int errorCode = (Integer)obj.get("errorCode");
            if (0 == errorCode) {
                String data = obj.get("data").toString();
                ReferenceAutoDataVO demoData = new ReferenceAutoDataVO(referenceDataVO.getNetWorkCount(), referenceDataVO.getID(), ResManager.loadKDString((String)"\u53c2\u8003\u5b57\u6bb5", (String)"OcrTempPlugin_24", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]), data);
                OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customrenfence", (String)"updateFieldByBase64", (Object)demoData);
            } else {
                String description = (String)obj.get("description");
                view.showTipNotification(description);
            }
        }
    }

    private void saveRotate(IFormView view, IDataModel model, String args) throws IOException {
        String imagePath = OcrControlUtils.base64ToImage((IFormView)view, (String)args);
        DynamicObject template = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
        String status = template.getString("status");
        if ("B".equals(status)) {
            template.set("status", (Object)"D");
            this.setBingdinDataStatus(template.get("bindingid"), "D");
        }
        template.set("temptageinfo", null);
        template.set("temprenfenceinfo", null);
        template.set("referenceimg", (Object)imagePath);
        template.set("modifierid", (Object)String.valueOf(RequestContext.get().getCurrUserId()));
        template.set("modifydate", (Object)new Date());
        model.setValue("temptageinfo", null);
        model.setValue("temprenfenceinfo", null);
        model.setValue("referenceimg", (Object)imagePath);
        model.setValue("modifierid", (Object)String.valueOf(RequestContext.get().getCurrUserId()));
        model.setValue("modifydate", template.get("modifydate"));
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{template});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OcrTempPlugin_12", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
    }

    public void updateTemplate(IDataModel model) {
        model.setValue("modifydate", (Object)new Date());
        model.setValue("modifierid", (Object)String.valueOf(RequestContext.get().getCurrUserId()));
        DynamicObject template = model.getDataEntity();
        String status = template.getString("status");
        if ("B".equals(status)) {
            template.set("status", (Object)"D");
            this.setBingdinDataStatus(template.get("bindingid"), "D");
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{template});
        model.setDataChanged(false);
        model.updateCache();
    }

    private void initCopyOrModify() {
        block6: {
            String entyName;
            DynamicObject ocrSchema;
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            Long billId = (Long)view.getFormShowParameter().getCustomParam("billId");
            if (billId == null) break block6;
            FormShowParameter parameter = view.getFormShowParameter();
            Boolean isCopy = (Boolean)parameter.getCustomParam("iscopy");
            if (isCopy == null) {
                isCopy = Boolean.FALSE;
            }
            if ((ocrSchema = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)(entyName = model.getDataEntityType().getName()))) != null) {
                if (isCopy.booleanValue()) {
                    String copyStr = ResManager.loadKDString((String)"(\u526f\u672c)", (String)"OcrTempPlugin_0", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]);
                    Object o = ocrSchema.get("name");
                    ILocaleString name = (ILocaleString)o;
                    name.setLocaleValue_zh_TW(name.getLocaleValue_zh_TW() + copyStr);
                    name.setLocaleValue_zh_CN(name.getLocaleValue_zh_CN() + copyStr);
                    model.setValue("name", (Object)name);
                    model.setValue("number", (Object)OcrControlUtils.geNumberCode((String)"OCRTEMPLATE-"));
                    Image imageap = (Image)this.getControl("imageap");
                    String url = String.valueOf(ocrSchema.get("templateimg"));
                    String imageFullUrl = UrlService.getImageFullUrl((String)url);
                    imageap.setUrl(imageFullUrl);
                    for (String prop : OCR_TEMP_MATES) {
                        model.setValue(prop, ocrSchema.get(prop));
                    }
                } else {
                    Image imageap = (Image)this.getControl("imageap");
                    String url = String.valueOf(ocrSchema.get("templateimg"));
                    String imageFullUrl = UrlService.getImageFullUrl((String)url);
                    imageap.setUrl(imageFullUrl);
                    for (String prop : OCR_TEMP_MATES_MODI) {
                        model.setValue(prop, ocrSchema.get(prop));
                    }
                }
            }
        }
    }

    private void ocrTempLateComplete(IFormView view, IDataModel model) throws Exception {
        DynamicObject temp = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
        String fid = temp.getPkValue().toString();
        int code = 0;
        boolean status = false;
        JSONObject query = new HashMap(10);
        String algoId = (String)temp.get("algoid");
        if (kd.bos.util.StringUtils.isNotEmpty((String)algoId)) {
            ArrayList<OcrParam> params = new ArrayList<OcrParam>(2);
            params.add(new OcrParam("ocrId", (Object)algoId));
            String resultQuery = OcrHttpClientUtils.kdCloudHttpClientGet((String)"/template/query", params);
            log.info(temp.get("number") + " - algo API:" + "/template/query" + " - \u53c2\u6570:  ocrId=" + algoId);
            query = JSON.parseObject((String)resultQuery);
            try {
                code = (Integer)query.get("errorCode");
                Map data = (Map)query.get("data");
                status = (Boolean)data.get("result");
            }
            catch (Exception e) {
                String description = (String)query.get("description");
                view.showTipNotification(description);
                log.error(temp.get("number") + " - algo API:" + "/template/query" + " - \u53c2\u6570: templateId:" + fid + "\u8fd4\u56de\u7ed3\u679c:" + resultQuery);
                return;
            }
        }
        if (0 == code) {
            String tempPath = (String)temp.get("referenceimg");
            String tImageBase64 = OcrControlUtils.imageToBase64((String)tempPath).replaceAll("data:image/png;base64,", "");
            String templateData = this.getTageString(model);
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>(4);
            list.add((NameValuePair)new BasicNameValuePair("imageBase64", tImageBase64));
            list.add((NameValuePair)new BasicNameValuePair("templateData", templateData));
            if (status) {
                this.synchronizeTemplateByAlgo(view, temp, algoId, list);
            } else {
                this.creatTemplateByAlgo(view, temp, fid, list);
            }
            this.updateBindingData(temp);
            model.setDataChanged(false);
            model.updateCache();
        } else {
            this.sendAlgoMessage(view, (Map<String, Object>)query);
        }
    }

    private void updateBindingData(DynamicObject template) {
        Object pkId = template.get("bindingid");
        DynamicObject bindingTemplate = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"cvp_template");
        if (bindingTemplate != null) {
            for (String key : OCR_TEMP_MATES_BIDING) {
                Object value = template.get(key);
                bindingTemplate.set(key, value);
            }
            bindingTemplate.set("bindingdata", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bindingTemplate});
        }
    }

    private void setBingdinDataStatus(Object pkId, String status) {
        DynamicObject bindingData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"cvp_template");
        bindingData.set("status", (Object)status);
        SaveServiceHelper.update((DynamicObject)bindingData);
    }

    private void creatTemplateByAlgo(IFormView view, DynamicObject temp, String fid, List<NameValuePair> list) throws Exception {
        UrlEncodedFormEntity httpEntity;
        String resultStr;
        JSONObject obj;
        int errorCode;
        if (kd.bos.util.StringUtils.isNotEmpty((String)fid)) {
            list.add((NameValuePair)new BasicNameValuePair("templateId", fid));
            list.add((NameValuePair)new BasicNameValuePair("sourceId", "cvp-ocr"));
        }
        if (0 == (errorCode = ((Integer)(obj = JSON.parseObject((String)(resultStr = OcrHttpClientUtils.kdCloudHttpClientPost((String)"/template/create", (HttpEntity)(httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8)))))).get("errorCode")).intValue())) {
            Map data = (Map)obj.get("data");
            this.getModel().setValue("status", (Object)"B");
            temp.set("status", (Object)"B");
            temp.set("bindingdata", (Object)"0");
            temp.set("algoid", data.get("ocrId"));
            SaveServiceHelper.update((DynamicObject)temp);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\uff0c\u53d1\u5e03\u6210\u529f", (String)"OcrTempPlugin_13", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
        } else {
            this.sendAlgoMessage(view, (Map<String, Object>)obj);
        }
    }

    private void synchronizeTemplateByAlgo(IFormView view, DynamicObject temp, String algoId, List<NameValuePair> list) throws Exception {
        list.add((NameValuePair)new BasicNameValuePair("ocrId", algoId));
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
        String resultStr = OcrHttpClientUtils.kdCloudHttpClientPost((String)"/template/synchronize", (HttpEntity)httpEntity);
        JSONObject obj = JSON.parseObject((String)resultStr);
        int errorCode = (Integer)obj.get("errorCode");
        if (0 == errorCode) {
            this.getModel().setValue("status", (Object)"B");
            temp.set("status", (Object)"B");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{temp});
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\uff0c\u53d1\u5e03\u6210\u529f", (String)"OcrTempPlugin_13", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
        } else {
            this.sendAlgoMessage(view, (Map<String, Object>)obj);
        }
    }

    public void sendAlgoMessage(IFormView view, Map<String, Object> obj) {
        String description = (String)obj.get("description");
        int code = (Integer)obj.get("errorCode");
        String message = AlgoInfoConvertCompleteEnum.getMessage((int)code);
        if (kd.bos.util.StringUtils.isNotEmpty((String)message)) {
            description = message;
        }
        view.showTipNotification(description);
    }

    private String getTageString(IDataModel model) {
        String tempRenfenceInfo;
        String disStr = (String)model.getValue("temptageinfo");
        Map<String, Object> templateData = new HashMap(4);
        if (kd.bos.util.StringUtils.isNotEmpty((String)disStr)) {
            JSONObject disMap = JSON.parseObject((String)disStr);
            templateData = (Map)disMap.get("distinguishPos");
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(tempRenfenceInfo = (String)model.getValue("temprenfenceinfo")))) {
            JSONObject jsonObject = JSON.parseObject((String)tempRenfenceInfo);
            Object anchor = jsonObject.get((Object)"anchor");
            templateData.put("anchor", anchor);
        }
        return JSON.toJSONString(templateData);
    }

    CvpResultData volidTemplateInfo(IDataModel model) {
        String number = (String)model.getValue("number");
        if (kd.bos.util.StringUtils.isEmpty((String)number)) {
            return CvpResultData.resultError((String)ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u586b\u5199\u6a21\u677f\u7f16\u7801", (String)"OcrTempPlugin_19", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
        }
        DynamicObject obj = OcrControlUtils.getObjByTempalteNumber((String)number);
        Long pkValue = (Long)model.getDataEntity().getPkValue();
        if (obj != null && pkValue.compareTo((Long)obj.getPkValue()) != 0) {
            String res = ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"OcrTempPlugin_18", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]);
            return CvpResultData.resultError((String)(number + res));
        }
        OrmLocaleValue localeValue = (OrmLocaleValue)model.getValue("name");
        String ftempname = localeValue.getLocaleValue();
        if (kd.bos.util.StringUtils.isEmpty((String)ftempname)) {
            return CvpResultData.resultError((String)ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u586b\u5199\u6a21\u677f\u540d\u79f0", (String)"OcrTempPlugin_3", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
        }
        String url = String.valueOf(model.getValue("templateimg"));
        if (kd.bos.util.StringUtils.isEmpty((String)url)) {
            return CvpResultData.resultError((String)ResManager.loadKDString((String)"\u6a21\u677f\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u4e0a\u4f20\u6a21\u677f\u56fe\u7247", (String)"OcrTempPlugin_4", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
        }
        return CvpResultData.resultOk();
    }

    private boolean isOkUpdateImage(IFormView view, IDataModel model) {
        String oldPath;
        String newPath;
        DynamicObject currenObjTemplate = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
        if (currenObjTemplate != null && !(newPath = (String)model.getValue("templateimg")).equals(oldPath = currenObjTemplate.getString("templateimg"))) {
            view.showConfirm(ResManager.loadKDString((String)"\u5df2\u6807\u6ce8\u7684\u4fe1\u606f\u5c06\u4f1a\u88ab\u6e05\u9664,\u662f\u5426\u4fee\u6539\u6a21\u677f\u56fe\u7247?", (String)"OcrTempPlugin_21", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("updateImageCallBack"));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("updateImageCallBack".equals(e.getCallBackId())) {
            IDataModel model = this.getModel();
            DynamicObject old = OcrControlUtils.getCurrenObjTemplate((IDataModel)model);
            String oldTemplatePath = old.getString("templateimg");
            if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                FileService imageFileService = FileServiceFactory.getImageFileService();
                imageFileService.delete(oldTemplatePath);
                model.setValue("referenceimg", null);
                model.setValue("temprenfenceinfo", null);
                model.setValue("temptageinfo", null);
                DynamicObject template = model.getDataEntity();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
            } else {
                Image imageap = (Image)this.getControl("imageap");
                String imageFullUrl = UrlService.getImageFullUrl((String)oldTemplatePath);
                imageap.setUrl(imageFullUrl);
                model.setValue("templateimg", (Object)oldTemplatePath);
            }
            model.setDataChanged(false);
            model.updateCache();
        }
    }

    CvpResultData save(IFormView view, IDataModel model) {
        String status = (String)model.getValue("status");
        CvpResultData cvpResultData = CvpResultData.resultOk();
        if (!"C".equals(status)) {
            cvpResultData = this.volidTemplateInfo(model);
            if ("0".equals(cvpResultData.getCode())) {
                return cvpResultData;
            }
            DynamicObject tempEntity = model.getDataEntity();
            long pkValue = (Long)tempEntity.getPkValue();
            boolean exists = QueryServiceHelper.exists((String)"cvp_template", (Object)pkValue);
            if (exists) {
                boolean flag = this.volidTemplateInfoChange(model);
                cvpResultData = flag ? this.updateTemplateData(tempEntity) : CvpResultData.resultOk((String)ResManager.loadKDString((String)"\u6a21\u677f\u57fa\u7840\u4fe1\u606f\uff0c\u4fdd\u5b58\u6210\u529f", (String)"OcrTempPlugin_7", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
            } else {
                FormShowParameter parameter = view.getFormShowParameter();
                Boolean isCopy = (Boolean)parameter.getCustomParam("iscopy");
                if (isCopy == null) {
                    isCopy = Boolean.FALSE;
                }
                if (isCopy.booleanValue()) {
                    String primaryPath = tempEntity.getString("templateimg");
                    String refencePath = tempEntity.getString("referenceimg");
                    FileService imageFileService = FileServiceFactory.getImageFileService();
                    InputStream primaryIn = imageFileService.getInputStream(primaryPath);
                    InputStream refenceIn = imageFileService.getInputStream(refencePath);
                    String newPrimaryPath = OcrControlUtils.setUploadFile((String)view.getEntityId(), (InputStream)primaryIn);
                    String newRefencePath = OcrControlUtils.setUploadFile((String)view.getEntityId(), (InputStream)refenceIn);
                    tempEntity.set("templateimg", (Object)newPrimaryPath);
                    tempEntity.set("referenceimg", (Object)newRefencePath);
                }
                cvpResultData = this.addTemplateData(tempEntity);
            }
            model.updateCache();
            model.setDataChanged(false);
        }
        return cvpResultData;
    }

    private CvpResultData updateTemplateData(DynamicObject tempEntity) {
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        tempEntity.set("modifierid", (Object)userId);
        tempEntity.set("modifydate", (Object)new Date());
        String status = tempEntity.getString("status");
        if ("C".equals(status)) {
            return CvpResultData.resultError((String)ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u6a21\u677f\u4e14\u8be5\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001", (String)"OcrTempPlugin_5", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
        }
        if ("B".equals(status)) {
            tempEntity.set("status", (Object)"D");
            this.setBingdinDataStatus(tempEntity.get("bindingid"), "D");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tempEntity});
        CvpResultData cvpResultData = CvpResultData.resultOk((String)ResManager.loadKDString((String)"\u6a21\u677f\u57fa\u7840\u4fe1\u606f\uff0c\u4fee\u6539\u6210\u529f\uff01", (String)"OcrTempPlugin_6", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
        return cvpResultData;
    }

    private CvpResultData addTemplateData(DynamicObject tempEntity) {
        long[] pkIds = DB.genLongIds((String)"cvp_template", (int)2);
        long pkId = pkIds[0];
        long pkId2 = pkIds[1];
        tempEntity.set("id", (Object)pkId);
        tempEntity.set("modifydate", (Object)new Date());
        tempEntity.set("bindingid", (Object)pkId2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tempEntity});
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cvp_template");
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)dataEntityType);
        dataEntity.set("id", (Object)pkId2);
        dataEntity.set("bindingid", (Object)pkId);
        for (String key : OCR_TEMP_MATES_BIDING) {
            dataEntity.set(key, tempEntity.get(key));
        }
        dataEntity.set("bindingdata", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        return CvpResultData.resultOk((String)ResManager.loadKDString((String)"\u6a21\u677f\u57fa\u7840\u4fe1\u606f\uff0c\u4fdd\u5b58\u6210\u529f", (String)"OcrTempPlugin_7", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
    }

    private boolean volidTemplateInfoChange(IDataModel model) {
        String oldName;
        DynamicObject oldObj = OcrControlUtils.getCurrenObjTemplateByKey((IDataModel)model);
        Object templateName = model.getValue("name");
        String localeValue = ((OrmLocaleValue)templateName).getLocaleValue();
        if (!localeValue.equals(oldName = oldObj.getString("name"))) {
            return true;
        }
        Object templateNumber = model.getValue("number");
        if (!templateNumber.equals(oldObj.getString("number"))) {
            return true;
        }
        Object desc = model.getValue("description");
        if (!desc.equals(oldObj.getString("description"))) {
            return true;
        }
        Object templatePath = model.getValue("templateimg");
        if (!templatePath.equals(oldObj.getString("templateimg"))) {
            return true;
        }
        Object remotPath = model.getValue("referenceimg");
        return !remotPath.equals(oldObj.getString("referenceimg"));
    }

    public void tabSelected(TabSelectEvent event) {
        String key = event.getTabKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        try {
            view.setVisible(Boolean.TRUE, new String[]{"btnsave"});
            view.setVisible(Boolean.TRUE, new String[]{"btnnext"});
            view.setVisible(Boolean.FALSE, new String[]{"btncomplete"});
            switch (key) {
                case "templateinfo": {
                    view.setVisible(Boolean.FALSE, new String[]{"btnprev"});
                    break;
                }
                case "renfencefiled": {
                    view.setVisible(Boolean.TRUE, new String[]{"btnprev"});
                    OcrControlUtils.setCustRenfData((IFormView)view, (IDataModel)model);
                    break;
                }
                case "distinguishfiled": {
                    view.setVisible(Boolean.TRUE, new String[]{"btnprev"});
                    OcrControlUtils.setCustDistData((IFormView)view, (IDataModel)model);
                    break;
                }
                case "templatetest": {
                    this.showCallExample();
                    view.setVisible(Boolean.TRUE, new String[]{"btnprev"});
                    view.setVisible(Boolean.FALSE, new String[]{"btnsave"});
                    break;
                }
                case "templatecomplete": {
                    view.setVisible(Boolean.TRUE, new String[]{"btnprev"});
                    view.setVisible(Boolean.TRUE, new String[]{"btncomplete"});
                    view.setVisible(Boolean.FALSE, new String[]{"btnnext"});
                    view.setVisible(Boolean.FALSE, new String[]{"btnsave"});
                    OcrControlUtils.setRenfDistData((IFormView)view, (IDataModel)model);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)(key + "\u6a21\u677f\u64cd\u4f5c\u81ea\u5b9a\u4e49\u63a7\u4ef6\u533a\u5f02\u5e38"), (String)"OcrTempPlugin_23", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]));
            log.error("\u6a21\u677f\u64cd\u4f5c\u81ea\u5b9a\u4e49\u63a7\u4ef6\u533a\u5f02\u5e38 \u64cd\u4f5c:" + key + "\u64cd\u4f5c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
    }

    private void showCallExample() {
        OCRRecVO ocrRecVO = new OCRRecVO();
        String domainContextUrl = UrlService.getDomainContextUrl();
        String attUrl = String.format("%s/attachment/upload.do", domainContextUrl);
        ocrRecVO.setUrl(attUrl);
        ocrRecVO.setBillid(0L);
        ocrRecVO.setFileSizeMax(1);
        ocrRecVO.setTraceId(RequestContext.get().getTraceId());
        ocrRecVO.setViewType("operate_test");
        ocrRecVO.setType(OcrRecEnum.CUSTOMTMP.getType());
        ocrRecVO.setMarkdownName("customTemplate");
        OcrControlUtils.setCustomcontrolData((IFormView)this.getView(), (String)"customtexttable", (String)"init", (Object)ocrRecVO);
    }
}

