/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin;

import java.util.EventObject;
import java.util.UUID;
import kd.ai.cvp.entity.CvpResultData;
import kd.ai.cvp.plugin.OcrTemplatePlugin;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class OcrWizardPlugin
extends AbstractFormPlugin
implements ClickListener,
IConfirmCallBack {
    private static Log log = LogFactory.getLog(OcrTemplatePlugin.class);
    private static String KEY_TESTIMAGEAP = "testimageap";
    private static String KEY_BTNIMAGETESTAGAIN = "btnimagetestagain";
    private static String KEY_TESTLABELAP = "testlabelap";

    public void initialize() {
        this.addClickListeners(new String[]{"btnnext", "btnprev"});
    }

    public void customEvent(CustomEventArgs e) {
        try {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            String eventName = e.getEventName();
            String args = e.getEventArgs();
            log.info("\u63a7\u4ef6\u653e\u56de\u53c2\u6570: args:" + args);
            OcrTemplatePlugin templatePlugin = new OcrTemplatePlugin();
            String currenGuideKey = OcrControlUtils.getGuideCurrenName((IFormView)view);
            if ("bnextReference".equals(eventName)) {
                templatePlugin.saveRenfence(args, model);
                if ("renfencefiled".equals(currenGuideKey)) {
                    this.next();
                }
            } else if ("bnextDistinguish".equals(eventName)) {
                templatePlugin.saveDistinguishInfo(args, model);
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnsave"});
                this.isShowBtn();
                if ("distinguishfiled".equals(currenGuideKey)) {
                    this.next();
                }
            }
        }
        catch (Exception e1) {
            this.getView().showErrMessage(e1.getMessage(), ResManager.loadKDString((String)"\u4fe1\u606f\u53d8\u66f4\u6821\u9a8c\u5f02\u5e38", (String)"OcrWizardPlugin_5", (String)"ai-cbp-plugin", (Object[])new Object[0]));
            log.error("\u63a7\u4ef6\u6570\u636e\u6821\u9a8c\u5f02\u5e38: " + e1.getMessage(), (Throwable)e1);
        }
    }

    private void isShowBtn() {
        IFormView view = this.getView();
        Object value = this.getModel().getValue("testimgpath");
        view.setVisible(Boolean.TRUE, new String[]{KEY_TESTIMAGEAP});
        if (value != null && !StringUtils.isEmpty((String)value.toString())) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_BTNIMAGETESTAGAIN});
            view.setVisible(Boolean.FALSE, new String[]{KEY_TESTLABELAP});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{KEY_BTNIMAGETESTAGAIN});
            view.setVisible(Boolean.TRUE, new String[]{KEY_TESTLABELAP});
        }
    }

    public void click(EventObject evt) {
        try {
            String key = ((Control)evt.getSource()).getKey();
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            String currenGuideKey = OcrControlUtils.getGuideCurrenName((IFormView)view);
            OcrTemplatePlugin templatePlugin = new OcrTemplatePlugin();
            switch (key) {
                case "btnnext": {
                    if ("templateinfo".equals(currenGuideKey)) {
                        CvpResultData cvpResultData = templatePlugin.volidTemplateInfo(model);
                        if ("100".equals(cvpResultData.getCode())) {
                            templatePlugin.save(view, model);
                            this.next();
                            break;
                        }
                        view.showTipNotification(cvpResultData.getMessage());
                        break;
                    }
                    if ("renfencefiled".equals(currenGuideKey)) {
                        OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customrenfence", (String)"bnextReference", (Object)UUID.randomUUID());
                        break;
                    }
                    if ("distinguishfiled".equals(currenGuideKey)) {
                        OcrControlUtils.setCustomcontrolData((IFormView)view, (String)"customdistinguish", (String)"bnextDistinguish", (Object)UUID.randomUUID());
                        break;
                    }
                    if (!"templatetest".equals(currenGuideKey)) break;
                    this.next();
                    break;
                }
                case "btnprev": {
                    if ("renfencefiled".equals(currenGuideKey)) {
                        templatePlugin.save(view, model);
                    } else if ("distinguishfiled".equals(currenGuideKey)) {
                        templatePlugin.save(view, model);
                    } else if ("templatecomplete".equals(currenGuideKey)) {
                        view.setVisible(Boolean.FALSE, new String[]{"btnsave"});
                    }
                    this.previous();
                    break;
                }
                default: {
                    view.showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u5b58\u5728", (String)"OcrWizardPlugin_3", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                }
            }
            model.setDataChanged(false);
            model.updateCache();
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u6a21\u677f\u64cd\u4f5c\u6309\u94ae\u533a\u5f02\u5e38", (String)"OcrWizardPlugin_2", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            log.error("\u6a21\u677f\u9875\u7b7e\u64cd\u4f5c\u6309\u94ae\u533a\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        IFormView view = this.getView();
        if ("exitGuideCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            view.close();
        }
        if ("tempSaveCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            OcrTemplatePlugin ocrTemplatePlugin = new OcrTemplatePlugin();
            CvpResultData cvpResultData = ocrTemplatePlugin.volidTemplateInfo(this.getModel());
            String code = cvpResultData.getCode();
            String message = cvpResultData.getMessage();
            if ("100".equals(code)) {
                view.showSuccessNotification(cvpResultData.getMessage());
                this.next();
            } else if ("0".equals(code)) {
                view.showTipNotification(message);
            }
        } else if ("tempSaveCallBack".equals(e.getCallBackId()) && MessageBoxResult.No.equals((Object)e.getResult())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d8\u66f4,\u8bf7\u5148\u70b9\u51fb\u4fdd\u5b58!", (String)"OcrWizardPlugin_4", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
    }

    private void next() {
        IFormView view = this.getView();
        Tab tab = (Tab)view.getControl("guidecontent");
        IDataModel model = this.getModel();
        String url = String.valueOf(model.getValue("templateimg"));
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        OrmLocaleValue ftempname = (OrmLocaleValue)this.getModel().getValue("name");
        int size = ftempname.size();
        if (size == 0) {
            return;
        }
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(tab.getItems().size() - 1)).getKey())) {
                view.showConfirm(ResManager.loadKDString((String)"\u5411\u5bfc\u5df2\u5b8c\u6210\uff0c\u662f\u5426\u9000\u51fa\u672c\u9875?", (String)"OcrWizardPlugin_0", (String)"ai-cvp-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitGuideCallBack"));
                break;
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
            break;
        }
    }

    private void previous() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(0)).getKey())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u4e3a\u7b2c\u4e00\u9875\uff01", (String)"OcrWizardPlugin_1", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                return;
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            break;
        }
    }
}

