/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin.classifier;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.cvp.utils.CommonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ClassifierPlanListPlugin
extends AbstractFormPlugin
implements TabSelectListener,
ItemClickListener {
    private Log logger = LogFactory.getLog(ClassifierPlanListPlugin.class);
    private static final String PRESET_TEMPLATE = "presetap";
    private static final String CUSTOM_TEMPLATE = "customap";
    private static final String IE_PLAN = "ieap";
    private static final String TAB_KEY = "tabap";
    private static final String TAB_KEY_PRESET = "tabpageap";
    private static final String TAB_KEY_CUSTOM = "tabpageap1";
    private static final String TAB_KEY_IEPLAN = "tabpageap2";
    private static final String FILTERCONTAINERAP = "filtercontainerap";

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl(TAB_KEY);
        tab.addTabSelectListener((TabSelectListener)this);
        tab.addItemClickListener((ItemClickListener)this);
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERAP);
        if (filterContainer != null) {
            filterContainer.setBillFormId("cvp_clssify_configf7");
            filterContainer.setNeedShareScheme(false);
        }
    }

    private boolean isBillListInit(String billListAp) {
        String billCache = this.getView().getPageCache().get(billListAp);
        return !StringUtils.isEmpty((String)billCache) && Boolean.parseBoolean(billCache);
    }

    private void setInitFlag(String billListAp) {
        String billCache = this.getView().getPageCache().get(billListAp);
        if (StringUtils.isEmpty((String)billCache) || !Boolean.parseBoolean(billCache)) {
            this.getView().getPageCache().put(billListAp, "true");
        }
    }

    public void createNewData(BizDataEventArgs e) {
        String formId = "cvp_ie_mouldplan";
        ((Tab)this.getView().getControl(TAB_KEY)).activeTab(TAB_KEY_IEPLAN);
        this.showList(TAB_KEY_IEPLAN, formId, IE_PLAN, "\u4fe1\u606f\u63d0\u53d6\u65b9\u6848");
    }

    private void showList(String btn, String formId, String billListAP, String caption) {
        if (!this.isBillListInit(billListAP)) {
            List<QFilter> qFilters = this.getFilter(btn);
            this.showCurrentList(formId, billListAP, qFilters, caption);
            this.setInitFlag(billListAP);
        }
    }

    private void showCurrentList(String billformid, String billLisstAp, List<QFilter> qFilters, String caption) {
        IFormView view = this.getView();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7_cvp");
        listShowParameter.setBillFormId(billformid);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setQFilters(qFilters);
        listShowParameter.setListFilterParameter(listFilterParameter);
        listShowParameter.setShowFilter(false);
        listShowParameter.setHasRight(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setShowQuickFilter(false);
        listShowParameter.setShowUsed(true);
        listShowParameter.setLookUp(true);
        listShowParameter.setCaption(caption);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(billLisstAp);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectMould"));
        view.showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        if (callBackId.equals("selectMould")) {
            if (closedCallBackEvent.getReturnData() != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                Object returnData = closedCallBackEvent.getReturnData();
                Object primaryKeyValue = null;
                if (!(returnData instanceof ListSelectedRowCollection)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ClassifierPlanListPlugin_002", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                }
                primaryKeyValue = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
                this.logger.info("\u8fd4\u56de\u7684\u7ec4\u5408\u8bc6\u522b\u5668\u65b9\u6848\u9009\u4e2d\u9879\u4e3b\u952e\u4e3a\uff1a{}", primaryKeyValue);
                map.put("id", primaryKeyValue.toString());
                Map<String, String> infoMap = this.getCodeAndRelateInfo();
                String keyCode = infoMap.get("keyCode");
                Map<String, String> dyObjMap = this.getPlanName(primaryKeyValue, keyCode);
                map.put("keyCode", keyCode);
                map.put("planName", dyObjMap.get("planName"));
                map.put("planNumber", dyObjMap.get("planNumber"));
                view.returnDataToParent(map);
            }
            view.close();
        }
    }

    private Map<String, String> getPlanName(Object primaryKeyValue, String keyCode) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String name = "";
        String number = "";
        String formid = "";
        switch (keyCode) {
            case "preset": 
            case "custom": {
                formid = "cvp_template";
                break;
            }
            case "ie": {
                formid = "cvp_ie_mouldplan";
            }
        }
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)formid);
        if (templateObj != null) {
            name = templateObj.getString("name");
            number = templateObj.getString("number");
        }
        map.put("planName", name);
        map.put("planNumber", number);
        return map;
    }

    private Map<String, String> getCodeAndRelateInfo() {
        HashMap<String, String> map = new HashMap<String, String>(10);
        String currentTab = ((Tab)this.getView().getControl(TAB_KEY)).getCurrentTab();
        String keyCode = "preset";
        switch (currentTab) {
            case "tabpageap": {
                keyCode = "preset";
                break;
            }
            case "tabpageap1": {
                keyCode = "custom";
                break;
            }
            case "tabpageap2": {
                keyCode = "ie";
            }
        }
        map.put("keyCode", keyCode);
        return map;
    }

    private List<QFilter> getFilter(String btn) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        switch (btn) {
            case "tabpageap": {
                QFilter qFilter = new QFilter("status", "=", (Object)"B");
                qFilters.add(qFilter);
                QFilter isPresetFilter = new QFilter("isValid", "=", (Object)"1");
                qFilters.add(isPresetFilter);
                QFilter bindingdata = new QFilter("bindingdata", "=", (Object)"1");
                qFilters.add(bindingdata);
                QFilter numberFilter = new QFilter("number", "!=", (Object)"OPM-GeneralTablePreset");
                qFilters.add(numberFilter);
                break;
            }
            case "tabpageap1": {
                QFilter custom_status = new QFilter("status", "=", (Object)"B");
                qFilters.add(custom_status);
                QFilter isPresetFilter = new QFilter("isValid", "=", (Object)"0");
                qFilters.add(isPresetFilter);
                QFilter bdata = new QFilter("bindingdata", "=", (Object)"1");
                qFilters.add(bdata);
                break;
            }
            case "tabpageap2": {
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                qFilters.add(statusFilter);
            }
        }
        return qFilters;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing donothing;
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        IFormView view = this.getView();
        if (source instanceof Donothing && "addplan".equals(operateKey = (donothing = (Donothing)source).getOperateKey())) {
            String currentTab = ((Tab)view.getControl(TAB_KEY)).getCurrentTab();
            CommonUtil.addNewTemp((IFormView)view, (String)currentTab);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String formId = "cvp_template_base";
        switch (tabKey) {
            case "tabpageap": {
                this.showList(tabKey, formId, PRESET_TEMPLATE, "\u9884\u7f6e\u6a21\u677f");
                break;
            }
            case "tabpageap1": {
                this.showList(tabKey, formId, CUSTOM_TEMPLATE, "\u81ea\u5b9a\u4e49\u6a21\u677f");
                break;
            }
            case "tabpageap2": {
                formId = "cvp_ie_mouldplan";
                this.showList(tabKey, formId, IE_PLAN, "\u4fe1\u606f\u63d0\u53d6\u65b9\u6848");
            }
        }
    }
}

