/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin.ie;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.ai.cvp.utils.CommonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextAreaEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class IeMouldInfoPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ListboxClickListener {
    private static Log logger = LogFactory.getLog(IeMouldInfoPlugin.class);
    private static final String TB_TEST = "bar_test";
    private static final String TB_SAVE = "bar_save";
    private static final String BTN_OPEN = "btnopen";
    private static final String BTN_CLOSE = "btnclose";
    private static final String BTN_ADDNEWTABLE = "btnnewentry";
    private static final String BTN_DELTABLE = "btndel";
    private static final String ITEM_LISTBOX = "listboxap";
    private static final String BTN_NEWENTRY = "btn_newentry";
    private static final String BTN_DELENTRY = "btn_delentry";
    private static final String LABEL_TABLE_NAME = "llmtable";
    private static final String BTN_DESCRIPTION = "llmexdescription";
    private static final String BTN_OUTPUT = "llmoutput";
    private static final String KEY_MODEL = "cvp_llm_fprompt";
    private static final String TOOL_KEY = "advcontoolbarap1";
    private static final String KEY_USE_LLM = "usellmextract";
    private static final String KEY_LISTBOX_LIST = "page_list_listbox";
    private static final String KEY_LAST_ITEMBOX = "page_lastitembox";
    private static final Integer TABLE_COUNT = 5;
    private static final Integer MAX_LLM_TABLE_SIZE = 25;
    private static final Integer MAX_LLM_COMMON_SIZE = 70;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control tbmain = this.getControl("tbmain");
        if (tbmain != null) {
            ((Toolbar)tbmain).addItemClickListener((ItemClickListener)this);
        }
        Button openBtn = (Button)this.getControl(BTN_OPEN);
        openBtn.addClickListener((ClickListener)this);
        Button closeBtn = (Button)this.getControl(BTN_CLOSE);
        closeBtn.addClickListener((ClickListener)this);
        Button addNewEntry = (Button)this.getControl(BTN_ADDNEWTABLE);
        addNewEntry.addClickListener((ClickListener)this);
        Button btndel = (Button)this.getControl(BTN_DELTABLE);
        btndel.addClickListener((ClickListener)this);
        Listbox listboxap = (Listbox)this.getControl(ITEM_LISTBOX);
        listboxap.addListboxClickListener((ListboxClickListener)this);
        Toolbar toolbar = (Toolbar)this.getControl(TOOL_KEY);
        toolbar.addItemClickListener((ItemClickListener)this);
        TextAreaEdit descEdit = (TextAreaEdit)this.getControl(BTN_DESCRIPTION);
        descEdit.addClickListener((ClickListener)this);
        TextAreaEdit outputEdit = (TextAreaEdit)this.getControl(BTN_OUTPUT);
        outputEdit.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        Object id = model.getValue("id");
        if (id == null || (Long)id == 0L) {
            this.initNewView();
        } else {
            this.showBizView(model);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
        this.filterEntryData("1");
    }

    private void initNewView() {
        ArrayList<ListboxItem> list = new ArrayList<ListboxItem>(16);
        ListboxItem listboxItem = new ListboxItem("1", "\u666e\u901a\u5b57\u6bb5");
        list.add(listboxItem);
        Listbox listbox = (Listbox)this.getControl(ITEM_LISTBOX);
        listbox.addItems(list);
        this.putNewListbox(list);
        listbox.activeItem(listboxItem.getId());
        listbox.listboxClick(listboxItem.getId());
        this.putCurrentListboxItem(listboxItem);
        this.getModel().setValue(KEY_USE_LLM, (Object)true);
        this.getModel().setDataChanged(false);
    }

    private void putCurrentListboxItem(ListboxItem lastbox) {
        this.getPageCache().put(KEY_LAST_ITEMBOX, JSON.toJSONString((Object)lastbox));
    }

    private ListboxItem getCurrentListbox() {
        String lastListboxItem = this.getPageCache().get(KEY_LAST_ITEMBOX);
        if (StringUtils.isNotEmpty((String)lastListboxItem)) {
            return (ListboxItem)JSON.parseObject((String)lastListboxItem, ListboxItem.class);
        }
        return null;
    }

    private void putNewListbox(List<ListboxItem> list) {
        this.getPageCache().put(KEY_LISTBOX_LIST, JSON.toJSONString(list));
    }

    private List<ListboxItem> getLastListbox() {
        String lastListboxList = this.getPageCache().get(KEY_LISTBOX_LIST);
        if (StringUtils.isNotEmpty((String)lastListboxList)) {
            return JSON.parseArray((String)lastListboxList, ListboxItem.class);
        }
        return new ArrayList<ListboxItem>(1);
    }

    private void showBizView(IDataModel model) {
        IFormView view = this.getView();
        Object businessconfig = model.getValue("businessconfig");
        if (businessconfig != null) {
            Object usellmextract;
            switch (businessconfig.toString()) {
                case "A": {
                    view.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap8"});
                    view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap13"});
                    Object number = model.getValue("number");
                    if (number == null || !number.toString().equals("ie_mp_A39B74A5")) break;
                    view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
                    break;
                }
                case "B": {
                    view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap8"});
                    break;
                }
                default: {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u77e5\u6587\u6863\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"IeMouldInfoPlugin_005", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                }
            }
            if ((usellmextract = model.getValue(KEY_USE_LLM)) != null && Boolean.parseBoolean(usellmextract.toString())) {
                view.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap13"});
            }
        }
        DynamicObjectCollection llmentryentity = model.getEntryEntity("llmentryentity");
        Set tabNumList = llmentryentity.stream().filter(entry -> !StringUtils.isEmpty((String)entry.getString("llmtabnum"))).map(entry -> entry.getString("llmtabnum")).collect(Collectors.toSet());
        List<ListboxItem> lastListBox = this.getLastListbox();
        ListboxItem commonListItem = new ListboxItem("1", "\u666e\u901a\u5b57\u6bb5");
        lastListBox.add(commonListItem);
        if (!tabNumList.isEmpty()) {
            for (String tabNum : tabNumList) {
                int t = tabNum.indexOf("t");
                String num = tabNum.substring(t + 1);
                String itemIdStr = Integer.parseInt(num) + 1 + "";
                logger.info("id:{},name:{}", (Object)itemIdStr, (Object)("\u8868\u683c" + num));
                ListboxItem listboxItem = new ListboxItem(itemIdStr, "\u5217\u8868" + num);
                lastListBox.add(listboxItem);
            }
        }
        this.putNewListbox(lastListBox);
        Listbox listbox = (Listbox)this.getControl(ITEM_LISTBOX);
        listbox.addItems(lastListBox);
        listbox.activeItem("1");
        listbox.listboxClick("1");
        this.putCurrentListboxItem(commonListItem);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView view = this.getView();
        switch (key) {
            case "btnopen": {
                view.setVisible(Boolean.valueOf(false), new String[]{BTN_OPEN});
                view.setVisible(Boolean.valueOf(true), new String[]{"listgridviewap", BTN_CLOSE});
                break;
            }
            case "btnclose": {
                view.setVisible(Boolean.valueOf(false), new String[]{BTN_CLOSE, "listgridviewap"});
                view.setVisible(Boolean.valueOf(true), new String[]{BTN_OPEN});
                break;
            }
            case "btnnewentry": {
                this.addNewTable(view);
                break;
            }
            case "btndel": {
                this.removeTable(view);
                break;
            }
            case "llmexdescription": {
                this.showTipsView(view, BTN_DESCRIPTION);
                break;
            }
            case "llmoutput": {
                this.showTipsView(view, BTN_OUTPUT);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("rewriteTable") && closedCallBackEvent.getReturnData() != null) {
            Object returnData = closedCallBackEvent.getReturnData();
            Map map = (Map)JSON.parseObject((String)returnData.toString(), Map.class);
            String fkey = (String)map.get("fkey");
            String value = (String)map.get("value");
            IDataModel model = this.getModel();
            EntryGrid entryGrid = (EntryGrid)this.getControl("llmentryentity");
            int[] selectRows = entryGrid.getSelectRows();
            model.setValue(fkey, (Object)value, selectRows[0]);
        }
    }

    private void showTipsView(IFormView view, String fName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(KEY_MODEL);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = showParameter.getCustomParams();
        customParams.put("templateName", fName);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "rewriteTable");
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        try {
            if (source instanceof Save) {
                this.validFieldAndSave(args);
            }
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u5f02\u5e38\uff0c\u64cd\u4f5ckey:{}", source, (Object)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"IeMouldInfoPlugin_301", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void removeTable(IFormView view) {
        List<ListboxItem> list = this.getLastListbox();
        Listbox listbox = (Listbox)this.getControl(ITEM_LISTBOX);
        ListboxItem currentListboxItem = this.getCurrentListbox();
        if (currentListboxItem != null) {
            String id = currentListboxItem.getId();
            if (!"1".equals(id)) {
                list.removeIf(item -> item.getId().equals(id));
                this.delEntry(view, id);
                listbox.addItems(list);
                this.putNewListbox(list);
                listbox.activeItem("1");
                listbox.listboxClick("1");
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u666e\u901a\u5b57\u6bb5\u201d\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"IeMouldInfoPlugin_003", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u9700\u8981\u5220\u9664\u7684\u8868\u683c\u540e\u518d\u64cd\u4f5c\u3002", (String)"IeMouldInfoPlugin_004", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
    }

    private void delEntry(IFormView view, String id) {
        if (Integer.parseInt(id) <= 1) {
            view.showErrorNotification("\u64cd\u4f5c\u5f02\u5e38\uff0c\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            return;
        }
        String tabNum = "t".concat(Integer.parseInt(id) - 1 + "");
        DynamicObjectCollection llmentryentity = this.getModel().getEntryEntity("llmentryentity");
        int[] rows = llmentryentity.stream().filter(entry -> tabNum.equals(entry.getString("llmtabnum"))).map(entry -> entry.getInt("seq") - 1).mapToInt(Integer::intValue).toArray();
        if (rows != null && rows.length > 0) {
            this.getModel().deleteEntryRows("llmentryentity", rows);
        }
    }

    private void addNewTable(IFormView view) {
        List<ListboxItem> list = this.getLastListbox();
        if (list.size() >= 6) {
            view.showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u63d0\u53d6\u8868\u683c\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc75\u4e2a,\u5f53\u524d\u5df2\u7ecf\u67095\u4e2a\u8868\u683c\u3002", (String)"IeMouldInfoPlugin_002", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return;
        }
        Integer minNum = this.getMinNum(list);
        if (minNum != null) {
            ListboxItem listboxItem = new ListboxItem(String.valueOf(minNum), "\u5217\u8868" + (minNum - 1));
            list.add(listboxItem);
            Listbox listbox = (Listbox)this.getControl(ITEM_LISTBOX);
            listbox.addItems(list);
            this.putNewListbox(list);
            listbox.activeItem(listboxItem.getId());
            listbox.listboxClick(listboxItem.getId());
        }
    }

    private Integer getMinNum(List<ListboxItem> list) {
        List ids = list.stream().map(box -> Integer.parseInt(box.getId())).collect(Collectors.toList());
        for (int i = 0; i < TABLE_COUNT + 1; ++i) {
            if (ids.contains(i + 1)) continue;
            return i + 1;
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        try {
            ChangeData[] changeSet;
            block10: for (ChangeData changeData : changeSet = e.getChangeSet()) {
                if (changeData.getNewValue() == null || changeData.getNewValue().equals(changeData.getOldValue())) continue;
                switch (key) {
                    case "businessconfig": {
                        this.changeByBizConfig(view, model, changeData);
                        continue block10;
                    }
                    case "usellmextract": {
                        this.changeByUseLLM(view, model, changeData);
                    }
                }
            }
        }
        catch (Exception e1) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u64cd\u4f5c\u201c\u5207\u6362\u201d\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"IeMouldInfoPlugin_001", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
    }

    private void changeByUseLLM(IFormView view, IDataModel model, ChangeData changeData) {
        if (changeData.getNewValue().equals(true)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap13"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap13"});
        }
    }

    private void changeByBizConfig(IFormView view, IDataModel model, ChangeData changeData) {
        if (changeData.getNewValue().equals("A")) {
            this.showContractView(view, model);
        } else if (changeData.getNewValue().equals("B")) {
            this.showCommonTableView(view, model);
        }
        model.setDataChanged(false);
    }

    private void showCommonTableView(IFormView view, IDataModel model) {
        view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap8"});
        model.setValue("commonextract", (Object)false);
        model.setValue(KEY_USE_LLM, (Object)true);
    }

    private void showContractView(IFormView view, IDataModel model) {
        view.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap8"});
        view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap13"});
        model.setValue("commonextract", (Object)false);
        model.setValue(KEY_USE_LLM, (Object)false);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        IDataModel model = this.getView().getModel();
        try {
            switch (evt.getItemKey()) {
                case "bar_test": {
                    long pkValue = (Long)model.getDataEntity().getPkValue();
                    if (pkValue == 0L) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u6d4b\u8bd5", (String)"IeMouldInfoPlugin_001", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                    }
                    FormShowParameter testShowParameter = CommonUtil.getTestShowParameter((long)pkValue);
                    this.getView().showForm(testShowParameter);
                    break;
                }
                case "btn_newentry": {
                    EntryGrid entryGrid = (EntryGrid)this.getControl("llmentryentity");
                    int[] selectRows = entryGrid.getSelectRows();
                    int selectRow = selectRows[0];
                    ListboxItem currentListbox = this.getCurrentListbox();
                    if (currentListbox == null) break;
                    String id = currentListbox.getId();
                    int fieldSize = (Integer)entryGrid.getEntryData().getData().get("rowcount");
                    if (Integer.parseInt(id) > 1) {
                        if (fieldSize > 25) {
                            this.getModel().deleteEntryRow("llmentryentity", selectRow);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u8fc7\u5217\u8868\u80fd\u6dfb\u52a0\u7684\u4e0a\u9650\u301025\u3011\u5b57\u6bb5\u4e2a\u6570\uff0c\u6682\u65f6\u65e0\u6cd5\u6dfb\u52a0\u3002", (String)"IeMouldInfoPlugin_306", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                            return;
                        }
                        int tableId = Integer.parseInt(id) - 1;
                        model.setValue("llmtabnum", (Object)("t" + tableId), selectRow);
                        model.setValue("llmtabname", (Object)("\u8868\u683c " + tableId + " \u5b57\u6bb5"), selectRow);
                        break;
                    }
                    if (fieldSize > 70) {
                        this.getModel().deleteEntryRow("llmentryentity", selectRow);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u8fc7\u666e\u901a\u5b57\u6bb5\u80fd\u6dfb\u52a0\u7684\u4e0a\u9650\u301070\u3011\u5b57\u6bb5\u4e2a\u6570\uff0c\u6682\u65f6\u65e0\u6cd5\u6dfb\u52a0\u3002", (String)"IeMouldInfoPlugin_307", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                        return;
                    }
                    break;
                }
            }
        }
        catch (KDBizException kde) {
            logger.error("\u4e1a\u52a1\u5f02\u5e38\uff0c\u64cd\u4f5ckey:{}", (Object)evt.getItemKey(), (Object)kde);
            String message = kde.getMessage();
            if (StringUtils.isEmpty((String)message)) {
                message = ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c", (String)"IeMouldInfoPlugin_001", (String)"ai-cvp-plugin", (Object[])new Object[0]);
            }
            this.getView().showTipNotification(message);
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u5f02\u5e38\uff0c\u64cd\u4f5ckey:{}", (Object)evt.getItemKey(), (Object)e);
            String message = e.getMessage();
            if (StringUtils.isEmpty((String)message)) {
                message = ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c", (String)"IeMouldInfoPlugin_001", (String)"ai-cvp-plugin", (Object[])new Object[0]);
            }
            this.getView().showTipNotification(message);
        }
    }

    private void validFieldAndSave(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object commonextract = model.getValue("commonextract");
        Object usellmextract = model.getValue(KEY_USE_LLM);
        if (commonextract != null && !Boolean.parseBoolean(commonextract.toString()) && usellmextract != null && !Boolean.parseBoolean(usellmextract.toString())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u901a\u7528\u63d0\u53d6\u5b57\u6bb5\u201d\u6216\u8005\u201c\u5927\u6a21\u578b\u81ea\u5b9a\u4e49\u63d0\u53d6\u5b57\u6bb5\u201d\u5fc5\u987b\u4efb\u9009\u4e00\u4e2a\u52fe\u9009\uff0c\u624d\u53ef\u6b63\u5e38\u4fdd\u5b58\u63d0\u53d6\u65b9\u6848\u3002", (String)"IeMouldInfoPlugin_001", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (usellmextract != null && Boolean.parseBoolean(usellmextract.toString())) {
            DynamicObjectCollection llmentryentity = model.getEntryEntity("llmentryentity");
            if (llmentryentity == null || llmentryentity.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u63d0\u53d6\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u884c\u63d0\u53d6\u5b57\u6bb5\u4fe1\u606f\u540e\u518d\u4fdd\u5b58\u3002", (String)"IeMouldInfoPlugin_003", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Map<String, List> sortedMap = llmentryentity.stream().collect(Collectors.groupingBy(entry -> entry.getString("llmtabnum"), Collector.of(ArrayList::new, List::add, (left, right) -> {
                left.addAll(right);
                return left;
            }, Collector.Characteristics.CONCURRENT))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ArrayList)entry.getValue()).stream().sorted(Comparator.comparing(obj -> obj.getInt("seq"))).collect(Collectors.toList())));
            sortedMap.forEach((key, value) -> {
                if (StringUtils.isEmpty((String)key)) {
                    if (value.size() > MAX_LLM_COMMON_SIZE) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u666e\u901a\u5b57\u6bb5\u6700\u591a\u53ef\u6dfb\u52a070\u4e2a\u5b57\u6bb5\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"IeMouldInfoPlugin_101", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                    }
                } else {
                    String tableN = key.substring(1);
                    if (value.size() > MAX_LLM_TABLE_SIZE) {
                        throw new KDBizException(ResManager.loadKDString((String)(tableN + "\u5217\u8868\u6700\u591a\u53ef\u6dfb\u52a025\u4e2a\u5b57\u6bb5\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002"), (String)"IeMouldInfoPlugin_102", (String)"ai-cvp-plugin", (Object[])new Object[0]));
                    }
                }
            });
            sortedMap.forEach((key, value) -> {
                List<Integer> ids = value.stream().filter(obj -> StringUtils.isNotEmpty((String)obj.getString("llmextractnum"))).map(obj -> Integer.parseInt(obj.getString("llmextractnum").substring(2))).sorted().collect(Collectors.toList());
                for (DynamicObject obj2 : value) {
                    String llmextractnum = obj2.getString("llmextractnum");
                    String llmtabnum = obj2.getString("llmtabnum");
                    if (!StringUtils.isEmpty((String)llmextractnum)) continue;
                    int num = this.getMinNum4Table(ids, (String)key);
                    obj2.set("llmextractnum", (Object)((StringUtils.isNotEmpty((String)llmtabnum) ? "tf" : "cf") + num));
                    ids.add(num);
                }
            });
        }
    }

    private int getMinNum4Table(List<Integer> ids, String tabKey) {
        int maxNum = MAX_LLM_TABLE_SIZE + 1;
        if (StringUtils.isEmpty((String)tabKey)) {
            maxNum = MAX_LLM_COMMON_SIZE + 1;
        }
        if (!ids.isEmpty()) {
            for (int i = 1; i < maxNum; ++i) {
                if (ids.contains(i)) continue;
                return i;
            }
            return 0;
        }
        return 1;
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        List<ListboxItem> list = this.getLastListbox();
        List currentList = list.stream().filter(listboxItem -> listboxItem.getId().equals(itemId)).collect(Collectors.toList());
        ListboxItem currentItem = (ListboxItem)currentList.get(0);
        this.putCurrentListboxItem(currentItem);
        this.filterEntryData(currentItem.getId());
        Label label = (Label)this.getView().getControl(LABEL_TABLE_NAME);
        label.setText(currentItem.getContent());
    }

    private void filterEntryData(String id) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("llmentryentity");
        ArrayList filters = new ArrayList(16);
        HashMap map = new HashMap(10);
        int index = Integer.parseInt(id);
        ArrayList<String> valueList = new ArrayList<String>(16);
        valueList.add("llmtabnum");
        map.put("FieldName", valueList);
        valueList = new ArrayList(16);
        if (index > 1) {
            valueList.add("t" + (Integer.parseInt(id) - 1));
            map.put("Value", valueList);
            valueList = new ArrayList(16);
            valueList.add("67");
            map.put("Compare", valueList);
        } else {
            valueList.add("");
            map.put("Value", valueList);
            valueList = new ArrayList(16);
            valueList.add("37");
            map.put("Compare", valueList);
        }
        filters.add(map);
        entryGrid.getGridDataByFilter(filters);
    }
}

