/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.plugin.ie;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.cvp.entity.ie.TieRelateConfigField;
import kd.ai.cvp.utils.IeUtils;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class IeRelateConfigPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(IeRelateConfigPlugin.class);
    private static String MARK_BUSINESS_LIST = "businessList";
    private static String MARK_DISTINGUISH_FIELDS = "distinguishFields";
    private static String REC_FIELD = "recfield";
    private static String BUSINESS_FIELD = "businessfield";
    private static String keyEntryEntity = "entryentity";
    private static final String keyTbmain = "tbmain";
    private static final String keyRelateConfig = "relateconfig";
    private static final String fieldNumber = "billno";
    private static final String fieldCurrentMould = "currentmould";
    private static final String fnumber_ie_plan = "ie_mp_A39B74A5";
    private static final String LABEL_LLM = "\uff08\u5927\u6a21\u578b\u63d0\u53d6\uff09";
    private static final String op_save = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarap = (Toolbar)this.getView().getControl(keyTbmain);
        toolbarap.addItemClickListener((ItemClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        DynamicObject ieRelateConfigObj;
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        Object pkId = billShowParameter.getPkId();
        if (pkId != null && (ieRelateConfigObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"cvp_ie_relateconfig")) != null && ieRelateConfigObj.getBoolean("preset")) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        IFormView view = this.getView();
        ChangeData[] changeSet = e.getChangeSet();
        try {
            block12: for (ChangeData changeData : changeSet) {
                Object oldValue = changeData.getOldValue();
                switch (key) {
                    case "mulieplan": {
                        this.updatePlanConfig(view, true);
                        continue block12;
                    }
                    case "businessobj": {
                        this.getModel().setValue(keyRelateConfig, (Object)"");
                        this.updatePlanConfig(view, false);
                        continue block12;
                    }
                    case "currentmould": {
                        boolean saveSuc;
                        if (oldValue == null || changeData.getNewValue().equals(oldValue) || !(saveSuc = this.saveEntryByField(oldValue))) continue block12;
                        this.updatePlanConfig(view, false);
                        continue block12;
                    }
                }
            }
        }
        catch (KDBizException kde) {
            logger.error("\u4e1a\u52a1\u5f02\u5e38\uff0c\u63d0\u53d6\u5173\u8054\u8bbe\u7f6e\u5f02\u5e38\u3002", (Throwable)kde);
            this.getView().showTipNotification(!StringUtils.isEmpty((String)kde.getMessage()) ? kde.getMessage() : "\u63d0\u53d6\u5173\u8054\u8bbe\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
    }

    private boolean saveEntryByField(Object oldValue) {
        this.updateModelConfigStr(oldValue);
        return true;
    }

    private void updateModelConfigStr(Object templateId) {
        if (templateId == null) {
            throw new KDBizException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(keyEntryEntity);
        if (entryEntity != null && !entryEntity.isEmpty()) {
            Map<Object, Object> relateConfigMap = this.buildRelateConfigMap(templateId, entryEntity);
            String relateConfigStr = String.valueOf(this.getModel().getValue(keyRelateConfig));
            String templateIdStr = String.valueOf(templateId);
            if (!StringUtils.isEmpty((String)relateConfigStr)) {
                JSONObject relateConfigObj = JSON.parseObject((String)relateConfigStr);
                if (relateConfigObj.get((Object)templateIdStr) != null) {
                    relateConfigObj.remove((Object)templateIdStr);
                }
                relateConfigObj.put(templateIdStr, relateConfigMap.get(templateId));
                relateConfigStr = relateConfigObj.toJSONString();
            } else {
                relateConfigStr = JSON.toJSONString(relateConfigMap);
            }
            this.getModel().setValue(keyRelateConfig, (Object)relateConfigStr);
            IeUtils.setDataChangeFalse((IFormView)this.getView(), (String[])new String[]{keyRelateConfig});
        }
    }

    private Map<Object, Object> buildRelateConfigMap(Object templateId, DynamicObjectCollection entryEntity) {
        HashMap<Object, Object> planConfigMap = new HashMap<Object, Object>(10);
        TieRelateConfigField relateConfigField = new TieRelateConfigField();
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(String.valueOf(templateId)), (String)"cvp_ie_mouldplan");
        OrmLocaleValue templateNameLocale = (OrmLocaleValue)templateObj.get("name");
        String templateName = templateNameLocale.getLocaleValue();
        relateConfigField.setName(templateName);
        ArrayList list = new ArrayList(entryEntity.size());
        ArrayList recList = new ArrayList(16);
        entryEntity.forEach(entry -> {
            HashMap<String, String> valueMap = new HashMap<String, String>(10);
            HashMap<String, String> extractMap = new HashMap<String, String>(10);
            Object recfiled = entry.get(REC_FIELD);
            Object businessfiled = entry.get(BUSINESS_FIELD);
            String recfiledStr = recfiled.toString();
            extractMap.put("extractName", "");
            extractMap.put("extractNumber", String.valueOf(recfiled));
            recList.add(extractMap);
            valueMap.put(recfiledStr, businessfiled != null ? String.valueOf(businessfiled) : "");
            list.add(valueMap);
        });
        relateConfigField.setValue(list);
        relateConfigField.setExtractFields(recList);
        planConfigMap.put(templateId, relateConfigField);
        return planConfigMap;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        try {
            boolean saveResult;
            if (source instanceof Save && !(saveResult = this.doSave())) {
                args.setCancel(true);
            }
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u63d0\u53d6\u5173\u8054\u8bbe\u7f6e\u5f02\u5e38", (String)"IeRelateConfigPlugin_4", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            logger.error("\u63d0\u53d6\u5173\u8054\u64cd\u4f5c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (op_save.equalsIgnoreCase(formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().updateView();
        }
    }

    private boolean doSave() {
        boolean validFlag = this.validRelateInfo(this.getView(), this.getModel());
        if (!validFlag) {
            return false;
        }
        Object value = this.getModel().getValue(fieldCurrentMould);
        this.saveEntryByField(value);
        this.prepareToSave();
        return true;
    }

    private void prepareToSave() {
        IDataModel model = this.getModel();
        String relateConfigStr = model.getValue(keyRelateConfig).toString();
        RequestContext rc = RequestContext.get();
        JSONObject configMap = JSON.parseObject((String)relateConfigStr);
        int size = configMap.size();
        model.setValue(keyRelateConfig, (Object)relateConfigStr);
        model.setValue("relateplannum", (Object)size);
        model.setValue("modifier", (Object)String.valueOf(rc.getCurrUserId()));
        model.setValue("modifytime", (Object)new Date());
    }

    public boolean validRelateInfo(IFormView view, IDataModel model) {
        String businessName;
        DynamicObject relateConfigBusObj;
        DynamicObject relateConfigObj = model.getDataEntity();
        String billno = (String)relateConfigObj.get(fieldNumber);
        Object pkValue = relateConfigObj.getPkValue();
        Object value = model.getValue(fieldCurrentMould);
        if (value == null) {
            view.showTipNotification(billno + ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f53\u524d\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u540d\u79f0\u201d\u5e76\u6dfb\u52a0\u5173\u8054\u914d\u7f6e\u540e\u518d\u4fdd\u5b58\u3002", (String)"IeRelateConfigPlugin_8", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject busObj = (DynamicObject)model.getValue("businessobj");
        if (busObj != null && (relateConfigBusObj = this.getRelateConfigByBusinessObj(businessName = (String)busObj.getPkValue())) != null && !relateConfigBusObj.getPkValue().equals(pkValue)) {
            view.showTipNotification(ResManager.loadKDString((String)("\u8be5\u4e1a\u52a1\u5bf9\u8c61\u3010" + busObj.getString("name") + "\u3011\u5df2\u914d\u7f6e\u63d0\u53d6\u5173\u8054\u8bbe\u7f6e,\u8bf7\u91cd\u65b0\u9009\u62e9"), (String)"IeRelateConfigPlugin_6", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)value, (String)"cvp_ie_mouldplan");
        String planName = planObj != null ? planObj.getString("name") : "\u672a\u77e5\u540d\u79f0";
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        if (entryentity == null || entryentity.size() == 0) {
            view.showTipNotification("\u3010" + planName + "\u3011\u65b9\u6848\u672a\u914d\u7f6e\u4efb\u4f55\u5173\u8054\u914d\u7f6e\uff0c\u8bf7\u5173\u8054\u914d\u7f6e\u3002");
            return false;
        }
        long recFieldCount = entryentity.stream().filter(entry -> entry.get("recfield") == null || StringUtils.isEmpty((String)entry.get("recfield").toString())).count();
        if (recFieldCount > 0L) {
            view.showTipNotification("\u3010" + planName + "\u3011\u65b9\u6848\u4e2d\u5b58\u5728\u672a\u914d\u7f6e\u63d0\u53d6\u5b57\u6bb5\u7684\u7a7a\u884c\uff0c\u8bf7\u5173\u8054\u914d\u7f6e\u6216\u5220\u9664\u8be5\u884c\u3002");
            return false;
        }
        long businessfieldCount = entryentity.stream().filter(entry -> entry.get("businessfield") != null && !StringUtils.isEmpty((String)entry.get("businessfield").toString())).count();
        if (businessfieldCount < 1L) {
            view.showTipNotification("\u3010" + planName + "\u3011\u65b9\u6848\u672a\u914d\u7f6e\u4efb\u4f55\u4e1a\u52a1\u5b57\u6bb5\uff0c\u8bf7\u5173\u8054\u914d\u7f6e\u3002");
            return false;
        }
        List<Map<String, String>> objInfoList = this.getBusinessFields(this.getModel());
        HashSet<String> set = new HashSet<String>();
        ArrayList nameList = new ArrayList(16);
        boolean repeateFlag = false;
        for (DynamicObject obj : entryentity) {
            List names;
            boolean add;
            if (obj.get(BUSINESS_FIELD) == null || StringUtils.isEmpty((String)obj.get(BUSINESS_FIELD).toString()) || (add = set.add(obj.get(BUSINESS_FIELD).toString()))) continue;
            if (objInfoList != null && !objInfoList.isEmpty() && !nameList.contains((names = objInfoList.stream().filter(objInfo -> objInfo.containsKey(obj.get(BUSINESS_FIELD).toString())).map(objInfo -> (String)objInfo.get(obj.get(BUSINESS_FIELD).toString())).collect(Collectors.toList())).get(0))) {
                nameList.add(names.get(0));
            }
            repeateFlag = true;
        }
        if (repeateFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)("\u68c0\u6d4b\u5230\u3010" + planName + "\u3011\u65b9\u6848\u4e2d\u5b58\u5728\u4e1a\u52a1\u5b57\u6bb5\u3010" + (!nameList.isEmpty() ? String.join((CharSequence)",", nameList) : "") + "\u3011\u5bf9\u5e94\u591a\u6761\u8bc6\u522b\u5b57\u6bb5\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u540e\u4fdd\u5b58"), (String)"IeRelateConfigPlugin_2", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject getRelateConfigByBusinessObj(String businessName) {
        QFilter filter = new QFilter("businessobj", "=", (Object)businessName);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,billno,description";
        return BusinessDataServiceHelper.loadSingle((String)"cvp_ie_relateconfig", (String)selectFields, (QFilter[])filters);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection rows = (DynamicObjectCollection)model.getValue("mulieplan");
        if (model.getValue("id") != null && Long.parseLong(model.getValue("id").toString()) != 0L && (rows == null || rows.size() == 0)) {
            QFilter qFilter = new QFilter("number", "=", (Object)fnumber_ie_plan);
            DynamicObject iePlanObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_mouldplan", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (iePlanObj != null) {
                model.setValue("mulieplan", (Object)new String[]{iePlanObj.getPkValue().toString()});
            } else {
                logger.info("\u672a\u627e\u5230\u9ed8\u8ba4\u7684\u4fe1\u606f\u63d0\u53d6\u65b9\u6848...");
            }
        }
        this.updatePlanConfig(view, true);
        model.setDataChanged(false);
    }

    private void updatePlanConfig(IFormView view, boolean isUpdateCurPlan) {
        Map<String, Object> templates = this.queryTemplateAndBusFields(view);
        boolean buildFlag = this.structComboBox(view, templates, isUpdateCurPlan);
        if (buildFlag) {
            this.buildEntryAndEntryComboBox(view, templates);
        } else {
            this.clearComboEdit();
        }
    }

    private void clearComboEdit() {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().setValue(fieldCurrentMould, (Object)"");
        ComboEdit currentCombo = (ComboEdit)this.getView().getControl(fieldCurrentMould);
        currentCombo.setComboItems(new ArrayList(1));
        ComboEdit recfiled = (ComboEdit)this.getView().getControl(REC_FIELD);
        recfiled.setComboItems(new ArrayList(1));
        ComboEdit businessfield = (ComboEdit)this.getView().getControl(BUSINESS_FIELD);
        businessfield.setComboItems(new ArrayList(1));
    }

    private void buildEntryAndEntryComboBox(IFormView view, Map<String, Object> templates) {
        Map<String, Object> entryMap = this.getEntryComboBoxFields(view, templates);
        List distinguishFields = (List)entryMap.get(MARK_DISTINGUISH_FIELDS);
        List businessList = (List)entryMap.get(MARK_BUSINESS_LIST);
        if (businessList == null || distinguishFields == null || distinguishFields.isEmpty()) {
            return;
        }
        this.setEntryComboBox(view, distinguishFields, businessList);
        this.fillValue(view, distinguishFields);
        this.updateModelRelateConfig(view, templates);
    }

    private void updateModelRelateConfig(IFormView view, Map<String, Object> templates) {
        IDataModel model = view.getModel();
        Object value = model.getValue(keyRelateConfig);
        if (null == value || StringUtils.isEmpty((String)String.valueOf(value))) {
            if (templates.size() > 1) {
                HashMap tempMap = new HashMap(templates.size() - 1);
                templates.entrySet().stream().forEach(e -> {
                    if (!"businessFields".equals(e.getKey())) {
                        tempMap.put(e.getKey(), e.getValue());
                    }
                });
                model.setValue(keyRelateConfig, (Object)JSON.toJSONString(tempMap));
                model.setDataChanged(false);
            }
        } else if (templates.size() > 1) {
            List<String> templateIds = templates.entrySet().stream().filter(ent -> !"businessFields".equals(ent.getKey())).map(ent -> String.valueOf(ent.getKey())).collect(Collectors.toList());
            JSONObject modelObj = JSON.parseObject((String)String.valueOf(value));
            List inIds = templateIds.stream().filter(tid -> modelObj.get(tid) != null).collect(Collectors.toList());
            templateIds.removeAll(inIds);
            List<Map.Entry> inEntry = modelObj.entrySet().stream().filter(entry -> inIds.contains(String.valueOf(entry.getKey()))).collect(Collectors.toList());
            JSONObject jsonObject = new JSONObject();
            templateIds.forEach(tid -> {
                Object template = templates.get(tid);
                jsonObject.put(tid, template);
            });
            inEntry.forEach(entry -> jsonObject.put((String)entry.getKey(), entry.getValue()));
            model.setValue(keyRelateConfig, (Object)jsonObject.toJSONString());
        } else {
            model.setValue(keyRelateConfig, (Object)StringUtils.getEmpty());
        }
    }

    private void fillValue(IFormView view, List<Map<String, String>> distinguishFields) {
        JSONObject jsonObject;
        Object templateConfigObj;
        IDataModel model = view.getModel();
        model.deleteEntryData(keyEntryEntity);
        String relateConfigStr = String.valueOf(model.getValue(keyRelateConfig));
        Object currentTemplateId = model.getValue(fieldCurrentMould);
        int count = 0;
        List value = new ArrayList(16);
        if (!StringUtils.isEmpty((String)relateConfigStr) && (templateConfigObj = (jsonObject = JSON.parseObject((String)relateConfigStr)).get((Object)currentTemplateId.toString())) != null) {
            TieRelateConfigField tieRelateConfigField = (TieRelateConfigField)JSON.parseObject((String)templateConfigObj.toString(), TieRelateConfigField.class);
            value = tieRelateConfigField.getValue();
            count = value.size();
        }
        count = count == 0 ? distinguishFields.size() : count;
        model.batchCreateNewEntryRow(keyEntryEntity, count);
        for (int i = 0; i < count; ++i) {
            if (!value.isEmpty()) {
                Map map = (Map)value.get(i);
                for (Map.Entry next : map.entrySet()) {
                    model.setValue(REC_FIELD, next.getKey(), i);
                    model.setValue(BUSINESS_FIELD, next.getValue(), i);
                }
            } else {
                model.setValue(REC_FIELD, (Object)distinguishFields.get(i).get("extractNumber"), i);
                model.setValue(BUSINESS_FIELD, (Object)"", i);
            }
            model.setDataChanged(false);
        }
    }

    private void setEntryComboBox(IFormView view, List<Map<String, String>> distinguishFields, List<Map<String, Object>> businessList) {
        ComboEdit recCombo = (ComboEdit)view.getControl(REC_FIELD);
        ComboEdit busCombo = (ComboEdit)view.getControl(BUSINESS_FIELD);
        ArrayList distList = new ArrayList(distinguishFields.size());
        distinguishFields.forEach(disMap -> this.setCombo1(distList, (Map<String, String>)disMap));
        recCombo.setComboItems(distList);
        ArrayList busList = new ArrayList(businessList.size());
        businessList.forEach(map -> {
            for (Map.Entry next : map.entrySet()) {
                this.setCombo(busList, next.getValue().toString(), next.getKey().toString());
            }
        });
        busCombo.setComboItems(busList);
    }

    private void setCombo1(List<ComboItem> list, Map<String, String> disMap) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(disMap.get("extractName")));
        comboItem.setValue(disMap.get("extractNumber"));
        list.add(comboItem);
    }

    private void setCombo(List<ComboItem> list, String caption, String value) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(caption));
        comboItem.setValue(value);
        list.add(comboItem);
    }

    private Map<String, Object> getEntryComboBoxFields(IFormView view, Map<String, Object> templates) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(10);
        List businessList = (List)templates.get("businessFields");
        resultMap.put(MARK_BUSINESS_LIST, businessList);
        Object value = view.getModel().getValue(fieldCurrentMould);
        TieRelateConfigField tieRelateConfigField = null;
        if (value != null && (tieRelateConfigField = (TieRelateConfigField)templates.get(value.toString())) != null) {
            List extractFields = tieRelateConfigField.getExtractFields();
            resultMap.put(MARK_DISTINGUISH_FIELDS, extractFields);
        }
        return resultMap;
    }

    private boolean structComboBox(IFormView view, Map<String, Object> templates, boolean isUpdateCurPlan) {
        DynamicObjectCollection rows = (DynamicObjectCollection)view.getModel().getValue("mulieplan");
        if (rows == null || rows.isEmpty()) {
            return false;
        }
        if (isUpdateCurPlan) {
            this.doStructComboBox(view, templates);
        }
        return true;
    }

    private void doStructComboBox(IFormView view, Map<String, Object> templates) {
        if (templates != null && templates.size() > 0) {
            HashMap tempMap = new HashMap(templates.size() - 1);
            templates.forEach((key, value) -> {
                if (!"businessFields".equals(key)) {
                    tempMap.put(key, value);
                }
            });
            if (tempMap.size() > 0) {
                this.setComboEdit(view, fieldCurrentMould, JSON.parseObject((String)JSON.toJSONString(tempMap)));
            }
        }
    }

    private void setComboEdit(IFormView view, String currentTemplatePlan, JSONObject parseObject) {
        List<ComboItem> comboList = this.createComboItems(parseObject);
        ComboEdit comboEdit = (ComboEdit)view.getControl(currentTemplatePlan);
        comboEdit.setComboItems(comboList);
        if (comboList != null && !comboList.isEmpty()) {
            ComboItem c = comboList.get(0);
            view.getModel().setValue(currentTemplatePlan, (Object)c.getValue());
            IeUtils.setDataChangeFalse((IFormView)view, (String[])new String[]{currentTemplatePlan});
        }
    }

    private List<ComboItem> createComboItems(JSONObject config) {
        if (config == null) {
            return Collections.emptyList();
        }
        Set entries = config.entrySet();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(config.size());
        entries.forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ComboItem comboItem = new ComboItem();
            JSONObject jsonObject = JSON.parseObject((String)String.valueOf(value));
            String name = jsonObject.getString("name");
            comboItem.setCaption(new LocaleString(name));
            comboItem.setValue(key);
            list.add(comboItem);
        });
        return list;
    }

    private Map<String, Object> queryTemplateAndBusFields(IFormView view) {
        IDataModel model = view.getModel();
        HashMap<String, Object> templates = new HashMap<String, Object>(16);
        this.setBusinessFields(model, templates);
        DynamicObjectCollection rows = (DynamicObjectCollection)model.getValue("mulieplan");
        this.setTemplateFields(templates, rows);
        return templates;
    }

    private void setTemplateFields(Map<String, Object> templates, DynamicObjectCollection rows) {
        if (rows != null && !rows.isEmpty()) {
            rows.forEach(row -> this.setOneTemplateFields(templates, (DynamicObject)row));
        }
    }

    private void setOneTemplateFields(Map<String, Object> templates, DynamicObject base) {
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)base.getDynamicObject("fbasedataid").getPkValue(), (String)"cvp_ie_mouldplan");
        TieRelateConfigField tieRelateConfigField = this.getRelateConfigByOneTemplate(templateObj);
        Object pkValue = templateObj.getPkValue();
        templates.put(String.valueOf(pkValue), tieRelateConfigField);
    }

    private TieRelateConfigField getRelateConfigByOneTemplate(DynamicObject templateObj) {
        DynamicObjectCollection llmentryentity;
        QFilter statusFilter;
        QFilter enableFilter;
        DynamicObject[] objCol;
        TieRelateConfigField tieRelateConfigField = new TieRelateConfigField();
        OrmLocaleValue templateNameLocale = (OrmLocaleValue)templateObj.get("name");
        String templateName = templateNameLocale.getLocaleValue();
        tieRelateConfigField.setName(templateName);
        ArrayList<Map<String, String>> relateList = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> extractFields = new ArrayList<Map<String, String>>(16);
        boolean commonextract = templateObj.getBoolean("commonextract");
        boolean usellmextract = templateObj.getBoolean("usellmextract");
        if (commonextract && (objCol = BusinessDataServiceHelper.load((String)"cvp_ie_extract_common", (String)"id,extractfield,extractnum,fieldtype,tabnum,tabname,createtime", (QFilter[])new QFilter[]{enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C")}, (String)"createtime asc")) != null && objCol.length > 0) {
            for (DynamicObject obj : objCol) {
                this.doBuildRelateConfig(obj, relateList, extractFields, false);
            }
        }
        if (usellmextract && (llmentryentity = templateObj.getDynamicObjectCollection("llmentryentity")) != null && !llmentryentity.isEmpty()) {
            for (DynamicObject obj : llmentryentity) {
                this.doBuildRelateConfig(obj, relateList, extractFields, true);
            }
        }
        tieRelateConfigField.setValue(relateList);
        tieRelateConfigField.setExtractFields(extractFields);
        return tieRelateConfigField;
    }

    private void doBuildRelateConfig(DynamicObject entity, List<Map<String, String>> relateList, List<Map<String, String>> extractFields, boolean isLLMExtract) {
        String extractfield = null;
        DynamicObject fieldtype = null;
        String extractnum = null;
        String tableNum = null;
        String tabName = null;
        if (isLLMExtract) {
            extractfield = entity.getString("llmextractfield");
            fieldtype = entity.getDynamicObject("llmfieldtype");
            extractnum = entity.getString("llmextractnum");
            tableNum = entity.getString("llmtabnum");
            tabName = entity.getString("llmtabname");
        } else {
            extractfield = entity.getString("extractfield");
            fieldtype = entity.getDynamicObject("fieldtype");
            extractnum = entity.getString("extractnum");
            tableNum = entity.getString("tabnum");
            tabName = entity.getString("tabname");
        }
        HashMap<String, String> extractMap = new HashMap<String, String>(10);
        HashMap<String, String> map = new HashMap<String, String>(10);
        if (StringUtils.isNotEmpty((String)tableNum) && StringUtils.isNotEmpty((String)tabName)) {
            extractMap.put("extractName", tabName.concat(".").concat(extractfield).concat(isLLMExtract ? LABEL_LLM : ""));
            extractMap.put("extractNumber", tableNum.concat(".").concat(extractnum));
            map.put(tableNum.concat(".").concat(extractnum), "");
        } else {
            extractMap.put("extractName", extractfield.concat(isLLMExtract ? LABEL_LLM : ""));
            extractMap.put("extractNumber", extractnum);
            map.put(extractnum, "");
        }
        extractFields.add(extractMap);
        relateList.add(map);
    }

    private void setBusinessFields(IDataModel model, Map<String, Object> templates) {
        List<Map<String, String>> businessFields = this.getBusinessFields(model);
        templates.put("businessFields", businessFields);
    }

    private List<Map<String, String>> getBusinessFields(IDataModel model) {
        MainEntityType busEntityType = this.getBusinessEntityType(model);
        List<Map<String, String>> businessFields = new ArrayList<Map<String, String>>(16);
        if (busEntityType != null) {
            businessFields = IeUtils.getBusinessFieldsList((MainEntityType)busEntityType, (String)"cvp_ie_relateconfig");
        }
        return businessFields;
    }

    private MainEntityType getBusinessEntityType(IDataModel model) {
        DynamicObject target = (DynamicObject)model.getValue("businessobj");
        if (target == null) {
            return null;
        }
        String entityNumber = (String)target.getPkValue();
        return EntityMetadataCache.getDataEntityType((String)entityNumber);
    }
}

