/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.mservice.OcrServiceImpl;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class OcrServiceWebApiPlugin
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(OcrServiceWebApiPlugin.class);
    private static final String KEY_BUSINESS = "businessObject";
    private static final String KEY_NUMBER = "templateNumber";
    private static final String KEY_BASE64 = "imageData";
    private static final String KEY_BIZPARAM = "bizParam";
    private static final String KEY_FILETYPE = "fileType";

    public void doAICommand(AICommandEvent e) {
        ApiResult result = e.getResult();
        try {
            Map parameter = e.getCommand().getParameter();
            this.getApiResult(result, parameter);
        }
        catch (Exception ex) {
            String traceId = RequestContext.get().getTraceId();
            result.setMessage(ex.getMessage() + "traceId: " + traceId);
            result.setErrorCode(String.valueOf(40002));
            result.setSuccess(false);
            log.error(traceId + " - OCR,\u667a\u80fd\u8bc6\u522b\u5f02\u5e38,\u64cd\u4f5c\u5f02\u5e38: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void getApiResult(ApiResult result, Map<String, Object> parameter) {
        String resultStr;
        AlgoResultData resultData;
        String businessObject = String.valueOf(parameter.get(KEY_BUSINESS));
        String templateNumber = String.valueOf(parameter.get(KEY_NUMBER));
        String imageData = String.valueOf(parameter.get(KEY_BASE64));
        Object bizParamObj = parameter.get(KEY_BIZPARAM);
        String traceId = RequestContext.get().getTraceId();
        Object[] objectArray = new Object[5];
        objectArray[0] = traceId;
        objectArray[1] = businessObject;
        objectArray[2] = templateNumber;
        Object object = objectArray[3] = bizParamObj != null ? JSON.toJSONString((Object)bizParamObj) : null;
        objectArray[4] = StringUtils.isEmpty((String)imageData) ? imageData : (imageData.length() > 200 ? imageData.substring(0, 200) : imageData);
        log.info("{}  traceId-\u89c6\u89c9\u8bc6\u522b\u5f00\u653e\u5e73\u53f0API\u8c03\u7528-start params: businessObject:{} - templateNumber:{} - bizParam:{} - imageData:{}", objectArray);
        OcrServiceImpl ocrService = new OcrServiceImpl();
        Map bizParam = null;
        if (bizParamObj != null) {
            bizParam = (Map)JSON.parseObject((String)bizParamObj.toString(), Map.class);
        }
        result.setSuccess((resultData = (AlgoResultData)JSONObject.parseObject((String)(resultStr = ocrService.ocrImage(businessObject, templateNumber, imageData, "C", bizParam)), AlgoResultData.class)).getErrorCode() == 0);
        result.setErrorCode(String.valueOf(resultData.getErrorCode()));
        result.setMessage(resultData.getDescription());
        result.setData(resultData.getData());
        log.info(traceId + " traceId-\u89c6\u89c9\u8bc6\u522b\u5f00\u653e\u5e73\u53f0API\u8c03\u7528 - \u8bc6\u522b\u7ed3\u679c: " + resultStr);
    }
}

