/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.ai.cvp.common.Enum.flow.TemplateTypeCodeEnum;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.agentflow.BizObjFieldVO;
import kd.ai.cvp.entity.agentflow.Enum.DataTypeEnum;
import kd.ai.cvp.entity.agentflow.Enum.DataUpdateTypeEnum;
import kd.ai.cvp.entity.agentflow.Enum.FieldTypeEnum;
import kd.ai.cvp.entity.agentflow.FieldVO;
import kd.ai.cvp.entity.agentflow.Output;
import kd.ai.cvp.entity.agentflow.TemplateFieldVO;
import kd.ai.cvp.entity.ie.MserviceRetCoreVO;
import kd.ai.cvp.entity.ie.MserviceRetVO;
import kd.ai.cvp.mservice.AgentFlowService;
import kd.ai.cvp.mservice.OcrServiceImpl;
import kd.ai.cvp.mservice.OcrTemplateFiledsServiceImpl;
import kd.ai.cvp.utils.IeUtils;
import kd.ai.cvp.utils.LicenseUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class AgentFlowServiceImpl
implements AgentFlowService {
    private Log logger = LogFactory.getLog(AgentFlowServiceImpl.class);

    public String getBizObjList(String templateId, String templateType, Map<String, String> filterParams) {
        AlgoResultData resultData;
        String traceId = UUID.randomUUID().toString();
        this.logger.info("param:{},keycode:{},traceId:{}", new Object[]{templateId, templateType, traceId});
        try {
            if (StringUtils.isEmpty((String)templateId) || StringUtils.isEmpty((String)templateType)) {
                this.logger.error("\u53c2\u6570\u9519\u8bef");
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"OcrServiceImpl_102", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            boolean hasRight = LicenseUtils.validApiPermission();
            if (!hasRight) {
                this.logger.error("\u7528\u6237\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002");
                throw new KDBizException(new ErrorCode("40012", ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u63a5\u53e3\u8c03\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002", (String)"OcrServiceImpl_101", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            boolean b = LicenseUtils.checkPureLicense();
            if (!b) {
                throw new KDBizException(new ErrorCode("401001", ResManager.loadKDString((String)"\u6ca1\u6709\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8d2d\u4e70\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_103", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            TemplateTypeCodeEnum enumByCode = TemplateTypeCodeEnum.getEnumByCode((String)templateType);
            if (enumByCode == null) {
                this.logger.error("\u53c2\u6570\u9519\u8bef");
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"OcrServiceImpl_102", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            this.validTemplateIdLong(templateId);
            HashMap<String, String> filterMap = new HashMap<String, String>(16);
            if (filterParams != null) {
                String bizName = filterParams.get("bizName");
                String bizNumber = filterParams.get("bizNumber");
                filterMap.put("bizName", bizName);
                filterMap.put("bizNumber", bizNumber);
            }
            Map<String, Object> result = this.getBizListByTemplate(templateId, enumByCode, filterMap);
            resultData = new AlgoResultData(traceId, 0, "success", result);
        }
        catch (KDBizException kde) {
            String message;
            String code;
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38\uff1a{}", (Object)kde.getMessage(), (Object)kde);
            ErrorCode errorCode = kde.getErrorCode();
            if (errorCode != null) {
                code = errorCode.getCode();
                message = errorCode.getMessage();
            } else {
                code = "40000";
                message = kde.getMessage();
            }
            resultData = new AlgoResultData(traceId, Integer.parseInt(code), message);
        }
        catch (Exception e) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            String message = e.getMessage();
            String code = "40000";
            resultData = new AlgoResultData(traceId, Integer.parseInt(code), message);
        }
        return SerializationUtils.toJsonString((Object)resultData);
    }

    private void validTemplateIdLong(String templateId) {
        try {
            Long.parseLong(templateId);
        }
        catch (NumberFormatException e) {
            this.logger.error("\u53c2\u6570\u9519\u8bef", (Throwable)e);
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"templateId\u53c2\u6570\u7c7b\u578b\u9519\u8bef", (String)"OcrServiceImpl_102", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
        }
    }

    private Map<String, Object> getBizListByTemplate(String templateId, TemplateTypeCodeEnum enumByCode, Map<String, String> filterMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String formid = enumByCode.getFormid();
        String relateFormid = enumByCode.getRelateFormid();
        map.put("newFormId", relateFormid);
        String orderby = "";
        String selectProperties = "";
        String bizObjKey = "";
        String bizNameKey = "";
        String bizNumberKey = "";
        String basedataIdKey = "";
        if (enumByCode == TemplateTypeCodeEnum.IE_PLAN) {
            orderby = "createtime desc";
            selectProperties = "id,number,businessobj,businessobj.number,businessobj.name";
            bizObjKey = "businessobj";
            bizNameKey = "businessobj.name";
            bizNumberKey = "businessobj.number";
            basedataIdKey = "mulieplan.fbasedataid.id";
        } else if (enumByCode == TemplateTypeCodeEnum.OCR_TEMPLATE) {
            orderby = "createdate desc";
            selectProperties = "id,number,businessobject,businessobject.number,businessobject.name";
            bizObjKey = "businessobject";
            bizNameKey = "businessobject.name";
            bizNumberKey = "businessobject.number";
            basedataIdKey = "choosetemplatebase.fbasedataid.id";
        }
        QFilter qFilter = this.buildFilter(templateId, filterMap, bizNameKey, bizNumberKey, basedataIdKey);
        DynamicObject[] planObjArr = BusinessDataServiceHelper.load((String)relateFormid, (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)orderby);
        if (planObjArr != null && planObjArr.length > 0) {
            ArrayList list = new ArrayList(16);
            int seqno = 0;
            for (DynamicObject plan : planObjArr) {
                Object pkValue = plan.getPkValue();
                DynamicObject bizObj = plan.getDynamicObject(bizObjKey);
                if (bizObj == null) continue;
                String bizNumber = bizObj.getString("number");
                String bizName = bizObj.getString("name");
                HashMap<String, Object> bizMap = new HashMap<String, Object>(2);
                bizMap.put("name", bizName);
                bizMap.put("number", bizNumber);
                bizMap.put("seqno", ++seqno);
                bizMap.put("id", pkValue);
                list.add(bizMap);
            }
            map.put("list", list);
        } else {
            map.put("list", new ArrayList(1));
        }
        return map;
    }

    private QFilter buildFilter(String templateId, Map<String, String> filterMap, String bizNameKey, String bizNumberKey, String basedataIdKey) {
        QFilter qFilter = new QFilter(basedataIdKey, "=", (Object)Long.parseLong(templateId));
        if (filterMap != null && !filterMap.isEmpty()) {
            String bizName = filterMap.get("bizName");
            String bizNumber = filterMap.get("bizNumber");
            if (StringUtils.isNotEmpty((String)bizName)) {
                QFilter nameFilter = new QFilter(bizNameKey, "like", (Object)("%" + bizName + "%"));
                qFilter = qFilter.and(nameFilter);
            }
            if (StringUtils.isNotEmpty((String)bizNumber)) {
                QFilter numberFilter = new QFilter(bizNumberKey, "like", (Object)("%" + bizNumber + "%"));
                qFilter = qFilter.and(numberFilter);
            }
        }
        return qFilter;
    }

    public String getTemplateAndMappingFields(String templateId, String templateType, String bizFormId, String mapId) {
        Map<String, Object> map;
        String requestId = RequestContext.get().getRequestId();
        try {
            this.logger.info("getTemplateAndMappingFields \u5165\u53c2\uff1atemplateId:{},templateType:{},bizObjNumber:{},mapId:{}", new Object[]{templateId, templateType, bizFormId, mapId});
            if (StringUtils.isEmpty((String)templateId) || StringUtils.isEmpty((String)templateType)) {
                this.logger.error("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a", (String)"OcrServiceImpl_1003", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            TemplateTypeCodeEnum enumByCode = TemplateTypeCodeEnum.getEnumByCode((String)templateType);
            if (enumByCode == null) {
                this.logger.error("\u53c2\u6570\u9519\u8bef");
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"OcrServiceImpl_102", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            boolean hasRight = LicenseUtils.validApiPermission();
            if (!hasRight) {
                this.logger.error("\u7528\u6237\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002");
                throw new KDBizException(new ErrorCode("40012", ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u63a5\u53e3\u8c03\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002", (String)"OcrServiceImpl_101", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            boolean b = LicenseUtils.checkPureLicense();
            if (!b) {
                throw new KDBizException(new ErrorCode("401001", ResManager.loadKDString((String)"\u6ca1\u6709\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8d2d\u4e70\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_103", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            Output output = new Output();
            Map<String, TemplateFieldVO> templateMap = this.getTemplateFields(templateId, enumByCode);
            if (templateMap.isEmpty()) {
                throw new KDBizException(new ErrorCode("42000", ResManager.loadKDString((String)"\u83b7\u53d6\u6a21\u7248\u63d0\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25,\u8bf7\u68c0\u67e5\u6a21\u7248\u662f\u5426\u6b63\u5e38\u3002", (String)"OcrServiceImpl_1004", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
            }
            output.setTemplateOutput(templateMap);
            Map<String, BizObjFieldVO> bizMap = this.getBizMappedFields(enumByCode, templateId, bizFormId, mapId);
            if (!bizMap.isEmpty()) {
                output.setBizOutput(bizMap);
            }
            map = this.buildSucResult(requestId, output);
        }
        catch (KDBizException kde) {
            String message;
            String code;
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38\uff1a{}", (Object)kde.getMessage(), (Object)kde);
            ErrorCode errorCode = kde.getErrorCode();
            if (errorCode != null) {
                code = errorCode.getCode();
                message = errorCode.getMessage();
            } else {
                code = "40000";
                message = kde.getMessage();
            }
            map = this.buildErrorResult(requestId, Integer.parseInt(code), message);
        }
        catch (Exception e) {
            this.logger.error("\u672a\u77e5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            String message = e.getMessage();
            String code = "40000";
            map = this.buildErrorResult(requestId, Integer.parseInt(code), message);
        }
        return JSON.toJSONString(map);
    }

    private Map<String, BizObjFieldVO> getBizMappedFields(TemplateTypeCodeEnum enumByCode, String templateId, String bizFormId, String mapId) {
        HashMap<String, BizObjFieldVO> map = new HashMap<String, BizObjFieldVO>();
        if (StringUtils.isEmpty((String)bizFormId) || StringUtils.isEmpty((String)mapId)) {
            return map;
        }
        MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)bizFormId);
        String bizAppId = bizEntityType.getAppId();
        BizObjFieldVO bizVO = new BizObjFieldVO();
        bizVO.setBizAppId(bizAppId);
        bizVO.setBizFormId(bizFormId);
        bizVO.setDataUpdateType(DataUpdateTypeEnum.INSERT.getType());
        HashMap<String, FieldVO> dataMap = new HashMap<String, FieldVO>(16);
        String relateFormId = enumByCode.getRelateFormid();
        String properties = "";
        String config = "";
        if (enumByCode == TemplateTypeCodeEnum.OCR_TEMPLATE) {
            properties = "id,number,templateconfig";
            config = "templateconfig";
        } else if (enumByCode == TemplateTypeCodeEnum.IE_PLAN) {
            properties = "id,billno,relateconfig";
            config = "relateconfig";
        }
        DynamicObject bizObj = this.getBizRelateObj(properties, mapId, relateFormId);
        if (bizObj != null) {
            List businessFields = IeUtils.getBusinessFieldsList((MainEntityType)bizEntityType, (String)"cvp_ie_relateconfig");
            this.updateDataMap(bizObj, config, templateId, bizEntityType, businessFields, dataMap);
        }
        bizVO.setData(dataMap);
        map.put(bizFormId, bizVO);
        return map;
    }

    private DynamicObject getBizRelateObj(String properties, String mapId, String relateFormId) {
        return BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(mapId), (String)relateFormId, (String)properties);
    }

    private void updateDataMap(DynamicObject bizObj, String config, String templateId, MainEntityType bizEntityType, List<Map<String, String>> businessFields, Map<String, FieldVO> dataMap) {
        JSONArray valueArr;
        JSONObject bizJSONObj;
        JSONObject jsonObject;
        String configStr = bizObj.getString(config);
        if (StringUtils.isNotEmpty((String)configStr) && (jsonObject = JSON.parseObject((String)configStr)).containsKey((Object)templateId) && (bizJSONObj = jsonObject.getJSONObject(templateId)) != null && (valueArr = bizJSONObj.getJSONArray("value")) != null && !valueArr.isEmpty()) {
            for (Object o : valueArr) {
                if (!(o instanceof JSONObject)) continue;
                block1: for (Map.Entry entry : ((JSONObject)o).entrySet()) {
                    String bizField;
                    if (entry.getValue() == null || !StringUtils.isNotEmpty((String)entry.getValue().toString()) || !StringUtils.isNotEmpty((String)(bizField = entry.getValue().toString())) || businessFields == null || businessFields.isEmpty()) continue;
                    for (Map<String, String> businessField : businessFields) {
                        if (!businessField.containsKey(bizField)) continue;
                        String bizFieldName = businessField.get(bizField);
                        Map<String, FieldVO> resultMap = this.build((IDataEntityType)bizEntityType, bizField, bizFieldName);
                        this.mergeDataMap(dataMap, resultMap);
                        continue block1;
                    }
                }
            }
        }
    }

    private void mergeDataMap(Map<String, FieldVO> dataMap, Map<String, FieldVO> resultMap) {
        for (Map.Entry<String, FieldVO> resultEntry : resultMap.entrySet()) {
            String key = resultEntry.getKey();
            FieldVO value = resultEntry.getValue();
            if (!dataMap.containsKey(key)) {
                dataMap.put(key, value);
                continue;
            }
            FieldVO fieldVO = dataMap.get(key);
            Object value1 = fieldVO.getValue();
            Object value2 = value.getValue();
            if (value1 instanceof List && value2 instanceof List) {
                List dataListMerge = (List)value1;
                List resultListMerge = (List)value2;
                Map map = (Map)dataListMerge.get(0);
                Map resMap = (Map)resultListMerge.get(0);
                map.putAll(resMap);
                ArrayList<Map> list = new ArrayList<Map>(1);
                list.add(map);
                fieldVO.setValue(list);
            } else if (value1 instanceof Map && value2 instanceof Map) {
                Map dataMapMerge = (Map)value1;
                Map resultMapMerge = (Map)value2;
                dataMapMerge.putAll(resultMapMerge);
                fieldVO.setValue((Object)dataMapMerge);
            }
            dataMap.put(key, fieldVO);
        }
    }

    private Map<String, FieldVO> build(IDataEntityType bizEntityType, String bizField, String bizFieldName) {
        HashMap<String, FieldVO> dataMap = new HashMap<String, FieldVO>(16);
        DynamicProperty currentFirstNodeType = null;
        FieldVO fieldVO = new FieldVO();
        if (bizField.contains(".")) {
            String[] split = bizField.split("\\.");
            String[] splitBizName = bizFieldName.split("\\.");
            String baseKey = split[0];
            String baseKeyName = splitBizName[0];
            fieldVO.setKeyName(baseKeyName);
            bizField = bizField.substring(bizField.indexOf(".") + 1);
            bizFieldName = bizFieldName.substring(bizFieldName.indexOf(".") + 1);
            IDataEntityType type = bizEntityType;
            if (bizEntityType instanceof MainEntityType) {
                currentFirstNodeType = (IDataEntityProperty)bizEntityType.getProperties().get((Object)baseKey);
                if (currentFirstNodeType instanceof EntryProp) {
                    type = ((EntryProp)currentFirstNodeType).getItemType();
                } else if (!(currentFirstNodeType instanceof BasedataProp) && currentFirstNodeType == null && ((BillEntityType)bizEntityType).getAllEntities().get(baseKey) instanceof SubEntryType) {
                    type = (IDataEntityType)((BillEntityType)bizEntityType).getAllEntities().get(baseKey);
                }
            } else {
                currentFirstNodeType = ((EntryType)bizEntityType).getProperty(baseKey);
            }
            Map<String, FieldVO> subMap = this.build(type, bizField, bizFieldName);
            if (split.length > 2) {
                fieldVO.setDataType(DataTypeEnum.ENTRY.getValue());
                fieldVO.setType(FieldTypeEnum.ARRAY.getValue());
                ArrayList<Map<String, FieldVO>> maps = new ArrayList<Map<String, FieldVO>>(1);
                maps.add(subMap);
                fieldVO.setValue(maps);
            } else if (currentFirstNodeType instanceof BasedataProp) {
                fieldVO.setDataType(DataTypeEnum.BASE.getValue());
                fieldVO.setType(FieldTypeEnum.OBJECT.getValue());
                fieldVO.setValue(subMap);
            } else if (currentFirstNodeType instanceof EntryProp) {
                fieldVO.setDataType(DataTypeEnum.ENTRY.getValue());
                fieldVO.setType(FieldTypeEnum.ARRAY.getValue());
                ArrayList<Map<String, FieldVO>> maps = new ArrayList<Map<String, FieldVO>>(1);
                maps.add(subMap);
                fieldVO.setValue(maps);
            }
            dataMap.put(baseKey, fieldVO);
        } else {
            fieldVO.setKeyName(bizFieldName);
            fieldVO.setDataType(DataTypeEnum.COMMON.getValue());
            fieldVO.setType(FieldTypeEnum.STRING.getValue());
            fieldVO.setValue((Object)"");
            dataMap.put(bizField, fieldVO);
        }
        return dataMap;
    }

    private IDataEntityType getCurrentType(IDataEntityType bizEntityType, String key) {
        return ((EntryProp)bizEntityType.getProperties().get((Object)key)).getItemType();
    }

    private Map<String, TemplateFieldVO> getTemplateFields(String templateId, TemplateTypeCodeEnum enumByCode) {
        HashMap<String, TemplateFieldVO> templateMap = new HashMap<String, TemplateFieldVO>(16);
        TemplateFieldVO templateFieldVO = null;
        String templateFormId = enumByCode.getFormid();
        String properties = "id,number";
        DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(templateId), (String)templateFormId, (String)properties);
        String number = templateObj.getString("number");
        if (enumByCode == TemplateTypeCodeEnum.OCR_TEMPLATE) {
            templateFieldVO = this.buildTemplateVO(templateObj);
            if (templateFieldVO != null) {
                templateMap.put(number, templateFieldVO);
            }
        } else if (enumByCode == TemplateTypeCodeEnum.IE_PLAN && (templateFieldVO = this.buildIePlanVO(templateObj)) != null) {
            templateMap.put(number, templateFieldVO);
        }
        return templateMap;
    }

    private TemplateFieldVO buildIePlanVO(DynamicObject templateObj) {
        List mserviceRetVOS;
        OcrServiceImpl ocrService;
        String allTieFields;
        if (templateObj == null) {
            return null;
        }
        TemplateFieldVO templateFieldVO = new TemplateFieldVO();
        String number = templateObj.getString("number");
        String id = templateObj.getString("id");
        if (StringUtils.isNotEmpty((String)number) && StringUtils.isNotEmpty((String)(allTieFields = (ocrService = new OcrServiceImpl()).getAllTieFields(number))) && (mserviceRetVOS = JSON.parseArray((String)allTieFields, MserviceRetVO.class)) != null && !mserviceRetVOS.isEmpty()) {
            MserviceRetVO mserviceRetVO = (MserviceRetVO)mserviceRetVOS.get(0);
            List fields = mserviceRetVO.getFields();
            String planNumber = mserviceRetVO.getPlanNumber();
            templateFieldVO.setTemplateNumber(planNumber);
            templateFieldVO.setTemplateId(id);
            HashMap<String, FieldVO> dataMap = new HashMap<String, FieldVO>(16);
            if (fields != null && !fields.isEmpty()) {
                for (MserviceRetCoreVO mserviceRetCoreVO : fields) {
                    String fname = mserviceRetCoreVO.getFname();
                    String fnumber = mserviceRetCoreVO.getFnumber();
                    String fisTableField = mserviceRetCoreVO.getFisTableField();
                    String ftableName = mserviceRetCoreVO.getFtableName();
                    String ftableNumber = mserviceRetCoreVO.getFtableNumber();
                    if (Boolean.parseBoolean(fisTableField)) {
                        FieldVO entryVo;
                        if (!dataMap.containsKey(ftableNumber)) {
                            entryVo = new FieldVO();
                            entryVo.setType(FieldTypeEnum.ARRAY.getValue());
                            entryVo.setDataType(DataTypeEnum.ENTRY.getValue());
                            entryVo.setKeyName(ftableName);
                            ArrayList list = new ArrayList(16);
                            HashMap<String, FieldVO> fMap = new HashMap<String, FieldVO>(16);
                            FieldVO f = new FieldVO();
                            f.setType(FieldTypeEnum.STRING.getValue());
                            f.setDataType(DataTypeEnum.COMMON.getValue());
                            f.setKeyName(fname);
                            f.setValue((Object)"");
                            fMap.put(fnumber, f);
                            list.add(fMap);
                            entryVo.setValue(list);
                            dataMap.put(ftableNumber, entryVo);
                            continue;
                        }
                        entryVo = (FieldVO)dataMap.get(ftableNumber);
                        Object value = entryVo.getValue();
                        ArrayList maps = (ArrayList)value;
                        Map fMap = (Map)maps.get(0);
                        FieldVO f = new FieldVO();
                        f.setType(FieldTypeEnum.STRING.getValue());
                        f.setDataType(DataTypeEnum.COMMON.getValue());
                        f.setKeyName(fname);
                        f.setValue((Object)"");
                        fMap.put(fnumber, f);
                        continue;
                    }
                    FieldVO fieldVO = new FieldVO();
                    fieldVO.setKeyName(fname);
                    fieldVO.setType(FieldTypeEnum.STRING.getValue());
                    fieldVO.setDataType(DataTypeEnum.COMMON.getValue());
                    fieldVO.setValue((Object)"");
                    dataMap.put(fnumber, fieldVO);
                }
            }
            templateFieldVO.setData(dataMap);
        }
        return templateFieldVO;
    }

    private TemplateFieldVO buildTemplateVO(DynamicObject templateObj) {
        if (templateObj == null) {
            return null;
        }
        String number = templateObj.getString("number");
        String id = templateObj.getString("id");
        OcrTemplateFiledsServiceImpl ocrTemplateFiledsService = new OcrTemplateFiledsServiceImpl();
        String allTieFields = ocrTemplateFiledsService.getFiledInfoByNumber("cvp_template", number);
        if (StringUtils.isNotEmpty((String)allTieFields)) {
            JSONObject dataObj;
            TemplateFieldVO templateFieldVO = new TemplateFieldVO();
            templateFieldVO.setTemplateNumber(number);
            templateFieldVO.setTemplateId(id);
            HashMap<String, FieldVO> dataMap = new HashMap<String, FieldVO>(16);
            JSONObject jsonObject = JSON.parseObject((String)allTieFields);
            if (jsonObject != null && "0".equals(jsonObject.getString("errorCode")) && (dataObj = jsonObject.getJSONObject("data")) != null && !dataObj.isEmpty()) {
                JSONArray recArr = dataObj.getJSONArray("recognitionAreaFiled");
                JSONArray tableArr = dataObj.getJSONArray("tableFiled");
                if (recArr != null && !recArr.isEmpty()) {
                    for (Object o : recArr) {
                        JSONObject fObj = JSON.parseObject((String)o.toString());
                        String desc = fObj.getString("desc");
                        String filed = fObj.getString("filed");
                        FieldVO fieldVO = new FieldVO();
                        fieldVO.setKeyName(desc);
                        fieldVO.setDataType(DataTypeEnum.COMMON.getValue());
                        fieldVO.setType(FieldTypeEnum.STRING.getValue());
                        fieldVO.setValue((Object)"");
                        dataMap.put(filed, fieldVO);
                    }
                }
                if (tableArr != null && !tableArr.isEmpty()) {
                    for (Object o : tableArr) {
                        String desc = "";
                        String filed = "";
                        JSONObject fObj = JSON.parseObject((String)o.toString());
                        JSONArray tableHeader = fObj.getJSONArray("tableHeader");
                        JSONObject tableInfo = fObj.getJSONObject("tableInfo");
                        if (tableInfo != null) {
                            desc = tableInfo.getString("desc");
                            filed = tableInfo.getString("filed");
                        }
                        ArrayList fdatasList = new ArrayList(16);
                        if (tableHeader != null && !tableHeader.isEmpty()) {
                            HashMap<String, FieldVO> fmap = new HashMap<String, FieldVO>(16);
                            for (Object t : tableHeader) {
                                JSONObject tableObj = JSON.parseObject((String)t.toString());
                                String tableFName = tableObj.getString("desc");
                                String tableFKey = tableObj.getString("filed");
                                FieldVO fieldVO = new FieldVO();
                                fieldVO.setKeyName(tableFName);
                                fieldVO.setDataType(DataTypeEnum.COMMON.getValue());
                                fieldVO.setType(FieldTypeEnum.STRING.getValue());
                                fieldVO.setValue((Object)"");
                                fmap.put(tableFKey, fieldVO);
                            }
                            fdatasList.add(fmap);
                        }
                        FieldVO tableFVO = new FieldVO();
                        tableFVO.setKeyName(desc);
                        tableFVO.setDataType(DataTypeEnum.ENTRY.getValue());
                        tableFVO.setType(FieldTypeEnum.ARRAY.getValue());
                        tableFVO.setValue(fdatasList);
                        dataMap.put(filed, tableFVO);
                    }
                }
                templateFieldVO.setData(dataMap);
                return templateFieldVO;
            }
        }
        return null;
    }

    private Map<String, Object> buildErrorResult(String requestId, int code, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("code", code);
        map.put("requestId", requestId);
        map.put("message", StringUtils.isNotEmpty((String)message) ? message : ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"AgentFlowServiceImpl_001", (String)"ai-cvp-mservice", (Object[])new Object[0]));
        return map;
    }

    private Map<String, Object> buildSucResult(String requestId, Object data) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("code", 0);
        map.put("requestId", requestId);
        map.put("message", ResManager.loadKDString((String)"\u8bf7\u6c42\u6210\u529f\u3002", (String)"AgentFlowServiceImpl_002", (String)"ai-cvp-mservice", (Object[])new Object[0]));
        map.put("data", data);
        return map;
    }
}

