/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.mservice;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.ai.cvp.common.Enum.LicenseCountServiceNameEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.tda.QuickDocDiffLayout;
import kd.ai.cvp.mservice.OcrQuickDocDiffService;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class OcrQuickDocDiffServiceImpl
implements OcrQuickDocDiffService {
    private final Log logger = LogFactory.getLog(OcrQuickDocDiffServiceImpl.class);
    private static final String CLAZZ_PREFIX = "OcrQuickDocDiffServiceImpl_";
    private static final String PACKAGENAME = "ai-cvp-mservice";

    public Map<String, Object> quickDocDiff(Map<String, String> paramMap) {
        String traceId = RequestContext.get().getTraceId();
        this.logger.info("\u5feb\u6377\u6bd4\u5bf9\u63a5\u53e3\u5f00\u59cb\uff1amap:{},traceId:{}", (Object)JSON.toJSONString(paramMap), (Object)traceId);
        String requestId = UUID.randomUUID().toString().replace("-", "");
        SourceTypeEnum sourceTypeEnum = SourceTypeEnum.FILEDIFFERENCE;
        long startTime = System.currentTimeMillis();
        AlgoResultData resultData = null;
        try {
            Map<String, Object> map = this.validParam(paramMap);
            if (map.isEmpty()) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u53c2\u6570\u6821\u9a8c\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\u3002", (String)"OcrQuickDocDiffServiceImpl_11", (String)PACKAGENAME, (Object[])new Object[0])), new Object[0]);
            }
            byte[] baseBytes = (byte[])map.get("baseBytes");
            byte[] compareBytes = (byte[])map.get("compareBytes");
            if (baseBytes.length < 1 || compareBytes.length < 1) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6b63\u5e38\u3002", (String)"OcrQuickDocDiffServiceImpl_12", (String)PACKAGENAME, (Object[])new Object[0])), new Object[0]);
            }
            boolean licenseCheckFlag = LicenseUtils.checkLicense((int)1, (String)LicenseCountServiceNameEnum.QUICK_DOC_DIFF.getName(), (String)requestId);
            if (!licenseCheckFlag) {
                throw new KDBizException(new ErrorCode(String.valueOf(40004), ResManager.loadKDString((String)"\u672a\u83b7\u5f97\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\uff0c\u8bf7\u5148\u8d2d\u4e70\u3002", (String)"OcrQuickDocDiffServiceImpl_01", (String)PACKAGENAME, (Object[])new Object[0])), new Object[0]);
            }
            QuickDocDiffLayout quickDocDiffLayout = this.getWordContentByPOI(baseBytes, compareBytes);
            resultData = this.getResultByAlgoAPI(quickDocDiffLayout, requestId);
            LicenseUtils.ensureCallNumToAlgo((resultData != null && resultData.getErrorCode() == 0 ? 1 : 0) != 0, (String)requestId, (SourceTypeEnum)SourceTypeEnum.FILEDIFFERENCE);
        }
        catch (KDBizException ke) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (Throwable)ke);
            String message = ke.getMessage();
            ErrorCode errorCode = ke.getErrorCode();
            resultData = new AlgoResultData(requestId, errorCode != null && !StringUtils.isEmpty((CharSequence)errorCode.getCode()) ? Integer.parseInt(errorCode.getCode()) : 40000, errorCode != null ? errorCode.getMessage() : message, null);
            LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)requestId, (SourceTypeEnum)sourceTypeEnum);
        }
        catch (Exception e) {
            this.logger.error("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (Throwable)e);
            String message = ResManager.loadKDString((String)String.format("requestId\uff1a%s \u8bc6\u522b\u5f02\u5e38\uff0c%s \uff0c", requestId, e.getMessage()), (String)"OcrQuickDocDiffServiceImpl_02", (String)PACKAGENAME, (Object[])new Object[0]);
            resultData = new AlgoResultData(requestId, 40000, message, null);
            LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)requestId, (SourceTypeEnum)sourceTypeEnum);
        }
        OcrControlUtils.saveApiInfo((String)"E", (int)(resultData != null ? resultData.getErrorCode() : 40000), (Object)0L, (String)ResManager.loadKDString((String)"\u5feb\u6377\u5dee\u5f02\u6bd4\u5bf9", (String)"OcrQuickDocDiffServiceImpl_100", (String)PACKAGENAME, (Object[])new Object[0]), (long)(System.currentTimeMillis() - startTime), (RequestContext)RequestContext.get(), (String)"cvp_template", (Object)"");
        if (resultData == null) {
            resultData = new AlgoResultData();
            resultData.setRequestId(requestId);
            resultData.setErrorCode(40000);
            resultData.setData(null);
            resultData.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrQuickDocDiffServiceImpl_03", (String)PACKAGENAME, (Object[])new Object[0]));
        }
        return JSON.parseObject((String)SerializationUtils.toJsonString((Object)resultData));
    }

    private AlgoResultData getResultByAlgoAPI(QuickDocDiffLayout quickDocDiffLayout, String requestId) {
        if (quickDocDiffLayout == null || quickDocDiffLayout.getBaseLayouts().isEmpty() || quickDocDiffLayout.getCompareLayouts().isEmpty()) {
            throw new KDBizException(new ErrorCode("403001", ResManager.loadKDString((String)"\u63d0\u53d6\u6587\u6863\u7ed3\u679c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrQuickDocDiffServiceImpl_13", (String)PACKAGENAME, (Object[])new Object[0])), new Object[0]);
        }
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(4);
        list.add(new BasicNameValuePair("docContent", JSON.toJSONString((Object)quickDocDiffLayout)));
        String resultStr = null;
        AlgoResultData algoResultData = null;
        try {
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
            resultStr = OcrHttpClientUtils.kdCloudHttpClientTraceIdPost((String)"/ieservice/generalDocDiff", (HttpEntity)httpEntity, (String)requestId);
        }
        catch (Exception e) {
            this.logger.error("quick doc diff error - traceId:{},requestId:{}", (Object)RequestContext.get().getTraceId(), (Object)requestId);
            algoResultData = new AlgoResultData();
            algoResultData.setErrorCode(403001);
            algoResultData.setRequestId(requestId);
            algoResultData.setDescription("\u672a\u77e5\u5f02\u5e38\u3002");
            algoResultData.setData(null);
            return algoResultData;
        }
        return (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
    }

    private QuickDocDiffLayout getWordContentByPOI(byte[] baseBytes, byte[] compareBytes) {
        QuickDocDiffLayout quickDocDiffLayout = new QuickDocDiffLayout();
        try (ByteArrayInputStream baseInput = new ByteArrayInputStream(baseBytes);
             ByteArrayInputStream compareInput = new ByteArrayInputStream(compareBytes);){
            quickDocDiffLayout.setBaseLayouts(CommonUtil.getParagrapLayout((InputStream)baseInput));
            quickDocDiffLayout.setCompareLayouts(CommonUtil.getParagrapLayout((InputStream)compareInput));
        }
        catch (IOException e) {
            throw new KDBizException(new ErrorCode("403001", ResManager.loadKDString((String)"\u63d0\u53d6\u6587\u6863\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrQuickDocDiffServiceImpl_13", (String)PACKAGENAME, (Object[])new Object[0])), new Object[0]);
        }
        return quickDocDiffLayout;
    }

    private Map<String, Object> validParam(Map<String, String> paramMap) {
        if (paramMap == null || paramMap.isEmpty()) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"OcrQuickDocDiffServiceImpl_04", (String)PACKAGENAME, (Object[])new Object[0])), new Object[0]);
        }
        String baseUrl = paramMap.get("baseUrl");
        String compareUrl = paramMap.get("compareUrl");
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        Map baseMap = CommonUtil.validFileUrl((String)baseUrl);
        this.validFileType4Stream(baseMap, "base");
        map.put("baseBytes", baseMap.get("bytes"));
        Map compareMap = CommonUtil.validFileUrl((String)compareUrl);
        this.validFileType4Stream(compareMap, "compare");
        map.put("compareBytes", compareMap.get("bytes"));
        return map;
    }

    private void validFileType4Stream(Map<String, Object> param, String typeName) {
        String alertName;
        String fileName = (String)param.get("fileName");
        String string = alertName = typeName.equals("base") ? "\u6a21\u677f\u6587\u6863" : "\u6bd4\u5bf9\u6587\u6863";
        if (!fileName.endsWith(".docx")) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)(alertName + "\u4e0d\u652f\u6301\u975edocx\u6587\u6863\u8fdb\u884c\u5feb\u6377\u6bd4\u5bf9\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002"), (String)"OcrQuickDocDiffServiceImpl_10", (String)PACKAGENAME, (Object[])new Object[0])), new Object[0]);
        }
    }
}

