/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.ai.cvp.common.Enum.DistingushFileTypeEnum;
import kd.ai.cvp.common.Enum.LicenseCountServiceNameEnum;
import kd.ai.cvp.common.Enum.OcrHandleTypeEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.common.Enum.TableOutputTypeEnum;
import kd.ai.cvp.common.OcrCommon;
import kd.ai.cvp.entity.AlgoPageNumAndFileIdVO;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.OcrGTPresetVO;
import kd.ai.cvp.entity.ie.ComplexPageInfo;
import kd.ai.cvp.entity.ie.CtieDBvo;
import kd.ai.cvp.entity.ie.CtieResultVO;
import kd.ai.cvp.entity.ie.DocTotalRecLayoutDataVO;
import kd.ai.cvp.entity.ie.GeneralIEResult;
import kd.ai.cvp.entity.ie.IeLLMExtractResultVO;
import kd.ai.cvp.entity.ie.MserviceRetCoreVO;
import kd.ai.cvp.entity.ie.MserviceRetVO;
import kd.ai.cvp.entity.ie.RedClauseExtractVO;
import kd.ai.cvp.entity.ie.VariableSiteVO;
import kd.ai.cvp.mservice.OcrService;
import kd.ai.cvp.task.CtiePullResultServiceNew;
import kd.ai.cvp.task.mserviceQuery.OcrMserviceHandler;
import kd.ai.cvp.task.mserviceQuery.TdaMserviceQuery;
import kd.ai.cvp.task.mserviceQuery.TieMserviceQuery;
import kd.ai.cvp.task.tie.IeCommonUtil;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.IeUtils;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.LocalTempFileCache;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.PDFPageNumUtil;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.ai.cvp.utils.TdaUtils;
import kd.ai.cvp.utils.ThreadUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.ISDTContent;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFSDTContent;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class OcrServiceImpl
implements OcrService {
    private final Log logger = LogFactory.getLog(OcrServiceImpl.class);
    private static final String SUPPORTFILETYPES = "jpg,jpeg,png,pdf";
    private static final String APPID = "ai-cvp-mservice";
    private static final String PDF_PAGENUM_MAX = System.getProperty("pdf_max_pagenum", "100");
    private static final int PDF_SPLIT_SIZE = Integer.parseInt(System.getProperty("pdf_split_size", "10"));
    private static final String ERROR_TIPS = "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002";
    private static final String LLM_RESULT_NOT_FOUND = "not found";
    private static final String SYSTEM_ERROR_ALERT_MESSAGE = ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_004", (String)"ai-cvp-mservice", (Object[])new Object[0]);
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ai-cvp");

    public String distinguishOcrImage(String businessObject, String templateNumber, String imageData) {
        this.logger.info("\u89c6\u89c9\u8bc6\u522b\u5fae\u670d\u52a1API\u8c03\u7528-start params: businessObject:" + businessObject + " - templateNumber:" + templateNumber);
        return this.ocrImage(businessObject, templateNumber, imageData, "B");
    }

    public String distinguishOcrByUrl(String businessObject, String templateNumber, String fileUrl) {
        this.logger.info("\u89c6\u89c9\u8bc6\u522b\u5fae\u670d\u52a1API\u8c03\u7528-byUrl-start params: businessObject:" + businessObject + " - templateNumber:" + templateNumber);
        AlgoResultData algoResult = null;
        try {
            Map map = CommonUtil.validFileUrl((String)fileUrl);
            if (!map.isEmpty()) {
                byte[] bytes = (byte[])map.get("bytes");
                String fileName = (String)map.get("fileName");
                this.logger.info("\u6587\u4ef6\u540d\u79f0\uff1a{}\uff0cbytes\u5927\u5c0f\uff1a{}", (Object)fileName, (Object)bytes);
                String imageData = OcrControlUtils.getFileBase64((byte[])bytes);
                return this.ocrImage(businessObject, templateNumber, imageData, "B");
            }
        }
        catch (KDBizException kde) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)kde);
            ErrorCode errorCode = kde.getErrorCode();
            int eCode = Integer.parseInt("42000");
            String code = errorCode.getCode();
            String message = errorCode.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)code)) {
                eCode = Integer.parseInt(kde.getErrorCode().getCode());
            }
            if (StringUtils.isEmpty((CharSequence)message)) {
                message = ResManager.loadKDString((String)"\u672a\u77e5\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_1002", (String)APPID, (Object[])new Object[0]);
            }
            algoResult = AlgoResultData.error((int)eCode, (String)message);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            algoResult = AlgoResultData.error((int)40000, (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_1001", (String)APPID, (Object[])new Object[0]));
        }
        if (algoResult == null) {
            this.logger.error("\u6587\u4ef6\u6821\u9a8c\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38\u3002");
            algoResult = AlgoResultData.error((int)40000, (String)SYSTEM_ERROR_ALERT_MESSAGE);
        }
        return SerializationUtils.toJsonString(algoResult);
    }

    public String distinguishOcrImage(String businessObject, String templateNumber, String imageData, DistingushFileTypeEnum distingushFileTypeEnum) {
        return this.distinguishOcrImage(businessObject, templateNumber, imageData);
    }

    public String distinguishOcrImageWithParam(String businessObject, String templateNumber, String imageData, Map<String, String> bizParam) {
        this.logger.info("\u89c6\u89c9\u8bc6\u522b\u5fae\u670d\u52a1API\u8c03\u7528-start params: businessObject:" + businessObject + " - templateNumber:" + templateNumber);
        return this.ocrImage(businessObject, templateNumber, imageData, "B", bizParam);
    }

    public boolean checkCVPLicense() {
        return LicenseUtils.checkPureLicense();
    }

    public String extractVariablesSite(String wordJsonStr) {
        this.logger.info("\u53d8\u91cf\u63d0\u53d6\u5fae\u670d\u52a1\u63a5\u53e3\uff0c\u5f00\u59cb\u3002\u5165\u53c2\uff1a{}", (Object)(StringUtils.isNotEmpty((CharSequence)wordJsonStr) && wordJsonStr.length() > 200 ? wordJsonStr.substring(0, 199) : wordJsonStr));
        AlgoResultData resultData = null;
        SourceTypeEnum sourceTypeEnum = SourceTypeEnum.EXTRACT_VARIABLES_SITE;
        String requestId = UUID.randomUUID().toString();
        try {
            this.validInputParam(wordJsonStr);
            boolean licenseCheckFlag = LicenseUtils.checkLicense((int)1, (String)LicenseCountServiceNameEnum.EXTRACT_VARIABLES.getName(), (String)requestId);
            if (!licenseCheckFlag) {
                throw new KDBizException(OcrCommon.ResCode.no_cvp_auth(), new Object[0]);
            }
            resultData = this.requestAlgoResultForVariablesSite(wordJsonStr, requestId);
            LicenseUtils.ensureCallNumToAlgo((resultData.getErrorCode() == 0 ? 1 : 0) != 0, (String)requestId, (SourceTypeEnum)SourceTypeEnum.INFOEXTRACT);
        }
        catch (KDBizException ke) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (Throwable)ke);
            String message = ke.getMessage();
            ErrorCode errorCode = ke.getErrorCode();
            resultData = new AlgoResultData(requestId, errorCode != null && !StringUtils.isEmpty((CharSequence)errorCode.getCode()) ? Integer.parseInt(errorCode.getCode()) : 40000, message, null);
            LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)requestId, (SourceTypeEnum)sourceTypeEnum);
        }
        catch (Exception e) {
            this.logger.error("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (Throwable)e);
            String message = ResManager.loadKDString((String)String.format("requestId\uff1a%s \u8bc6\u522b\u5f02\u5e38\uff0c%s \uff0c", requestId, e.getMessage()), (String)"OcrServiceImp_004", (String)APPID, (Object[])new Object[0]);
            resultData = new AlgoResultData(requestId, 40000, message, null);
            LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)requestId, (SourceTypeEnum)sourceTypeEnum);
        }
        return SerializationUtils.toJsonString((Object)resultData);
    }

    private AlgoResultData requestAlgoResultForVariablesSite(String wordJsonStr, String requestId) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)wordJsonStr)) {
            StringEntity entity = new StringEntity(wordJsonStr, ContentType.APPLICATION_JSON);
            entity.setContentEncoding("UTF-8");
            long startReqTime = System.currentTimeMillis();
            String resultStr = OcrHttpClientUtils.kdCloudHttpClientTraceIdPost((String)"/ieservice/nlp_service/keywords_extract", (HttpEntity)entity, (String)requestId);
            long endReqTime = System.currentTimeMillis();
            this.logger.info(String.format("\u8bf7\u6c42\u53d8\u91cf\u4f4d\u7f6e\u63d0\u53d6\u63a5\u53e3\u7528\u65f6:%s,\u7ed3\u679c\u4e3a\uff1a%s", endReqTime - startReqTime, resultStr));
            return this.analysisResp(resultStr);
        }
        return new AlgoResultData(requestId, 40000, SYSTEM_ERROR_ALERT_MESSAGE);
    }

    private AlgoResultData analysisResp(String resultStr) {
        AlgoResultData algoResultData = (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
        String errorMsg = ResManager.loadKDString((String)"\u7b97\u6cd5\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"OcrServiceImpl_010", (String)APPID, (Object[])new Object[0]);
        if (algoResultData != null) {
            Object data;
            int errorCode = algoResultData.getErrorCode();
            errorMsg = algoResultData.getDescription();
            if (errorCode == 0 && (data = algoResultData.getData()) != null) {
                JSONArray arr = JSON.parseArray((String)data.toString());
                algoResultData.setData((Object)arr);
                return algoResultData;
            }
        }
        throw new KDBizException(new ErrorCode("30011", errorMsg), new Object[0]);
    }

    private void validInputParam(String wordJsonStr) {
        if (StringUtils.isEmpty((CharSequence)wordJsonStr)) {
            throw new KDBizException(OcrCommon.ResCode.get_param_error(), new Object[0]);
        }
        try {
            JSON.parseObject((String)wordJsonStr, VariableSiteVO.class);
        }
        catch (Exception e) {
            this.logger.error("\u975ejson\u683c\u5f0f\u5165\u53c2", (Throwable)e);
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"OcrServiceImpl_003", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
    }

    public String getAllTieFields(String planNumber) {
        QFilter fnumberFilter;
        DynamicObject[] planObjColl;
        this.logger.info("\u89c6\u89c9\u8bc6\u522b\u5fae\u670d\u52a1API\u8c03\u7528-start params: planNumber:{}", (Object)planNumber);
        AlgoResultData algoResultData = this.validAllTieFieldsParams(planNumber);
        if (algoResultData != null) {
            return SerializationUtils.toJsonString((Object)algoResultData);
        }
        ArrayList<String> planStrList = new ArrayList<String>(16);
        if (planNumber.contains(",")) {
            planStrList.addAll(Arrays.stream(planNumber.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList()));
        } else {
            planStrList.add(planNumber);
        }
        ArrayList retList = new ArrayList(16);
        if (!planStrList.isEmpty() && (planObjColl = BusinessDataServiceHelper.load((String)"cvp_ie_mouldplan", (String)"id,number,name,commonextract,usellmextract,llmentryentity,llmentryentity.llmextractfield,llmentryentity.llmextractnum,llmentryentity.llmtabnum,llmentryentity.llmtabname", (QFilter[])new QFilter[]{fnumberFilter = new QFilter("number", "in", planStrList)})) != null && planObjColl.length > 0) {
            Arrays.stream(planObjColl).forEach(planObj -> {
                MserviceRetVO mserviceRetVO = new MserviceRetVO();
                String curPlanNumber = planObj.getString("number");
                String curPlanName = planObj.getString("name");
                mserviceRetVO.setPlanNumber(curPlanNumber);
                mserviceRetVO.setPlanName(curPlanName);
                ArrayList<MserviceRetCoreVO> fields = new ArrayList<MserviceRetCoreVO>(16);
                this.addCommonExtractFields((DynamicObject)planObj, (List<MserviceRetCoreVO>)fields);
                this.addLLMExtractFields((DynamicObject)planObj, (List<MserviceRetCoreVO>)fields);
                mserviceRetVO.setFields(fields);
                retList.add(mserviceRetVO);
            });
        }
        return SerializationUtils.toJsonString(retList);
    }

    private void addLLMExtractFields(DynamicObject planObj, List<MserviceRetCoreVO> fields) {
        boolean usellmextract;
        if (planObj != null && (usellmextract = planObj.getBoolean("usellmextract"))) {
            DynamicObjectCollection entryentity = planObj.getDynamicObjectCollection("llmentryentity");
            entryentity.forEach(entry -> {
                MserviceRetCoreVO mserviceRetCoreVO = new MserviceRetCoreVO();
                String extractfield = entry.getString("llmextractfield");
                String extractnum = entry.getString("llmextractnum");
                String tabnum = entry.getString("llmtabnum");
                String tabname = entry.getString("llmtabname");
                if (StringUtils.isNotEmpty((CharSequence)tabnum) && StringUtils.isNotEmpty((CharSequence)tabname)) {
                    mserviceRetCoreVO.setFisTableField("true");
                    mserviceRetCoreVO.setFtableName(tabname);
                    mserviceRetCoreVO.setFtableNumber(tabnum);
                } else {
                    mserviceRetCoreVO.setFisTableField("false");
                }
                mserviceRetCoreVO.setFname(extractfield);
                mserviceRetCoreVO.setFnumber(extractnum);
                fields.add(mserviceRetCoreVO);
            });
        }
    }

    private void addCommonExtractFields(DynamicObject planObj, List<MserviceRetCoreVO> fields) {
        QFilter statusFilter;
        QFilter enableFilter;
        DynamicObject[] objCol;
        boolean commonextract;
        if (planObj != null && (commonextract = planObj.getBoolean("commonextract")) && (objCol = BusinessDataServiceHelper.load((String)"cvp_ie_extract_common", (String)"id,extractfield,extractnum,tabnum,tabname,createtime", (QFilter[])new QFilter[]{enableFilter = new QFilter("enable", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C")}, (String)"createtime asc")) != null && objCol.length > 0) {
            for (DynamicObject obj : objCol) {
                String extractfield = obj.getString("extractfield");
                String extractnum = obj.getString("extractnum");
                String tabnum = obj.getString("tabnum");
                String tabname = obj.getString("tabname");
                MserviceRetCoreVO mserviceRetCoreVO = new MserviceRetCoreVO();
                if (StringUtils.isNotEmpty((CharSequence)tabnum) && StringUtils.isNotEmpty((CharSequence)tabname)) {
                    mserviceRetCoreVO.setFisTableField("true");
                    mserviceRetCoreVO.setFtableName(tabname);
                    mserviceRetCoreVO.setFtableNumber(tabnum);
                } else {
                    mserviceRetCoreVO.setFisTableField("false");
                }
                mserviceRetCoreVO.setFname(extractfield);
                mserviceRetCoreVO.setFnumber(extractnum);
                fields.add(mserviceRetCoreVO);
            }
        }
    }

    private AlgoResultData validAllTieFieldsParams(String planNumber) {
        if (StringUtils.isEmpty((CharSequence)planNumber)) {
            String message = ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"OcrServiceImpl_002", (String)"ai-cvp-common", (Object[])new Object[0]);
            return new AlgoResultData(RequestContext.get().getTraceId(), 40002, message);
        }
        return null;
    }

    public String getContractRedClauseAlter(String url, String terms) {
        AlgoResultData resultData = null;
        String requestId = UUID.randomUUID().toString();
        SourceTypeEnum sourceTypeEnum = SourceTypeEnum.EXTRACT_VARIABLES_SITE;
        long startTime = System.currentTimeMillis();
        try {
            this.validParamForRedClause(url, terms);
            String tempPath = CvpFileServiceUtils.attFile2TempFile((String)url);
            CommonUtil.validFileTypeByCommonCache((String)tempPath, (String)"docx");
            List redClauseExtractVOS = JSON.parseArray((String)terms, RedClauseExtractVO.class);
            if (redClauseExtractVOS.isEmpty()) {
                throw new KDBizException(OcrCommon.ResCode.get_param_error(), new Object[0]);
            }
            this.logger.info("\u8f93\u5165\u8def\u5f84\uff1a{}", (Object)url);
            url = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(url);
            String suffixStr = url.substring(url.lastIndexOf(".") + 1);
            String docContent = this.getWordContent(tempPath, suffixStr);
            boolean licenseCheckFlag = LicenseUtils.checkLicense((int)1, (String)LicenseCountServiceNameEnum.EXTRACT_VARIABLES.getName(), (String)requestId);
            if (!licenseCheckFlag) {
                throw new KDBizException(new ErrorCode(String.valueOf(40004), ResManager.loadKDString((String)"\u672a\u83b7\u5f97\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\uff0c\u8bf7\u5148\u8d2d\u4e70\u3002", (String)"OcrServiceImpl_03", (String)APPID, (Object[])new Object[0])), new Object[0]);
            }
            resultData = this.getResultByAlgoAPI(docContent, redClauseExtractVOS, requestId);
            LicenseUtils.ensureCallNumToAlgo((resultData != null && resultData.getErrorCode() == 0 ? 1 : 0) != 0, (String)requestId, (SourceTypeEnum)SourceTypeEnum.INFOEXTRACT);
        }
        catch (KDBizException ke) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (Throwable)ke);
            String message = ke.getMessage();
            ErrorCode errorCode = ke.getErrorCode();
            resultData = new AlgoResultData(requestId, errorCode != null && !StringUtils.isEmpty((CharSequence)errorCode.getCode()) ? Integer.parseInt(errorCode.getCode()) : 40000, message, null);
            LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)requestId, (SourceTypeEnum)sourceTypeEnum);
        }
        catch (Exception e) {
            this.logger.error("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (Throwable)e);
            String message = ResManager.loadKDString((String)String.format("requestId\uff1a%s \u8bc6\u522b\u5f02\u5e38\uff0c%s \uff0c", requestId, e.getMessage()), (String)"OcrServiceImp_004", (String)APPID, (Object[])new Object[0]);
            resultData = new AlgoResultData(requestId, 40000, message, null);
            LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)requestId, (SourceTypeEnum)sourceTypeEnum);
        }
        OcrControlUtils.saveApiInfo((String)"E", (int)(resultData != null ? resultData.getErrorCode() : 40000), (Object)0L, (String)ResManager.loadKDString((String)"\u7ea2\u7ebf\u6761\u6b3e\u6bd4\u5bf9", (String)"OcrServiceImpl_200", (String)APPID, (Object[])new Object[0]), (long)(System.currentTimeMillis() - startTime), (RequestContext)RequestContext.get(), (String)"cvp_template", (Object)"");
        if (resultData == null) {
            resultData = new AlgoResultData();
            resultData.setRequestId(requestId);
            resultData.setErrorCode(40000);
            resultData.setData(null);
            resultData.setDescription(SYSTEM_ERROR_ALERT_MESSAGE);
        }
        return SerializationUtils.toJsonString((Object)resultData);
    }

    public String createTieTask4OpenAPI(String fileUrl, String pageListStr, String planNumber) {
        return IeUtils.ieStartTaskForMservice((String)fileUrl, (String)pageListStr, (String)planNumber, (String)"cvp_template", (String)"1", (String)"I");
    }

    public String createTieTask(String url, String pageListStr, String planNumber, String businessObj, String billId) {
        return IeUtils.ieStartTaskForMservice((String)url, (String)pageListStr, (String)planNumber, (String)businessObj, (String)billId, (String)"H");
    }

    public String createTieTaskV2(String url, String pageListStr, String planNumber, Map<String, Object> planInfo, Map<String, String> callback) {
        AlgoResultData algoResultData = new AlgoResultData();
        String traceId = RequestContext.get().getTraceId();
        try {
            if (!LicenseUtils.checkLicenseWithDROrRN()) {
                throw new KDBizException(new ErrorCode("401001", ResManager.loadKDString((String)"\u8bb8\u53ef\u6743\u9650\u4e0d\u8db3\uff0c\u5fc5\u987b\u540c\u65f6\u5177\u5907\u8bbe\u8ba1\u5668\u8bb8\u53ef\u548c\u8fd0\u884c\u65f6\u8bb8\u53ef\uff0c\u6216\u8005\u5177\u5907\u6d41\u91cf\u7248\u8bb8\u53ef\u624d\u53ef\u4ee5\u8c03\u7528\u672c\u63a5\u53e3\u3002", (String)"OcrServiceImpl_110", (String)APPID, (Object[])new Object[0])), new Object[0]);
            }
            this.validBizParam(planNumber, planInfo, callback);
            this.savePlanInfo(planInfo);
            if (StringUtils.isEmpty((CharSequence)planNumber)) {
                planNumber = planInfo.get("fnumber").toString();
            }
            return IeUtils.ieStartTaskWitchCallBack((String)url, (String)pageListStr, (String)planNumber, (String)"cvp_template", (String)"1", (String)"H", callback);
        }
        catch (KDBizException ke) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)ke);
            String customErrorMsg = ke.getMessage();
            int bizCode = 42000;
            ErrorCode errorCode = ke.getErrorCode();
            if (errorCode != null) {
                String code = errorCode.getCode();
                this.logger.error("biz error code :{}", (Object)code);
                String message = errorCode.getMessage();
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    customErrorMsg = message;
                }
            }
            algoResultData.setErrorCode(bizCode);
            algoResultData.setDescription(customErrorMsg);
            algoResultData.setRequestId(traceId);
            return SerializationUtils.toJsonString((Object)algoResultData);
        }
        catch (Exception e) {
            this.logger.error("\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            String message = e.getMessage();
            algoResultData.setErrorCode(40000);
            algoResultData.setDescription(StringUtils.isEmpty((CharSequence)message) ? ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"IeUtils_003", (String)"ai-cvp-common", (Object[])new Object[0]) : message);
            algoResultData.setRequestId(traceId);
            return SerializationUtils.toJsonString((Object)algoResultData);
        }
    }

    private void savePlanInfo(Map<String, Object> planInfo) {
        DynamicObject iePlan;
        String bizConfig;
        if (planInfo == null || planInfo.isEmpty()) {
            return;
        }
        String planNumber = planInfo.get("fnumber").toString();
        long planPkId = this.doDeleteOldData(planNumber);
        Object fbusinessconfig = planInfo.get("fbusinessconfig");
        Object fcommonextract = planInfo.get("fcommonextract");
        Object fusellmextract = planInfo.get("fusellmextract");
        Object fdescription = planInfo.get("fdescription");
        Object fdocdescrip = planInfo.get("fdocdescrip");
        Object fname = planInfo.get("fname");
        Object fnumber = planInfo.get("fnumber");
        Object ffields = planInfo.get("ffields");
        if (fbusinessconfig != null && StringUtils.isNotEmpty((CharSequence)fbusinessconfig.toString()) && "B".equals(bizConfig = fbusinessconfig.toString())) {
            fusellmextract = "true";
            fcommonextract = "false";
        }
        if (planPkId == 0L) {
            iePlan = BusinessDataServiceHelper.newDynamicObject((String)"cvp_ie_mouldplan");
            iePlan.set("id", (Object)DB.genLongId((String)"cvp_ie_mouldplan"));
        } else {
            iePlan = BusinessDataServiceHelper.loadSingle((Object)planPkId, (String)"cvp_ie_mouldplan");
        }
        iePlan.set("number", fnumber);
        iePlan.set("name", fname);
        iePlan.set("description", fdescription);
        iePlan.set("businessconfig", fbusinessconfig);
        iePlan.set("commonextract", fcommonextract);
        iePlan.set("usellmextract", fusellmextract);
        iePlan.set("docdescrip", fdocdescrip);
        iePlan.set("status", (Object)"C");
        iePlan.set("enable", (Object)"1");
        iePlan.set("issys", (Object)true);
        DynamicObjectCollection llmentryentity = iePlan.getDynamicObjectCollection("llmentryentity");
        if (ffields != null) {
            List maps = JSON.parseArray((String)ffields.toString(), Map.class);
            Map<String, List<Map<String, Object>>> groupMap = this.genMapByGroup(maps);
            if (groupMap.size() > 6) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u7cfb\u7edf\u6682\u53ea\u652f\u63015\u4e2a\u8868\u683c\u548c\u4e00\u4e2a\u901a\u7528\u5b57\u6bb5\u5217\u8868\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"OcrServiceImpl_211", (String)APPID, (Object[])new Object[0])), new Object[0]);
            }
            int tabIndex = 1;
            int totalIndex = 1;
            for (Map.Entry<String, List<Map<String, Object>>> groupEntry : groupMap.entrySet()) {
                List<Map<String, Object>> value;
                String key = groupEntry.getKey();
                String tabName = "";
                String tabNum = "";
                if (!StringUtils.equals((CharSequence)"common", (CharSequence)key)) {
                    tabName = String.format("\u8868\u683c %d \u5b57\u6bb5", tabIndex);
                    tabNum = String.format("t%s", tabIndex);
                    ++tabIndex;
                }
                if ((value = groupEntry.getValue()) == null || value.isEmpty()) continue;
                String extractNum = "";
                extractNum = StringUtils.isNotEmpty((CharSequence)tabName) ? "tf%d" : "cf%d";
                for (int i = 0; i < value.size(); ++i) {
                    Map<String, Object> map = value.get(i);
                    Object fextractfield = map.get("fextractfield");
                    Object ffieldtype = map.get("ffieldtype");
                    Object fexdescription = map.get("fexdescription");
                    Object foutput = map.get("foutput");
                    Integer fseq = totalIndex;
                    ++totalIndex;
                    DynamicObject llmObj = llmentryentity.addNew();
                    llmObj.set("llmextractfield", fextractfield);
                    if (ffieldtype == null) {
                        ffieldtype = "1517513264819398656";
                    }
                    llmObj.set("llmfieldtype", (Object)Long.parseLong(ffieldtype.toString()));
                    if (fexdescription != null && StringUtils.isNotEmpty((CharSequence)fexdescription.toString())) {
                        llmObj.set("llmexdescription", (Object)fexdescription.toString());
                    }
                    if (foutput != null && StringUtils.isNotEmpty((CharSequence)foutput.toString())) {
                        llmObj.set("llmoutput", (Object)foutput.toString());
                    }
                    llmObj.set("seq", (Object)fseq);
                    if (StringUtils.isNotEmpty((CharSequence)tabName)) {
                        llmObj.set("llmtabname", (Object)tabName);
                        llmObj.set("llmtabnum", (Object)tabNum);
                    }
                    llmObj.set("llmextractnum", (Object)String.format(extractNum, i + 1));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{iePlan});
    }

    private long doDeleteOldData(String planNumber) {
        DynamicObject planObj;
        QFilter qFilter = new QFilter("number", "=", (Object)planNumber);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse("2022-09-25");
        }
        catch (ParseException e) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)ERROR_TIPS, (String)"OcrServiceImpl_212", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
        QFilter timeFilter = null;
        if (date != null) {
            timeFilter = new QFilter("createtime", ">", (Object)date);
        }
        if ((planObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_mouldplan", (String)"id,llmentryentity", (QFilter[])new QFilter[]{qFilter, statusFilter, timeFilter})) != null) {
            this.logger.warn("\u5220\u9664\u65e7\u7248\u672c\u65b9\u6848\uff0c\u65b9\u6848\u7f16\u7801\uff1a{}", (Object)planNumber);
            DynamicObjectCollection entry = planObj.getDynamicObjectCollection("llmentryentity");
            DeleteServiceHelper.delete((IDataEntityType)entry.getDynamicObjectType(), (Object[])entry.stream().map(DataEntityBase::getPkValue).toArray());
            return Long.parseLong(planObj.getPkValue().toString());
        }
        return 0L;
    }

    private Map<String, List<Map<String, Object>>> genMapByGroup(List<Map> maps) {
        if (maps == null || maps.isEmpty()) {
            return new HashMap<String, List<Map<String, Object>>>();
        }
        LinkedHashMap<String, List<Map<String, Object>>> resultMap = new LinkedHashMap<String, List<Map<String, Object>>>();
        ArrayList<Map> commonList = new ArrayList<Map>();
        for (int i = 0; i < maps.size(); ++i) {
            Map map = maps.get(i);
            Object llmtabname = map.get("ftablename");
            if (llmtabname == null || StringUtils.isEmpty((CharSequence)llmtabname.toString())) {
                commonList.add(map);
                continue;
            }
            ArrayList<Map> tabs = (ArrayList<Map>)resultMap.get(llmtabname.toString());
            if (tabs != null && !tabs.isEmpty()) {
                tabs.add(map);
                continue;
            }
            tabs = new ArrayList<Map>();
            tabs.add(map);
            resultMap.put(llmtabname.toString(), tabs);
        }
        resultMap.put("common", commonList);
        return resultMap;
    }

    private void validBizParam(String planNumber, Map<String, Object> planInfo, Map<String, String> callback) {
        if (planInfo != null) {
            this.doValidPlanInfo(planNumber, planInfo);
        }
        if (callback != null) {
            String str = JSON.toJSONString(callback);
            if (str.length() > 2000) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u56de\u8c03\u53c2\u6570\u8d85\u8fc7\u5b57\u6bb5\u957f\u5ea62000\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_203", (String)APPID, (Object[])new Object[0])), new Object[0]);
            }
            String bizCloudId = callback.get("bizCloudId");
            String bizAppId = callback.get("bizAppId");
            String bizCallBackService = callback.get("bizCallBackService");
            String bizCallBackMethod = callback.get("bizCallBackMethod");
            if (StringUtils.isEmpty((CharSequence)bizCloudId) || StringUtils.isEmpty((CharSequence)bizAppId) || StringUtils.isEmpty((CharSequence)bizCallBackService) || StringUtils.isEmpty((CharSequence)bizCallBackMethod)) {
                this.logger.info("\u56de\u8c03\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u4e0d\u8fdb\u884c\u56de\u8c03\u3002");
                callback = null;
            }
        }
    }

    private void doValidPlanInfo(String planNumber, Map<String, Object> planInfo) {
        if (StringUtils.isEmpty((CharSequence)planNumber) && (planInfo == null || planInfo.isEmpty() || planInfo.get("fnumber") == null)) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OcrServiceImpl_200", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
        if (planInfo != null) {
            Object fnumberObj = planInfo.get("fnumber");
            if (fnumberObj != null) {
                String fnumber = fnumberObj.toString();
                if (StringUtils.isNotEmpty((CharSequence)planNumber) && !planNumber.equals(fnumber)) {
                    throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u9700\u8981\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_201", (String)APPID, (Object[])new Object[0])), new Object[0]);
                }
                if ("ie_mp_A39B74A5".equals(fnumber)) {
                    throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u7cfb\u7edf\u9884\u7f6e\u7684\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\uff0c\u8bf7\u76f4\u63a5\u8f93\u5165\u5f85\u63d0\u53d6\u7684\u65b9\u6848\u7f16\u7801\u518d\u8fdb\u884c\u63d0\u53d6\u3002", (String)"OcrServiceImpl_202", (String)APPID, (Object[])new Object[0])), new Object[0]);
                }
                this.validParamForBill(planInfo);
            }
        } else {
            QFilter numberFilter = new QFilter("number", "=", (Object)planNumber);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            DynamicObject planObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_mouldplan", (String)"id,number", (QFilter[])new QFilter[]{numberFilter, statusFilter});
            if (planObj == null) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u662f\u5426\u5b58\u5728\u6216\u662f\u5426\u5df2\u53d1\u5e03\u3002", (String)"OcrServiceImpl_204", (String)APPID, (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    private void validParamForBill(Map<String, Object> planInfo) {
        String descri;
        String docdesResult;
        String usellmExtract;
        String llmResult;
        String commonExtract;
        String commonResult;
        String bizConfig;
        String configResult;
        String numberResult;
        Object fbusinessconfig = planInfo.get("fbusinessconfig");
        Object fcommonextract = planInfo.get("fcommonextract");
        Object fdescription = planInfo.get("fdescription");
        Object fdocdescrip = planInfo.get("fdocdescrip");
        Object fname = planInfo.get("fname");
        Object fnumber = planInfo.get("fnumber");
        Object fusellmextract = planInfo.get("fusellmextract");
        Object ffields = planInfo.get("ffields");
        if (fname == null || fnumber == null || fbusinessconfig == null || fcommonextract == null || fusellmextract == null) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u540e\u6309\u7167\u63a5\u53e3\u6587\u6863\u4f20\u9012\u5fc5\u8981\u63d0\u53d6\u65b9\u6848\u53c2\u6570\u3002", (String)"OcrServiceImpl_203", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
        if (Boolean.parseBoolean(fusellmextract.toString()) && fdocdescrip == null) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u63d0\u53d6\u65b9\u6848\u4f7f\u7528\u5927\u6a21\u578b\u63d0\u53d6\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u6587\u6863\u63cf\u8ff0[fdocdescrip]\u3002", (String)"OcrServiceImpl_210", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        String nameResult = this.validParamLength(fname.toString(), "fname", 50, -1);
        if (StringUtils.isNotEmpty((CharSequence)nameResult)) {
            sb.append(nameResult).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(numberResult = this.validParamLength(fnumber.toString(), "fnumber", 30, -1)))) {
            sb.append(numberResult).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(configResult = this.validParamLength(bizConfig = fbusinessconfig.toString(), "fbusinessconfig", 1, -1)))) {
            sb.append(configResult).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)bizConfig) && !"A,B".contains(bizConfig)) {
            sb.append(ResManager.loadKDString((String)"\u6587\u6863\u7c7b\u578b\u5b57\u6bb5\u672a\u6309\u8981\u6c42\u586b\u5199\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_208", (String)APPID, (Object[])new Object[0])).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(commonResult = this.validParamLength(commonExtract = fcommonextract.toString(), "fcommonextract", 5, -1)))) {
            sb.append(commonResult).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)commonExtract) && !"true,false".contains(commonExtract)) {
            sb.append(ResManager.loadKDString((String)"\u901a\u7528\u63d0\u53d6\u5b57\u6bb5\u9700\u8981\u4f20\u9012true\u6216\u8005false\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_209", (String)APPID, (Object[])new Object[0])).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)(llmResult = this.validParamLength(usellmExtract = fusellmextract.toString(), "fusellmextract", 5, -1)))) {
            sb.append(llmResult).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)usellmExtract) && !"true,false".contains(usellmExtract)) {
            sb.append(ResManager.loadKDString((String)"\u5927\u6a21\u578b\u81ea\u5b9a\u4e49\u5b57\u6bb5\u9700\u8981\u4f20\u9012true\u6216\u8005false\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_210", (String)APPID, (Object[])new Object[0])).append("\n");
        }
        if ("B".equals(bizConfig)) {
            if (!Boolean.parseBoolean(usellmExtract)) {
                sb.append(ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u6587\u6863\u63d0\u53d6\u65f6\u5fc5\u987b\u5141\u8bb8\u5927\u6a21\u578b\u81ea\u5b9a\u4e49\u63d0\u53d6\u5b57\u6bb5\u3002", (String)"OcrServiceImpl_211", (String)APPID, (Object[])new Object[0]));
            }
            if (Boolean.parseBoolean(commonExtract)) {
                sb.append(ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u6587\u6863\u63d0\u53d6\u65f6\u65e0\u6cd5\u4f7f\u7528\u901a\u7528\u6a21\u578b\u63d0\u53d6\u5b57\u6bb5\u3002", (String)"OcrServiceImpl_212", (String)APPID, (Object[])new Object[0]));
            }
        }
        if (fdocdescrip != null && StringUtils.isNotEmpty((CharSequence)(docdesResult = this.validParamLength(fdocdescrip.toString(), "fdocdescrip", 50, -1)))) {
            sb.append(docdesResult).append("\n");
        }
        if (fdescription != null && StringUtils.isNotEmpty((CharSequence)fdescription.toString()) && StringUtils.isNotEmpty((CharSequence)(descri = this.validParamLength(fdescription.toString(), "fdescription", 255, -1)))) {
            sb.append(descri).append("\n");
        }
        if (!Boolean.parseBoolean(fusellmextract.toString()) && ffields != null && !JSON.parseArray((String)ffields.toString()).isEmpty()) {
            this.logger.info("\u975e\u5927\u6a21\u578b\u63d0\u53d6\uff0c\u5ffd\u7565\u5927\u6a21\u578b\u5b57\u6bb5\u3002");
            planInfo.remove("ffields");
            ffields = "";
        }
        if (ffields != null && StringUtils.isNotEmpty((CharSequence)ffields.toString())) {
            sb.append(this.validEntryParam(ffields));
        }
        if (StringUtils.isNotEmpty((CharSequence)sb)) {
            throw new KDBizException(new ErrorCode("40002", sb.toString()), new Object[0]);
        }
    }

    private String validEntryParam(Object ffields) {
        StringBuilder sb = new StringBuilder();
        List lists = JSON.parseArray((String)ffields.toString(), Map.class);
        for (int i = 0; i < lists.size(); ++i) {
            String ftableNameResult;
            String foutputResult;
            String fexdescResult;
            Map map = (Map)lists.get(i);
            Object fextractfield = map.get("fextractfield");
            Object ffieldtype = map.get("ffieldtype");
            Object fexdescription = map.get("fexdescription");
            Object foutput = map.get("foutput");
            Object ftablename = map.get("ftablename");
            if (fextractfield == null) {
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_205", (String)APPID, (Object[])new Object[0])), new Object[0]);
            }
            String extractFResult = this.validParamLength(fextractfield.toString(), "fextractfield", 30, i);
            if (StringUtils.isNotEmpty((CharSequence)extractFResult)) {
                sb.append(extractFResult).append("\n");
            }
            if (ffieldtype != null && StringUtils.isNotEmpty((CharSequence)ffieldtype.toString())) {
                QFilter qFilter;
                DynamicObject ftypeObj;
                String ffieldResult = this.validParamLength(ffieldtype.toString(), "ffieldtype", 20, i);
                if (StringUtils.isNotEmpty((CharSequence)ffieldResult)) {
                    sb.append(ffieldResult).append("\n");
                }
                if ((ftypeObj = BusinessDataServiceHelper.loadSingle((String)"cvp_field_types", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", ffieldtype)})) == null) {
                    sb.append(ResManager.loadKDString((String)String.format("\u7b2c%d\u884c\u5b57\u6bb5\u7c7b\u578b%d\u4e0d\u5b58\u5728\n", i + 1, Long.parseLong(ffieldtype.toString())), (String)"OcrServiceImpl_212", (String)"ai-cvp-msevice", (Object[])new Object[0]));
                }
            }
            if (fexdescription != null && StringUtils.isNotEmpty((CharSequence)fexdescription.toString()) && StringUtils.isNotEmpty((CharSequence)(fexdescResult = this.validParamLength(fexdescription.toString(), "fexdescription", 100, i)))) {
                sb.append(fexdescResult).append("\n");
            }
            if (foutput != null && StringUtils.isNotEmpty((CharSequence)foutput.toString()) && StringUtils.isNotEmpty((CharSequence)(foutputResult = this.validParamLength(foutput.toString(), "foutput", 100, i)))) {
                sb.append(foutputResult).append("\n");
            }
            if (ftablename == null || !StringUtils.isNotEmpty((CharSequence)ftablename.toString()) || !StringUtils.isNotEmpty((CharSequence)(ftableNameResult = this.validParamLength(ftablename.toString(), "ftablename", 50, i)))) continue;
            sb.append(ftableNameResult).append("\n");
        }
        return sb.toString();
    }

    private String validParamLength(String param, String key, int len, int i) {
        if (StringUtils.isNotEmpty((CharSequence)param) && param.length() > len) {
            String alertMsg = i >= 0 ? String.format("\u7b2c%d\u884c\u53c2\u6570%s\u8d85\u8fc7\u7cfb\u7edf\u53ef\u652f\u6301\u957f\u5ea6%d\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", i, key, len) : String.format("\u53c2\u6570%s\u8d85\u8fc7\u7cfb\u7edf\u53ef\u652f\u6301\u957f\u5ea6%d\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", key, len);
            return ResManager.loadKDString((String)alertMsg, (String)"OcrServiceImpl_206", (String)APPID, (Object[])new Object[0]);
        }
        return null;
    }

    public String queryTieTaskResult(String taskId) {
        return IeCommonUtil.queryTask((OcrMserviceHandler)new TieMserviceQuery(), (String)taskId);
    }

    public String createTdaTask(String baseUrl, String compareUrl, String tdaPlanNumber, String billId) {
        return TdaUtils.tdaCreateTaskForMservice((String)baseUrl, (String)compareUrl, (String)tdaPlanNumber, (String)billId);
    }

    public String queryTdaTaskResult(String taskId) {
        return IeCommonUtil.queryTask((OcrMserviceHandler)new TdaMserviceQuery(), (String)taskId);
    }

    public String complexDocExtractForOpanAPI(String fileUrl, boolean extractTable, boolean extractImageInDoc, boolean docWithSiteAndPage, String tableOutType) {
        return this.complexDocExtract(null, fileUrl, extractTable, extractImageInDoc, docWithSiteAndPage, tableOutType, null, "O");
    }

    @Deprecated
    public String complexDocExtract(String bizTaskId, String fileUrl, boolean extractTable, boolean extractImageInDoc, Map<String, String> bizCallBackInfo) {
        return this.complexDocExtract(null, fileUrl, extractTable, extractImageInDoc, false, TableOutputTypeEnum.JSON.getType(), null, "N");
    }

    @Deprecated
    public String complexDocExtract(String bizTaskId, String fileUrl, boolean extractTable, boolean extractImageInDoc, String tableOutType, Map<String, String> bizCallBackInfo) {
        return this.complexDocExtract(bizTaskId, fileUrl, extractTable, extractImageInDoc, false, tableOutType, bizCallBackInfo, "N");
    }

    public String complexDocExtract(Map<String, Object> bizParam, Map<String, String> bizCallBackInfo) {
        String requestId = RequestContext.get().getRequestId();
        if (bizParam == null || bizParam.isEmpty()) {
            AlgoResultData resultData = new AlgoResultData();
            resultData.setErrorCode(40002);
            resultData.setRequestId(requestId);
            resultData.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"OcrServiceImpl_205", (String)APPID, (Object[])new Object[0]));
            return JSON.toJSONString((Object)resultData);
        }
        Object bizTaskIdObj = bizParam.get("bizTaskId");
        Object fileUrlObj = bizParam.get("fileUrl");
        Object extractTableObj = bizParam.get("extractTable");
        Object extractImageInDocObj = bizParam.get("extractImageInDoc");
        Object docWithSiteAndPageObj = bizParam.get("docWithSiteAndPage");
        Object tableOutTypeObj = bizParam.get("tableOutType");
        boolean extractTable = false;
        boolean extractImageInDoc = false;
        boolean docWithSiteAndPage = false;
        String bizTaskId = String.valueOf(bizTaskIdObj);
        String fileUrl = String.valueOf(fileUrlObj);
        String tableOutType = String.valueOf(tableOutTypeObj);
        if (extractTableObj != null) {
            extractTable = Boolean.parseBoolean(extractTableObj.toString());
        }
        if (extractImageInDocObj != null) {
            extractImageInDoc = Boolean.parseBoolean(extractImageInDocObj.toString());
        }
        if (docWithSiteAndPageObj != null) {
            docWithSiteAndPage = Boolean.parseBoolean(docWithSiteAndPageObj.toString());
        }
        return this.complexDocExtract(bizTaskId, fileUrl, extractTable, extractImageInDoc, docWithSiteAndPage, tableOutType, bizCallBackInfo, "N");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String complexDocExtract(String bizTaskId, String fileUrl, boolean extractTable, boolean extractImageInDoc, boolean docWithSiteAndPageNum, String tableOutType, Map<String, String> bizCallBackInfo, String status) {
        String fileName;
        byte[] bytes;
        String requestId = RequestContext.get().getRequestId();
        AlgoResultData resultData = new AlgoResultData();
        String countKey = UUID.randomUUID().toString();
        long taskId = -1L;
        long st = System.currentTimeMillis();
        int pageNum = 0;
        Long fileId = null;
        long bizTaskIdLong = 0L;
        try {
            tableOutType = this.getTableOutputType(tableOutType, extractTable);
            Map map = CommonUtil.validFileUrl((String)fileUrl);
            this.logger.info("\u6587\u4ef6\u540d\u79f0:{}", map.get("fileName"));
            bytes = (byte[])map.get("bytes");
            this.logger.info("bytes\u5927\u5c0f\uff1a{}", (Object)bytes.length);
            fileName = (String)map.get("fileName");
            AlgoPageNumAndFileIdVO algoPageNumAndFileIdVO = this.getFilePageNum(bytes, fileName);
            if (algoPageNumAndFileIdVO != null) {
                pageNum = algoPageNumAndFileIdVO.getPageNum();
                this.logger.info("\u9875\u7801\u6570:{}", (Object)pageNum);
                fileId = algoPageNumAndFileIdVO.getFileId();
            }
            if (pageNum == 0) {
                throw new KDBizException(new ErrorCode("40002", "\u83b7\u53d6\u6587\u4ef6\u9875\u7801\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002"), new Object[0]);
            }
            try {
                if (StringUtils.isNotEmpty((CharSequence)bizTaskId)) {
                    bizTaskIdLong = Long.parseLong(bizTaskId);
                }
            }
            catch (NumberFormatException e) {
                this.logger.error("\u8f93\u5165\u975e\u957f\u6574\u578b\u4efb\u52a1id\u5f02\u5e38", (Throwable)e);
                throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"bizTaskId\u9700\u8981\u4f20\u4e3b\u952e\u7c7b\u578b\u5b57\u7b26\u4e32\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_211", (String)APPID, (Object[])new Object[0])), new Object[0]);
            }
        }
        catch (KDBizException e) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            ErrorCode errorCode222 = e.getErrorCode();
            String code = StringUtils.isEmpty((CharSequence)errorCode222.getCode()) ? "40002" : errorCode222.getCode();
            String message222 = StringUtils.isEmpty((CharSequence)errorCode222.getMessage()) ? ResManager.loadKDString((String)"\u53d1\u751f\u672a\u77e5\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_210", (String)APPID, (Object[])new Object[0]) : errorCode222.getMessage();
            OcrControlUtils.saveApiInfo((String)status, (int)Integer.parseInt(code), (Object)0, (String)"cvp_ctie_history", (long)(System.currentTimeMillis() - st), (RequestContext)RequestContext.get(), (String)"cvp_template", (Object)message222);
            resultData.setErrorCode(40002);
            resultData.setRequestId(requestId);
            resultData.setDescription(StringUtils.isEmpty((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"OcrServiceImpl_205", (String)APPID, (Object[])new Object[0]) : e.getMessage());
            return JSON.toJSONString((Object)resultData);
        }
        catch (Exception e1) {
            this.logger.error("\u672a\u77e5\u5f02\u5e38", (Throwable)e1);
            OcrControlUtils.saveApiInfo((String)status, (int)40000, (Object)0, (String)"cvp_ctie_history", (long)(System.currentTimeMillis() - st), (RequestContext)RequestContext.get(), (String)"cvp_template", (Object)e1.getMessage());
            resultData.setErrorCode(40000);
            resultData.setRequestId(requestId);
            resultData.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"OcrServiceImpl_205", (String)APPID, (Object[])new Object[0]));
            return JSON.toJSONString((Object)resultData);
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            if (!LicenseUtils.checkLicense((int)pageNum, (String)LicenseCountServiceNameEnum.COMPLEX_DOC_EXTRACT.getName(), (String)countKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5\u5e73\u53f0\u662f\u5426\u6709\u3010\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u3011\u8bb8\u53ef\u6216\u53ef\u7528\u6d41\u91cf\u662f\u5426\u5927\u4e8e0", (String)"OcrServiceImpl_207", (String)APPID, (Object[])new Object[0]));
            }
            taskId = this.reqAlgoAsyncForCreateTask(bizTaskIdLong, inputStream, fileName, pageNum, fileId, extractTable, extractImageInDoc, docWithSiteAndPageNum);
            CtieDBvo ctieDBvo = new CtieDBvo();
            ctieDBvo.setTaskId(taskId);
            ctieDBvo.setCallbackInfo(bizCallBackInfo);
            ctieDBvo.setDocName(fileName);
            ctieDBvo.setDocPath(fileUrl);
            ctieDBvo.setStatus("running");
            ctieDBvo.setPageCount(pageNum);
            ctieDBvo.setExtractImageInDoc(extractImageInDoc);
            ctieDBvo.setExtractTable(extractTable);
            ctieDBvo.setTableOutputType(tableOutType);
            ctieDBvo.setDocWithSiteAndPage(docWithSiteAndPageNum);
            this.record2Db(ctieDBvo, status, st);
            CommonUtil.setTaskIdAndTraceIdRelation((String)String.valueOf(taskId), (String)countKey);
            CtiePullResultServiceNew.executeQuery((RequestContext)RequestContext.get());
            resultData.setData((Object)taskId);
            resultData.setRequestId(RequestContext.get().getTraceId());
            resultData.setDescription("ok");
            resultData.setErrorCode(0);
            String message222 = JSON.toJSONString((Object)resultData);
            return message222;
        }
        catch (KDBizException e) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            ErrorCode errorCode = e.getErrorCode();
            String code = StringUtils.isEmpty((CharSequence)errorCode.getCode()) ? "40002" : errorCode.getCode();
            String message = StringUtils.isEmpty((CharSequence)errorCode.getMessage()) ? ResManager.loadKDString((String)"\u53d1\u751f\u672a\u77e5\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_210", (String)APPID, (Object[])new Object[0]) : errorCode.getMessage();
            LicenseUtils.ensureCallNumToAlgoAsync((boolean)false, (String)String.valueOf(taskId), (SourceTypeEnum)SourceTypeEnum.INFOEXTRACT);
            OcrControlUtils.saveApiInfo((String)status, (int)Integer.parseInt(code), (Object)0, (String)"cvp_ctie_history", (long)(System.currentTimeMillis() - st), (RequestContext)RequestContext.get(), (String)"cvp_template", (Object)message);
            resultData.setErrorCode(40002);
            resultData.setRequestId(requestId);
            resultData.setDescription(StringUtils.isEmpty((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"OcrServiceImpl_205", (String)APPID, (Object[])new Object[0]) : e.getMessage());
            return JSON.toJSONString((Object)resultData);
        }
        catch (Exception ex) {
            this.logger.error("\u672a\u77e5\u5f02\u5e38", (Throwable)ex);
            LicenseUtils.ensureCallNumToAlgoAsync((boolean)false, (String)String.valueOf(taskId), (SourceTypeEnum)SourceTypeEnum.INFOEXTRACT);
            OcrControlUtils.saveApiInfo((String)status, (int)40000, (Object)0, (String)"cvp_ctie_history", (long)(System.currentTimeMillis() - st), (RequestContext)RequestContext.get(), (String)"cvp_template", (Object)ex.getMessage());
            resultData.setErrorCode(40000);
            resultData.setRequestId(requestId);
            resultData.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25", (String)"OcrServiceImpl_205", (String)APPID, (Object[])new Object[0]));
            return JSON.toJSONString((Object)resultData);
        }
    }

    private String getTableOutputType(String tableOutType, boolean extractTable) {
        tableOutType = extractTable ? TableOutputTypeEnum.getOutputType((String)tableOutType) : "json";
        this.logger.info("table output type:{}", (Object)tableOutType);
        return tableOutType;
    }

    private long reqAlgoAsyncForCreateTask(long bizTaskId, InputStream inputStream, String fileName, int pageNum, Long fileId, boolean extractTable, boolean extractImageInDoc, boolean docWithSiteAndPageNum) {
        Long taskId = 0L == bizTaskId ? DB.genLongId((String)"cvp_ctie_history") : bizTaskId;
        ThreadUtils.get().execute(() -> {
            try {
                this.doReqAlgo(taskId + "", "A", inputStream, fileName, this.getExtractPageNum(pageNum), fileId, extractTable, extractImageInDoc, docWithSiteAndPageNum);
            }
            catch (Throwable e) {
                this.logger.error("\u521b\u5efa\u590d\u6742\u63d0\u53d6\u4efb\u52a1\u5f02\u5e38", e);
                QFilter qFilter = new QFilter("taskid", "=", (Object)String.valueOf(taskId));
                DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ctie_history", (QFilter[])new QFilter[]{qFilter});
                if (taskObj != null) {
                    taskObj.set("extractstatus", (Object)"error");
                    taskObj.set("progressinfo", (Object)"\u521b\u5efa\u4efb\u52a1\u5931\u8d25");
                }
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{taskObj});
            }
        });
        return taskId;
    }

    private void record2Db(CtieDBvo vo, String status, long startTime) {
        long taskId = vo.getTaskId();
        String taskStatus = vo.getStatus();
        Map callbackInfo = vo.getCallbackInfo();
        String docName = vo.getDocName();
        String docPath = vo.getDocPath();
        DynamicObject ctieHistoryObj = BusinessDataServiceHelper.newDynamicObject((String)"cvp_ctie_history");
        ctieHistoryObj.set("id", (Object)DB.genLongId((String)"cvp_ctie_history"));
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ctieHistoryObj.getDataEntityType().getName(), (DynamicObject)ctieHistoryObj, null);
        ctieHistoryObj.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)ctieHistoryObj));
        ctieHistoryObj.set("billstatus", (Object)"A");
        ctieHistoryObj.set("taskId", (Object)taskId);
        ctieHistoryObj.set("docname", (Object)docName);
        ctieHistoryObj.set("docpath", (Object)docPath);
        ctieHistoryObj.set("callback", (Object)JSON.toJSONString((Object)callbackInfo));
        ctieHistoryObj.set("extractstatus", (Object)taskStatus);
        ctieHistoryObj.set("createtime", (Object)startTime);
        ctieHistoryObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        ctieHistoryObj.set("pagecount", (Object)vo.getPageCount());
        ctieHistoryObj.set("extracttable", (Object)vo.getExtractTable());
        ctieHistoryObj.set("extractimageindoc", (Object)vo.getExtractImageInDoc());
        ctieHistoryObj.set("docwithsiteandpage", (Object)vo.getDocWithSiteAndPage());
        ctieHistoryObj.set("tableoutputtype", (Object)vo.getTableOutputType());
        ctieHistoryObj.set("progressinfo", (Object)ResManager.loadKDString((String)"\u6587\u4ef6\u4f20\u8f93\u4e2d...", (String)"OcrServiceImpl_110", (String)APPID, (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ctieHistoryObj});
        this.logger.info("\u8c03\u7528\u65b9\u5f0f\uff1a{}", (Object)status);
        OcrControlUtils.saveApiInfo((String)status, (int)0, (Object)0, (String)"cvp_ctie_history", (long)0L, (RequestContext)RequestContext.get(), (String)"cvp_template", (Object)taskId);
    }

    private List<Integer> getExtractPageNum(int pageNum) {
        ArrayList<Integer> pages = new ArrayList<Integer>(pageNum);
        for (int i = 0; i < pageNum; ++i) {
            pages.add(i + 1);
        }
        return pages;
    }

    private AlgoPageNumAndFileIdVO getFilePageNum(byte[] bytes, String fileName) throws Exception {
        String tempFileId = CvpFileServiceUtils.saveFile((StorageTypeEnum)StorageTypeEnum.TMP, (String)fileName, (byte[])bytes);
        return CommonUtil.fileValid((String)tempFileId, (String)fileName, null, (String)"jpg,jpeg,png,bmp,pdf,doc,docx,ofd,wps", (long)0x3200000L, (int)500);
    }

    private long doReqAlgo(String taskId, String businessConfig, InputStream in, String fileName, List<Integer> pageList, Long fileId, boolean extractTable, boolean extractImageInDoc, boolean docWithSiteAndPageNum) {
        try {
            String resultStr;
            RequestContext requestContext = RequestContext.get();
            String tenantCode = requestContext.getTenantCode();
            String tenantName = requestContext.getTenantInfo().getName();
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            multipartEntityBuilder.addTextBody("businessConfig", businessConfig);
            multipartEntityBuilder.addTextBody("sourceType", "cvp");
            multipartEntityBuilder.addTextBody("tenantCode", tenantCode);
            multipartEntityBuilder.addTextBody("tenantName", tenantName);
            multipartEntityBuilder.addTextBody("extractTable", String.valueOf(extractTable));
            multipartEntityBuilder.addTextBody("extractImageInDoc", String.valueOf(extractImageInDoc));
            multipartEntityBuilder.addTextBody("docWithSiteAndPageNum", String.valueOf(docWithSiteAndPageNum));
            multipartEntityBuilder.addTextBody("fileId", fileId == null || fileId == 0L ? "" : fileId + "");
            this.logger.info("\u6e90\u6587\u4ef6\u4f20\u9012\u6587\u4ef6\u6d41...");
            multipartEntityBuilder.addBinaryBody("file", in, ContentType.MULTIPART_FORM_DATA, fileName);
            String pageNums = pageList.stream().sorted().map(String::valueOf).collect(Collectors.joining(","));
            multipartEntityBuilder.addTextBody("targetPageNums", pageNums);
            multipartEntityBuilder.addTextBody("taskId", StringUtils.isEmpty((CharSequence)taskId) ? "0" : taskId);
            HttpEntity httpEntity = multipartEntityBuilder.build();
            this.logger.info("\u521b\u5efa\u590d\u6742\u6587\u6863\u63d0\u53d6");
            try {
                resultStr = OcrHttpClientUtils.kdCloudHttpClientPost((String)"/vrsp/complexTie/createTask", (HttpEntity)httpEntity);
            }
            catch (Exception e) {
                this.logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u7b97\u6cd5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrserviceImpl_200", (String)APPID, (Object[])new Object[0]));
            }
            this.logger.info(String.format("CTIE \u521b\u5efa\u4efb\u52a1\u5b8c\u6210,\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a%s", resultStr));
            AlgoResultData resultData = (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
            if (resultData != null && resultData.getErrorCode() == 0) {
                JSONObject jsonObject = JSON.parseObject((String)resultData.getData().toString());
                long l = jsonObject.getLong("taskId");
                return l;
            }
            throw new KDBizException(new ErrorCode("402001", ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_210", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
        finally {
            StreamHandleUtils.closeResource((Closeable)in);
        }
    }

    public String queryComplexDocExtractInfo(String taskId) {
        CtiePullResultServiceNew.executeQuery((RequestContext)RequestContext.getOrCreate());
        AlgoResultData algoResultData = new AlgoResultData();
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            algoResultData.setErrorCode(40002);
            algoResultData.setDescription(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728", (String)"OcrServiceImpl_201", (String)APPID, (Object[])new Object[0]));
            algoResultData.setRequestId(traceId);
            return JSON.toJSONString((Object)algoResultData);
        }
        try {
            CtieResultVO ctieResultVO = this.doQueyCtieResult(taskId);
            algoResultData.setData((Object)ctieResultVO);
            algoResultData.setRequestId(traceId);
            algoResultData.setDescription("ok");
            algoResultData.setErrorCode(0);
        }
        catch (KDException kde) {
            this.logger.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)kde);
            ErrorCode errorCode = kde.getErrorCode();
            String code = errorCode.getCode();
            String message = errorCode.getMessage();
            algoResultData.setRequestId(traceId);
            algoResultData.setDescription("fail " + message);
            algoResultData.setErrorCode(Integer.parseInt(code));
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            algoResultData.setRequestId(traceId);
            algoResultData.setDescription(ResManager.loadKDString((String)"fail \u672a\u77e5\u7684\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_102", (String)APPID, (Object[])new Object[0]));
            algoResultData.setErrorCode(40000);
        }
        return JSON.toJSONString((Object)algoResultData);
    }

    public void llmStreamResponseHandler(List<Map<String, String>> data) {
        block12: {
            this.logger.info("\u5f00\u59cb\u56de\u8c03,\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(data));
            DynamicObject historyObj = null;
            DynamicObject llmHistoryObj = null;
            String ieTaskId = null;
            try {
                if (data != null && !data.isEmpty()) {
                    for (Map<String, String> map : data) {
                        String taskId = map.get("id");
                        String status = map.get("status");
                        String result = map.get("result");
                        String errorCode = map.get("errorCode");
                        String message = map.get("message");
                        QFilter qFilter = new QFilter("llmtaskid", "=", (Object)taskId);
                        llmHistoryObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_llm_history", (String)"id,llmresult_tag,layoutdata_tag,pageinfo_tag,requesttask,ieplan,firstextract,extractstatus,iehistory,llmtaskid,modifytime", (QFilter[])new QFilter[]{qFilter});
                        if (llmHistoryObj == null) {
                            throw new KDBizException("\u56de\u8c03\u7684\u5927\u6a21\u578b\u63d0\u53d6\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002\u4efb\u52a1id:" + taskId);
                        }
                        String iehistory = llmHistoryObj.getString("iehistory");
                        historyObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(iehistory), (String)"cvp_ie_history");
                        ieTaskId = historyObj.getString("taskid");
                        if (StringUtils.isNotEmpty((CharSequence)errorCode) && "0".equals(errorCode)) {
                            if (!StringUtils.isNotEmpty((CharSequence)status)) continue;
                            StringBuilder sb = new StringBuilder(this.getLLMResult(taskId));
                            if (!"data: [DONE]".equals(result) && "running".equals(status)) {
                                if (!StringUtils.isNotEmpty((CharSequence)result)) continue;
                                sb.append(this.getResult(result));
                                this.setLLMResult(taskId, sb.toString());
                                continue;
                            }
                            if ("success".equals(status)) {
                                this.doAfterHandler(sb.toString(), llmHistoryObj, historyObj);
                                this.removeLLMResult(taskId);
                                if (historyObj.getBoolean("isTest")) continue;
                                LicenseUtils.ensureCallNumToAlgoAsync((boolean)true, (String)ieTaskId, (SourceTypeEnum)SourceTypeEnum.INFOEXTRACT);
                                CommonUtil.doCallBack((DynamicObject)historyObj);
                                continue;
                            }
                            this.logger.error("\u672a\u77e5\u5f02\u5e38\uff0c\u4efb\u52a1id:{}", (Object)taskId);
                            throw new KDBizException("\u672a\u77e5\u56de\u8c03\u4fe1\u606f,\u8bf7\u68c0\u67e5\u3002");
                        }
                        this.logger.info("\u8bf7\u6c42aicc\u8fd4\u56de\u5f02\u5e38\uff0cerrorcode:{},message:{}", (Object)errorCode, (Object)message);
                        if (errorCode.equals("aicc.100007") && (message.contains("Connection reset") || message.contains("Read timed out"))) {
                            this.reRequestForLLM(llmHistoryObj);
                            continue;
                        }
                        throw new KDBizException(new ErrorCode(errorCode, message), new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u56de\u8c03\u7ed3\u679c\u5931\u8d25,data\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(data), (Object)e);
                if (historyObj != null) {
                    if (!historyObj.getBoolean("istest") && StringUtils.isNotEmpty(ieTaskId)) {
                        LicenseUtils.ensureCallNumToAlgoAsync((boolean)false, ieTaskId, (SourceTypeEnum)SourceTypeEnum.INFOEXTRACT);
                    }
                    historyObj.set("extractstatus", (Object)"error");
                    String message = e.getMessage();
                    if (StringUtils.isNotEmpty((CharSequence)message) && message.length() > 200) {
                        message = message.substring(0, 200);
                    }
                    historyObj.set("progressinfo", (Object)(StringUtils.isEmpty((CharSequence)message) ? ResManager.loadKDString((String)"\u56de\u8c03\u7ed3\u679c\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u95ee\u9898\u3002", (String)"OcrserviceImpl_301", (String)APPID, (Object[])new Object[0]) : message));
                    CommonUtil.doCallBack(historyObj);
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{historyObj});
                }
                if (llmHistoryObj == null) break block12;
                llmHistoryObj.set("extractstatus", (Object)"error");
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{llmHistoryObj});
            }
        }
    }

    private void reRequestForLLM(DynamicObject llmHistoryObj) {
        String iehistory = llmHistoryObj.getString("iehistory");
        DynamicObject historyObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(iehistory), (String)"cvp_ie_history");
        QFilter qFilter = new QFilter("iehistory", "=", (Object)iehistory);
        QFilter repealFilter = new QFilter("requesttask", "=", (Object)false);
        DynamicObject[] llmHisObjList = BusinessDataServiceHelper.load((String)"cvp_ie_llm_history", (String)"id,extractstatus,requesttask", (QFilter[])new QFilter[]{qFilter, repealFilter});
        if (llmHisObjList != null && llmHisObjList.length >= 2) {
            throw new KDBizException(OcrCommon.ResCode.repeal_times_out(), new Object[0]);
        }
        HashMap<String, String> varParams = new HashMap<String, String>(10);
        DynamicObject iemould = llmHistoryObj.getDynamicObject("ieplan");
        Object pkValue = iemould.getPkValue();
        DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cvp_ie_mouldplan", (String)"id,number,docdescrip,llmentryentity,llmentryentity.llmtabnum,llmentryentity.llmextractnum,llmentryentity.llmtabname,llmentryentity.llmextractfield,llmentryentity.llmfieldtype,llmentryentity.llmexdescription,llmentryentity.llmoutput");
        varParams.put("docWord", historyObj.getString("docstr_tag"));
        varParams.put("docDescription", planObj.getString("docdescrip"));
        varParams.put("fieldParam", CommonUtil.getFieldParam((DynamicObject)planObj));
        this.logger.info("aicc\u56de\u8c03http\u8d85\u65f6\u6216\u91cd\u7f6e\uff0c\u91cd\u65b0\u521b\u5efa\u65b0\u4efb\u52a1\u63d0\u53d6\u3002");
        String taskId = CommonUtil.createLLMTask(varParams);
        DynamicObject ieLLMhistoryObj = BusinessDataServiceHelper.newDynamicObject((String)"cvp_ie_llm_history");
        ieLLMhistoryObj.set("layoutdata_tag", (Object)llmHistoryObj.getString("layoutdata_tag"));
        ieLLMhistoryObj.set("pageinfo_tag", (Object)llmHistoryObj.getString("pageinfo_tag"));
        ieLLMhistoryObj.set("ieplan", pkValue);
        ieLLMhistoryObj.set("llmtaskid", (Object)taskId);
        ieLLMhistoryObj.set("iehistory", (Object)iehistory);
        ieLLMhistoryObj.set("id", (Object)DB.genLongId((String)"cvp_ie_llm_history"));
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ieLLMhistoryObj.getDataEntityType().getName(), (DynamicObject)ieLLMhistoryObj, null);
        ieLLMhistoryObj.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)ieLLMhistoryObj));
        ieLLMhistoryObj.set("createtime", (Object)new Date());
        ieLLMhistoryObj.set("modifytime", (Object)ieLLMhistoryObj.getDate("createtime"));
        ieLLMhistoryObj.set("extractstatus", (Object)"running");
        ieLLMhistoryObj.set("firstextract", (Object)true);
        ieLLMhistoryObj.set("requesttask", (Object)true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ieLLMhistoryObj});
        llmHistoryObj.set("requesttask", (Object)false);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{llmHistoryObj});
        historyObj.set("llmtaskid", (Object)taskId);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{historyObj});
    }

    private String getResult(String result) {
        String dataStr;
        JSONObject jsonObject;
        JSONArray choices;
        Object finish_reason;
        if (result.startsWith("data:") && ((finish_reason = ((JSONObject)(choices = (jsonObject = JSON.parseObject((String)(dataStr = result.substring(result.indexOf("data:") + 5)))).getJSONArray("choices")).get(0)).get((Object)"finish_reason")) == null || finish_reason.equals("stop"))) {
            Object o = ((JSONObject)((JSONObject)choices.get(0)).get((Object)"delta")).get((Object)"content");
            if (o != null) {
                return o.toString();
            }
            return "";
        }
        throw new KDBizException(new ErrorCode("405001", "\u5927\u6a21\u578b\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5ai\u80fd\u529b\u4e2d\u5fc3\u8c03\u7528\u7ed3\u679c\u3002"), new Object[0]);
    }

    private void doAfterHandler(String result, DynamicObject llmHistoryObj, DynamicObject ieHistory) {
        this.logger.info("\u7ed3\u679c\uff1a{}", (Object)result);
        JSONObject jsonResult = this.beforeParse(result);
        jsonResult = this.preHandleResult(jsonResult);
        DynamicObject ieplan = llmHistoryObj.getDynamicObject("ieplan");
        DynamicObject iePlanObj = BusinessDataServiceHelper.loadSingle((Object)ieplan.getPkValue(), (String)"cvp_ie_mouldplan", (String)"id,number,businessconfig,usellmextract,llmentryentity,llmentryentity.llmtabnum,llmentryentity.seq,llmentryentity.llmextractnum,llmentryentity.llmtabname,llmentryentity.llmextractfield,llmentryentity.llmfieldtype,llmentryentity.llmexdescription,llmentryentity.llmoutput");
        if (iePlanObj != null) {
            DynamicObjectCollection llmObjCol = iePlanObj.getDynamicObjectCollection("llmentryentity");
            boolean firstextract = llmHistoryObj.getBoolean("firstextract");
            this.logger.info("\u662f\u5426\u7b2c\u4e00\u6b21\u63d0\u53d6\uff1a{}", (Object)firstextract);
            if (llmObjCol != null && !llmObjCol.isEmpty()) {
                Map<String, List<GeneralIEResult.Dict>> llmTieInfo;
                String newLLMTaskId = null;
                List<DynamicObject> llmCommonFieldsList = llmObjCol.stream().filter(obj -> StringUtils.isEmpty((CharSequence)obj.getString("llmtabname"))).collect(Collectors.toList());
                List<DynamicObject> llmTableFieldsList = llmObjCol.stream().filter(obj -> StringUtils.isNotEmpty((CharSequence)obj.getString("llmtabname"))).collect(Collectors.toList());
                IeLLMExtractResultVO ieLLMExtractResultVO = new IeLLMExtractResultVO();
                if (firstextract) {
                    this.logger.info("\u7b2c\u4e00\u6b21\u5927\u6a21\u578b\u63d0\u53d6\uff0c\u68c0\u67e5\u662f\u5426\u9700\u8981\u518d\u6b21\u63d0\u53d6");
                    newLLMTaskId = this.needReExtractLLM(llmCommonFieldsList, jsonResult, ieHistory);
                    this.logger.info("\u4e8c\u6b21\u63d0\u53d6\u4efb\u52a1id:{}", (Object)newLLMTaskId);
                }
                if (!llmCommonFieldsList.isEmpty() && !(llmTieInfo = this.buildCommonFields(llmCommonFieldsList, jsonResult, firstextract)).isEmpty()) {
                    ieLLMExtractResultVO.setLlmInfo(llmTieInfo);
                }
                if (!firstextract) {
                    this.addAllLLMResult(ieLLMExtractResultVO, ieHistory.getPkValue().toString());
                } else if (!llmTableFieldsList.isEmpty()) {
                    Map<String, List<Map<String, GeneralIEResult.Dict>>> llmTieTableInfo = this.buildTableFields(llmTableFieldsList, jsonResult);
                    if (llmTieTableInfo != null) {
                        this.logger.info("\u83b7\u53d6\u5230\u7684\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(llmTieTableInfo));
                    }
                    ieLLMExtractResultVO.setLlmTableInfo(llmTieTableInfo);
                }
                llmHistoryObj.set("llmresult_tag", (Object)JSON.toJSONString((Object)ieLLMExtractResultVO));
                llmHistoryObj.set("extractstatus", (Object)"success");
                llmHistoryObj.set("modifytime", (Object)new Date());
                SaveServiceHelper.update((DynamicObject)llmHistoryObj);
                if (StringUtils.isNotEmpty((CharSequence)newLLMTaskId)) {
                    this.logger.info("\u66f4\u65b0\u4e8c\u6b21\u63d0\u53d6\u4efb\u52a1id");
                    ieHistory.set("llmtaskid", (Object)newLLMTaskId);
                } else {
                    this.logger.info("\u66f4\u65b0\u6700\u540e\u7ed3\u679c");
                    ieHistory.set("llmtaskid", (Object)llmHistoryObj.getString("llmtaskid"));
                    DynamicObject lastIeHistory = BusinessDataServiceHelper.loadSingle((Object)ieHistory.getPkValue(), (String)"cvp_ie_history");
                    String extractStatus = lastIeHistory.getString("extractstatus");
                    if (!Arrays.asList("success", "error", "cancel").contains(extractStatus)) {
                        boolean ieResult = "extract_suc".equals(extractStatus);
                        if (ieResult) {
                            ieHistory.set("extractstatus", (Object)"success");
                            ieHistory.set("progressinfo", (Object)ResManager.loadKDString((String)"\u63d0\u53d6\u5b8c\u6210", (String)"OcrServiceImpl_010", (String)"ai-cvp-common", (Object[])new Object[0]));
                        } else {
                            ieHistory.set("extractstatus", (Object)"llm_suc");
                            ieHistory.set("progressinfo", (Object)ResManager.loadKDString((String)"\u5927\u6a21\u578b\u63d0\u53d6\u5b8c\u6210", (String)"OcrServiceImpl_011", (String)"ai-cvp-common", (Object[])new Object[0]));
                        }
                    }
                    this.logger.info("\u4efb\u52a1\u63d0\u53d6\u72b6\u6001:{}", (Object)ieHistory.getString("extractstatus"));
                }
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{ieHistory});
            }
        }
    }

    private JSONObject preHandleResult(JSONObject jsonResult) {
        JSONObject resultObj = null;
        if (jsonResult != null && !jsonResult.isEmpty()) {
            resultObj = new JSONObject(jsonResult.size());
            for (Map.Entry entry : jsonResult.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                String newKey = this.matchBraceAndBlankStrForKey(key);
                Object newValue = value;
                if (value instanceof JSONObject) {
                    newValue = this.preHandleResult((JSONObject)value);
                } else if (value instanceof JSONArray) {
                    JSONArray jsonArray = new JSONArray(((JSONArray)value).size());
                    for (Object o : (JSONArray)value) {
                        if (!(o instanceof JSONObject)) continue;
                        jsonArray.add((Object)this.preHandleResult((JSONObject)o));
                    }
                    newValue = jsonArray;
                }
                resultObj.put(newKey, newValue);
            }
        }
        this.logger.info("\u5904\u7406\u540e\u7684\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(resultObj));
        return resultObj;
    }

    private String matchBraceAndBlankStrForKey(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            str = str.trim();
            String braceRegex = "^\\{.*\\}$";
            Matcher matcher = Pattern.compile(braceRegex).matcher(str);
            String newKey = "";
            if (matcher.find()) {
                String match = matcher.group();
                this.logger.info("\u6b63\u5219\u8c03\u6574\u63d0\u53d6key\uff0c\u5339\u914d\u5230\uff1a{}", (Object)match);
                newKey = match.substring(1, match.length() - 1);
            } else {
                newKey = str;
            }
            if (StringUtils.isNotEmpty((CharSequence)newKey) && newKey.contains(" ")) {
                newKey = newKey.replace(" ", "");
            }
            return newKey;
        }
        return "";
    }

    private JSONObject beforeParse(String result) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                if (!result.startsWith("{")) {
                    result = result.substring(result.indexOf("{"));
                }
                if (!result.endsWith("}")) {
                    result = result.substring(0, result.lastIndexOf("}") + 1);
                }
                result = this.replaceNotFoundForTable(result);
                return JSON.parseObject((String)result);
            }
            throw new KDBizException(new ErrorCode("403002", ResManager.loadKDString((String)"\u5927\u6a21\u578b\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6e05\u7406\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_302", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
        catch (JSONException ex) {
            throw new KDBizException(new ErrorCode("403002", ResManager.loadKDString((String)"\u5927\u6a21\u578b\u8fd4\u56de\u7684\u7ed3\u679c\u4e0d\u662f\u9700\u8981\u7684json\u7ed3\u6784\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_300", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("403002", ResManager.loadKDString((String)"\u5927\u6a21\u578b\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_301", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
    }

    private String replaceNotFoundForTable(String result) {
        String regex = "\"\u8868\u683c.*[0-9]+.*\u5b57\u6bb5\":[^\\[{]*not found";
        Matcher matcher = Pattern.compile(regex).matcher(result);
        String str = "";
        String resStr = "";
        while (matcher.find()) {
            str = matcher.group();
            this.logger.info("\u6b63\u5219\u524d\u7f6e\u5904\u7406\uff0c\u5339\u914d\u5230\uff1a{}", (Object)str);
            if (!str.contains(LLM_RESULT_NOT_FOUND)) continue;
            resStr = str.replace(LLM_RESULT_NOT_FOUND, "[]");
            result = result.replace(str, resStr);
        }
        return result;
    }

    private void addAllLLMResult(IeLLMExtractResultVO ieLLMExtractResultVO, String ieHistoryId) {
        List firstObjList;
        QFilter qFilter = new QFilter("iehistory", "=", (Object)ieHistoryId);
        DynamicObject[] ieLLMHistorys = BusinessDataServiceHelper.load((String)"cvp_ie_llm_history", (String)"id,llmresult_tag,iehistory,firstextract", (QFilter[])new QFilter[]{qFilter});
        if (ieLLMHistorys != null && ieLLMHistorys.length > 0 && !(firstObjList = Arrays.stream(ieLLMHistorys).filter(history -> history.getBoolean("firstextract")).collect(Collectors.toList())).isEmpty()) {
            String llmresult = ((DynamicObject)firstObjList.get(0)).getString("llmresult_tag");
            IeLLMExtractResultVO oldVO = (IeLLMExtractResultVO)JSON.parseObject((String)llmresult, IeLLMExtractResultVO.class);
            HashMap map = new HashMap(10);
            if (oldVO != null) {
                Map llmTieInfo = oldVO.getLlmInfo();
                map.putAll(llmTieInfo);
                this.logger.info("\u7b2c\u4e00\u6b21\u63d0\u53d6\u5b57\u6bb5\u6570\u91cf\uff1a{}", (Object)map.size());
                if (ieLLMExtractResultVO.getLlmInfo() != null) {
                    map.putAll(ieLLMExtractResultVO.getLlmInfo());
                }
                this.logger.info("\u5408\u5e76\u540e\u6570\u91cf\uff1a{}", (Object)map.size());
                Map llmTableInfo = oldVO.getLlmTableInfo();
                ieLLMExtractResultVO.setLlmTableInfo(llmTableInfo);
            } else {
                Map llmInfo = ieLLMExtractResultVO.getLlmInfo();
                map.putAll(llmInfo);
                ieLLMExtractResultVO.setLlmTableInfo(new HashMap(1));
            }
            ieLLMExtractResultVO.setLlmInfo(map);
        }
    }

    private String needReExtractLLM(List<DynamicObject> llmCommonFieldsList, JSONObject jsonResult, DynamicObject ieHistoryObj) {
        this.logger.info("\u662f\u5426\u9700\u8981\u518d\u6b21\u63d0\u53d6\u3002\u3002\u3002");
        if (llmCommonFieldsList != null && !llmCommonFieldsList.isEmpty() && jsonResult != null) {
            String docstr;
            String commonStr;
            Map<String, String> modelMap;
            Object commonMapObj = jsonResult.get((Object)"\u975e\u8868\u683c\u5b57\u6bb5");
            if (commonMapObj == null) {
                throw new KDBizException(new ErrorCode("403002", "\u5927\u6a21\u578b\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff0c\u63d0\u53d6\u5931\u8d25\u3002"), new Object[0]);
            }
            Map resultMap = (Map)commonMapObj;
            ArrayList<DynamicObject> needReExtractList = new ArrayList<DynamicObject>(16);
            for (DynamicObject obj : llmCommonFieldsList) {
                String fName = obj.getString("llmextractfield");
                if (resultMap.containsKey(fName)) continue;
                needReExtractList.add(obj);
            }
            if (!needReExtractList.isEmpty() && !(modelMap = this.getLLMModelAndPrompt("\u6211\u521a\u521a\u7528\u63d0\u793a\u8bcd\u505a\u4e86\u6587\u672c\u4fe1\u606f\u63d0\u53d6\uff0c\u4f46\u662f\u6709\u51e0\u4e2a\u5b57\u6bb5\u60a8\u6ca1\u6709\u63d0\u53d6\u51fa\u6765\u6216\u63d0\u53d6\u9519\u8bef\uff0c\u8bf7\u614e\u91cd\u601d\u8003\uff0c\u91cd\u65b0\u5e2e\u6211\u6309\u7167\u89c4\u5b9a\u683c\u5f0f\u6309\u8981\u6c42\u628a\u4ee5\u4e0b\u51e0\u4e2a\u5b57\u6bb5\u63d0\u53d6\u51fa\u6765\uff0c\u8f93\u51fa\u683c\u5f0f\u4e3a\u6807\u51c6json\uff1a\n%s\n\u8f93\u51fa\u8981\u6c42\uff1a\n1.\u7528\u6807\u51c6\u7684json\u8f93\u51fa\n2.json\u91cc\u7684\u975e\u8868\u683c\u5b57\u6bb5\u4e2d\u7684key\u4e3a\uff1a{\u5b57\u6bb51\u540d\u79f0}\u3001{\u5b57\u6bb52\u540d\u79f0}\u3001{\u5b57\u6bb5n\u540d\u79f0}\n3.\u6bcf\u4e2akey\u5bf9\u5e94\u7684value\u503c\u8bf7\u60a8\u6839\u636e\u4e0a\u6587\u63d0\u5230\u7684\u6bcf\u4e2a\u5b57\u6bb5\u7684\u201c\u63cf\u8ff0\u4e0e\u63d0\u53d6\u8981\u6c42\u201d\u603b\u7ed3\u5e76\u6309\u7167\u6bcf\u4e2a\u5b57\u6bb5\u201c\u8f93\u51fa\u7ed3\u679c\u8981\u6c42\u201d\u4e2d\u7684\u8981\u6c42\u8f93\u51fa\uff0c\u5982\u679c\u6709\u7684key\u6309\u7167\u8981\u6c42\u6ca1\u6709\u63d0\u53d6\u51favalue\u503c\uff0c\u5219\u6b64key\u5bf9\u5e94\u7684value\u8f93\u51fa\"not found\"\u3002\n\u8f93\u51fa\u7ed3\u679c\u793a\u4f8b:\n\n{\n\"\u975e\u8868\u683c\u5b57\u6bb5\": {\n\"\u5546\u54c1\u540d\u79f0\": \"xxxxx\",\n\"\u7532\u65b9\": \"xx\"\n},\n}\n\u62c6\u5206\u597d\u7684\u6587\u6863\u7247\u6bb5\uff1a\n%s", commonStr = CommonUtil.buildCommonParams(needReExtractList), docstr = ieHistoryObj.getString("docstr_tag"))).isEmpty()) {
                this.logger.info("\u5f00\u59cb\u521b\u5efa\u4e8c\u6b21\u63d0\u53d6\u4efb\u52a1");
                String llmNewTaskId = this.createLLMTask(modelMap);
                this.createLLMHistory(ieHistoryObj, llmNewTaskId);
                return llmNewTaskId;
            }
        }
        return null;
    }

    private void createLLMHistory(DynamicObject ieHistory, String llmTaskId) {
        Object iePlanPkId = ieHistory.getDynamicObject("iemould").getPkValue();
        DynamicObject ieLLMhistoryObj = BusinessDataServiceHelper.newDynamicObject((String)"cvp_ie_llm_history");
        ieLLMhistoryObj.set("ieplan", iePlanPkId);
        ieLLMhistoryObj.set("llmtaskid", (Object)llmTaskId);
        ieLLMhistoryObj.set("iehistory", ieHistory.getPkValue());
        ieLLMhistoryObj.set("id", (Object)DB.genLongId((String)"cvp_ie_llm_history"));
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ieLLMhistoryObj.getDataEntityType().getName(), (DynamicObject)ieLLMhistoryObj, null);
        ieLLMhistoryObj.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)ieLLMhistoryObj));
        ieLLMhistoryObj.set("createtime", (Object)new Date());
        ieLLMhistoryObj.set("modifytime", (Object)ieLLMhistoryObj.getDate("createtime"));
        ieLLMhistoryObj.set("extractstatus", (Object)"running");
        ieLLMhistoryObj.set("firstextract", (Object)false);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ieLLMhistoryObj});
    }

    private String createLLMTask(Map<String, String> modelMap) {
        String prompt = modelMap.get("prompt");
        String serviceNumber = modelMap.get("service");
        Map params = CommonUtil.buildReqParam((String)prompt);
        Map callbackMap = CommonUtil.buildCallBackParam();
        Object[] objects = new Object[]{callbackMap, serviceNumber, JSON.toJSONString((Object)params)};
        this.logger.info("aicc\u518d\u6b21\u8c03\u7528\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)objects));
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"asyncService", (Object[])objects);
        if (resultMap != null) {
            if ("0".equals(resultMap.get("errorCode"))) {
                return (String)resultMap.get("id");
            }
            String errorCode = (String)resultMap.get("errorCode");
            String message = (String)resultMap.get("message");
            this.logger.error("error:{},message:{}", (Object)errorCode, (Object)message);
            throw new KDBizException(new ErrorCode(errorCode, message), new Object[0]);
        }
        this.logger.error("\u8c03\u7528aicc\u521b\u5efa\u5927\u6a21\u578b\u518d\u63d0\u53d6\u4efb\u52a1\u5931\u8d25\u3002");
        throw new KDBizException(new ErrorCode("403001", "\u5927\u6a21\u578b\u4efb\u52a1\u521b\u5efa\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002"), new Object[0]);
    }

    private Map<String, String> getLLMModelAndPrompt(String promptModel, String commonStr, String docstr) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        String prompt = String.format(promptModel, commonStr, docstr);
        int length = prompt.length();
        if (length <= 25000) {
            map.put("prompt", prompt);
            map.put("service", "DOUBAO_PRO_32K");
        } else if (length < 110000) {
            map.put("prompt", prompt);
            map.put("service", "DOUBAO_PRO_128K");
        } else {
            this.logger.info("\u957f\u5ea6\u8d85\u8fc7110k,\u622a\u53d6\u5f85\u63d0\u53d6\u5185\u5bb9");
            String format = String.format(promptModel, commonStr, "");
            docstr = docstr.substring(0, 110000 - format.length());
            prompt = String.format(promptModel, commonStr, docstr);
            map.put("prompt", prompt);
            map.put("service", "DOUBAO_PRO_128K");
        }
        return map;
    }

    private Map<String, List<Map<String, GeneralIEResult.Dict>>> buildTableFields(List<DynamicObject> llmTableFieldsList, JSONObject jsonResult) {
        HashMap<String, List<Map<String, GeneralIEResult.Dict>>> map = new HashMap<String, List<Map<String, GeneralIEResult.Dict>>>(10);
        if (llmTableFieldsList != null && !llmTableFieldsList.isEmpty() && jsonResult != null) {
            Map<String, List<DynamicObject>> tables = this.getTargetTables(llmTableFieldsList);
            JSONObject resultObj = jsonResult.getJSONObject("\u8868\u683c\u5b57\u6bb5");
            this.logger.info("\u63d0\u53d6\u5230\u7684\u8868\u683c\u540d\u79f0:{}", (Object)(resultObj != null ? JSON.toJSONString((Object)resultObj.keySet()) : ""));
            for (Map.Entry<String, List<DynamicObject>> entry : tables.entrySet()) {
                String tableKey = entry.getKey();
                this.logger.info("tableKey:{}", (Object)tableKey);
                List<DynamicObject> value = entry.getValue();
                HashMap<String, DynamicObject> fMap = new HashMap<String, DynamicObject>(value.size());
                for (DynamicObject v : value) {
                    String llmextractfield = v.getString("llmextractfield");
                    fMap.put(llmextractfield, v);
                }
                String tableNum = value.get(0).getString("llmtabnum");
                ArrayList list = new ArrayList(16);
                if (resultObj != null && resultObj.containsKey((Object)tableKey)) {
                    Object dataObj = resultObj.get((Object)tableKey);
                    List datas = new ArrayList(16);
                    if (dataObj instanceof List) {
                        datas = (List)dataObj;
                    }
                    if (!datas.isEmpty()) {
                        for (Map data : datas) {
                            HashMap<String, GeneralIEResult.Dict> colMaps = new HashMap<String, GeneralIEResult.Dict>(10);
                            ArrayList<String> existKeys = new ArrayList<String>(16);
                            for (Map.Entry dataEntry : data.entrySet()) {
                                String fkey = (String)dataEntry.getKey();
                                Object fvalue = dataEntry.getValue();
                                if (!fMap.containsKey(fkey)) continue;
                                existKeys.add(fkey);
                                DynamicObject fieldObj = (DynamicObject)fMap.get(fkey);
                                String llmExtractNum = fieldObj.getString("llmextractnum");
                                GeneralIEResult.Dict dict = new GeneralIEResult.Dict();
                                dict.setText(LLM_RESULT_NOT_FOUND.equals(fvalue) ? "" : fvalue + "");
                                colMaps.put(llmExtractNum, dict);
                            }
                            Map<String, GeneralIEResult.Dict> missKeyMap = this.patchMissKey(fMap, existKeys);
                            if (!missKeyMap.isEmpty()) {
                                colMaps.putAll(missKeyMap);
                            }
                            list.add(colMaps);
                        }
                    }
                }
                map.put(tableNum, list);
            }
        }
        return map;
    }

    private Map<String, GeneralIEResult.Dict> patchMissKey(Map<String, DynamicObject> fMap, List<String> existKeys) {
        HashMap<String, GeneralIEResult.Dict> map = new HashMap<String, GeneralIEResult.Dict>(10);
        Set<String> keys = fMap.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        keyList.removeAll(existKeys);
        if (!keyList.isEmpty()) {
            for (String key : keyList) {
                DynamicObject fieldObj = fMap.get(key);
                String llmExtractNum = fieldObj.getString("llmextractnum");
                GeneralIEResult.Dict dict = new GeneralIEResult.Dict();
                dict.setText("");
                map.put(llmExtractNum, dict);
            }
        }
        return map;
    }

    private Map<String, List<DynamicObject>> getTargetTables(List<DynamicObject> llmTableFieldsList) {
        return llmTableFieldsList.stream().collect(Collectors.groupingBy(entry -> entry.getString("llmtabname").trim().replace(" ", ""), Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collector.Characteristics.CONCURRENT))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ArrayList)entry.getValue()).stream().sorted(Comparator.comparing(obj -> obj.getInt("seq"))).collect(Collectors.toList())));
    }

    private Map<String, List<GeneralIEResult.Dict>> buildCommonFields(List<DynamicObject> llmCommonFieldsList, JSONObject jsonResult, boolean firstExtract) {
        HashMap<String, List<GeneralIEResult.Dict>> map = new HashMap<String, List<GeneralIEResult.Dict>>(10);
        if (llmCommonFieldsList != null && !llmCommonFieldsList.isEmpty() && jsonResult != null) {
            Map resultMap = (Map)jsonResult.get((Object)"\u975e\u8868\u683c\u5b57\u6bb5");
            for (DynamicObject obj : llmCommonFieldsList) {
                String fName = obj.getString("llmextractfield");
                String llmextractnum = obj.getString("llmextractnum");
                ArrayList<GeneralIEResult.Dict> dicts = new ArrayList<GeneralIEResult.Dict>(16);
                if (resultMap.containsKey(fName)) {
                    Object value = resultMap.get(fName);
                    GeneralIEResult.Dict dict = new GeneralIEResult.Dict();
                    dict.setText(LLM_RESULT_NOT_FOUND.equals(value) ? "" : value + "");
                    dicts.add(dict);
                }
                if (!firstExtract && dicts.isEmpty()) continue;
                map.put(llmextractnum, dicts);
            }
        }
        return map;
    }

    private String getLLMResult(String taskId) {
        String cacheKey = "cvp_llm_" + taskId;
        this.logger.info("\u83b7\u53d6\u7f13\u5b58key:{}", (Object)cacheKey);
        String result = (String)this.cache.get("cvp_llm_" + taskId);
        this.logger.info("\u7f13\u5b58\u5185\u5bb9\uff1a{}", (Object)result);
        return StringUtils.isEmpty((CharSequence)result) ? "" : result;
    }

    private void setLLMResult(String taskId, String result) {
        String cacheKey = "cvp_llm_" + taskId;
        this.logger.info("\u5b58\u5165\u7f13\u5b58key:{}", (Object)cacheKey);
        this.cache.put(cacheKey, (Object)result, 86400);
    }

    private void removeLLMResult(String taskId) {
        String cacheKey = "cvp_llm_" + taskId;
        this.logger.info("\u6e05\u7406\u7f13\u5b58key:{}", (Object)cacheKey);
        this.cache.remove(cacheKey);
    }

    private CtieResultVO doQueyCtieResult(String taskId) {
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ctie_history", (String)"id,docname,docpath,extractstatus,taskid,progressinfo,layoutdata_tag,pageinfo_tag,docwithsiteandpage,tableoutputtype", (QFilter[])new QFilter[]{qFilter});
        if (taskObj == null) {
            throw new KDBizException(new ErrorCode("40002", ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_210", (String)APPID, (Object[])new Object[0])), new Object[0]);
        }
        String extractstatus = taskObj.getString("extractstatus");
        String progressinfo = taskObj.getString("progressinfo");
        String layoutdata = taskObj.getString("layoutdata_tag");
        String pageinfo = taskObj.getString("pageinfo_tag");
        String tableOutputType = taskObj.getString("tableoutputtype");
        String docName = taskObj.getString("docname");
        boolean docWithSiteAndPage = taskObj.getBoolean("docwithsiteandpage");
        String docType = "";
        this.logger.info("docName:{}", (Object)docName);
        if (StringUtils.isNotEmpty((CharSequence)docName)) {
            docType = docName.substring(docName.lastIndexOf(".") + 1);
            this.logger.info("docType:{}", (Object)docType);
        }
        CtieResultVO ctieResultVO = new CtieResultVO();
        ctieResultVO.setTaskId(taskId);
        ctieResultVO.setStatus(extractstatus);
        ctieResultVO.setProgress(progressinfo);
        if (StringUtils.isNotEmpty((CharSequence)layoutdata) && !"null".equals(layoutdata)) {
            this.setTableInfoWithMarkdownStr(layoutdata, tableOutputType, docType, docWithSiteAndPage, ctieResultVO);
        }
        if (StringUtils.isNotEmpty((CharSequence)pageinfo) && !"null".equals(pageinfo)) {
            ctieResultVO.setPageInfo(JSON.parseArray((String)pageinfo, ComplexPageInfo.class));
        }
        return ctieResultVO;
    }

    private void setTableInfoWithMarkdownStr(String layoutdata, String tableOutputType, String docType, boolean docWithSiteAndPage, CtieResultVO ctieResultVO) {
        List docTotalRecLayoutDataVOS;
        String markdownContent;
        if (ctieResultVO == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a\uff0c\u7cfb\u7edf\u5f02\u5e38", (String)"OcrServiceImpl_201", (String)APPID, (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)layoutdata)) {
            this.logger.info("layoutdata\u4e3a\u7a7a\u3002\u3002\u3002");
            return;
        }
        String[] split = tableOutputType.split(",");
        if (split.length > 0) {
            tableOutputType = split[0];
        }
        if (StringUtils.isNotEmpty((CharSequence)(markdownContent = CommonUtil.getMarkDownContentAndUpdateVO((List)(docTotalRecLayoutDataVOS = JSON.parseArray((String)layoutdata, DocTotalRecLayoutDataVO.class)), (String)docType, (boolean)docWithSiteAndPage, (String)tableOutputType)))) {
            ctieResultVO.setDocContent(markdownContent);
        } else {
            ctieResultVO.setDocContent("");
        }
        ctieResultVO.setLayoutData(docTotalRecLayoutDataVOS);
    }

    private AlgoResultData getResultByAlgoAPI(String docContent, List<RedClauseExtractVO> terms, String requestId) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)docContent) && terms != null && !terms.isEmpty()) {
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            map.put("doc_text", docContent);
            map.put("terms", terms);
            StringEntity entity = new StringEntity(JSON.toJSONString(map), ContentType.APPLICATION_JSON);
            entity.setContentEncoding("UTF-8");
            long startReqTime = System.currentTimeMillis();
            String resultStr = OcrHttpClientUtils.kdCloudHttpClientTraceIdPost((String)"/ieservice/nlp_service/red_line_differ", (HttpEntity)entity, (String)requestId);
            long endReqTime = System.currentTimeMillis();
            this.logger.info(String.format("\u8bf7\u6c42\u7ea2\u7ebf\u6761\u6b3e\u53d8\u66f4\u63a5\u53e3\u7528\u65f6:%s,\u7ed3\u679c\u4e3a\uff1a%s", endReqTime - startReqTime, resultStr));
            return (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
        }
        return new AlgoResultData(requestId, 40000, SYSTEM_ERROR_ALERT_MESSAGE);
    }

    private String getWordContent(String tempPath, String suffixStr) throws IOException {
        StringBuilder docContent;
        block49: {
            docContent = new StringBuilder();
            try (InputStream fileIn = CvpFileServiceUtils.getFileIn((StorageTypeEnum)StorageTypeEnum.TMP, (String)tempPath);){
                if ("doc".equalsIgnoreCase(suffixStr)) {
                    this.logger.info("doc\u683c\u5f0f\u6587\u4ef6\u6682\u4e0d\u652f\u6301\u3002");
                    throw new KDBizException(new ErrorCode("40000", ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301doc\u683c\u5f0f\u6587\u4ef6\u8bf7\u6c42\u7ea2\u7ebf\u6761\u6b3e\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_100", (String)APPID, (Object[])new Object[0])), new Object[0]);
                }
                if ("docx".equalsIgnoreCase(suffixStr)) {
                    int pIndex = 0;
                    int tableIndex = 0;
                    try (OPCPackage opcPackage = OPCPackage.open((InputStream)fileIn);
                         XWPFDocument xwpfDocument = new XWPFDocument(opcPackage);){
                        List tables = xwpfDocument.getTables();
                        List paragraphs = xwpfDocument.getParagraphs();
                        List bodyElements = xwpfDocument.getBodyElements();
                        for (int docIndex = 0; docIndex < bodyElements.size(); ++docIndex) {
                            String lockText;
                            IBodyElement iBodyElement = (IBodyElement)bodyElements.get(docIndex);
                            if (iBodyElement.getElementType() == BodyElementType.PARAGRAPH) {
                                XWPFParagraph paragraph = (XWPFParagraph)paragraphs.get(pIndex);
                                String text = this.getTextByParagraph(paragraph);
                                if (StringUtils.isNotEmpty((CharSequence)text)) {
                                    docContent.append(text);
                                }
                                docContent.append('\n');
                                ++pIndex;
                                continue;
                            }
                            if (iBodyElement.getElementType() == BodyElementType.TABLE) {
                                List rows = ((XWPFTable)tables.get(tableIndex)).getRows();
                                ++tableIndex;
                                for (int i = 0; i < rows.size(); ++i) {
                                    List tableCells = ((XWPFTableRow)rows.get(i)).getTableCells();
                                    for (int j = 0; j < tableCells.size(); ++j) {
                                        List tableParagraphs = ((XWPFTableCell)tableCells.get(j)).getParagraphs();
                                        if (tableParagraphs != null && !tableParagraphs.isEmpty()) {
                                            for (int t = 0; t < tableParagraphs.size(); ++t) {
                                                String textByParagraph = this.getTextByParagraph((XWPFParagraph)tableParagraphs.get(t));
                                                if (StringUtils.isNotEmpty((CharSequence)textByParagraph)) {
                                                    docContent.append(textByParagraph);
                                                }
                                                if (tableParagraphs.size() <= 1 || t == tableParagraphs.size() - 1) continue;
                                                docContent.append('\n');
                                            }
                                        }
                                        if (j == tableCells.size() - 1) continue;
                                        docContent.append(' ');
                                    }
                                    docContent.append('\n');
                                }
                                continue;
                            }
                            if (iBodyElement.getElementType() != BodyElementType.CONTENTCONTROL || !(iBodyElement instanceof XWPFSDT) || !StringUtils.isNotEmpty((CharSequence)(lockText = this.getLockedText((XWPFSDT)iBodyElement)))) continue;
                            docContent.append(lockText);
                            docContent.append('\n');
                        }
                        break block49;
                    }
                    catch (InvalidFormatException e) {
                        this.logger.error("\u6253\u5f00docx\u6587\u6863\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (Throwable)e);
                        throw new IOException(e.toString(), e);
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_030", (String)APPID, (Object[])new Object[0]));
            }
        }
        return docContent.toString();
    }

    private String getLockedText(XWPFSDT xwpfsdt) {
        ISDTContent content = xwpfsdt.getContent();
        if (content instanceof XWPFSDTContent) {
            XWPFSDTContent xwpfsdtContent = (XWPFSDTContent)content;
            try {
                Class<?> aClass = xwpfsdtContent.getClass();
                Field f = FieldUtils.getField(aClass, (String)"bodyElements", (boolean)true);
                Object o = f.get(xwpfsdtContent);
                if (o instanceof List) {
                    List o1 = (List)o;
                    for (ISDTContents isdtContents : o1) {
                        if (!(isdtContents instanceof XWPFParagraph)) continue;
                        return this.getTextByParagraph((XWPFParagraph)isdtContents);
                    }
                }
            }
            catch (IllegalAccessException e) {
                this.logger.error("\u53cd\u5c04\u83b7\u53d6word\u7ed3\u6784\u5931\u8d25\u3002", (Throwable)e);
            }
        }
        return null;
    }

    private String getTextByParagraph(XWPFParagraph paragraph) {
        List runs = paragraph.getIRuns();
        StringBuilder sb = new StringBuilder();
        for (IRunElement run : runs) {
            String text = "";
            if (run instanceof XWPFRun) {
                text = ((XWPFRun)run).getText(0);
            } else if (run instanceof XWPFSDT) {
                ISDTContent content = ((XWPFSDT)run).getContent();
                text = content.getText();
            }
            if (!StringUtils.isNotEmpty((CharSequence)text) || "null".equals(text)) continue;
            sb.append(text);
        }
        return sb.toString();
    }

    private void validParamForRedClause(String url, String terms) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_001", (String)APPID, (Object[])new Object[0]));
        }
        boolean exists = FileServiceFactory.getAttachmentFileService().exists(url);
        if (!exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\u3002", (String)"OcrServiceImpl_001", (String)APPID, (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)terms)) {
            throw new KDBizException(OcrCommon.ResCode.get_param_error(), new Object[0]);
        }
    }

    public String ocrImage(String businessObject, String templateNumber, String imageData, String invokeType) {
        return this.ocrImage(businessObject, templateNumber, imageData, invokeType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ocrImage(String businessObject, String templateNumber, String imageData, String invokeType, Map<String, String> bizParam) {
        AlgoResultData resultData;
        String traceId = UUID.randomUUID().toString();
        boolean hasRight = LicenseUtils.validApiPermission();
        if (!hasRight) {
            this.logger.error("\u7528\u6237\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002");
            AlgoResultData resultData2 = new AlgoResultData(traceId, 40012, ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u63a5\u53e3\u8c03\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002", (String)"OcrServiceImpl_101", (String)APPID, (Object[])new Object[0]));
            return SerializationUtils.toJsonString((Object)resultData2);
        }
        long beginServiceMillon = System.currentTimeMillis();
        if ("C".equals(invokeType)) {
            businessObject = "cvp_template";
        }
        if ((resultData = this.validParams(invokeType, businessObject, templateNumber, imageData)) == null) {
            long start;
            block56: {
                this.logger.info(String.format("base64\u56fe\u50cf\u5185\u5bb9\u524d\u90e8\u5206:%s", imageData.substring(0, 35)));
                String tempFileId = kd.bos.util.StringUtils.getEmpty();
                SourceTypeEnum sourceTypeEnum = SourceTypeEnum.PRESETTEMPLATE;
                int pageNum = 0;
                start = System.currentTimeMillis();
                try {
                    if (imageData.startsWith("data:image/png;base64,")) {
                        imageData = imageData.replaceAll("data:image/png;base64,", "");
                    } else if (imageData.startsWith("data:image/jpeg;base64,")) {
                        imageData = imageData.replaceAll("data:image/jpeg;base64,", "");
                    } else if (imageData.startsWith("data:application/pdf;base64,")) {
                        imageData = imageData.replaceAll("data:application/pdf;base64,", "");
                    } else if (imageData.contains(";base64,")) {
                        String notSuitStr = ResManager.loadKDString((String)"\u4f20\u9012\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301,\u8bf7\u68c0\u67e5\u4f20\u9012\u7684\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"OcrServiceImpl_003", (String)APPID, (Object[])new Object[0]);
                        String string = SerializationUtils.toJsonString((Object)new AlgoResultData(traceId, 40002, notSuitStr, null));
                        return string;
                    }
                    tempFileId = this.saveTempfile(imageData);
                    try {
                        CommonUtil.validFileType((String)tempFileId, (String)SUPPORTFILETYPES);
                    }
                    catch (KDBizException e) {
                        this.logger.error("\u6821\u9a8c\u5f02\u5e38\u5904\u7406\uff1a", (Throwable)e);
                        String message = e.getMessage();
                        message = StringUtils.isEmpty((CharSequence)message) ? "\u6587\u4ef6\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002" : message;
                        resultData = new AlgoResultData(traceId, 40002, message, null);
                        String string = SerializationUtils.toJsonString((Object)resultData);
                        LocalTempFileCache.remove((String)tempFileId);
                        return string;
                    }
                    this.logger.info(String.format("\u8c03\u7528API-distinguishOcrImage: traceId: %s ", traceId));
                    OcrHandleTypeEnum handleTypeEnum = OcrHandleTypeEnum.TYPE_PDF_FIRSTPAGE;
                    String paramKey = "imageData";
                    int requestType = 2;
                    switch (templateNumber) {
                        case "OPM-CertificateOfResignation": 
                        case "OPM-CertificateOfDegree": 
                        case "OPM-Diploma": 
                        case "OPM-DrivingLicenseFront": 
                        case "OPM-Passport": 
                        case "OPM-PaymentRecord": {
                            paramKey = "imageData";
                            requestType = 2;
                            break;
                        }
                        case "OPM-GeneralTablePreset": {
                            handleTypeEnum = OcrHandleTypeEnum.TYPE_PDF_ALLPAGES;
                            break;
                        }
                        case "OPM-GeneralTable": 
                        case "OPM-StatesmentRec": {
                            handleTypeEnum = OcrHandleTypeEnum.TYPE_PDF_ORIGIN;
                            break;
                        }
                        case "OPM-GeneralSpotting": {
                            paramKey = "ocrGeneral";
                            break;
                        }
                        case "OPM-BankReceipt": {
                            paramKey = "bankTicket";
                            handleTypeEnum = OcrHandleTypeEnum.TYPE_PDF_ORIGIN;
                            break;
                        }
                        case "OPM-Invoice": {
                            paramKey = "file";
                            break;
                        }
                        case "OPM-BankCard": {
                            paramKey = "bank";
                            break;
                        }
                        case "OPM-IdCardBack": {
                            paramKey = "FRONT";
                            break;
                        }
                        case "OPM-IDCardFront": {
                            paramKey = "BACK";
                            break;
                        }
                        default: {
                            sourceTypeEnum = SourceTypeEnum.SELFDESIGNTEMPLATE;
                            resultData = this.valiadCustomTemplate(templateNumber, traceId);
                            requestType = 1;
                            paramKey = "imageBase64";
                        }
                    }
                    if (resultData != null) break block56;
                    Map<String, Object> map = this.calculatePgNumAndType(tempFileId, handleTypeEnum);
                    if (!map.isEmpty()) {
                        pageNum = (Integer)map.get("pageNum");
                        handleTypeEnum = (OcrHandleTypeEnum)map.get("handleType");
                        if (pageNum < 1) {
                            throw new KDBizException(new ErrorCode(String.valueOf(40000), ERROR_TIPS), new Object[0]);
                        }
                    }
                    if (pageNum < 1) {
                        throw new KDBizException(new ErrorCode(String.valueOf(40000), ResManager.loadKDString((String)"\u8bb8\u53ef\u6d88\u8017\u6570\u91cf\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OcrServiceImpl_02", (String)APPID, (Object[])new Object[0])), new Object[0]);
                    }
                    boolean licenseCheckFlag = LicenseUtils.checkLicense((int)pageNum, (String)templateNumber, (String)traceId);
                    if (licenseCheckFlag) {
                        resultData = this.requestAlgoForResult(bizParam, imageData, tempFileId, paramKey, templateNumber, traceId, requestType, handleTypeEnum);
                        LicenseUtils.ensureCallNumToAlgo((resultData != null && resultData.getErrorCode() == 0 ? 1 : 0) != 0, (String)traceId, (SourceTypeEnum)sourceTypeEnum);
                        break block56;
                    }
                    throw new KDBizException(new ErrorCode(String.valueOf(40004), ResManager.loadKDString((String)"\u672a\u83b7\u5f97\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\uff0c\u8bf7\u5148\u8d2d\u4e70\u3002", (String)"OcrServiceImpl_03", (String)APPID, (Object[])new Object[0])), new Object[0]);
                }
                catch (KDBizException be) {
                    String message = be.getMessage();
                    ErrorCode errorCode = be.getErrorCode();
                    resultData = new AlgoResultData(traceId, errorCode != null && !StringUtils.isEmpty((CharSequence)errorCode.getCode()) ? Integer.parseInt(errorCode.getCode()) : 40000, message, null);
                    LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)traceId, (SourceTypeEnum)sourceTypeEnum);
                    this.logger.error(traceId + " traceId OCR - API \u6a21\u677f\u8bc6\u522b,\u4e1a\u52a1\u8c03\u7528distinguishOcrImage\u65b9\u6cd5\u5931\u8d25,\u6a21\u677f\u7f16\u7801: " + templateNumber + " \u64cd\u4f5c\u5f02\u5e38: " + message, (Throwable)be);
                }
                catch (Exception e) {
                    String message = ResManager.loadKDString((String)String.format("\u6a21\u7248\uff1a%s \u8bc6\u522b\u5f02\u5e38\uff0c%s \uff0c", templateNumber, e.getMessage()), (String)"OcrServiceImp_04", (String)APPID, (Object[])new Object[0]);
                    resultData = new AlgoResultData(traceId, 40000, message, null);
                    LicenseUtils.ensureCallNumToAlgo((boolean)false, (String)traceId, (SourceTypeEnum)sourceTypeEnum);
                    this.logger.error(traceId + " traceId OCR - API \u6a21\u677f\u8bc6\u522b,\u4e1a\u52a1\u8c03\u7528distinguishOcrImage\u65b9\u6cd5\u5931\u8d25,\u6a21\u677f\u7f16\u7801: " + templateNumber + " \u64cd\u4f5c\u5f02\u5e38: " + message, (Throwable)e);
                }
                finally {
                    LocalTempFileCache.remove((String)tempFileId);
                }
            }
            long end = System.currentTimeMillis();
            if ("OPM-GeneralTable".equals(templateNumber) || "OPM-StatesmentRec".equals(templateNumber)) {
                return SerializationUtils.toJsonString((Object)resultData);
            }
            if (resultData != null) {
                this.setApiInfo(businessObject, templateNumber, resultData, invokeType, end - start);
            } else {
                this.logger.error("\u8c03\u7528\u8fd4\u56de\u7684\u5bf9\u8c61\u4e3a\u7a7a\u3002\u3002\u3002key:resultData");
            }
        }
        this.logger.info(traceId + " traceId-\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u7ed3\u675f ");
        this.logger.info("\u7ed3\u675f\u8bf7\u6c42\u3002\u8017\u65f6\uff1a" + (System.currentTimeMillis() - beginServiceMillon));
        return SerializationUtils.toJsonString((Object)resultData);
    }

    private Map<String, Object> calculatePgNumAndType(String tempFileId, OcrHandleTypeEnum handleTypeEnum) throws IOException {
        int pageNum;
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        try (InputStream inputStream = LocalTempFileCache.getInputStream((String)tempFileId);){
            String result = StreamHandleUtils.validFileType((InputStream)inputStream, (String)"pdf");
            if (StringUtils.isEmpty((CharSequence)result)) {
                if (handleTypeEnum == OcrHandleTypeEnum.TYPE_PDF_ALLPAGES) {
                    pageNum = this.getPdfPage(tempFileId, inputStream);
                    if (pageNum < 1) {
                        this.logger.error("\u83b7\u53d6pdf\u9875\u7801\u6570\u5f02\u5e38\u3002");
                        throw new KDBizException(new ErrorCode(String.valueOf(40000), ERROR_TIPS), new Object[0]);
                    }
                    if (pageNum > Integer.parseInt(PDF_PAGENUM_MAX)) {
                        throw new KDBizException(new ErrorCode(String.valueOf(40002), ResManager.loadKDString((String)"\u6587\u4ef6\u9875\u6570\u8d85\u8fc7\u7cfb\u7edf\u9ed8\u8ba4\u7684\u6700\u5927\u503c", (String)"OcrServiceImpl_2", (String)APPID, (Object[])new Object[0]) + PDF_PAGENUM_MAX + ResManager.loadKDString((String)"\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u5c1d\u8bd5\u3002", (String)"OcrServiceImpl_3", (String)APPID, (Object[])new Object[0])), new Object[0]);
                    }
                    if (pageNum == 1) {
                        handleTypeEnum = OcrHandleTypeEnum.TYPE_PDF_FIRSTPAGE;
                    }
                } else {
                    pageNum = 1;
                }
            } else {
                pageNum = 1;
                handleTypeEnum = OcrHandleTypeEnum.TYPE_IMG;
            }
        }
        map.put("pageNum", pageNum);
        map.put("handleType", handleTypeEnum);
        return map;
    }

    private String saveTempfile(String imageData) throws IOException {
        try (ByteArrayInputStream inputStream = OcrControlUtils.getByteArrayInputStreamByBase64((String)imageData);){
            String string = LocalTempFileCache.saveToLocalTempPath((InputStream)inputStream);
            return string;
        }
    }

    private int getPdfPage(String tempfileId, InputStream inputStream) throws IOException {
        int total = PDFPageNumUtil.getPdfPageNumByBufferedArrNew((InputStream)inputStream);
        if (total < 1) {
            try (InputStream localTempinputStream = LocalTempFileCache.getInputStream((String)tempfileId);){
                total = CommonUtil.validOrGetPdfNum((InputStream)localTempinputStream);
            }
            this.logger.info("\u8bb0\u5f55\u4fee\u6b63\u4e4b\u540e\u7684pdf\u6587\u4ef6\u9875\u7801\u6570\uff1a" + total);
        }
        return total;
    }

    /*
     * Exception decompiling
     */
    private AlgoResultData requestAlgoForResult(Map<String, String> bizParam, String imageData, String tempFileId, String paramKey, String templateNumber, String traceId, int requestType, OcrHandleTypeEnum typeEnum) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlgoResultData handleAllPdf(InputStream inputStream, String paramKey, String templateNumber, int requestType, String traceId) throws Exception {
        List<String> pdfLocalIds = new ArrayList<String>(16);
        try {
            String tempfileId = templateNumber.concat(traceId);
            pdfLocalIds = OcrControlUtils.splitPdfNew((InputStream)inputStream, (String)tempfileId, (Integer)PDF_SPLIT_SIZE);
            AlgoResultData algoResultData = this.batchHandlerPdf(pdfLocalIds, paramKey, templateNumber, requestType, traceId);
            return algoResultData;
        }
        finally {
            this.batchRemoveLocalFile(pdfLocalIds);
        }
    }

    private List<HttpEntity> batchWrapRequestParam(List<String> imageDatas, String paramKey, String templateNumber) {
        ArrayList<HttpEntity> list = new ArrayList<HttpEntity>(imageDatas.size());
        for (String imageData : imageDatas) {
            list.add(this.setEntity(paramKey, imageData, templateNumber, null));
        }
        return list;
    }

    private void batchRemoveLocalFile(List<String> localDirs) {
        if (localDirs != null && !localDirs.isEmpty()) {
            LocalTempFileCache.batchRemove(localDirs);
        }
    }

    private AlgoResultData batchHandlerPdf(List<String> pdfLocalIds, String paramKey, String templateNumber, int requestType, String traceId) throws InterruptedException, ExecutionException {
        if (pdfLocalIds == null || pdfLocalIds.isEmpty()) {
            this.logger.error("\u83b7\u53d6\u8f6c\u6362\u548c\u538b\u7f29\u540e\u7684\u56fe\u7247\u96c6\u5408\u4e3a\u7a7a\u3002");
            return this.errorResult(traceId);
        }
        int size = pdfLocalIds.size();
        ArrayList<AlgoResultData> resultDataList = new ArrayList<AlgoResultData>(size);
        CountDownLatch cdl = new CountDownLatch(size);
        HashMap<String, Object> map = null;
        for (int i = 0; i < pdfLocalIds.size(); ++i) {
            map = new HashMap<String, Object>(10);
            String relateTraceId = UUID.randomUUID().toString().replace("-", "");
            map.put("splitNum", i);
            map.put("localId", pdfLocalIds.get(i));
            map.put("paramKey", paramKey);
            map.put("templateNumber", templateNumber);
            map.put("requestType", requestType);
            map.put("traceId", traceId);
            map.put("countDownLatch", cdl);
            map.put("relateTraceId", relateTraceId);
            this.logger.info("\u4e3b\u4efb\u52a1traceId:{},\u5206\u4efb\u52a1traceId:{}", (Object)traceId, (Object)relateTraceId);
            ThreadPool threadPool = ThreadUtils.get();
            Future result = threadPool.submit((Callable)new RequestAlgoSync(map));
            resultDataList.add((AlgoResultData)result.get());
        }
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            this.logger.error("\u7b49\u5f85\u8bf7\u6c42\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            return this.errorResult(traceId);
        }
        return this.constructResult(resultDataList, traceId);
    }

    private AlgoResultData errorResult(String traceId) {
        AlgoResultData resultData = new AlgoResultData();
        resultData.setRequestId(traceId);
        resultData.setErrorCode(40000);
        resultData.setDescription("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        resultData.setData(null);
        return resultData;
    }

    private AlgoResultData constructResult(List<AlgoResultData> resultDataList, String traceId) {
        JSONArray arr = new JSONArray();
        if (resultDataList == null || resultDataList.isEmpty()) {
            return this.errorResult(traceId);
        }
        for (AlgoResultData resultData : resultDataList) {
            OcrGTPresetVO gtPresetVO1;
            int dataPageNumber;
            if (resultData == null) {
                return this.errorResult(traceId);
            }
            if (resultData.getErrorCode() != 0) {
                resultData.setRequestId(traceId);
                return resultData;
            }
            JSONArray objectArr = JSON.parseArray((String)String.valueOf(resultData.getData()));
            if (arr.isEmpty()) {
                arr.addAll((Collection)objectArr);
                continue;
            }
            OcrGTPresetVO gtPresetVO = (OcrGTPresetVO)JSON.parseObject((String)String.valueOf(arr.get(arr.size() - 1)), OcrGTPresetVO.class);
            int LastPageNumber = gtPresetVO.getPageNumber();
            if (LastPageNumber < (dataPageNumber = (gtPresetVO1 = (OcrGTPresetVO)JSON.parseObject((String)String.valueOf(objectArr.get(0)), OcrGTPresetVO.class)).getPageNumber())) {
                arr.addAll((Collection)objectArr);
                continue;
            }
            JSONArray objects = new JSONArray();
            objects.addAll((Collection)objectArr);
            objects.addAll((Collection)arr);
            arr = objects;
        }
        AlgoResultData resultData = new AlgoResultData();
        resultData.setRequestId(traceId);
        resultData.setDescription("\u8bf7\u6c42\u6210\u529f");
        resultData.setErrorCode(0);
        resultData.setData((Object)arr);
        return resultData;
    }

    private String zipImageForBase64(InputStream inputStream, boolean validExcept) throws IOException {
        try (InputStream zipImageInputStream = OcrControlUtils.getZipImageInputStream((InputStream)inputStream, (boolean)validExcept);){
            String string = OcrControlUtils.getFileBase64ByIO((InputStream)zipImageInputStream);
            return string;
        }
    }

    private AlgoResultData validParams(String invokeType, String businessObject, String templateNumber, String imageData) {
        String message = this.getValidMessage(invokeType, businessObject, templateNumber, imageData);
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            return new AlgoResultData(RequestContext.get().getTraceId(), 40002, message);
        }
        return null;
    }

    private String getValidMessage(String invokeType, String businessObject, String templateNumber, String imageData) {
        if (!"C".equals(invokeType)) {
            if (StringUtils.isEmpty((CharSequence)businessObject)) {
                return ResManager.loadKDString((String)"\u53c2\u6570:businessObject \u4e1a\u52a1\u5bf9\u8c61\u6807\u8bc6 \u4e3a\u7a7a ", (String)"OcrServiceImp_07", (String)APPID, (Object[])new Object[0]);
            }
            MainEntityType entityType = null;
            try {
                entityType = MetadataServiceHelper.getDataEntityType((String)businessObject);
            }
            catch (Exception e) {
                return ResManager.loadKDString((String)"\u53c2\u6570:businessObject \u4e1a\u52a1\u5bf9\u8c61\u6807\u8bc6 \u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u4f20\u6709\u6548\u6807\u8bc6 ", (String)"OcrServiceImp_08", (String)APPID, (Object[])new Object[0]);
            }
            if (entityType == null) {
                return ResManager.loadKDString((String)"\u53c2\u6570:businessObject \u4e1a\u52a1\u5bf9\u8c61\u6807\u8bc6 \u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u4f20\u6709\u6548\u6807\u8bc6 ", (String)"OcrServiceImp_08", (String)APPID, (Object[])new Object[0]);
            }
        }
        if (StringUtils.isEmpty((CharSequence)templateNumber)) {
            return ResManager.loadKDString((String)"\u53c2\u6570:templateNumber \u6a21\u677f\u7f16\u7801 \u4e3a\u7a7a ", (String)"OcrServiceImp_09", (String)APPID, (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)imageData)) {
            return ResManager.loadKDString((String)"\u53c2\u6570:imageData \u56fe\u7247Base64 \u4e3a\u7a7a ", (String)"OcrServiceImp_10", (String)APPID, (Object[])new Object[0]);
        }
        return null;
    }

    private AlgoResultData httpAlgo(String paramKey, String imageData, Map<String, String> bizParam, String templateNumber, String traceId, int requestType) throws Exception {
        HttpEntity httpEntity = this.setEntity(paramKey, imageData, templateNumber, bizParam);
        return CommonUtil.requestAlgo((String)templateNumber, (String)traceId, (HttpEntity)httpEntity, (int)requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpEntity setEntity(String paramKey, String imageData, String templateNumber, Map<String, String> bizParam) {
        HttpEntity httpEntity = null;
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(3);
        if ("imageData".equals(paramKey)) {
            httpEntity = CommonUtil.getHttpEntity((String)imageData, (String)paramKey);
        } else if ("ocrGeneral".equals(paramKey)) {
            httpEntity = CommonUtil.getHttpEntity((String)imageData, (String)"imageBase64");
        } else if ("file".equals(paramKey)) {
            ByteArrayInputStream in = null;
            try {
                in = OcrControlUtils.getByteArrayInputStreamByBase64((String)imageData);
                httpEntity = CommonUtil.getHttpEntity((InputStream)in, (String)paramKey);
            }
            finally {
                StreamHandleUtils.closeResource((Closeable)in);
            }
        } else if ("imageBase64".equals(paramKey)) {
            httpEntity = CommonUtil.getHttpEntity((String)imageData, (String)paramKey, (String)templateNumber);
        } else if ("bank".equals(paramKey)) {
            list.add(new BasicNameValuePair("imageData", imageData));
            httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
        } else if ("BACK".equals(paramKey) || "FRONT".equals(paramKey)) {
            list.add(new BasicNameValuePair("cardSide", paramKey));
            list.add(new BasicNameValuePair("imageData", imageData));
            httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
        } else if ("bankTicket".equals(paramKey)) {
            if (bizParam != null && !bizParam.isEmpty()) {
                List bizList = CommonUtil.addBizParam(bizParam);
                if (!bizList.isEmpty()) {
                    list.addAll(bizList);
                }
                this.logger.info("list\u989d\u5916\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(list));
            }
            list.add(new BasicNameValuePair("imageBase64", imageData));
            httpEntity = new UrlEncodedFormEntity(list, StandardCharsets.UTF_8);
        }
        return httpEntity;
    }

    public AlgoResultData valiadCustomTemplate(String templateNumber, String traceId) {
        DynamicObject template = OcrControlUtils.getObjCacheByNumber((String)"cvp_template", (String)templateNumber);
        if (template != null) {
            String ocrId = template.getString("algoid");
            if (StringUtils.isEmpty((CharSequence)ocrId)) {
                String message = ResManager.loadKDString((String)(templateNumber + " \u81ea\u5b9a\u4e49\u6a21\u677f\u672a\u53d1\u5e03,\u8bf7\u5148\u53d1\u5e03\u3002"), (String)"OcrServiceImp_11", (String)APPID, (Object[])new Object[0]);
                return new AlgoResultData(traceId, 40003, message, null);
            }
        } else {
            String message = ResManager.loadKDString((String)(templateNumber + " \u81ea\u5b9a\u4e49\u6a21\u677f\u4e0d\u5b58\u5728\u3002"), (String)"OcrServiceImp_12", (String)APPID, (Object[])new Object[0]);
            return new AlgoResultData(traceId, 40003, message, null);
        }
        return null;
    }

    public void setApiInfo(String businessObject, String templateNumber, AlgoResultData resultData, String invokeType, long callTime) {
        this.logger.info(String.format("\u6a21\u7248\uff1a%s  ,\u8bb0\u5f55\u82cd\u7a79-API \u8c03\u7528\u4fe1\u606f", templateNumber));
        RequestContext rc = RequestContext.get();
        DynamicObject template = OcrControlUtils.getBindingObjCacheByNumber((String)"cvp_template", (String)templateNumber);
        DynamicObject apiInfo = ORM.create().newDynamicObject("cvp_api_invoke_info");
        String businessName = MetadataServiceHelper.getDataEntityType((String)businessObject).getDisplayName().getLocaleValue();
        apiInfo.set("createdate", (Object)new Date());
        apiInfo.set("calltime", (Object)callTime);
        apiInfo.set("errorcode", (Object)resultData.getErrorCode());
        apiInfo.set("traceid", (Object)rc.getTraceId());
        apiInfo.set("templateid", template != null ? template.getPkValue() : Integer.valueOf(0));
        apiInfo.set("templatename", (Object)(template != null ? template.getString("name") : ""));
        apiInfo.set("callobjectid", (Object)businessObject);
        apiInfo.set("callobjectname", (Object)businessName);
        apiInfo.set("userid", (Object)String.valueOf(rc.getCurrUserId()));
        apiInfo.set("username", (Object)rc.getUserName());
        apiInfo.set("status", (Object)invokeType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apiInfo});
    }

    private class RequestAlgoSync
    implements Callable<AlgoResultData> {
        private Map<String, Object> map;

        RequestAlgoSync(Map<String, Object> param) {
            this.map = param;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AlgoResultData call() throws Exception {
            int splitNum = Integer.parseInt(String.valueOf(this.map.get("splitNum")));
            String localId = String.valueOf(this.map.get("localId"));
            String paramKey = String.valueOf(this.map.get("paramKey"));
            String templateNumber = String.valueOf(this.map.get("templateNumber"));
            int requestType = Integer.parseInt(String.valueOf(this.map.get("requestType")));
            String traceId = String.valueOf(this.map.get("traceId"));
            String relateTraceId = String.valueOf(this.map.get("relateTraceId"));
            CountDownLatch cdl = (CountDownLatch)this.map.get("countDownLatch");
            AlgoResultData resultData = null;
            OcrServiceImpl.this.logger.info("\u4efb\u52a1\u5f00\u59cb...\u5206\u4efb\u52a1traceid:{},\u4e3b\u4efb\u52a1traceid:{}", (Object)relateTraceId, (Object)traceId);
            ArrayList<String> list = new ArrayList<String>();
            try (InputStream inputStream = LocalTempFileCache.getInputStream((String)localId);){
                List imageInputStreamList = OcrControlUtils.getImageInputStreamsByPdfInputStream((InputStream)inputStream);
                if (imageInputStreamList != null && !imageInputStreamList.isEmpty()) {
                    for (InputStream imageInputStream : imageInputStreamList) {
                        list.add(OcrServiceImpl.this.zipImageForBase64(imageInputStream, false));
                    }
                }
                resultData = this.batchRequestAlgo(splitNum, OcrServiceImpl.this.batchWrapRequestParam(list, paramKey, templateNumber), templateNumber, requestType, relateTraceId);
            }
            catch (Exception e) {
                OcrServiceImpl.this.logger.error("\u8f6c\u6362\u3001\u538b\u7f29pdf\u51fa\u9519", (Throwable)e);
            }
            finally {
                cdl.countDown();
            }
            return resultData;
        }

        private AlgoResultData batchRequestAlgo(int splitNum, List<HttpEntity> list, String templateNumber, int requestType, String traceId) throws Exception {
            AlgoResultData resultData = new AlgoResultData();
            resultData.setErrorCode(0);
            resultData.setRequestId(traceId);
            if (list == null || list.isEmpty()) {
                resultData.setData((Object)"");
                resultData.setDescription("\u8bf7\u6c42\u6210\u529f");
                return resultData;
            }
            HttpEntity httpEntity = null;
            for (int i = 0; i < list.size(); ++i) {
                httpEntity = list.get(i);
                AlgoResultData result = CommonUtil.requestAlgo((String)templateNumber, (String)traceId, (HttpEntity)httpEntity, (int)requestType);
                if (result == null || result.getErrorCode() != 0) {
                    this.wrapErrorRequest(resultData, result);
                    return resultData;
                }
                JSONArray objectArr = JSON.parseArray((String)String.valueOf(result.getData()));
                OcrGTPresetVO gtPresetVO = (OcrGTPresetVO)JSON.parseObject((String)String.valueOf(objectArr.get(0)), OcrGTPresetVO.class);
                JSONArray totalArr = JSON.parseArray((String)String.valueOf(resultData.getData()));
                if (totalArr == null) {
                    totalArr = new JSONArray();
                    gtPresetVO.setPageNumber(splitNum * PDF_SPLIT_SIZE);
                } else {
                    OcrGTPresetVO oldGTPPresetVO = (OcrGTPresetVO)JSON.parseObject((String)String.valueOf(totalArr.get(totalArr.size() - 1)), OcrGTPresetVO.class);
                    int pageNumber = oldGTPPresetVO.getPageNumber();
                    gtPresetVO.setPageNumber(pageNumber + 1);
                }
                totalArr.add((Object)gtPresetVO);
                resultData.setData((Object)totalArr);
            }
            return resultData;
        }

        private void wrapErrorRequest(AlgoResultData resultData, AlgoResultData result) {
            resultData.setErrorCode(result != null ? result.getErrorCode() : 40000);
            resultData.setData((Object)"");
            resultData.setDescription(result != null ? result.getDescription() : "\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
    }
}

