/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.mservice.upgrade;

import java.sql.ResultSet;
import java.sql.SQLException;
import kd.ai.cvp.mservice.upgrade.TdaPlanHistoryDataUpdate;
import kd.ai.cvp.utils.CommonUtil;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class CustomHistoryDataHandler
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(TdaPlanHistoryDataUpdate.class);
    private static final String DB_KEY = "aidb";
    private static final String PREFIX = "d@f*g:SGVsbG8";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info(String.format("\u89c6\u89c9\u8bc6\u522b\uff0c\u6587\u6863\u5dee\u5f02\u5206\u6790\u5386\u53f2\u8bb0\u5f55 \u52a0\u5bc6\u5dee\u5f02\u5206\u6790\u3001\u4fe1\u606f\u63d0\u53d6\u7ed3\u679c \u7248\u672c\u53f7\uff1a%s,\u8fed\u4ee3\u5668\uff1a%s, \u6570\u636e\u5e93\uff1a%s, sql\u6587\u4ef6\u540d\uff1a%s, start ", ver, iteration, dbKey, sqlFileName));
        DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)"select fid,fentryid,fbilltdaresult from t_cvp_tda_comparison_task where 1=1", resultSet -> {
            while (resultSet.next()) {
                this.operateTDAData(resultSet);
            }
            return null;
        });
        logger.info("\u89c6\u89c9\u8bc6\u522b\uff0c\u6587\u6863\u5dee\u5f02\u5206\u6790\u5386\u53f2\u8bb0\u5f55 \u6267\u884c end");
        logger.info(String.format("\u4fe1\u606f\u63d0\u53d6\u5386\u53f2\u8bb0\u5f55 \u52a0\u5bc6\u5904\u7406 \u7248\u672c\u53f7\uff1a%s,\u8fed\u4ee3\u5668\uff1a%s, \u6570\u636e\u5e93\uff1a%s, sql\u6587\u4ef6\u540d\uff1a%s, start ", ver, iteration, dbKey, sqlFileName));
        DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)"select fid,fbillieresult,fupdatedata from t_cvp_ie_history where 1=1", resultSet -> {
            while (resultSet.next()) {
                this.operateTIEData(resultSet);
            }
            return null;
        });
        logger.info("\u4fe1\u606f\u63d0\u53d6\u5386\u53f2\u8bb0\u5f55 \u52a0\u5bc6\u5904\u7406 \u6267\u884c end");
        return null;
    }

    private void operateTIEData(ResultSet resultSet) throws SQLException {
        String fbillieresult = resultSet.getString("fbillieresult");
        String fupdatedata = resultSet.getString("fupdatedata");
        long id = resultSet.getLong("fid");
        if (id == 0L) {
            logger.info("\u4e0d\u66f4\u65b0\u7684\u6570\u636e\uff1aid:{}", (Object)id);
            return;
        }
        if (StringUtils.isNotEmpty((String)fbillieresult) && !fbillieresult.startsWith(PREFIX)) {
            fbillieresult = CommonUtil.encryptString((String)fbillieresult);
        }
        if (StringUtils.isNotEmpty((String)fupdatedata) && !fupdatedata.startsWith(PREFIX)) {
            fupdatedata = CommonUtil.encryptString((String)fupdatedata);
        }
        Object[] param = new Object[]{fbillieresult, fupdatedata, id};
        int update = DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_cvp_ie_history set fbillieresult = ?,fupdatedata = ? where fid = ?", (Object[])param);
        logger.info("tie\u6570\u636e\u66f4\u65b0\u6210\u529f\uff1aid:{},\u66f4\u65b0\u6570\u636e\uff1a{}", (Object)id, (Object)update);
    }

    public void operateTDAData(ResultSet resultSet) throws SQLException {
        String result = resultSet.getString("fbilltdaresult");
        long fentryid = resultSet.getLong("fentryid");
        if (StringUtils.isNotEmpty((String)result)) {
            if (fentryid == 0L) {
                logger.info("\u4e0d\u66f4\u65b0\u7684\u6570\u636e\uff1afentryid:{}", (Object)fentryid);
                return;
            }
            if (result.startsWith(PREFIX)) {
                logger.info("fentryid:{},\u4e0d\u662fjson\u7279\u5f81\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u52a0\u5bc6\u3002", (Object)fentryid);
                return;
            }
            logger.info("\u8fdb\u5165\u6267\u884c\u3002\u3002\u3002fentryid:{}", (Object)fentryid);
            String encryptStr = CommonUtil.encryptString((String)result);
            Object[] param = new Object[]{encryptStr, fentryid};
            int update = DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"update t_cvp_tda_comparison_task set fbilltdaresult = ? where fentryid = ?", (Object[])param);
            logger.info("tda\u6570\u636e\u66f4\u65b0\u6210\u529f\uff1afentryid:{},\u66f4\u65b0\u6570\u636e\uff1a{}", (Object)fentryid, (Object)update);
        }
    }
}

