/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.mservice.upgrade;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import kd.ai.cvp.utils.DtsManage;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class DtsPlanInitUpgrade
implements IUpgradeService {
    private static Log log = LogFactory.getLog(DtsPlanInitUpgrade.class);
    private static final String DB_KEY = "aidb";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        log.info(String.format("\u89c6\u89c9\u8bc6\u522b\uff0c\u5173\u8054\u65b9\u6848\u57fa\u7840\u8d44\u6599 DTS \u540c\u6b65 \u7248\u672c\u53f7\uff1a%s,\u8fed\u4ee3\u5668\uff1a%s, \u6570\u636e\u5e93\uff1a%s, sql\u6587\u4ef6\u540d\uff1a%s, start ", ver, iteration, dbKey, sqlFileName));
        DB.query((DBRoute)DBRoute.of((String)DB_KEY), (String)"select fid, fbusinessobject from t_cvp_plan", resultSet -> {
            while (resultSet.next()) {
                this.operateData(resultSet);
            }
            return null;
        });
        log.info("\u89c6\u89c9\u8bc6\u522b\uff0c\u5173\u8054\u65b9\u6848\u57fa\u7840\u8d44\u6599 DTS \u540c\u6b65 end");
        return null;
    }

    public void operateData(ResultSet resultSet) throws SQLException {
        String businessobject = resultSet.getString("fbusinessobject");
        if (StringUtils.isNotEmpty((String)businessobject)) {
            long planId = resultSet.getLong("fid");
            Set entityNumbers = DtsManage.getEntityNames((String)businessobject);
            entityNumbers.forEach(entityNumber -> this.operateOneData(planId, (String)entityNumber));
        }
    }

    public void operateOneData(long planId, String entityNumber) {
        long businessId = DB.genLongId((String)"cvp_plan_syn_business");
        DB.update((DBRoute)DBRoute.of((String)DB_KEY), (String)"insert into t_cvp_plan_syn_business (fid, fplannumber, fentitynumber, fcreatorid, fcreatedate) values(?,?,?,?,?)", (Object[])new Object[]{businessId, planId, entityNumber, 0L, new Date()});
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"select fentitynumber from t_dts_datasyncconfig where fentitynumber =? and fregion=? ", (Object[])new Object[]{entityNumber, "cvpsearch"}, result -> {
            if (!result.next()) {
                this.operateSysData(entityNumber);
            }
            return null;
        });
    }

    public void operateSysData(String entityNumber) {
        long syncId = DB.genLongId((String)"data_sync_config");
        DB.update((DBRoute)DBRoute.of((String)"sys"), (String)"insert into t_dts_datasyncconfig (fid,fentitynumber,fstatus,fdestinationtype,fentityfields,fregion,fenable,fbusinesstype) values(?,?,?,?,?,?,?,?)", (Object[])new Object[]{syncId, entityNumber, "working", "fulltext", ",id,number,name,", "cvpsearch", "1", "cvpsearch"});
    }
}

