/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.agent.tool.util.GaiFileUtils;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class KdComplexDocExtractAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(KdComplexDocExtractAction.class);
    private static final String ComplexDocExtractAction = "complexDocExtract";
    private static final String GaiOcrCallBackService = "GaiOcrCallBackService";
    private static final int DEFAULT_READ_TIMEOUT = 600;
    private static final int QUERY_TIME_MS = 3000;

    public Map<String, String> invokeAction(String action, Map<String, String> param) {
        logger.info("complexDocExtract,\u5f53\u524d\u9884\u7f6e\u64cd\u4f5c\uff1a{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)action, param);
        Map<Object, Object> result = new HashMap(0);
        if (ComplexDocExtractAction.equalsIgnoreCase(action)) {
            Map<String, Object> bizParams = this.validateParams(param);
            String timeout = param.get("timeout");
            int[] numTimeOuts = new int[1];
            numTimeOuts[0] = !StringUtils.isEmpty((CharSequence)timeout) ? (StringUtils.isNumeric((CharSequence)timeout) ? Integer.parseInt(timeout) : 600) : 600;
            HashMap<String, String> bizCallBackInfo = new HashMap<String, String>(0);
            bizCallBackInfo.put("bizCloudId", "ai");
            bizCallBackInfo.put("bizAppId", "gai");
            bizCallBackInfo.put("bizCallBackService", GaiOcrCallBackService);
            bizCallBackInfo.put("bizCallBackMethod", "callback");
            logger.info("\u91d1\u8776\u590d\u6742\u6587\u6863\u8bc6\u522b\u521b\u5efa\u4efb\u52a1\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(bizParams));
            String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)ComplexDocExtractAction, (Object[])new Object[]{bizParams, bizCallBackInfo});
            OcrResult orcResult = (OcrResult)SerializationUtils.fromJsonString((String)resultStr, OcrResult.class);
            logger.info("\u91d1\u8776\u590d\u6742\u6587\u6863\u8bc6\u522b\u521b\u5efa\u4efb\u52a1\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)orcResult));
            int errCode = orcResult.getErrorCode();
            if (0 != errCode) {
                throw new KDBizException(GaiExceptionUtil.buildCvpErr(errCode, orcResult.getDescription()), new Object[0]);
            }
            String taskId = String.valueOf(orcResult.getData());
            logger.info("\u67e5\u8be2\u6587\u6863\u89e3\u6790\u7ed3\u679c\u5f00\u59cb...");
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            Boolean timeoutClose = Boolean.TRUE;
            Boolean isError = Boolean.FALSE;
            while (end - start <= (long)(numTimeOuts[0] * 1000)) {
                end = System.currentTimeMillis();
                result = this.queryComplexDocExtractInfo(taskId);
                String status = (String)result.get("status");
                logger.info("status:{}", (Object)status);
                if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"success")) {
                    timeoutClose = Boolean.FALSE;
                    break;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"error")) {
                    timeoutClose = Boolean.FALSE;
                    isError = Boolean.TRUE;
                    logger.info("\u91d1\u8776\u590d\u6742\u6587\u6863\u7ed3\u679c\u63d0\u53d6\u72b6\u6001:{}\u9000\u51fa", (Object)status);
                    break;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error("\u95f4\u96943\u79d2\u67e5\u8be2\u6587\u6863\u89e3\u6790\u7ed3\u679c\u5931\u8d25,{}", (Object)e.getMessage());
                    throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u8776\u590d\u6742\u6587\u6863\u7ed3\u679c\u63d0\u53d6\u5f02\u5e38\u4e2d\u65ad\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"KdComplexDocExtractAction_4", (String)"ai-gai-core", (Object[])new Object[0]));
                }
            }
            if (timeoutClose.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u8776\u590d\u6742\u6587\u6863\u89e3\u6790\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"KdComplexDocExtractAction_3", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            if (isError.booleanValue() && result != null) {
                String progress = (String)result.get("process");
                logger.info("\u91d1\u8776\u590d\u6742\u6587\u6863\u7ed3\u679c\u63d0\u53d6\u5931\u8d25,progress:{}", (Object)progress);
            }
            logger.info("\u67e5\u8be2\u6587\u6863\u89e3\u6790\u7ed3\u679c\u7ed3\u675f,\u5171\u8017\u65f6\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - start) / 1000L));
            logger.info("\u67e5\u8be2\u6587\u6863\u89e3\u6790\u7ed3\u679c\u7ed3\u675f,\u67e5\u8be2\u7ed3\u679c:{}", result);
            return result;
        }
        logger.error("\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002");
        throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"KdComplexDocExtractAction_1", (String)"ai-gai-core", (Object[])new Object[0]));
    }

    private Map<String, Object> validateParams(Map<String, String> param) {
        HashMap<String, Object> bizParams = new HashMap<String, Object>(0);
        String fileUrl = param.get("fileUrl");
        if (StringUtils.isEmpty((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"fileUrl\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"KdComplexDocExtractAction_2", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        if (StringUtils.isNumeric((CharSequence)fileUrl)) {
            logger.info("\u91d1\u8776\u590d\u6742\u6587\u6863\u8bc6\u522b fileId\uff1a{}", (Object)fileUrl);
            fileUrl = GaiFileUtils.getGaiFilePath(Long.parseLong(fileUrl));
            logger.info("\u91d1\u8776\u590d\u6742\u6587\u6863\u8bc6\u522b fileUrl\uff1a{}", (Object)fileUrl);
        }
        bizParams.put("fileUrl", fileUrl);
        String extractTable = param.get("extractTable");
        bizParams.put("extractTable", StringUtils.isEmpty((CharSequence)extractTable) ? Boolean.TRUE : Boolean.parseBoolean(extractTable));
        String extractImageInDoc = param.get("extractImageInDoc");
        bizParams.put("extractImageInDoc", StringUtils.isEmpty((CharSequence)extractImageInDoc) ? Boolean.TRUE : Boolean.parseBoolean(extractImageInDoc));
        String docWithSiteAndPage = param.get("docWithSiteAndPage");
        bizParams.put("docWithSiteAndPage", StringUtils.isEmpty((CharSequence)docWithSiteAndPage) ? Boolean.FALSE : Boolean.parseBoolean(docWithSiteAndPage));
        String tableOutType = param.get("tableOutType");
        bizParams.put("tableOutType", StringUtils.isEmpty((CharSequence)tableOutType) ? "markdown" : tableOutType);
        bizParams.put("bizTaskId", "");
        return bizParams;
    }

    private Map<String, String> queryComplexDocExtractInfo(String taskId) {
        HashMap<String, String> result = new HashMap<String, String>(1);
        logger.info("\u91d1\u8776\u590d\u6742\u6587\u6863\u63d0\u53d6\u7ed3\u679c\u67e5\u8be2,taskId\uff1a{}", (Object)taskId);
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"queryComplexDocExtractInfo", (Object[])new Object[]{taskId});
        logger.info("\u91d1\u8776\u590d\u6742\u6587\u6863\u63d0\u53d6\u7ed3\u679c\uff1a{}", (Object)resultStr);
        OcrResult orcResult = (OcrResult)SerializationUtils.fromJsonString((String)resultStr, OcrResult.class);
        int errCode = orcResult.getErrorCode();
        if (0 != errCode) {
            throw new KDBizException(GaiExceptionUtil.buildCvpErr(errCode, orcResult.getDescription()), new Object[0]);
        }
        Object obj = orcResult.getData();
        String data = JSONObject.toJSONString((Object)obj);
        result.putAll(this.handlerQueryComplexDocResult(data));
        return result;
    }

    private Map<String, String> handlerQueryComplexDocResult(String data) {
        HashMap<String, String> result = new HashMap<String, String>(0);
        if (!StringUtils.isEmpty((CharSequence)data)) {
            JSONObject ocrRes = JSONObject.parseObject((String)data);
            result.put("progress", ocrRes.getString("progress"));
            result.put("status", ocrRes.getString("status"));
            result.put("taskId", ocrRes.getString("taskId"));
            result.put("endDataTimestamps", String.valueOf(ocrRes.getLongValue("endDataTimestamps")));
            JSONArray layoutData = ocrRes.getJSONArray("layoutData");
            result.put("layoutData", JSONObject.toJSONString((Object)layoutData));
            result.put("docContent", ocrRes.getString("docContent"));
        }
        return result;
    }

    static class OcrResult {
        private String requestId;
        private int errorCode;
        private String description;
        private Object data;

        OcrResult() {
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

