/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.action;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.agent.tool.tms.TmsClient;
import kd.ai.gai.core.agent.tool.tms.entity.SearchCommonRequest;
import kd.ai.gai.core.agent.tool.tms.entity.SearchCommonResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class TencentAiSearchAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(TencentAiSearchAction.class);
    private static final String AiSearchAction = "aiSearch";
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

    public Map<String, String> invokeAction(String action, Map<String, String> param) {
        logger.info("aiSearch,\u5f53\u524d\u9884\u7f6e\u64cd\u4f5c\uff1a{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)action, param);
        HashMap<String, String> result = new HashMap<String, String>(0);
        if (AiSearchAction.equalsIgnoreCase(action)) {
            String configParams = param.get("configParams");
            JSONObject cp = JSONObject.parseObject((String)configParams);
            String secretId = cp.getString("secretId");
            String secretKey = cp.getString("secretKey");
            if (StringUtils.isEmpty((CharSequence)secretId) || StringUtils.isEmpty((CharSequence)secretKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u5de5\u5177\u914d\u7f6e\u53c2\u6570\u4e2d\u83b7\u53d6\u7684secretId\u6216\u8005secretKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentAiSearchAction_1", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            TmsClient client = new TmsClient(secretId, secretKey, "");
            SearchCommonRequest request = this.handlerRequestParams(param);
            logger.info("\u817e\u8bafAIGC\u641c\u7d22\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)request));
            SearchCommonResponse response = client.searchCommon(request, 5000, 20000);
            logger.info("\u817e\u8bafAIGC\u641c\u7d22\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)response));
            Map<String, String> resData = this.handlerResult(response);
            result.putAll(resData);
            return result;
        }
        logger.error("\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002");
        throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentAiSearchAction_5", (String)"ai-gai-core", (Object[])new Object[0]));
    }

    private Map<String, String> handlerResult(SearchCommonResponse response) {
        HashMap<String, String> result = new HashMap<String, String>(0);
        result.put("Pages", JSONObject.toJSONString((Object)response.getPages()));
        result.put("Query", response.getQuery());
        result.put("RequestId", response.getRequestId());
        return result;
    }

    private SearchCommonRequest handlerRequestParams(Map<String, String> param) {
        String vrid;
        String insite;
        String category;
        String tsn;
        SearchCommonRequest request = new SearchCommonRequest();
        String query = param.get("query");
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new KDBizException(ResManager.loadKDString((String)"query\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentAiSearchAction_2", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        request.setQuery(query);
        String cnt = param.get("cnt");
        if (!StringUtils.isEmpty((CharSequence)cnt)) {
            if (StringUtils.isNumeric((CharSequence)cnt)) {
                Integer numCnt = Integer.parseInt(cnt);
                if (numCnt < 0) {
                    numCnt = 10;
                } else if (numCnt > 30) {
                    numCnt = 30;
                }
                request.setCnt(numCnt);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"cnt\u53c2\u6570\u4e0d\u662f\u6709\u6548\u7684\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentAiSearchAction_3", (String)"ai-gai-core", (Object[])new Object[0]));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(tsn = param.get("tsn")))) {
            if (StringUtils.isNumeric((CharSequence)tsn)) {
                Integer numTsn = Integer.parseInt(tsn);
                if (numTsn < 0) {
                    numTsn = 6;
                } else if (numTsn > 6) {
                    numTsn = 6;
                }
                request.setTsn(numTsn);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"tsn\u53c2\u6570\u4e0d\u662f\u6709\u6548\u7684\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentAiSearchAction_4", (String)"ai-gai-core", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isEmpty((CharSequence)(category = param.get("category")))) {
            request.setCategory(null);
        }
        if (StringUtils.isEmpty((CharSequence)(insite = param.get("insite")))) {
            request.setInsite(null);
        }
        if (StringUtils.isEmpty((CharSequence)(vrid = param.get("vrid")))) {
            request.setVrid(null);
        }
        return request;
    }
}

