/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.agent.tool.tms.LkeClient;
import kd.ai.gai.core.agent.tool.tms.entity.ComplexDocExtractRequest;
import kd.ai.gai.core.agent.tool.tms.entity.ReconstructDocumentConfig;
import kd.ai.gai.core.agent.tool.util.GaiFileUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class TencentComplexDocExtractAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(TencentComplexDocExtractAction.class);
    private static final String ComplexDocExtractAction = "complexDocExtract";
    private static final int DEFAULT_READ_TIMEOUT = 600000;

    public Map<String, String> invokeAction(String action, Map<String, String> param) {
        logger.info("complexDocExtract,\u5f53\u524d\u9884\u7f6e\u64cd\u4f5c\uff1a{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)action, param);
        HashMap<String, String> result = new HashMap<String, String>(0);
        if (ComplexDocExtractAction.equalsIgnoreCase(action)) {
            String configParams = param.get("configParams");
            JSONObject cp = JSONObject.parseObject((String)configParams);
            String secretId = cp.getString("secretId");
            String secretKey = cp.getString("secretKey");
            if (StringUtils.isEmpty((CharSequence)secretId) || StringUtils.isEmpty((CharSequence)secretKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u5de5\u5177\u914d\u7f6e\u53c2\u6570\u4e2d\u83b7\u53d6\u7684secretId\u6216\u8005secretKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentComplexDocExtractAction_7", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            LkeClient client = new LkeClient(secretId, secretKey);
            ComplexDocExtractRequest validate = this.validateRequestParams(param);
            logger.info("\u817e\u8baf\u6587\u6863\u89e3\u6790\u53c2\u6570\u6821\u9a8c\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)validate));
            String timeout = param.get("timeout");
            Integer time = 0;
            time = !StringUtils.isEmpty((CharSequence)timeout) ? Integer.valueOf(Integer.parseInt(timeout) * 1000) : Integer.valueOf(600000);
            logger.info("\u817e\u8baf\u6587\u6863\u89e3\u6790\u8d85\u65f6\u65f6\u95f4\uff1a{}", (Object)time);
            ComplexDocExtractRequest request = this.downloadFile(validate);
            String content = client.complexDocExtract(request, 10000, time);
            logger.info("\u817e\u8baf\u6587\u6863\u89e3\u6790\u63a5\u53e3\u8c03\u7528\u7ed3\u679c:{}", (Object)content);
            Map<String, String> resData = this.handlerComplexDocResult(content);
            logger.info("\u817e\u8baf\u6587\u6863\u89e3\u6790\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString(resData));
            result.putAll(resData);
            return result;
        }
        logger.error("\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002");
        throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentComplexDocExtractAction_8", (String)"ai-gai-core", (Object[])new Object[0]));
    }

    private Map<String, String> handlerComplexDocResult(String data) {
        JSONObject ocrRes;
        JSONObject response;
        HashMap<String, String> result = new HashMap<String, String>(0);
        if (!StringUtils.isEmpty((CharSequence)data) && (response = (ocrRes = JSONObject.parseObject((String)data)).getJSONObject("Response")) != null) {
            if (response.containsKey((Object)"Error")) {
                JSONObject error = response.getJSONObject("Error");
                String code = error.getString("Code");
                String message = error.getString("Message");
                result.put("Code", code);
                result.put("Message", message);
            } else {
                JSONArray documentRecognizeInfo = response.getJSONArray("DocumentRecognizeInfo");
                result.put("DocumentRecognizeInfo", JSONArray.toJSONString((Object)documentRecognizeInfo));
                result.put("InsetImagePackage", response.getString("InsetImagePackage"));
                String markdownBase64 = response.getString("MarkdownBase64");
                String content = "";
                if (!StringUtils.isEmpty((CharSequence)markdownBase64)) {
                    byte[] bData = Base64.getDecoder().decode(markdownBase64);
                    content = new String(bData);
                } else {
                    content = markdownBase64;
                }
                result.put("MarkdownBase64", content);
                result.put("RequestId", response.getString("RequestId"));
            }
        }
        return result;
    }

    private ComplexDocExtractRequest downloadFile(ComplexDocExtractRequest request) {
        String fileUrl = request.getFileUrl();
        byte[] bytes = null;
        if (StringUtils.isNumeric((CharSequence)fileUrl)) {
            logger.info("\u817e\u8baf\u6587\u6863\u89e3\u6790 fileUrl:{} is long file id", (Object)fileUrl);
            bytes = GaiFileUtils.downloadFile(Long.parseLong(fileUrl));
        } else {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            boolean attaExist = fileService.exists(fileUrl);
            boolean tempExist = false;
            try {
                if (!attaExist) {
                    tempExist = tempFileCache.exists(fileUrl);
                }
            }
            catch (KDException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (errorCode != BosErrorCode.downloadFailed && errorCode != BosErrorCode.fileIsExistFailed) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TencentComplexDocExtractAction_4", (String)"ai-gai-core", (Object[])new Object[0]));
                }
                logger.error("\u4f20\u9012\u7684\u6587\u4ef6url\u65e0\u6cd5\u6821\u9a8c\u901a\u8fc7\u4e34\u65f6\u6587\u4ef6", (Throwable)e);
            }
            catch (Exception ex) {
                logger.error("\u4f20\u9012\u7684\u6587\u4ef6url\u65e0\u6cd5\u6821\u9a8c\u901a\u8fc7\u4e34\u65f6\u6587\u4ef6", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TencentComplexDocExtractAction_4", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            InputStream is = null;
            try {
                if (!attaExist && !tempExist) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u63d0\u53d6\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u652f\u6301\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TencentComplexDocExtractAction_5", (String)"ai-gai-core", (Object[])new Object[0]));
                }
                if (attaExist) {
                    String realPath = fileService.getFileServiceExt().getRealPath(fileUrl);
                    String fileName = realPath.substring(realPath.lastIndexOf("/") + 1);
                    logger.info("\u817e\u8baf\u590d\u6742\u6587\u6863\u89e3\u6790\u83b7\u53d6\u7684\u6587\u4ef6 realPath:{},fileName:{}", (Object)realPath, (Object)fileName);
                    is = fileService.getInputStream(realPath);
                    bytes = IOUtils.toByteArray((InputStream)is);
                } else {
                    is = tempFileCache.getInputStream(fileUrl);
                    bytes = IOUtils.toByteArray((InputStream)is);
                }
            }
            catch (IOException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TencentComplexDocExtractAction_6", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                }
            }
        }
        String base64Str = Base64.getEncoder().encodeToString(bytes);
        request.setFileBase64(base64Str);
        request.setFileUrl(null);
        return request;
    }

    private ComplexDocExtractRequest validateRequestParams(Map<String, String> param) {
        String timeout;
        String fileEndPageNumber;
        ComplexDocExtractRequest request = new ComplexDocExtractRequest();
        String fileUrl = param.get("fileUrl");
        if (StringUtils.isEmpty((CharSequence)fileUrl)) {
            String message = ResManager.loadKDString((String)"fileUrl\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentComplexDocExtractAction_1", (String)"ai-gai-core", (Object[])new Object[0]);
            logger.error(message);
            throw new KDBizException(message);
        }
        request.setFileUrl(fileUrl);
        String fileStartPageNumber = param.get("fileStartPageNumber");
        if (!StringUtils.isEmpty((CharSequence)fileStartPageNumber)) {
            if (StringUtils.isNumeric((CharSequence)fileStartPageNumber)) {
                request.setFileStartPageNumber(Integer.parseInt(fileStartPageNumber));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"fileStartPageNumber\u53c2\u6570\u4e0d\u662f\u6709\u6548\u7684\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentComplexDocExtractAction_2", (String)"ai-gai-core", (Object[])new Object[0]));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(fileEndPageNumber = param.get("fileEndPageNumber")))) {
            if (StringUtils.isNumeric((CharSequence)fileEndPageNumber)) {
                request.setFileEndPageNumber(Integer.parseInt(fileEndPageNumber));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"fileEndPageNumber\u53c2\u6570\u4e0d\u662f\u6709\u6548\u7684\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentComplexDocExtractAction_3", (String)"ai-gai-core", (Object[])new Object[0]));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(timeout = param.get("timeout"))) && !StringUtils.isNumeric((CharSequence)timeout)) {
            throw new KDBizException(ResManager.loadKDString((String)"timeout\u53c2\u6570\u4e0d\u662f\u6709\u6548\u7684\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TencentComplexDocExtractAction_9", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        String enableInsetImage = param.getOrDefault("enableInsetImage", "false");
        ReconstructDocumentConfig config = new ReconstructDocumentConfig();
        config.setEnableInsetImage(Boolean.parseBoolean(enableInsetImage));
        request.setConfig(config);
        return request;
    }
}

