/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.action;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.agent.tool.util.GaiFileUtils;
import kd.ai.gai.core.agent.tool.util.HttpXmlUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class TextInOcrAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(TextInOcrAction.class);
    private static final String TextInOcrAction = "textInOcr";
    private static final String TextInOcrPdf2MarkdownUrl = "https://api.textin.com/ai/service/v1/pdf_to_markdown";
    private static final int DEFAULT_READ_TIMEOUT = 600000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;

    public Map<String, String> invokeAction(String action, Map<String, String> param) {
        HashMap<String, String> result = new HashMap<String, String>(1);
        logger.info("textInOcr,\u5f53\u524d\u9884\u7f6e\u64cd\u4f5c\uff1a{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)action, param);
        if (TextInOcrAction.equalsIgnoreCase(action)) {
            String configParams = param.get("configParams");
            JSONObject cp = JSONObject.parseObject((String)configParams);
            String appId = cp.getString("appId");
            String secretCode = cp.getString("secretCode");
            if ((StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)secretCode)) && (StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)secretCode))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u5de5\u5177\u914d\u7f6e\u53c2\u6570\u4e2d\u83b7\u53d6\u7684appId\u6216\u8005secretCode\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TextInOcrAction_1", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            String timeout = param.get("timeout");
            int[] numTimeOuts = new int[1];
            numTimeOuts[0] = !StringUtils.isEmpty((CharSequence)timeout) ? (StringUtils.isNumeric((CharSequence)timeout) ? Integer.parseInt(timeout) : 600000) : 600000;
            String fileUrl = param.get("fileUrl");
            byte[] data = this.downloadFile(fileUrl);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-ti-app-id", appId);
            headers.put("x-ti-secret-code", secretCode);
            headers.put("Content-Type", "application/octet-stream");
            String content = null;
            try {
                content = HttpXmlUtils.postOctStreamRequest(TextInOcrPdf2MarkdownUrl, headers, data, 10000, 600000);
                logger.info("\u5408\u5408\u590d\u6742\u6587\u6863\u89e3\u6790\u8c03\u7528\u7ed3\u679c:{}", (Object)content);
                if (!StringUtils.isEmpty((CharSequence)content)) {
                    JSONObject obj = JSONObject.parseObject((String)content);
                    int code = obj.getIntValue("code");
                    String message = obj.getString("message");
                    logger.info("\u5408\u5408\u590d\u6742\u6587\u6863\u89e3\u6790\u8c03\u7528code:{},message:{}", (Object)code, (Object)message);
                }
            }
            catch (IOException e) {
                logger.error("\u8c03\u7528\u5408\u5408\u590d\u6742\u6587\u6863\u89e3\u6790\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                throw new KDBizException(e.getMessage());
            }
            result.put("data", content);
            return result;
        }
        logger.error("\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002");
        throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TextInOcrAction_5", (String)"ai-gai-core", (Object[])new Object[0]));
    }

    private byte[] downloadFile(String fileUrl) {
        byte[] bytes = new byte[]{};
        if (StringUtils.isNumeric((CharSequence)fileUrl)) {
            logger.info("\u5408\u5408\u590d\u6742\u6587\u6863\u89e3\u6790 fileUrl:{} is long file id", (Object)fileUrl);
            bytes = GaiFileUtils.downloadFile(Long.parseLong(fileUrl));
        } else {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            boolean attaExist = fileService.exists(fileUrl);
            boolean tempExist = false;
            try {
                if (!attaExist) {
                    tempExist = tempFileCache.exists(fileUrl);
                }
            }
            catch (KDException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (errorCode != BosErrorCode.downloadFailed && errorCode != BosErrorCode.fileIsExistFailed) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TextInOcrAction_2", (String)"ai-gai-core", (Object[])new Object[0]));
                }
                logger.error("\u4f20\u9012\u7684\u6587\u4ef6url\u65e0\u6cd5\u6821\u9a8c\u901a\u8fc7\u4e34\u65f6\u6587\u4ef6", (Throwable)e);
            }
            catch (Exception ex) {
                logger.error("\u4f20\u9012\u7684\u6587\u4ef6url\u65e0\u6cd5\u6821\u9a8c\u901a\u8fc7\u4e34\u65f6\u6587\u4ef6", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TextInOcrAction_2", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            InputStream is = null;
            try {
                if (!attaExist && !tempExist) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u63d0\u53d6\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u652f\u6301\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TextInOcrAction_3", (String)"ai-gai-core", (Object[])new Object[0]));
                }
                if (attaExist) {
                    String realPath = fileService.getFileServiceExt().getRealPath(fileUrl);
                    String fileName = realPath.substring(realPath.lastIndexOf("/") + 1);
                    logger.info("\u6587\u6863\u89e3\u6790\u83b7\u53d6\u7684\u6587\u4ef6 realPath:{},fileName:{}", (Object)realPath, (Object)fileName);
                    is = fileService.getInputStream(realPath);
                    bytes = IOUtils.toByteArray((InputStream)is);
                } else {
                    is = tempFileCache.getInputStream(fileUrl);
                    bytes = IOUtils.toByteArray((InputStream)is);
                }
            }
            catch (IOException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TextInOcrAction_4", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                }
            }
        }
        return bytes;
    }
}

