/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.agent.tool.util.HttpXmlUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ZhiPuAISearchAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(ZhiPuAISearchAction.class);
    private static final String webSearchAction = "AiSearch";
    private static final int DEFAULT_READ_TIMEOUT = 60000;
    private static final String AI_ASSISTANT_ID = "659e54b1b8006379b4b2abd6";
    private static final String assistant_url = "https://open.bigmodel.cn/api/paas/v4/assistant";

    public Map<String, String> invokeAction(String action, Map<String, String> param) {
        logger.info("\u667a\u8c31AI\u641c\u7d22,\u5f53\u524d\u9884\u7f6e\u64cd\u4f5c\uff1a{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)action, param);
        HashMap<String, String> result = new HashMap<String, String>(0);
        result.put("data", "");
        if (webSearchAction.equalsIgnoreCase(action)) {
            String configParams = param.get("configParams");
            JSONObject cp = JSONObject.parseObject((String)configParams);
            String apiKey = cp.getString("api_key");
            if (StringUtils.isEmpty((CharSequence)apiKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u5de5\u5177\u914d\u7f6e\u53c2\u6570\u4e2d\u83b7\u53d6\u7684api_key\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ZhiPuAISearchAction_1", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            JSONObject data = this.handleRequestParams(param);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", apiKey);
            header.put("Accept", "text/event-stream");
            try {
                logger.info("\u667a\u8c31AI\u641c\u7d22 url:{},header:{},\u8d85\u65f6\u65f6\u95f4:{}", new Object[]{assistant_url, header, 60000});
                logger.info("\u667a\u8c31AI\u641c\u7d22 request:{}", (Object)JSONObject.toJSONString((Object)data));
                String res = HttpXmlUtils.postApplicationJSON(assistant_url, header, JSONObject.toJSONString((Object)data), 5000, 60000);
                logger.info("\u667a\u8c31AI\u641c\u7d22 response:{}", (Object)res);
                JSONObject searchResult = this.parser(res);
                result.put("data", JSONObject.toJSONString((Object)searchResult));
                return result;
            }
            catch (IOException e) {
                logger.error("\u667a\u8c31AI\u641c\u7d22 error:{}", (Object)e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
        logger.error("\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002");
        throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5caction\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ZhiPuAISearchAction_3", (String)"ai-gai-core", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject parser(String data) {
        JSONObject res = new JSONObject();
        res.put("read_urls", (Object)new JSONArray());
        res.put("search_urls", (Object)new JSONArray());
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(data.getBytes("utf-8"));
            List messages = IOUtils.readLines((InputStream)is, (String)"utf-8");
            StringBuilder sb = new StringBuilder();
            for (String message : messages) {
                String msgStatus;
                String result;
                if (StringUtils.isEmpty((CharSequence)message) || !JSONPath.contains((Object)(result = message.startsWith("data: ") ? message.substring(6) : message), (String)"$.choices[0].delta")) continue;
                String role = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.role", String.class);
                if (StringUtils.endsWithIgnoreCase((CharSequence)role, (CharSequence)"tool")) {
                    JSONObject webBrowser;
                    JSONArray outputs;
                    String type = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.tool_calls[0].type", String.class);
                    if (!StringUtils.endsWithIgnoreCase((CharSequence)"web_browser", (CharSequence)type)) continue;
                    String input = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.tool_calls[0].web_browser.input", String.class);
                    if (!StringUtils.isEmpty((CharSequence)input)) {
                        if (input.matches("msearch(.*)")) {
                            res.put("input", (Object)input);
                        }
                        if (input.matches("mclick(.*)")) {
                            res.put("reader_info", (Object)input);
                        }
                    }
                    if ((outputs = (webBrowser = (JSONObject)JSONPath.read((String)result, (String)"$.choices[0].delta.tool_calls[0].web_browser", JSONObject.class)).getJSONArray("outputs")) == null || outputs.isEmpty()) continue;
                    if (outputs.size() == 1) {
                        res.getJSONArray("read_urls").addAll((Collection)outputs);
                        continue;
                    }
                    res.getJSONArray("search_urls").addAll((Collection)outputs);
                    continue;
                }
                if (!StringUtils.endsWithIgnoreCase((CharSequence)role, (CharSequence)"assistant") || !StringUtils.endsWithIgnoreCase((CharSequence)(msgStatus = (String)JSONPath.read((String)result, (String)"$.status", String.class)), (CharSequence)"in_process")) continue;
                String content = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.content", String.class);
                sb.append(content);
            }
            res.put("content", (Object)sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u667a\u8c31AI\u641c\u7d22 UnsupportedEncodingException error:{}", (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error("\u667a\u8c31AI\u641c\u7d22 IOException error:{}", (Object)e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    logger.error("\u667a\u8c31AI\u641c\u7d22 IOException error:{}", (Object)e.getMessage());
                }
            }
        }
        return res;
    }

    private JSONObject handleRequestParams(Map<String, String> param) {
        String query = param.get("query");
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new KDBizException(ResManager.loadKDString((String)"query\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ZhiPuAISearchAction_2", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        JSONObject data = new JSONObject();
        data.put("assistant_id", (Object)AI_ASSISTANT_ID);
        data.put("model", (Object)"glm-4-assistant");
        data.put("stream", (Object)Boolean.TRUE);
        JSONArray messages = new JSONArray();
        JSONObject message = new JSONObject();
        message.put("role", (Object)"user");
        JSONArray content = new JSONArray();
        JSONObject contentItem = new JSONObject();
        contentItem.put("type", (Object)"text");
        contentItem.put("text", (Object)query);
        content.add((Object)contentItem);
        message.put("content", (Object)content);
        messages.add((Object)message);
        data.put("messages", (Object)messages);
        return data;
    }
}

