/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.hander;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.model.FormDataEntity;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.openapi.v3.models.HttpMethod;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Parameter;
import kd.ai.gai.core.agent.tool.util.HttpXmlUtils;
import kd.ai.gai.core.agent.tool.util.MultiPartStringParser;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseHandler {
    private static final Log logger = LogFactory.getLog(BaseHandler.class);
    private static int default_connectionTimeout = 5;
    private static int default_readTimeout = 60;
    private int connectionTimeout = default_connectionTimeout;
    private int readTimeout = default_readTimeout;

    public void preHandler(JSONObject toolParams, OperationParam operationParam, Map<String, String> headerParamsMap, Map<String, Object> queryParamsMap, Map<String, Object> pathParamsMap) {
        String operationId = toolParams.getString("operationId");
        logger.info("\u5904\u7406\u7b2c\u4e09\u65b9\u5de5\u5177\u63a5\u53e3\u65b9\u6cd5({})", (Object)operationId);
        String server = operationParam.getServer();
        String path = operationParam.getPath();
        String method = operationParam.getMethod();
        logger.info("\u5904\u7406\u7b2c\u4e09\u65b9\u5de5\u5177\u63a5\u53e3server:{},path:{},method:{}", new Object[]{server, path, method});
        JSONArray inputParameters = toolParams.getJSONArray("parameters");
        logger.info("\u5904\u7406\u7b2c\u4e09\u65b9\u5de5\u5177\u63a5\u53e3\u8f93\u5165\u53c2\u6570({})", (Object)JSONObject.toJSONString((Object)inputParameters));
        List<Parameter> parameters = operationParam.getParameters();
        Map<String, Object> defaultValueMap = this.handlerDefaultValue(parameters);
        HashMap<String, Object> inputParameterValueMap = new HashMap<String, Object>(inputParameters.size());
        if (inputParameters != null && !inputParameters.isEmpty()) {
            for (int i = 0; i < inputParameters.size(); ++i) {
                JSONObject parameter = inputParameters.getJSONObject(i);
                Object value = parameter.get((Object)"value");
                String paramName = parameter.getString("name");
                if (value == null && defaultValueMap.containsKey(paramName)) {
                    inputParameterValueMap.put(paramName, defaultValueMap.get(paramName));
                    continue;
                }
                inputParameterValueMap.put(paramName, value);
            }
        }
        JSONArray commonHeaders = toolParams.getJSONArray("headers");
        this.handlerParameters(parameters, inputParameterValueMap, headerParamsMap, queryParamsMap, pathParamsMap, commonHeaders);
    }

    private Map<String, Object> handlerDefaultValue(List<Parameter> parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (parameters != null && !parameters.isEmpty()) {
            parameters.stream().forEach(e -> map.put(e.getName(), e.getDefaultValue()));
        }
        return map;
    }

    public JSONObject buildRequestData(JSONObject toolParams, OperationParam operationParam) {
        JSONObject requestBody = toolParams.getJSONObject("requestBody");
        JSONObject data = new JSONObject();
        if (requestBody != null) {
            String contentType = requestBody.getString("contentType");
            JSONArray bodyCommonParams = toolParams.getJSONArray("bodyParamList");
            String body = requestBody.getString("body");
            if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_JSON.getType())) {
                body = this.handlerRequestBodyCommonParams(body, bodyCommonParams);
            }
            data.put("contentType", (Object)contentType);
            data.put("body", (Object)body);
        }
        logger.info("###RequestBody:{}", (Object)JSONObject.toJSONString((Object)data));
        return data;
    }

    private String handlerRequestBodyCommonParams(String bodyJson, JSONArray bodyCommonParams) {
        if (bodyCommonParams == null || bodyCommonParams.isEmpty()) {
            return bodyJson;
        }
        Map<String, String> bodyParamMap = this.transformBodyParams(bodyCommonParams);
        Object item = JSON.parse((String)bodyJson);
        String resJson = null;
        if (item instanceof JSONObject) {
            JSONObject objItem = (JSONObject)item;
            resJson = this.handleObjectJSON(bodyParamMap, objItem);
        } else if (item instanceof JSONArray) {
            JSONArray array = (JSONArray)item;
            resJson = this.handleArrayJSON(bodyParamMap, array);
        }
        return resJson;
    }

    private String handleObjectJSON(Map<String, String> bodyParamMap, JSONObject objItem) {
        if (bodyParamMap != null && !bodyParamMap.isEmpty()) {
            for (Map.Entry<String, String> param : bodyParamMap.entrySet()) {
                String paramName = param.getKey();
                String paramValue = param.getValue();
                if (objItem.containsKey((Object)paramName) && !ObjectUtils.isEmpty((Object)objItem.get((Object)paramName))) continue;
                objItem.put(paramName, (Object)paramValue);
            }
        }
        return JSONObject.toJSONString((Object)objItem);
    }

    private String handleArrayJSON(Map<String, String> bodyParamMap, JSONArray array) {
        if (bodyParamMap != null && !bodyParamMap.isEmpty()) {
            for (Map.Entry<String, String> param : bodyParamMap.entrySet()) {
                String paramName = param.getKey();
                String paramValue = param.getValue();
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject objItem = array.getJSONObject(i);
                    if (objItem.containsKey((Object)paramName) && !ObjectUtils.isEmpty((Object)objItem.get((Object)paramName))) continue;
                    objItem.put(paramName, (Object)paramValue);
                }
            }
        }
        return JSONObject.toJSONString((Object)array);
    }

    private Map<String, String> transformBodyParams(JSONArray bodyCommonParams) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (bodyCommonParams != null && !bodyCommonParams.isEmpty()) {
            for (int i = 0; i < bodyCommonParams.size(); ++i) {
                JSONObject param = bodyCommonParams.getJSONObject(i);
                String paramName = param.getString("paramName");
                String value = param.getString("paramValue");
                data.put(paramName, value);
            }
        }
        return data;
    }

    private void handlerParameters(List<Parameter> parameters, final Map<String, Object> inputParameterValueMap, final Map<String, String> headerParamsMap, final Map<String, Object> queryParamsMap, final Map<String, Object> pathParamsMap, JSONArray commonHeaders) {
        parameters.stream().forEach(new Consumer<Parameter>(){

            @Override
            public void accept(Parameter parameter) {
                String in = parameter.getIn();
                String name = parameter.getName();
                if (!StringUtils.isEmpty((CharSequence)name)) {
                    name = name.trim();
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)in, (CharSequence)ToolConstant.OpenAPIConstant.In.HEADER.getValue())) {
                    String value = String.valueOf(inputParameterValueMap.get(name));
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        headerParamsMap.put(name, value);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)in, (CharSequence)ToolConstant.OpenAPIConstant.In.QUERY.getValue())) {
                    queryParamsMap.put(name, inputParameterValueMap.get(name));
                } else if (StringUtils.equalsIgnoreCase((CharSequence)in, (CharSequence)ToolConstant.OpenAPIConstant.In.PATH.getValue())) {
                    pathParamsMap.put(name, inputParameterValueMap.get(name));
                }
            }
        });
        if (commonHeaders != null && !commonHeaders.isEmpty()) {
            for (int i = 0; i < commonHeaders.size(); ++i) {
                JSONObject header = commonHeaders.getJSONObject(i);
                String key = header.getString("key");
                if (!StringUtils.isEmpty((CharSequence)key)) {
                    key = key.trim();
                }
                String value = header.getString("value");
                headerParamsMap.put(key, value);
            }
        }
    }

    public String buildUrl(String server, String path, Map<String, Object> pathParamsMap, Map<String, Object> queryParamsMap) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(StringUtils.isEmpty((CharSequence)server) ? "" : server).append(StringUtils.isEmpty((CharSequence)path) ? "" : path);
        String url = urlBuilder.toString();
        if (!pathParamsMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : pathParamsMap.entrySet()) {
                String pathParamName = entry.getKey();
                Object obj = entry.getValue();
                String value = ObjectUtils.isEmpty((Object)obj) ? "" : (String)obj;
                url = url.replaceAll(String.format("\\{\\s*%s\\s*\\}", pathParamName), value);
            }
        }
        logger.info("\u89e3\u6790\u63a5\u53e3URL:{}", (Object)url);
        ArrayList<String> querys = new ArrayList<String>(1);
        try {
            URI uri = new URI(url);
            String query = uri.getQuery();
            if (!StringUtils.isEmpty((CharSequence)query)) {
                querys.add(query);
            }
            for (Map.Entry<String, Object> queryParam : queryParamsMap.entrySet()) {
                String queryParamName = queryParam.getKey();
                String queryParamValue = String.valueOf(queryParam.getValue());
                String encoderStr = URLEncoder.encode(queryParamValue, "utf-8");
                querys.add(String.format("%s=%s", queryParamName, encoderStr));
            }
        }
        catch (URISyntaxException e) {
            logger.error("\u89e3\u6790\u63a5\u53e3URL\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u89e3\u6790\u63a5\u53e3URL\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        if (querys.isEmpty()) {
            return url;
        }
        if (url.contains("?")) {
            String preUrl = url.substring(0, url.lastIndexOf("?"));
            return String.format("%s?%s", preUrl.trim(), StringUtils.join(querys, (String)"&"));
        }
        return String.format("%s?%s", url.trim(), StringUtils.join(querys, (String)"&"));
    }

    public BaseResult sendGetRequest(String server, String path, String method, Map<String, String> headerParamsMap, Map<String, Object> queryParamsMap, Map<String, Object> pathParamsMap, JSONObject data) {
        String result = null;
        String errorMsg = null;
        try {
            String bodyStr;
            String url = this.buildUrl(server, path, pathParamsMap, queryParamsMap);
            logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177URL:{},method:{},headerParams:{},queryParams:{}", new Object[]{url, method, headerParamsMap, queryParamsMap});
            Map body = new HashMap();
            if (data != null && !data.isEmpty() && !StringUtils.isEmpty((CharSequence)(bodyStr = data.getString("body")))) {
                body = (Map)JSONObject.parseObject((String)bodyStr, Map.class);
            }
            result = HttpClientUtils.get((String)url, headerParamsMap, body, (int)(this.connectionTimeout * 1000), (int)(this.readTimeout * 1000));
        }
        catch (Exception e) {
            errorMsg = String.format("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:%s", e.getMessage());
            logger.error(errorMsg);
            return BaseHandler.handlerErrorResult(errorMsg);
        }
        return BaseHandler.handlerResult(result, errorMsg);
    }

    public BaseResult sendDeleteRequest(String server, String path, String method, Map<String, String> headerParamsMap, Map<String, Object> queryParamsMap, Map<String, Object> pathParamsMap, JSONObject data) {
        String result = null;
        String errorMsg = null;
        try {
            String bodyStr;
            String url = this.buildUrl(server, path, pathParamsMap, queryParamsMap);
            logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177URL:{},method:{},headerParams:{},queryParams:{}", new Object[]{url, method, headerParamsMap, queryParamsMap});
            Map<String, Object> body = new HashMap<String, Object>();
            if (data != null && !data.isEmpty() && !StringUtils.isEmpty((CharSequence)(bodyStr = data.getString("body")))) {
                body = (Map)JSONObject.parseObject((String)bodyStr, Map.class);
            }
            result = HttpXmlUtils.delete(url, headerParamsMap, body, this.connectionTimeout * 1000, this.readTimeout * 1000);
        }
        catch (Exception e) {
            errorMsg = String.format("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:%s", e.getMessage());
            logger.error(errorMsg);
            return BaseHandler.handlerErrorResult(errorMsg);
        }
        return BaseHandler.handlerResult(result, errorMsg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseResult sendPostRequest(String server, String path, String method, Map<String, String> headerParamsMap, Map<String, Object> queryParamsMap, Map<String, Object> pathParamsMap, JSONObject data) {
        String result = null;
        String errorMsg = null;
        try {
            String url = this.buildUrl(server, path, pathParamsMap, queryParamsMap);
            logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177URL:{},method:{},headerParams:{},queryParams:{}", new Object[]{url, method, headerParamsMap, queryParamsMap});
            if (data != null && !data.isEmpty()) {
                String body = data.getString("body");
                String contentType = data.getString("contentType");
                if (StringUtils.isEmpty((CharSequence)contentType)) {
                    return BaseResult.fail("\u8bf7\u6c42\u7684requestBody\u4e2d\u53c2\u6570contentType\u7684\u503c\u4e3a\u7a7a");
                }
                logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177URL:{},contentType:{},method:{},body:{}", new Object[]{url, contentType, method, body});
                if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.X_WWW_FORM_URLENCODED.getType())) {
                    Map<String, Object> urlBody = BaseHandler.handlerHttpWwwFormBody(body);
                    result = HttpXmlUtils.post(url, headerParamsMap, urlBody, this.connectionTimeout * 1000, this.readTimeout * 1000);
                    return BaseHandler.handlerResult(result, errorMsg);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_JSON.getType())) {
                    result = HttpXmlUtils.postApplicationJSON(url, headerParamsMap, body, this.connectionTimeout * 1000, this.readTimeout * 1000);
                    return BaseHandler.handlerResult(result, errorMsg);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.MULTIPART_FORM_DATA.getType())) {
                    List<HttpClientUtils.FormDataEntity> entities = this.transforms(body);
                    result = HttpClientUtils.postFormData((String)url, headerParamsMap, entities, (int)(this.connectionTimeout * 1000), (int)(this.readTimeout * 1000));
                    return BaseHandler.handlerResult(result, errorMsg);
                } else {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_XML.getType())) return BaseResult.fail(String.format("\u6682\u4e0d\u652f\u6301contentType\u4e3a%s\u7684\u8bf7\u6c42", contentType));
                    result = HttpXmlUtils.postXmlRequest(url, headerParamsMap, body, this.connectionTimeout * 1000, this.readTimeout * 1000);
                }
                return BaseHandler.handlerResult(result, errorMsg);
            } else {
                result = HttpXmlUtils.post(url, headerParamsMap, new HashMap<String, Object>(), this.connectionTimeout * 1000, this.readTimeout * 1000);
            }
            return BaseHandler.handlerResult(result, errorMsg);
        }
        catch (KDBizException e) {
            errorMsg = e.getMessage();
            logger.error(errorMsg);
            return BaseHandler.handlerErrorResult(errorMsg);
        }
        catch (Exception e) {
            errorMsg = String.format("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:%s", e.getMessage());
            logger.error(errorMsg);
            return BaseHandler.handlerErrorResult(errorMsg);
        }
    }

    private static Map<String, Object> handlerHttpWwwFormBody(String encodedStr) {
        String[] pairs;
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String pair : pairs = encodedStr.split("&")) {
            int idx = pair.indexOf("=");
            try {
                String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : "";
                params.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("UTF-8 is not supported ,{}", (Object)e.getMessage());
            }
        }
        return params;
    }

    private List<HttpClientUtils.FormDataEntity> transforms(String body) {
        ArrayList<HttpClientUtils.FormDataEntity> datas = new ArrayList<HttpClientUtils.FormDataEntity>();
        try {
            MultiPartStringParser parser = new MultiPartStringParser(body);
            Map<String, FormDataEntity> parameters = parser.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, FormDataEntity> param : parameters.entrySet()) {
                    HttpClientUtils.FormDataEntity formDataEntity;
                    String key = param.getKey();
                    FormDataEntity entity = param.getValue();
                    FormDataEntity.FormType formType = entity.getFormType();
                    if (FormDataEntity.FormType.STRING == formType) {
                        formDataEntity = new HttpClientUtils.FormDataEntity(key, entity.getValueString());
                        datas.add(formDataEntity);
                        continue;
                    }
                    if (FormDataEntity.FormType.FILE != formType) continue;
                    formDataEntity = new HttpClientUtils.FormDataEntity(key, entity.getValueInputStream(), entity.getFileName());
                    datas.add(formDataEntity);
                }
            }
        }
        catch (Exception e) {
            String errorMsg = String.format("\u89e3\u6790Http ContentType\u4e3amultipart/form-data\u65f6\u7684\u8bf7\u6c42\u4f53\u51fa\u9519,%s", e.getMessage());
            logger.error(errorMsg);
            throw new KDBizException(errorMsg);
        }
        return datas;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseResult sendPutRequest(String server, String path, String method, Map<String, String> headerParamsMap, Map<String, Object> queryParamsMap, Map<String, Object> pathParamsMap, JSONObject data) {
        String result = null;
        String errorMsg = null;
        try {
            String url = this.buildUrl(server, path, pathParamsMap, queryParamsMap);
            logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177URL:{},method:{},headerParams:{},queryParams:{}", new Object[]{url, method, headerParamsMap, queryParamsMap});
            if (data != null && !data.isEmpty()) {
                String body = data.getString("body");
                String contentType = data.getString("contentType");
                if (StringUtils.isEmpty((CharSequence)contentType)) {
                    return BaseResult.fail("\u8bf7\u6c42\u7684requestBody\u4e2d\u53c2\u6570contentType\u7684\u503c\u4e3a\u7a7a");
                }
                logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177URL:{},contentType:{},method:{},body:{}", new Object[]{url, contentType, method, body});
                if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.X_WWW_FORM_URLENCODED.getType())) {
                    Map<String, Object> urlBody = BaseHandler.handlerHttpWwwFormBody(body);
                    result = HttpXmlUtils.put(url, headerParamsMap, urlBody, this.connectionTimeout * 1000, this.readTimeout * 1000);
                    return BaseHandler.handlerResult(result, errorMsg);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_JSON.getType())) {
                    result = HttpXmlUtils.putApplicationJSON(url, headerParamsMap, body, this.connectionTimeout * 1000, this.readTimeout * 1000);
                    return BaseHandler.handlerResult(result, errorMsg);
                } else {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_XML.getType())) return BaseResult.fail(String.format("\u6682\u4e0d\u652f\u6301contentType\u4e3a%s\u7684\u8bf7\u6c42", contentType));
                    result = HttpXmlUtils.putXmlRequest(url, headerParamsMap, body, this.connectionTimeout * 1000, this.readTimeout * 1000);
                }
                return BaseHandler.handlerResult(result, errorMsg);
            } else {
                result = HttpXmlUtils.put(url, headerParamsMap, new HashMap<String, Object>());
            }
            return BaseHandler.handlerResult(result, errorMsg);
        }
        catch (Exception e) {
            errorMsg = String.format("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:%s", e.getMessage());
            logger.error(errorMsg);
            return BaseHandler.handlerErrorResult(errorMsg);
        }
    }

    public BaseResult sendCall(String server, String path, String method, Map<String, String> headerParamsMap, Map<String, Object> queryParamsMap, Map<String, Object> pathParamsMap, JSONObject data) {
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)HttpMethod.GET.toString())) {
            return this.sendGetRequest(server, path, method, headerParamsMap, queryParamsMap, pathParamsMap, data);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)HttpMethod.POST.toString())) {
            return this.sendPostRequest(server, path, method, headerParamsMap, queryParamsMap, pathParamsMap, data);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)HttpMethod.DELETE.toString())) {
            return this.sendDeleteRequest(server, path, method, headerParamsMap, queryParamsMap, pathParamsMap, data);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)HttpMethod.PUT.toString())) {
            return this.sendPutRequest(server, path, method, headerParamsMap, queryParamsMap, pathParamsMap, data);
        }
        return BaseResult.fail(String.format("\u6682\u4e0d\u652f\u6301Http %s\u8bf7\u6c42\u65b9\u6cd5", method));
    }

    private static BaseResult handlerResult(String result, String errorMsg) {
        JSONObject data = new JSONObject();
        logger.info("\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177\u63a5\u53e3\u8fd4\u56de:{}", (Object)result);
        if (StringUtils.isEmpty((CharSequence)result)) {
            if (StringUtils.isEmpty((CharSequence)errorMsg)) {
                errorMsg = "\u8c03\u7528\u7b2c\u4e09\u65b9\u5de5\u5177\u5931\u8d25\uff0c\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u7801\u975e200";
            }
            data.put("output", (Object)"");
            BaseResult br = BaseResult.fail(errorMsg);
            br.setData(data);
            return br;
        }
        data.put("output", (Object)result);
        return new BaseResult(data);
    }

    private static BaseResult handlerErrorResult(String errorMsg) {
        JSONObject data = new JSONObject();
        data.put("output", (Object)"");
        BaseResult br = BaseResult.fail(errorMsg);
        br.setData(data);
        return br;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

