/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.hander;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.hander.BaseHandler;
import kd.ai.gai.core.agent.tool.hander.IOpenAPIHandler;
import kd.ai.gai.core.agent.tool.model.APIParam;
import kd.ai.gai.core.agent.tool.model.CosmicAccessTokenAuthConfig;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class CosmicAccessTokenAuthHandler
extends BaseHandler
implements IOpenAPIHandler {
    private static final Log logger = LogFactory.getLog(CosmicAccessTokenAuthHandler.class);

    @Override
    public BaseResult call(APIParam params) {
        logger.info("\u5904\u7406\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177\u82cd\u7a79AccessToken\u9274\u6743\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)params));
        JSONObject toolParams = params.getToolParams();
        OperationParam operationParam = params.getOperationParam();
        HashMap<String, String> headerParamsMap = new HashMap<String, String>();
        HashMap<String, Object> queryParamsMap = new HashMap<String, Object>();
        HashMap<String, Object> pathParamsMap = new HashMap<String, Object>();
        String toolType = params.getToolType();
        logger.info("toolType:{}", (Object)toolType);
        Integer timeout = params.getTimeout();
        this.setReadTimeout(timeout);
        this.preHandler(toolParams, operationParam, headerParamsMap, queryParamsMap, pathParamsMap);
        CosmicAccessTokenAuthConfig config = (CosmicAccessTokenAuthConfig)params.getConfig();
        String clientId = config.getClient_id();
        String clientSecret = config.getClient_secret();
        String accountId = config.getAccountId();
        String username = config.getUsername();
        String tokenUrl = config.getTokenUrl();
        logger.info("tokenUrl:{}", (Object)tokenUrl);
        String accessToken = null;
        StringBuilder sb = new StringBuilder();
        if (tokenUrl.endsWith("api/login.do") || tokenUrl.indexOf("api/login.do") != -1) {
            logger.info("\u4f7f\u7528\u82cd\u7a796.0\u4ee5\u4e0b\u7248\u672c\u7684OpenAPI.");
            accessToken = CosmicAccessTokenAuthHandler.getAccessTokenByAppToken(sb, tokenUrl, clientId, clientSecret, accountId, username);
        } else if (tokenUrl.endsWith("oauth2/getToken") || tokenUrl.indexOf("oauth2/getToken") != -1) {
            logger.info("\u4f7f\u7528\u82cd\u7a796.0\u4ee5\u4e0a\u7248\u672c\u7684OpenAPI.");
            accessToken = CosmicAccessTokenAuthHandler.getAccessToken(tokenUrl, clientId, clientSecret, accountId, username);
        } else {
            accessToken = CosmicAccessTokenAuthHandler.getAccessToken(tokenUrl, clientId, clientSecret, accountId, username);
        }
        if (!StringUtils.isEmpty((CharSequence)accessToken)) {
            headerParamsMap.put("accesstoken", accessToken);
            String server = operationParam.getServer();
            String path = operationParam.getPath();
            String method = operationParam.getMethod();
            JSONObject data = this.buildRequestData(toolParams, operationParam);
            BaseResult br = this.sendCall(server, path, method, headerParamsMap, queryParamsMap, pathParamsMap, data);
            JSONObject resdata = (JSONObject)br.getData();
            String output = resdata.getString("output");
            if (StringUtils.isEmpty((CharSequence)output)) {
                BaseResult baseResult = BaseResult.fail("OpenAPI\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                JSONObject dataJo = new JSONObject();
                dataJo.put("output", (Object)"");
                baseResult.setData(dataJo);
                return baseResult;
            }
            JSONObject res = JSONObject.parseObject((String)output);
            String errCode = res.getString("errorCode");
            logger.info("\u8c03\u7528\u82cd\u7a79OpenAPI\u8fd4\u56deerrcode:{}", (Object)errCode);
            if (!StringUtils.equalsIgnoreCase((CharSequence)errCode, (CharSequence)"0")) {
                String errorMsg = res.getString("message");
                BaseResult baseResult = BaseResult.fail(errorMsg);
                JSONObject dataJo = new JSONObject();
                dataJo.put("output", (Object)"");
                baseResult.setData(dataJo);
                baseResult.setErrCode(errCode);
                return baseResult;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType())) {
                JSONObject dataJo = new JSONObject();
                dataJo.put("output", (Object)output);
                br.setData(dataJo);
            } else {
                Object cosmicData = res.get((Object)"data");
                JSONObject dataJo = new JSONObject();
                dataJo.put("output", (Object)JSONObject.toJSONString((Object)cosmicData));
                br.setData(dataJo);
            }
            return br;
        }
        String errMsg = sb.toString();
        return BaseResult.fail(String.format("\u8c03\u7528\u7b2c\u4e09\u65b9OpenAPI\u63a5\u53e3,\u901a\u8fc7\u82cd\u7a79AccessToken\u9274\u6743\u83b7\u53d6accessToken\u5931\u8d25,clientId(%s),%s", clientId, errMsg));
    }

    public static String getAccessToken(String tokenUrl, String clientId, String clientSecret, String accountId, String username) {
        String accessToken = null;
        try {
            logger.info("get cosmic access token ,url:{},clientId:{},username:{},accountId:{}", new Object[]{tokenUrl, clientId, username, accountId});
            HashMap<String, String> queryParamsMap = new HashMap<String, String>();
            queryParamsMap.put("client_id", clientId);
            queryParamsMap.put("client_secret", clientSecret);
            queryParamsMap.put("accountId", accountId);
            queryParamsMap.put("username", username);
            queryParamsMap.put("nonce", RandomStringUtils.randomAlphabetic((int)8));
            queryParamsMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
            String result = HttpClientUtils.postAppJson((String)tokenUrl, new HashMap(), queryParamsMap);
            logger.info("get access token response:{}", (Object)result);
            if (!StringUtils.isEmpty((CharSequence)result)) {
                JSONObject data;
                JSONObject response = JSONObject.parseObject((String)result);
                String errCode = response.getString("errorCode");
                if (Errors.OK.getCode().equalsIgnoreCase(errCode) && (data = response.getJSONObject("data")) != null) {
                    accessToken = data.getString("access_token");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177\u82cd\u7a79AccessToken\u9274\u6743\u63a5\u53e3\u83b7\u53d6AccessToken\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        return accessToken;
    }

    public static String getAccessTokenByAppToken(StringBuilder sb, String tokenUrl, String clientId, String clientSecret, String accountId, String username) {
        String accessToken = null;
        try {
            String appTokenPrefix = tokenUrl.substring(0, tokenUrl.indexOf("api/login.do"));
            String appTokenUrl = String.format("%s%s", appTokenPrefix, "api/getAppToken.do");
            logger.info("appTokenPrefix:{},appTokenUrl:{}", (Object)appTokenPrefix, (Object)appTokenUrl);
            String appToken = CosmicAccessTokenAuthHandler.getAppToken(sb, appTokenUrl, clientId, clientSecret, accountId);
            if (StringUtils.isBlank((CharSequence)appToken)) {
                logger.info("get app token error.");
            } else {
                logger.info("get cosmic access token by app token ,url:{},clientId:{},username:{},accountId:{},appToken:{}", new Object[]{tokenUrl, clientId, username, accountId, appToken});
                HashMap<String, String> queryParamsMap = new HashMap<String, String>();
                queryParamsMap.put("user", username);
                queryParamsMap.put("usertype", "UserName");
                queryParamsMap.put("apptoken", appToken);
                queryParamsMap.put("accountId", accountId);
                String result = HttpClientUtils.postAppJson((String)tokenUrl, new HashMap(), queryParamsMap);
                logger.info("get access token by app token response:{}", (Object)result);
                if (!StringUtils.isEmpty((CharSequence)result)) {
                    JSONObject response = JSONObject.parseObject((String)result);
                    String state = response.getString("state");
                    if ("success".equalsIgnoreCase(state)) {
                        JSONObject data = response.getJSONObject("data");
                        if (data != null) {
                            accessToken = data.getString("access_token");
                        }
                    } else {
                        String errorMsg = response.getString("errorMsg");
                        logger.info("get access token by app token error,msg :{}", (Object)errorMsg);
                        sb.append(errorMsg);
                    }
                }
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage());
            logger.error("\u8c03\u7528\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177\u82cd\u7a79AccessToken\u9274\u6743\u63a5\u53e3\u83b7\u53d6AccessToken\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        return accessToken;
    }

    public static String getAppToken(StringBuilder sb, String appTokenUrl, String clientId, String clientSecret, String accountId) {
        String appToken = null;
        try {
            logger.info("get app token url :{},clientId :{},accountId :{}", new Object[]{appTokenUrl, clientId, accountId});
            HashMap<String, String> queryParamsMap = new HashMap<String, String>();
            queryParamsMap.put("appId", clientId);
            queryParamsMap.put("appSecret", clientSecret);
            queryParamsMap.put("accountId", accountId);
            String result = HttpClientUtils.postAppJson((String)appTokenUrl, new HashMap(), queryParamsMap);
            logger.info("get app token response:{}", (Object)result);
            if (!StringUtils.isEmpty((CharSequence)result)) {
                JSONObject response = JSONObject.parseObject((String)result);
                String state = response.getString("state");
                if ("success".equalsIgnoreCase(state)) {
                    JSONObject data = response.getJSONObject("data");
                    if (data != null) {
                        appToken = data.getString("app_token");
                    }
                } else {
                    String errorMsg = response.getString("errorMsg");
                    logger.info("get app token error,msg :{}", (Object)errorMsg);
                    sb.append(errorMsg);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177\u82cd\u7a79AccessToken\u9274\u6743\u63a5\u53e3\u83b7\u53d6AppToken\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            sb.append(e.getMessage());
        }
        return appToken;
    }
}

