/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.mcp.client;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.ai.mcp.client.McpClient;
import kd.ai.mcp.client.McpSyncClient;
import kd.ai.mcp.spec.McpClientTransport;
import kd.ai.mcp.spec.McpSchema;

public abstract class AbstractMcpSyncClient {
    protected abstract McpClientTransport createMcpTransport(String var1, String var2, Map<String, String> var3);

    protected void onStart() {
    }

    protected void onClose() {
    }

    protected Duration getRequestTimeout() {
        return Duration.ofSeconds(60L);
    }

    protected Duration getInitializationTimeout() {
        return Duration.ofSeconds(2L);
    }

    McpSyncClient client(McpClientTransport transport) {
        return this.client(transport, Function.identity());
    }

    McpSyncClient client(McpClientTransport transport, Function<McpClient.SyncSpec, McpClient.SyncSpec> customizer) {
        AtomicReference<McpSyncClient> client = new AtomicReference<McpSyncClient>();
        McpClient.SyncSpec builder = McpClient.sync((McpClientTransport)transport).requestTimeout(this.getRequestTimeout()).initializationTimeout(this.getInitializationTimeout()).capabilities(new McpSchema.ClientCapabilities(null, new McpSchema.ClientCapabilities.RootsCapabilities(true), null));
        builder = customizer.apply(builder);
        client.set(builder.build());
        return (McpSyncClient)client.get();
    }

    public void withClient(McpClientTransport transport, Consumer<McpSyncClient> c) {
        this.withClient(transport, Function.identity(), c);
    }

    void withClient(McpClientTransport transport, Function<McpClient.SyncSpec, McpClient.SyncSpec> customizer, Consumer<McpSyncClient> c) {
        McpSyncClient client = this.client(transport, customizer);
        c.accept(client);
    }
}

