/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import kd.bos.base.utils.BaseFontSingleton;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ImageParam {
    private static final Log logger = LogFactory.getLog(ImageParam.class);
    private static final int DEFAULT_WIDTH = 68;
    private static final int DEFAULT_HEIGHT = 68;
    private static final String DEFAULT_FORMAT = "png";
    private static final int CHINESE_FONT_SIZE = 32;
    private static final int OTHER_FONT_SIZE = 40;
    private static final String CHINESE_REGEX = "[\u4e00-\u9fa5]";
    private static final String FOLDER_IMAGES = "images";
    private static final String EXTENSION_PNG = ".png";
    private static final String FILE_NAME_SEPARATOR = "-";
    private static final String[] UUID_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".split("");
    public static final String FILE_PATH_SEPARATOR = "/";
    private static final ColorPair[] COLOR_PAIRS = new ColorPair[]{new ColorPair(new Color(248, 13, 88), new Color(255, 237, 240)), new ColorPair(new Color(248, 96, 33), new Color(255, 244, 235)), new ColorPair(new Color(249, 153, 29), new Color(255, 250, 237)), new ColorPair(new Color(49, 185, 177), new Color(233, 252, 247)), new ColorPair(new Color(52, 176, 241), new Color(235, 251, 255)), new ColorPair(new Color(40, 111, 245), new Color(235, 244, 255)), new ColorPair(new Color(34, 95, 217), new Color(234, 245, 255)), new ColorPair(new Color(112, 29, 240), new Color(247, 238, 255))};
    private String path;
    private int width = 68;
    private int height = 68;
    private String writing;
    private ColorPair colorPair;
    private String formatName = "png";
    private boolean createNewFileWhenExists;
    private final SecureRandom secureRandom = new SecureRandom();

    public static Optional<String> createImages(String text, String formNumber) {
        try {
            ImageParam imageParam = ImageParam.buildImageParam(text, formNumber);
            imageParam.uploadImage();
            return Optional.ofNullable(imageParam.getPath());
        }
        catch (Exception e) {
            logger.error("Failed to create avatar: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public static ImageParam buildImageParam(String text, String formNumber) {
        text = ImageParam.removeSymbols(text);
        ImageParam imageParam = new ImageParam();
        String folder = ImageParam.getImageAbstractFolder(formNumber);
        imageParam.setPath(folder + FILE_NAME_SEPARATOR + ImageParam.generateShortUUID() + EXTENSION_PNG);
        imageParam.setWriting(text);
        imageParam.setCreateNewFileWhenExists(true);
        return imageParam;
    }

    public static String removeSymbols(String input) {
        return input.replaceAll("[^a-zA-Z0-9\\u4E00-\\u9FA5]", "");
    }

    public void uploadImage() {
        try {
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            g2.setColor(this.getBackgroundColor());
            g2.fillRect(0, 0, this.getWidth(), this.getWidth());
            String text = this.getWriting();
            if (!StringUtils.isBlank((CharSequence)text)) {
                g2.setFont(this.getWritingFont());
                g2.setColor(this.getWritingColor());
                FontRenderContext context = g2.getFontRenderContext();
                Rectangle2D bounds = this.getWritingFont().getStringBounds(text, context);
                int x = (int)(((double)this.getWidth() - bounds.getWidth()) / 2.0);
                int y = (int)(((double)this.getHeight() - bounds.getHeight()) / 2.0 - bounds.getY());
                g2.drawString(text, x, y);
            }
            g2.dispose();
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, this.getFormatName(), bs);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bs.toByteArray());
            FileItem fileItem = new FileItem(this.getName(), this.getPath(), (InputStream)inputStream);
            fileItem.setCreateNewFileWhenExists(this.isCreateNewFileWhenExists());
            FileService fileService = FileServiceFactory.getImageFileService();
            String fileServerPath = fileService.upload(fileItem);
            this.setPath(fileServerPath);
        }
        catch (IOException e) {
            logger.info("Failed to create and upload image: " + e.getMessage());
        }
    }

    private static String getImageAbstractFolder(String formNumber) {
        RequestContext context = RequestContext.get();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String date = sdf.format(new Date());
        return String.format("/%s/%s/%s/%s/%s", context.getTenantId(), context.getAccountId(), date, formNumber, FOLDER_IMAGES);
    }

    private static String generateShortUUID() {
        StringBuilder shortBuffer = new StringBuilder();
        String uuid = UUID.randomUUID().toString().replace(FILE_NAME_SEPARATOR, "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(UUID_CHARS[x % 62]);
        }
        return shortBuffer.toString();
    }

    public String getName() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            return "";
        }
        return this.path.endsWith(File.separator) ? StringUtils.substringAfterLast((String)this.path, (String)File.separator) : StringUtils.substringAfterLast((String)this.path, (String)FILE_PATH_SEPARATOR);
    }

    private ColorPair getRandomColorPair() {
        if (this.colorPair == null) {
            this.colorPair = COLOR_PAIRS[this.secureRandom.nextInt(COLOR_PAIRS.length)];
        }
        return this.colorPair;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getWriting() {
        return this.writing;
    }

    public void setWriting(String writing) {
        this.writing = this.extractImageText(writing);
    }

    public Font getWritingFont() {
        int fontSize = ImageParam.isChinese(this.writing) ? 32 : 40;
        return new Font(BaseFontSingleton.getFont().getChineseFont(), 0, fontSize);
    }

    private String extractImageText(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        return String.valueOf(name.trim().charAt(0));
    }

    private static boolean isChinese(String str) {
        return !StringUtils.isBlank((CharSequence)str) && str.matches(CHINESE_REGEX);
    }

    public Color getWritingColor() {
        return this.getRandomColorPair().getFontColor();
    }

    public Color getBackgroundColor() {
        return this.getRandomColorPair().getBackgroundColor();
    }

    public String getFormatName() {
        return this.formatName;
    }

    public boolean isCreateNewFileWhenExists() {
        return this.createNewFileWhenExists;
    }

    public void setCreateNewFileWhenExists(boolean createNewFileWhenExists) {
        this.createNewFileWhenExists = createNewFileWhenExists;
    }

    public String toString() {
        return "ImageParam{path='" + this.path + '\'' + ", width=" + this.width + ", height=" + this.height + ", writing='" + this.writing + '\'' + ", formatName='" + this.formatName + '\'' + ", createNewFileWhenExists=" + this.createNewFileWhenExists + '}';
    }

    private static class ColorPair {
        private final Color fontColor;
        private final Color backgroundColor;

        public ColorPair(Color fontColor, Color backgroundColor) {
            this.fontColor = fontColor;
            this.backgroundColor = backgroundColor;
        }

        public Color getFontColor() {
            return this.fontColor;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }
    }
}

