/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.tms;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import kd.ai.gai.core.agent.tool.tms.Sign;
import kd.ai.gai.core.agent.tool.tms.entity.ComplexDocExtractRequest;
import kd.ai.gai.core.agent.tool.util.HttpXmlUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.codec.binary.Hex;

public class LkeClient {
    private static final Log logger = LogFactory.getLog(LkeClient.class);
    public static final String protocol = "https://";
    public static final String path = "/";
    private static String endpoint = "lke.tencentcloudapi.com";
    private static String service = "lke";
    private static String version = "2023-11-30";
    private static String reqMethod = "POST";
    private static String action = "ReconstructDocument";
    private static String REGION_GUANGZHOU = "ap-guangzhou";
    public static final int TM_MINUTE = 60;
    private int readTimeout;
    private int writeTimeout;
    private int connTimeout;
    private String secretId;
    private String secretKey;
    private String region;

    public LkeClient(String secretId, String secretKey) {
        this(secretId, secretKey, REGION_GUANGZHOU, 0, 0, 60);
    }

    public LkeClient(String secretId, String secretKey, String region, int readTimeout, int writeTimeout, int connTimeout) {
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.connTimeout = connTimeout;
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.region = region;
    }

    public static String getEndpoint() {
        return endpoint;
    }

    public static void setEndpoint(String endpoint) {
        LkeClient.endpoint = endpoint;
    }

    public static String getService() {
        return service;
    }

    public static void setService(String service) {
        LkeClient.service = service;
    }

    public static String getVersion() {
        return version;
    }

    public static void setVersion(String version) {
        LkeClient.version = version;
    }

    public static String getReqMethod() {
        return reqMethod;
    }

    public static void setReqMethod(String reqMethod) {
        LkeClient.reqMethod = reqMethod;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private String getCanonicalQueryString(HashMap<String, String> params, String method) throws KDBizException {
        if (method != null && method.equals(reqMethod)) {
            return "";
        }
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String v;
            try {
                v = URLEncoder.encode(entry.getValue(), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new KDBizException("UTF8 is not supported." + e.getMessage());
            }
            queryString.append("&").append(entry.getKey()).append("=").append(v);
        }
        if (queryString.length() == 0) {
            return "";
        }
        return queryString.toString().substring(1);
    }

    public String complexDocExtract(ComplexDocExtractRequest req, int connectionTimeout, int readTimeout) throws KDBizException {
        String endpoint = "lke.tencentcloudapi.com";
        String res = this.complexDocExtract(endpoint, req, action, connectionTimeout, readTimeout);
        return res;
    }

    public String complexDocExtract(String endpoint, ComplexDocExtractRequest request, String actionName, int connectionTimeout, int readTimeout) throws KDBizException {
        String httpRequestMethod = LkeClient.getReqMethod();
        HashMap<String, String> params = new HashMap<String, String>();
        String jsonReq = JSONObject.toJSONString((Object)request);
        byte[] requestPayload = jsonReq.getBytes(StandardCharsets.UTF_8);
        String contentType = "application/json; charset=utf-8";
        String canonicalUri = path;
        String canonicalQueryString = this.getCanonicalQueryString(params, httpRequestMethod);
        String canonicalHeaders = "content-type:" + contentType + "\nhost:" + endpoint + "\n";
        String signedHeaders = "content-type;host";
        String hashedRequestPayload = Sign.sha256Hex(requestPayload);
        String canonicalRequest = httpRequestMethod + "\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date(Long.parseLong(timestamp + "000")));
        String service = endpoint.split("\\.")[0];
        String credentialScope = date + path + service + "/tc3_request";
        String hashedCanonicalRequest = Sign.sha256Hex(canonicalRequest.getBytes(StandardCharsets.UTF_8));
        String stringToSign = "TC3-HMAC-SHA256\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
        String secretId = this.getSecretId();
        String secretKey = this.getSecretKey();
        byte[] secretDate = Sign.hmac256(("TC3" + secretKey).getBytes(StandardCharsets.UTF_8), date);
        byte[] secretService = Sign.hmac256(secretDate, service);
        byte[] secretSigning = Sign.hmac256(secretService, "tc3_request");
        String signature = Hex.encodeHexString((byte[])Sign.hmac256(secretSigning, stringToSign)).toLowerCase();
        String authorization = "TC3-HMAC-SHA256 Credential=" + secretId + path + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", contentType);
        headers.put("Host", endpoint);
        headers.put("Authorization", authorization);
        headers.put("X-TC-Action", actionName);
        headers.put("X-TC-Timestamp", timestamp);
        headers.put("X-TC-Version", version);
        headers.put("X-TC-Region", this.getRegion());
        String url = protocol + endpoint + path;
        logger.info("complex doc extract url : {},headers : {} ", (Object)url, (Object)JSONObject.toJSONString(headers));
        String response = null;
        try {
            response = HttpXmlUtils.postApplicationJSON(url, headers, jsonReq, connectionTimeout, readTimeout);
        }
        catch (IOException e) {
            logger.error("\u8c03\u7528\u817e\u8baf\u590d\u6742\u6587\u6863\u8bc6\u522b\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new KDBizException("\u8c03\u7528\u817e\u8baf\u590d\u6742\u6587\u6863\u8bc6\u522b\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return response;
    }
}

