/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.tms;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.exception.KDBizException;
import org.apache.commons.codec.binary.Hex;

public class Sign {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    public static String sha256Hex(byte[] b) throws KDBizException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException("SHA-256 is not supported." + e.getMessage());
        }
        byte[] d = md.digest(b);
        return Hex.encodeHexString((byte[])d).toLowerCase();
    }

    public static byte[] hmac256(byte[] key, String msg) throws KDBizException {
        Mac mac;
        try {
            mac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException("HmacSHA256 is not supported." + e.getMessage());
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException e) {
            throw new KDBizException(e.getClass().getName() + "-" + e.getMessage());
        }
        return mac.doFinal(msg.getBytes(UTF8));
    }
}

