/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.tms;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import kd.ai.gai.core.agent.tool.tms.Sign;
import kd.ai.gai.core.agent.tool.tms.entity.JsonResponseModel;
import kd.ai.gai.core.agent.tool.tms.entity.SearchCommonRequest;
import kd.ai.gai.core.agent.tool.tms.entity.SearchCommonResponse;
import kd.ai.gai.core.agent.tool.util.HttpXmlUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class TmsClient {
    private static final Log logger = LogFactory.getLog(TmsClient.class);
    public static final String protocol = "https://";
    public static final String path = "/";
    private static String endpoint = "tms.tencentcloudapi.com";
    private static String service = "tms";
    private static String version = "2020-12-29";
    public static final String SDK_VERSION = "SDK_JAVA_3.1.991";
    private static String reqMethod = "POST";
    public static final int TM_MINUTE = 60;
    private int readTimeout;
    private int writeTimeout;
    private int connTimeout;
    private String secretId;
    private String secretKey;
    private String region;

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    private TmsClient() {
    }

    public TmsClient(String secretId, String secretKey, String region) {
        this(secretId, secretKey, region, 0, 0, 60);
    }

    public TmsClient(String secretId, String secretKey, String region, int readTimeout, int writeTimeout, int connTimeout) {
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.connTimeout = connTimeout;
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.region = region;
    }

    public static String getEndpoint() {
        return endpoint;
    }

    public static String getService() {
        return service;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public static String getReqMethod() {
        return reqMethod;
    }

    private String getCanonicalQueryString(HashMap<String, String> params, String method) throws KDBizException {
        if (method != null && method.equals(reqMethod)) {
            return "";
        }
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String v;
            try {
                v = URLEncoder.encode(entry.getValue(), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new KDBizException("UTF8 is not supported." + e.getMessage());
            }
            queryString.append("&").append(entry.getKey()).append("=").append(v);
        }
        if (queryString.length() == 0) {
            return "";
        }
        return queryString.toString().substring(1);
    }

    protected <T> T processResponseJson(String body, Class<T> typeOfT) throws KDBizException {
        Type type = TypeToken.getParameterized(JsonResponseModel.class, (Type[])new Type[]{typeOfT}).getType();
        Gson gson = new Gson();
        return ((JsonResponseModel)gson.fromJson((String)body, (Type)type)).response;
    }

    private void handlerRequest(SearchCommonRequest req) {
        if (StringUtils.isBlank((CharSequence)req.getInsite())) {
            req.setInsite(null);
        }
        if (StringUtils.isBlank((CharSequence)req.getCategory())) {
            req.setCategory(null);
        }
        if (StringUtils.isBlank((CharSequence)req.getVrid())) {
            req.setVrid(null);
        }
    }

    public SearchCommonResponse searchCommon(SearchCommonRequest req, int connectionTimeout, int readTimeout) throws KDBizException {
        String endpoint = TmsClient.getEndpoint();
        this.handlerRequest(req);
        String res = this.searchCommon(endpoint, req, "SearchCommon", connectionTimeout, readTimeout);
        return this.processResponseJson(res, SearchCommonResponse.class);
    }

    public String searchCommon(String endpoint, SearchCommonRequest request, String actionName, int connectionTimeout, int readTimeout) throws KDBizException {
        String httpRequestMethod = TmsClient.getReqMethod();
        HashMap<String, String> params = new HashMap<String, String>();
        request.toMap(params, "");
        String jsonReq = JSONObject.toJSONString((Object)request);
        String contentType = "application/json; charset=utf-8";
        String canonicalUri = path;
        String canonicalQueryString = this.getCanonicalQueryString(params, httpRequestMethod);
        String canonicalHeaders = "content-type:" + contentType + "\nhost:" + endpoint + "\n";
        String signedHeaders = "content-type;host";
        byte[] requestPayload = jsonReq.getBytes(StandardCharsets.UTF_8);
        String hashedRequestPayload = Sign.sha256Hex(requestPayload);
        String canonicalRequest = httpRequestMethod + "\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date(Long.parseLong(timestamp + "000")));
        String service = endpoint.split("\\.")[0];
        String credentialScope = date + path + service + "/tc3_request";
        String hashedCanonicalRequest = Sign.sha256Hex(canonicalRequest.getBytes(StandardCharsets.UTF_8));
        String stringToSign = "TC3-HMAC-SHA256\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
        String secretId = this.getSecretId();
        String secretKey = this.getSecretKey();
        byte[] secretDate = Sign.hmac256(("TC3" + secretKey).getBytes(StandardCharsets.UTF_8), date);
        byte[] secretService = Sign.hmac256(secretDate, service);
        byte[] secretSigning = Sign.hmac256(secretService, "tc3_request");
        String signature = Hex.encodeHexString((byte[])Sign.hmac256(secretSigning, stringToSign)).toLowerCase();
        String authorization = "TC3-HMAC-SHA256 Credential=" + secretId + path + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", contentType);
        headers.put("Host", endpoint);
        headers.put("Authorization", authorization);
        headers.put("X-TC-Action", actionName);
        headers.put("X-TC-Timestamp", timestamp);
        headers.put("X-TC-Version", version);
        headers.put("X-TC-RequestClient", SDK_VERSION);
        headers.put("X-TC-Region", this.getRegion());
        String url = protocol + endpoint + path;
        logger.info("aigc search url : {},headers : {} ", (Object)url, (Object)JSONObject.toJSONString(headers));
        String searchCommonResponse = null;
        try {
            searchCommonResponse = HttpXmlUtils.postApplicationJSON(url, headers, jsonReq, connectionTimeout, readTimeout);
        }
        catch (IOException e) {
            logger.error("\u8c03\u7528AIGC\u901a\u7528\u641c\u7d22\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new KDBizException("\u8c03\u7528AIGC\u901a\u7528\u641c\u7d22\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return searchCommonResponse;
    }
}

