/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.ai.gai.core.agent.tool.CosmicOpenAPIConstant;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPIInfo;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPIParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.result.ApiServiceResult;
import kd.bos.openapi.api.util.ApiService;
import kd.bos.openapi.base.custom.CustomApiUtil;
import kd.bos.openapi.base.custom.info.CustomApiHeader;
import kd.bos.openapi.base.custom.info.CustomApiInfo;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.bos.util.CollectionUtils;

public class CosmicOpenAPIUtils {
    private static final Log logger = LogFactory.getLog(CosmicOpenAPIUtils.class);
    private static final int DEFAULT_COSMIC_VER = 6;
    private static final List<String> COMMON_HEADERS = Arrays.asList("accesstoken", "Content-Type", "Idempotency-Key");

    public static Boolean checkCosmicCustomOpenAPIValidate(Long apiId) {
        DynamicObject bizApp;
        DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)apiId, (String)"openapi_apilist");
        if (api == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684API\u4fe1\u606f\u3002", (String)"CosmicOpenAPIUtils_1", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        String apiservicetype = api.getString("apiservicetype");
        if (StringUtils.equalsIgnoreCase((CharSequence)apiservicetype, (CharSequence)String.valueOf(CosmicOpenAPIConstant.OpenApiServiceType.CUSTOM.getType())) && (bizApp = api.getDynamicObject("appid")) == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static DynamicObject checkIsSupportCosmicOperationOpenAPI(Long apiId) {
        DynamicObject api = BusinessDataServiceHelper.loadSingleFromCache((Object)apiId, (String)"openapi_apilist");
        if (api == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684API\u4fe1\u606f\u3002", (String)"CosmicOpenAPIUtils_1", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        int apiservicetype = api.getInt("apiservicetype");
        CosmicOpenAPIConstant.OpenApiServiceType type = CosmicOpenAPIConstant.OpenApiServiceType.fromOpenApiServiceType(apiservicetype);
        String version = CosmicOpenAPIUtils.getCosmicVer();
        logger.info("\u5f53\u524d\u82cd\u7a79\u7248\u672c\u4e3a\uff1a" + version);
        int cosmicMainVer = CosmicOpenAPIUtils.getCosmicMainVer(version);
        if (cosmicMainVer <= 5 && !CosmicOpenAPIConstant.OpenApiServiceType.getVer5SupportType().contains((Object)type)) {
            throw new KDBizException(ResManager.loadKDString((String)String.format("\u5f53\u524d\u7248\u672c\u6682\u4e0d\u652f\u6301%s\u7c7b\u578b\u7684OpenAPI\u3002", new Object[]{type}), (String)"CosmicOpenAPIUtils_18", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        if (type == CosmicOpenAPIConstant.OpenApiServiceType.OPERATION) {
            String operation = api.getString("operation");
            if (!(ApiOperationType.DELETE.getOp().equalsIgnoreCase(operation) || ApiOperationType.SUBMIT.getOp().equalsIgnoreCase(operation) || ApiOperationType.UNSUBMIT.getOp().equalsIgnoreCase(operation) || ApiOperationType.AUDIT.getOp().equalsIgnoreCase(operation) || ApiOperationType.UNAUDIT.getOp().equalsIgnoreCase(operation) || ApiOperationType.ENABLE.getOp().equalsIgnoreCase(operation) || ApiOperationType.DISABLE.getOp().equalsIgnoreCase(operation) || ApiOperationType.QUERY.getOp().equalsIgnoreCase(operation) || ApiOperationType.SAVE.getOp().equalsIgnoreCase(operation))) {
                throw new KDBizException(ResManager.loadKDString((String)String.format("\u6682\u4e0d\u652f\u6301%s\u64cd\u4f5c\u7c7b\u578b\u7684\u81ea\u5b9a\u4e49API\u3002", operation), (String)"CosmicOpenAPIUtils_16", (String)"ai-gai-core", (Object[])new Object[0]));
            }
        }
        return api;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CosmicOpenAPIInfo parserCosmicOpenAPIInfo(Long apiId) {
        DynamicObject api = CosmicOpenAPIUtils.checkIsSupportCosmicOperationOpenAPI(apiId);
        CosmicOpenAPIInfo cosmicOpenAPIInfo = new CosmicOpenAPIInfo();
        int apiservicetype = api.getInt("apiservicetype");
        Boolean withoutStatus = api.getBoolean("isoutparawithoutstatus");
        cosmicOpenAPIInfo.setUrl(api.getString("urlformat"));
        cosmicOpenAPIInfo.setName(api.getString("name"));
        cosmicOpenAPIInfo.setDescription(api.getString("discription"));
        cosmicOpenAPIInfo.setNumber(api.getString("number"));
        cosmicOpenAPIInfo.setHttpMethod(String.valueOf(api.getInt("httpmethod")));
        Boolean isGet = api.getInt("httpmethod") == 0;
        CosmicOpenAPIConstant.OpenApiServiceType type = CosmicOpenAPIConstant.OpenApiServiceType.fromOpenApiServiceType(apiservicetype);
        if (type == CosmicOpenAPIConstant.OpenApiServiceType.OPERATION) {
            String operation = api.getString("operation");
            DynamicObjectCollection headerentryentity = api.getDynamicObjectCollection("headerentryentity");
            if (headerentryentity != null && !headerentryentity.isEmpty()) {
                cosmicOpenAPIInfo.setHeaders(CosmicOpenAPIUtils.buildOperationOpenAPIHeaders(headerentryentity));
            }
            DynamicObjectCollection bodyentryentity = api.getDynamicObjectCollection("bodyentryentity");
            cosmicOpenAPIInfo.setRequest(CosmicOpenAPIUtils.transformOperationOpenAPIParam(withoutStatus, "bodyentryentity", operation, isGet, bodyentryentity));
            DynamicObjectCollection respentryentity = api.getDynamicObjectCollection("respentryentity");
            cosmicOpenAPIInfo.setResponse(CosmicOpenAPIUtils.transformOperationOpenAPIParam(withoutStatus, "respentryentity", operation, isGet, respentryentity));
            return cosmicOpenAPIInfo;
        } else if (type == CosmicOpenAPIConstant.OpenApiServiceType.CUSTOM) {
            List headers;
            List response;
            String className = api.getString("classname");
            String methodName = api.getString("methodname");
            DynamicObject bizApp = api.getDynamicObject("appid");
            if (bizApp == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49API\u6240\u5c5e\u5e94\u7528\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790API\u4fe1\u606f\u3002", (String)"CosmicOpenAPIUtils_3", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            if (!StringUtils.isNotEmpty((CharSequence)className) || !StringUtils.isNotEmpty((CharSequence)methodName)) throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49API\u7684\u7c7b\u540d\u6216\u8005\u65b9\u6cd5\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790API\u4fe1\u606f\u3002", (String)"CosmicOpenAPIUtils_19", (String)"ai-gai-core", (Object[])new Object[0]));
            CustomApiInfo customApiInfo = CustomApiUtil.getCustomApiInfo((String)bizApp.getString("number"), (String)className, (String)methodName);
            if (customApiInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684API\u4fe1\u606f\u3002", (String)"CosmicOpenAPIUtils_1", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            List request = customApiInfo.getRequest();
            if (CollectionUtils.isNotEmpty((Collection)request)) {
                cosmicOpenAPIInfo.setRequest(CosmicOpenAPIUtils.transformCustomOpenAPIParam(request));
            }
            if (CollectionUtils.isNotEmpty((Collection)(response = customApiInfo.getResponse()))) {
                cosmicOpenAPIInfo.setResponse(CosmicOpenAPIUtils.transformCustomOpenAPIParam(response));
            }
            if (!CollectionUtils.isNotEmpty((Collection)(headers = customApiInfo.getHeaders()))) return cosmicOpenAPIInfo;
            cosmicOpenAPIInfo.setHeaders(CosmicOpenAPIUtils.buildCustomOpenAPIHeader(headers));
            return cosmicOpenAPIInfo;
        } else if (type == CosmicOpenAPIConstant.OpenApiServiceType.SCRIPT) {
            DynamicObjectCollection headerentryentity = api.getDynamicObjectCollection("headerentryentity");
            if (headerentryentity != null && !headerentryentity.isEmpty()) {
                cosmicOpenAPIInfo.setHeaders(CosmicOpenAPIUtils.buildOperationOpenAPIHeaders(headerentryentity));
            }
            DynamicObjectCollection bodyentryentity = api.getDynamicObjectCollection("bodyentryentity");
            cosmicOpenAPIInfo.setRequest(CosmicOpenAPIUtils.transformScriptOpenAPIParam(withoutStatus, "bodyentryentity", bodyentryentity));
            DynamicObjectCollection respentryentity = api.getDynamicObjectCollection("respentryentity");
            cosmicOpenAPIInfo.setResponse(CosmicOpenAPIUtils.transformScriptOpenAPIParam(withoutStatus, "respentryentity", respentryentity));
            return cosmicOpenAPIInfo;
        } else {
            if (type != CosmicOpenAPIConstant.OpenApiServiceType.SERVLET) throw new KDBizException(ResManager.loadKDString((String)String.format("\u5f53\u524d\u7248\u672c\u6682\u4e0d\u652f\u6301%s\u7c7b\u578b\u7684OpenAPI\u3002", new Object[]{type}), (String)"CosmicOpenAPIUtils_18", (String)"ai-gai-core", (Object[])new Object[0]));
            DynamicObjectCollection headerentryentity = api.getDynamicObjectCollection("headerentryentity");
            if (headerentryentity != null && !headerentryentity.isEmpty()) {
                cosmicOpenAPIInfo.setHeaders(CosmicOpenAPIUtils.buildOperationOpenAPIHeaders(headerentryentity));
            }
            DynamicObjectCollection bodyentryentity = api.getDynamicObjectCollection("bodyentryentity");
            cosmicOpenAPIInfo.setRequest(CosmicOpenAPIUtils.transformServletOpenAPIParam(withoutStatus, "bodyentryentity", bodyentryentity));
            DynamicObjectCollection respentryentity = api.getDynamicObjectCollection("respentryentity");
            cosmicOpenAPIInfo.setResponse(CosmicOpenAPIUtils.transformServletOpenAPIParam(withoutStatus, "respentryentity", respentryentity));
        }
        return cosmicOpenAPIInfo;
    }

    private static List<Map<String, String>> buildCustomOpenAPIHeader(List<CustomApiHeader> request) {
        return request.stream().map(header -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", header.getName());
            map.put("desc", header.getDesc());
            map.put("example", header.getExample());
            return map;
        }).collect(Collectors.toList());
    }

    private static List<Map<String, String>> buildOperationOpenAPIHeaders(DynamicObjectCollection headerentryentity) {
        return headerentryentity.stream().map(e -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", e.getString("headername"));
            map.put("desc", e.getString("headerdes"));
            map.put("example", e.getString("headervalue"));
            return map;
        }).collect(Collectors.toList()).stream().filter(map -> !COMMON_HEADERS.contains(map.get("name"))).collect(Collectors.toList());
    }

    private static List<CosmicOpenAPIParam> transformCustomOpenAPIParam(List<CustomApiParam> request) {
        return request.stream().map(param -> {
            CosmicOpenAPIParam cosmicOpenAPIParam = CosmicOpenAPIUtils.buildCustomOpenAPIParam(param);
            return cosmicOpenAPIParam;
        }).collect(Collectors.toList());
    }

    private static CosmicOpenAPIParam buildCustomOpenAPIParam(CustomApiParam param) {
        CosmicOpenAPIParam cosmicOpenAPIParam = new CosmicOpenAPIParam();
        cosmicOpenAPIParam.setParamName(param.getParamName());
        cosmicOpenAPIParam.setParamType(param.getParamType());
        cosmicOpenAPIParam.setExample(param.getExample());
        cosmicOpenAPIParam.setIsMust(param.isRequired() ? "1" : "0");
        cosmicOpenAPIParam.setDesc(param.getDesc());
        cosmicOpenAPIParam.setLevel(param.getLevel());
        if (CollectionUtils.isNotEmpty((Collection)param.getChildList())) {
            CosmicOpenAPIUtils.buildCustomOpenAPIParam(cosmicOpenAPIParam, param.getChildList());
        }
        return cosmicOpenAPIParam;
    }

    private static void buildCustomOpenAPIParam(CosmicOpenAPIParam cosmicOpenAPIParam, List<CustomApiParam> child) {
        child.stream().forEach(param -> {
            CosmicOpenAPIParam subParam = CosmicOpenAPIUtils.buildCustomOpenAPIParam(param);
            cosmicOpenAPIParam.getChildList().add(subParam);
        });
    }

    private static List<CosmicOpenAPIParam> transformScriptOpenAPIParam(Boolean withoutStatus, String entryKey, DynamicObjectCollection entryentity) {
        List<CosmicOpenAPIParam> cosmicOpenAPIParams = CosmicOpenAPIUtils.getOpenAPIParamByGroup(entryKey, entryentity);
        if (StringUtils.equalsIgnoreCase((CharSequence)entryKey, (CharSequence)"respentryentity")) {
            ArrayList<CosmicOpenAPIParam> results = new ArrayList<CosmicOpenAPIParam>(0);
            if (withoutStatus.booleanValue()) {
                List<CosmicOpenAPIParam> commonResultParams = CosmicOpenAPIUtils.buildAPIResultParam();
                results.addAll(commonResultParams);
                CosmicOpenAPIParam dataParam = CosmicOpenAPIUtils.buildOperationResultCommonParam("data");
                results.add(dataParam);
                dataParam.getChildList().addAll(cosmicOpenAPIParams);
                CosmicOpenAPIUtils.setParamLevel(dataParam.getLevel() + 1, cosmicOpenAPIParams);
            } else {
                List<CosmicOpenAPIParam> resultParams = CosmicOpenAPIUtils.buildAPIResultParam();
                CosmicOpenAPIParam data = CosmicOpenAPIUtils.buildOperationResultCommonParam("data");
                data.getChildList().addAll(cosmicOpenAPIParams);
                CosmicOpenAPIUtils.setParamLevel(data.getLevel() + 1, cosmicOpenAPIParams);
                results.addAll(resultParams);
                results.add(data);
            }
            return results;
        }
        return cosmicOpenAPIParams;
    }

    private static List<CosmicOpenAPIParam> transformServletOpenAPIParam(Boolean withoutStatus, String entryKey, DynamicObjectCollection entryentity) {
        List<CosmicOpenAPIParam> cosmicOpenAPIParams = CosmicOpenAPIUtils.getOpenAPIParamByGroup(entryKey, entryentity);
        if (StringUtils.equalsIgnoreCase((CharSequence)entryKey, (CharSequence)"respentryentity")) {
            ArrayList<CosmicOpenAPIParam> results = new ArrayList<CosmicOpenAPIParam>(0);
            if (withoutStatus.booleanValue()) {
                List<CosmicOpenAPIParam> commonResultParams = CosmicOpenAPIUtils.buildAPIResultParam();
                results.addAll(commonResultParams);
                CosmicOpenAPIParam dataParam = CosmicOpenAPIUtils.buildOperationResultCommonParam("data");
                results.add(dataParam);
                dataParam.getChildList().addAll(cosmicOpenAPIParams);
                CosmicOpenAPIUtils.setParamLevel(dataParam.getLevel() + 1, cosmicOpenAPIParams);
            } else {
                List<CosmicOpenAPIParam> resultParams = CosmicOpenAPIUtils.buildAPIResultParam();
                CosmicOpenAPIParam data = CosmicOpenAPIUtils.buildOperationResultCommonParam("data");
                data.getChildList().addAll(cosmicOpenAPIParams);
                CosmicOpenAPIUtils.setParamLevel(data.getLevel() + 1, cosmicOpenAPIParams);
                results.addAll(resultParams);
                results.add(data);
            }
            return results;
        }
        return cosmicOpenAPIParams;
    }

    private static List<CosmicOpenAPIParam> getOpenAPIParamByGroup(String entryKey, DynamicObjectCollection entryentity) {
        String paramName = "bodyentryentity".equals(entryKey) ? "paramname" : "respparamname";
        String paramTypeName = "bodyentryentity".equals(entryKey) ? "paramtype" : "respparamtype";
        Supplier<Stream> supplier = () -> entryentity.stream().filter(it -> StringUtils.isNotEmpty((CharSequence)it.getString(paramName)));
        if (supplier.get() == null) {
            return Collections.emptyList();
        }
        Stream stream = supplier.get();
        Map pidMap = stream.collect(Collectors.groupingBy(it -> it.getString("pid"), LinkedHashMap::new, Collectors.toList()));
        List<CosmicOpenAPIParam> cosmicOpenAPIParams = CosmicOpenAPIUtils.getOperationOpenAPIParam(pidMap, "0", entryKey, paramTypeName);
        return cosmicOpenAPIParams;
    }

    private static List<CosmicOpenAPIParam> transformOperationOpenAPIParam(Boolean withoutStatus, String entryKey, String operation, Boolean isGet, DynamicObjectCollection entryentity) {
        List<CosmicOpenAPIParam> cosmicOpenAPIParams = CosmicOpenAPIUtils.getOpenAPIParamByGroup(entryKey, entryentity);
        if (StringUtils.equalsIgnoreCase((CharSequence)entryKey, (CharSequence)"respentryentity")) {
            return CosmicOpenAPIUtils.buildOperationRespParam(withoutStatus, operation, cosmicOpenAPIParams);
        }
        ArrayList<CosmicOpenAPIParam> results = new ArrayList<CosmicOpenAPIParam>(0);
        if (isGet.booleanValue()) {
            if (ApiOperationType.QUERY.getOp().equalsIgnoreCase(operation)) {
                List<CosmicOpenAPIParam> pageParams = CosmicOpenAPIUtils.buildOperationPageParam();
                results.addAll(pageParams);
                CosmicOpenAPIParam queryData = CosmicOpenAPIUtils.buildQueryOperationRequestDataParam();
                queryData.getChildList().addAll(cosmicOpenAPIParams);
                CosmicOpenAPIUtils.setParamLevel(queryData.getLevel() + 1, cosmicOpenAPIParams);
                results.add(queryData);
            }
        } else if (ApiOperationType.QUERY.getOp().equalsIgnoreCase(operation)) {
            CosmicOpenAPIParam queryData = CosmicOpenAPIUtils.buildQueryOperationRequestDataParam();
            queryData.getChildList().addAll(cosmicOpenAPIParams);
            CosmicOpenAPIUtils.setParamLevel(queryData.getLevel() + 1, cosmicOpenAPIParams);
            List<CosmicOpenAPIParam> pageParams = CosmicOpenAPIUtils.buildOperationPageParam();
            results.addAll(pageParams);
            results.add(queryData);
        } else if (ApiOperationType.SAVE.getOp().equalsIgnoreCase(operation)) {
            CosmicOpenAPIParam saveData = CosmicOpenAPIUtils.buildSaveOperationRequestDataParam();
            saveData.getChildList().addAll(cosmicOpenAPIParams);
            CosmicOpenAPIUtils.setParamLevel(saveData.getLevel() + 1, cosmicOpenAPIParams);
            results.add(saveData);
        } else if (ApiOperationType.DELETE.getOp().equalsIgnoreCase(operation) || ApiOperationType.SUBMIT.getOp().equalsIgnoreCase(operation) || ApiOperationType.UNSUBMIT.getOp().equalsIgnoreCase(operation) || ApiOperationType.AUDIT.getOp().equalsIgnoreCase(operation) || ApiOperationType.UNAUDIT.getOp().equalsIgnoreCase(operation) || ApiOperationType.ENABLE.getOp().equalsIgnoreCase(operation) || ApiOperationType.DISABLE.getOp().equalsIgnoreCase(operation)) {
            CosmicOpenAPIParam deleteData = CosmicOpenAPIUtils.buildDeleteOperationRequestDataParam();
            deleteData.getChildList().addAll(cosmicOpenAPIParams);
            CosmicOpenAPIUtils.setParamLevel(deleteData.getLevel() + 1, cosmicOpenAPIParams);
            results.add(deleteData);
        }
        return results;
    }

    private static void setParamLevel(int begin, List<CosmicOpenAPIParam> cosmicOpenAPIParams) {
        cosmicOpenAPIParams.stream().forEach(param -> {
            param.setLevel(begin);
            if (CollectionUtils.isNotEmpty(param.getChildList())) {
                CosmicOpenAPIUtils.setParamLevel(begin + 1, param.getChildList());
            }
        });
    }

    private static List<CosmicOpenAPIParam> buildOperationPageParam() {
        ArrayList<CosmicOpenAPIParam> cosmicOpenAPIParams = new ArrayList<CosmicOpenAPIParam>(2);
        CosmicOpenAPIParam pageSize = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.INTEGER.getType(), "pageSize", 1, "1", ResManager.loadKDString((String)"\u6bcf\u9875\u6761\u6570", (String)"CosmicOpenAPIUtils_13", (String)"ai-gai-core", (Object[])new Object[0]), "10", Boolean.FALSE);
        cosmicOpenAPIParams.add(pageSize);
        CosmicOpenAPIParam pageNo = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.INTEGER.getType(), "pageNo", 1, "1", ResManager.loadKDString((String)"\u9875\u6570", (String)"CosmicOpenAPIUtils_14", (String)"ai-gai-core", (Object[])new Object[0]), "1", Boolean.FALSE);
        cosmicOpenAPIParams.add(pageNo);
        return cosmicOpenAPIParams;
    }

    private static List<CosmicOpenAPIParam> buildAPIResultParam() {
        ArrayList<CosmicOpenAPIParam> cosmicOpenAPIParams = new ArrayList<CosmicOpenAPIParam>(2);
        CosmicOpenAPIParam errorCode = CosmicOpenAPIUtils.buildOperationResultCommonParam("errorCode");
        cosmicOpenAPIParams.add(errorCode);
        CosmicOpenAPIParam message = CosmicOpenAPIUtils.buildOperationResultCommonParam("message");
        cosmicOpenAPIParams.add(message);
        CosmicOpenAPIParam status = CosmicOpenAPIUtils.buildOperationResultCommonParam("status");
        cosmicOpenAPIParams.add(status);
        return cosmicOpenAPIParams;
    }

    private static CosmicOpenAPIParam buildQueryOperationRequestDataParam() {
        return CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.OBJECT.getType(), "data", 1, "1", "data", "", Boolean.FALSE);
    }

    private static CosmicOpenAPIParam buildSaveOperationRequestDataParam() {
        return CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.ARRAY_OBJECT.getType(), "data", 1, "1", "data", "", Boolean.TRUE);
    }

    private static CosmicOpenAPIParam buildDeleteOperationRequestDataParam() {
        return CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.OBJECT.getType(), "data", 1, "1", "data", "", Boolean.FALSE);
    }

    private static List<CosmicOpenAPIParam> buildOperationRespParam(Boolean withoutStatus, String operation, List<CosmicOpenAPIParam> entryParams) {
        ArrayList<CosmicOpenAPIParam> cosmicOpenAPIParams = new ArrayList<CosmicOpenAPIParam>(0);
        if (withoutStatus.booleanValue()) {
            List<CosmicOpenAPIParam> commonResultParams = CosmicOpenAPIUtils.buildAPIResultParam();
            cosmicOpenAPIParams.addAll(commonResultParams);
            CosmicOpenAPIParam dataParam = CosmicOpenAPIUtils.buildOperationResultCommonParam("data");
            cosmicOpenAPIParams.add(dataParam);
            ApiServiceResult result = ApiService.valueOf((String)operation.toUpperCase()).getResultType();
            Map data = (Map)JsonUtil.toJSON((Object)result);
            List<CosmicOpenAPIParam> dataSubParams = CosmicOpenAPIUtils.buildOperationRespDataSubParam(data, dataParam.getLevel() + 1, operation, entryParams);
            dataParam.getChildList().addAll(dataSubParams);
        } else {
            Map<String, Object> data = CosmicOpenAPIUtils.getOperationResultType(operation);
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String key = entry.getKey();
                CosmicOpenAPIParam param = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"data")) {
                    CosmicOpenAPIParam dataParam = CosmicOpenAPIUtils.buildOperationResultCommonParam("data");
                    cosmicOpenAPIParams.add(dataParam);
                    Map dataChild = (Map)entry.getValue();
                    List<CosmicOpenAPIParam> dataSubParams = CosmicOpenAPIUtils.buildOperationRespDataSubParam(dataChild, dataParam.getLevel() + 1, operation, entryParams);
                    dataParam.getChildList().addAll(dataSubParams);
                    continue;
                }
                param = CosmicOpenAPIUtils.buildOperationResultCommonParam(key);
                cosmicOpenAPIParams.add(param);
            }
        }
        return cosmicOpenAPIParams;
    }

    private static List<CosmicOpenAPIParam> buildOperationRespDataSubParam(Map<String, Object> data, int level, String operation, List<CosmicOpenAPIParam> entryParams) {
        ArrayList<CosmicOpenAPIParam> params = new ArrayList<CosmicOpenAPIParam>(0);
        CosmicOpenAPIParam param = null;
        for (Map.Entry<String, Object> entryChild : data.entrySet()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"result")) {
                param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.ARRAY_OBJECT.getType(), "result", level, "1", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u8be6\u7ec6\u4fe1\u606f", (String)"CosmicOpenAPIUtils_9", (String)"ai-gai-core", (Object[])new Object[0]), "\"" + entryChild.getValue() + "\"", Boolean.TRUE);
                CosmicOpenAPIUtils.handlerOperationResultParam(param, operation);
                params.add(param);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"failCount")) {
                param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.STRING.getType(), "failCount", level, "1", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u6570\u91cf", (String)"CosmicOpenAPIUtils_10", (String)"ai-gai-core", (Object[])new Object[0]), "\"2\"", Boolean.FALSE);
                params.add(param);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"successCount")) {
                param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.STRING.getType(), "successCount", level, "1", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u6570\u91cf", (String)"CosmicOpenAPIUtils_11", (String)"ai-gai-core", (Object[])new Object[0]), "\"2\"", Boolean.FALSE);
                params.add(param);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"pageSize")) {
                param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.INTEGER.getType(), "pageSize", level, "1", ResManager.loadKDString((String)"\u6bcf\u9875\u6761\u6570", (String)"CosmicOpenAPIUtils_13", (String)"ai-gai-core", (Object[])new Object[0]), "\"" + entryChild.getValue() + "\"", Boolean.FALSE);
                params.add(param);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"pageNo")) {
                param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.INTEGER.getType(), "pageNo", level, "1", ResManager.loadKDString((String)"\u9875\u6570", (String)"CosmicOpenAPIUtils_14", (String)"ai-gai-core", (Object[])new Object[0]), "\"2\"", Boolean.FALSE);
                params.add(param);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"filter")) {
                param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.STRING.getType(), "filter", level, "1", ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6", (String)"CosmicOpenAPIUtils_17", (String)"ai-gai-core", (Object[])new Object[0]), "[enable is not null  AND enable != '' AND enable != ' ']", Boolean.FALSE);
                params.add(param);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"lastPage")) {
                param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.BOOLEAN.getType(), "lastPage", level, "1", "", "", Boolean.FALSE);
                params.add(param);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"totalCount")) {
                param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.INTEGER.getType(), "totalCount", level, "1", ResManager.loadKDString((String)"\u603b\u6761\u6570", (String)"CosmicOpenAPIUtils_15", (String)"ai-gai-core", (Object[])new Object[0]), "20", Boolean.FALSE);
                params.add(param);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)entryChild.getKey(), (CharSequence)"rows")) continue;
            param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.ARRAY_OBJECT.getType(), "rows", level, "1", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u8be6\u7ec6\u4fe1\u606f", (String)"CosmicOpenAPIUtils_9", (String)"ai-gai-core", (Object[])new Object[0]), "", Boolean.TRUE);
            param.getChildList().addAll(entryParams);
            CosmicOpenAPIUtils.setParamLevel(param.getLevel() + 1, entryParams);
            params.add(param);
        }
        return params;
    }

    private static void handlerOperationResultParam(CosmicOpenAPIParam resultParam, String operation) {
        ArrayList<CosmicOpenAPIParam> params = new ArrayList<CosmicOpenAPIParam>(0);
        CosmicOpenAPIParam resultParamChild = null;
        List<Object> commonFileds = new ArrayList(0);
        if (StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)ApiOperationType.SAVE.getOp())) {
            commonFileds = Arrays.asList("id", "number", "type", "keys", "billStatus");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)ApiOperationType.DELETE.getOp()) || StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)ApiOperationType.SUBMIT.getOp()) || StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)ApiOperationType.UNSUBMIT.getOp()) || StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)ApiOperationType.UNAUDIT.getOp()) || StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)ApiOperationType.AUDIT.getOp()) || StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)ApiOperationType.ENABLE.getOp()) || StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)ApiOperationType.DISABLE.getOp())) {
            commonFileds = Arrays.asList("id", "number", "billStatus");
            resultParamChild = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.ARRAY_STRING.getType(), "errors", resultParam.getLevel() + 1, "1", "", "", Boolean.FALSE);
            params.add(resultParamChild);
        }
        for (String string : commonFileds) {
            if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"id")) {
                resultParamChild = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.STRING.getType(), "id", resultParam.getLevel() + 1, "1", "", "", Boolean.FALSE);
                params.add(resultParamChild);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"number")) {
                resultParamChild = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.STRING.getType(), "number", resultParam.getLevel() + 1, "1", "", "", Boolean.FALSE);
                params.add(resultParamChild);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"type")) {
                resultParamChild = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.STRING.getType(), "type", resultParam.getLevel() + 1, "1", "", "", Boolean.FALSE);
                params.add(resultParamChild);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"keys")) {
                resultParamChild = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.OBJECT.getType(), "keys", resultParam.getLevel() + 1, "1", "", "", Boolean.FALSE);
                params.add(resultParamChild);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"billStatus")) continue;
            resultParamChild = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.BOOLEAN.getType(), "billStatus", resultParam.getLevel() + 1, "1", "", "", Boolean.FALSE);
            params.add(resultParamChild);
        }
        resultParam.getChildList().addAll(params);
    }

    private static Map<String, Object> getOperationResultType(String operation) {
        ApiServiceResult result = ApiService.valueOf((String)operation.toUpperCase()).getResultType();
        OpenApiResult openApiResult = OpenApiResult.builder().success((Object)result);
        Map data = (Map)JsonUtil.toJSON((Object)openApiResult);
        return data;
    }

    private static CosmicOpenAPIParam buildOperationResultCommonParam(String key) {
        CosmicOpenAPIParam param = new CosmicOpenAPIParam();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"errorCode")) {
            param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.STRING.getType(), "errorCode", 1, "1", ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"CosmicOpenAPIUtils_4", (String)"ai-gai-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u529f\u65f6\u4e3a0\uff0c\u5931\u8d25\u65f6\u4f1a\u8fd4\u56de\u9519\u8bef\u7801\u5982400", (String)"CosmicOpenAPIUtils_5", (String)"ai-gai-core", (Object[])new Object[0]), Boolean.FALSE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"message")) {
            param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.STRING.getType(), "message", 1, "1", ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u9519\u8bef\u4fe1\u606f", (String)"CosmicOpenAPIUtils_6", (String)"ai-gai-core", (Object[])new Object[0]), "true/false", Boolean.FALSE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"status")) {
            param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.BOOLEAN.getType(), "status", 1, "1", ResManager.loadKDString((String)"\u63a5\u53e3\u8bbf\u95ee\u662f\u5426\u6210\u529f", (String)"CosmicOpenAPIUtils_8", (String)"ai-gai-core", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u529f\u65f6\u4e3a\u7a7a\uff0c\u5931\u8d25\u65f6\u4f1a\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u5982\u201c\u64cd\u4f5c\u5931\u8d25\u201d", (String)"CosmicOpenAPIUtils_7", (String)"ai-gai-core", (Object[])new Object[0]), Boolean.FALSE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"data")) {
            param = CosmicOpenAPIUtils.buildCosmicOpenAPIParam(CosmicOpenAPIConstant.DataType.OBJECT.getType(), "data", 1, "1", ResManager.loadKDString((String)"\u7ed3\u679c\u6570\u636e", (String)"CosmicOpenAPIUtils_12", (String)"ai-gai-core", (Object[])new Object[0]), "{}", Boolean.FALSE);
        }
        return param;
    }

    private static CosmicOpenAPIParam buildCosmicOpenAPIParam(String paramType, String paramName, int level, String isMust, String desc, Object example, Boolean isMulValue) {
        CosmicOpenAPIParam param = new CosmicOpenAPIParam();
        param.setParamType(CosmicOpenAPIUtils.paramTypeTransform(paramType, isMulValue));
        param.setCosmicParamType(paramType);
        param.setParamName(paramName);
        param.setLevel(level);
        param.setIsMust(isMust);
        param.setDesc(desc);
        param.setExample(example);
        param.setMulValue(isMulValue);
        return param;
    }

    private static String paramTypeTransform(String paramType, Boolean isMulValue) {
        if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)CosmicOpenAPIConstant.DataType.STRUCT.getType())) {
            return isMulValue != false ? CosmicOpenAPIConstant.DataType.ARRAY_OBJECT.getType() : CosmicOpenAPIConstant.DataType.OBJECT.getType();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)CosmicOpenAPIConstant.DataType.ENTRIES.getType())) {
            return CosmicOpenAPIConstant.DataType.ARRAY_OBJECT.getType();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)CosmicOpenAPIConstant.DataType.DECIMAL.getType())) {
            return CosmicOpenAPIConstant.DataType.FLOAT.getType();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)CosmicOpenAPIConstant.DataType.DATE_TIME.getType()) || StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)CosmicOpenAPIConstant.DataType.DATE.getType())) {
            return CosmicOpenAPIConstant.DataType.STRING.getType();
        }
        if (CosmicOpenAPIConstant.DataType.BOOLEAN.getType().equalsIgnoreCase(paramType)) {
            return CosmicOpenAPIConstant.DataType.BOOLEAN.getType();
        }
        if (CosmicOpenAPIConstant.DataType.FLEX.getType().equalsIgnoreCase(paramType)) {
            return CosmicOpenAPIConstant.DataType.OBJECT.getType();
        }
        return paramType;
    }

    private static List<CosmicOpenAPIParam> getOperationOpenAPIParam(Map<String, List<DynamicObject>> pidMap, String parentPid, String entryKey, String dataTypeName) {
        ArrayList<CosmicOpenAPIParam> cosmicOpenAPIParams = new ArrayList<CosmicOpenAPIParam>(0);
        if (pidMap != null && !pidMap.isEmpty() && CollectionUtils.isNotEmpty((Collection)pidMap.get(parentPid))) {
            List<DynamicObject> child = pidMap.get(parentPid);
            for (DynamicObject obj : child) {
                String dataType = obj.getString(dataTypeName);
                CosmicOpenAPIParam cosmicOpenAPIParam = CosmicOpenAPIUtils.buildOperationOpenAPIParam(entryKey, obj);
                cosmicOpenAPIParams.add(cosmicOpenAPIParam);
                if (!CosmicOpenAPIConstant.DataType.ENTRIES.getType().equals(dataType) && !CosmicOpenAPIConstant.DataType.STRUCT.getType().equals(dataType)) continue;
                List<CosmicOpenAPIParam> entryParams = CosmicOpenAPIUtils.getOperationOpenAPIParam(pidMap, obj.getString("id"), entryKey, dataTypeName);
                cosmicOpenAPIParam.getChildList().addAll(entryParams);
            }
        }
        return cosmicOpenAPIParams;
    }

    private static CosmicOpenAPIParam buildOperationOpenAPIParam(String entryKey, DynamicObject dynamicObject) {
        String paramName = "bodyentryentity".equals(entryKey) ? "paramname" : "respparamname";
        String paramType = "bodyentryentity".equals(entryKey) ? "paramtype" : "respparamtype";
        String isMust = "bodyentryentity".equals(entryKey) ? "must" : "respparammust";
        String example = "bodyentryentity".equals(entryKey) ? "example" : "respexample";
        String desc = "bodyentryentity".equals(entryKey) ? "bodyparamdes" : "respdes";
        String levelName = "bodyentryentity".equals(entryKey) ? "body_level" : "resp_level";
        String isMulValue = "bodyentryentity".equals(entryKey) ? "is_req_mul_value" : "is_resp_mul_value";
        String isMustValue = dynamicObject.getString(isMust);
        isMustValue = StringUtils.equalsIgnoreCase((CharSequence)isMustValue, (CharSequence)"\u662f") || StringUtils.equalsIgnoreCase((CharSequence)isMustValue, (CharSequence)"1") ? "1" : "0";
        return CosmicOpenAPIUtils.buildCosmicOpenAPIParam(dynamicObject.getString(paramType), dynamicObject.getString(paramName), dynamicObject.getInt(levelName), isMustValue, dynamicObject.getString(desc), dynamicObject.getString(example), dynamicObject.getBoolean(isMulValue));
    }

    private static int getCosmicMainVer(String version) {
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            String[] split = version.split("\\.");
            String firstPart = split[0];
            return Integer.parseInt(firstPart);
        }
        return 6;
    }

    private static String getCosmicVer() {
        IndustryVersionInfo csVersion = IndustryVersionServiceHelper.getVersion((String)"cosmic_bos", (String)"kingdee");
        return CosmicOpenAPIUtils.removeLastVersion(csVersion.getVersion());
    }

    private static String removeLastVersion(String version) {
        String[] split;
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }
}

