/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FastJsonUtil {
    private static final Log log = LogFactory.getLog(FastJsonUtil.class);
    private static Pattern pattern = Pattern.compile("[<>&\"',]");

    public static String removeWhitespaceAndNewlines(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object obj = mapper.readValue(json, Object.class);
            String compactJson = mapper.writeValueAsString(obj);
            return compactJson;
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return json;
        }
    }

    public static String fastJsonToXml(String jsonStr, Boolean escape, JSONObject xmlConfig) {
        try {
            StringBuffer buffer = new StringBuffer();
            JSONObject json = JSONObject.parseObject((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField});
            FastJsonUtil.jsonToXmlStr(json, buffer, escape != null && escape != false, xmlConfig);
            return buffer.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static void jsonToXmlStr(String schemaName, JSON json, StringBuffer buffer, Boolean isEscape, JSONObject xmlConfig) {
        if (json instanceof JSONObject) {
            JSONObject obj = (JSONObject)json;
            FastJsonUtil.jsonToXmlStr(obj, buffer, isEscape, xmlConfig);
        } else if (json instanceof JSONArray) {
            JSONObject config = xmlConfig.getJSONObject(schemaName);
            Boolean wrapped = Boolean.FALSE;
            String wrappedNodeName = schemaName;
            if (config != null) {
                wrapped = config.getBoolean("_$XML_WRAPPED$_");
                wrappedNodeName = config.getString("_$XML_NODE_NAME$_");
            }
            JSONArray array = (JSONArray)json;
            for (int i = 0; i < array.size(); ++i) {
                JSONObject item = array.getJSONObject(i);
                if (wrapped.booleanValue()) {
                    buffer.append("<").append(wrappedNodeName).append(">");
                    FastJsonUtil.jsonToXmlStr(item, buffer, isEscape, xmlConfig);
                    buffer.append("</").append(wrappedNodeName).append(">");
                    continue;
                }
                FastJsonUtil.jsonToXmlStr(item, buffer, isEscape, xmlConfig);
            }
        }
    }

    public static void jsonToXmlStr(JSONObject json, StringBuffer buffer, Boolean isEscape, JSONObject xmlConfig) {
        for (Map.Entry en : json.entrySet()) {
            if (((String)en.getKey()).startsWith("-")) continue;
            if (((String)en.getKey()).equals("#text")) {
                buffer.append(en.getValue());
                continue;
            }
            if (en.getValue() instanceof JSONObject) {
                buffer.append("<").append((String)en.getKey()).append(FastJsonUtil.getAttr((JSONObject)en.getValue())).append(">");
                JSONObject jo = json.getJSONObject((String)en.getKey());
                FastJsonUtil.jsonToXmlStr(jo, buffer, isEscape, xmlConfig);
                buffer.append("</").append((String)en.getKey()).append(">");
                continue;
            }
            if (en.getValue() instanceof JSONArray) {
                String arrayKey = (String)en.getKey();
                JSONObject config = xmlConfig.getJSONObject(arrayKey);
                Boolean wrapped = Boolean.FALSE;
                String wrappedNodeName = arrayKey;
                if (config != null) {
                    wrapped = config.getBoolean("_$XML_WRAPPED$_");
                    wrappedNodeName = config.getString("_$XML_NODE_NAME$_");
                }
                JSONArray jsonArray = json.getJSONArray(arrayKey);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Object item = jsonArray.get(i);
                    if (item instanceof JSONObject) {
                        JSONObject jsonobject = (JSONObject)item;
                        buffer.append("<").append((String)en.getKey()).append(FastJsonUtil.getAttr(jsonobject)).append(">");
                        if (wrapped.booleanValue()) {
                            buffer.append("<").append(wrappedNodeName).append(FastJsonUtil.getAttr(jsonobject)).append(">");
                            FastJsonUtil.jsonToXmlStr(jsonobject, buffer, isEscape, xmlConfig);
                            buffer.append("</").append(wrappedNodeName).append(">");
                        } else {
                            FastJsonUtil.jsonToXmlStr(jsonobject, buffer, isEscape, xmlConfig);
                        }
                        buffer.append("</").append((String)en.getKey()).append(">");
                        continue;
                    }
                    if (!(item instanceof String) && !(item instanceof Number)) continue;
                    buffer.append("<").append((String)en.getKey()).append(">");
                    if (wrapped.booleanValue()) {
                        buffer.append("<").append(wrappedNodeName).append(">");
                        buffer.append("</").append(wrappedNodeName).append(">");
                    }
                    buffer.append("</").append((String)en.getKey()).append(">");
                }
                continue;
            }
            buffer.append("<").append((String)en.getKey()).append(">").append(isEscape != false ? FastJsonUtil.escape(String.valueOf(en.getValue())) : String.valueOf(en.getValue())).append("</").append((String)en.getKey()).append(">");
        }
    }

    private static String getAttr(JSONObject json) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entity : json.entrySet()) {
            if (!((String)entity.getKey()).startsWith("-")) continue;
            sb.append(" ").append(((String)entity.getKey()).substring(1)).append("=\"").append(entity.getValue().toString()).append("\"");
        }
        return sb.toString();
    }

    private static String escape(String string) {
        return pattern.matcher(string).find() ? "<![CDATA[" + string + "]]>" : string;
    }

    public static boolean isJsonArray(String str) {
        if (str.isEmpty()) {
            return false;
        }
        return FastJsonUtil.isWrap(str.trim(), '[', ']');
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }
}

