/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import kd.ai.gai.core.domain.dto.agent.FileInfo;
import kd.ai.gai.core.service.agent.FileService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class GaiFileUtils {
    private static final Log logger = LogFactory.getLog(GaiFileUtils.class);

    public static byte[] downloadFile(Long fileId) {
        logger.info("gai file id:{}", (Object)fileId);
        FileInfo fileInfo = FileService.queryFileUrl(fileId);
        logger.info("gai fileInfo:{}", (Object)JSONObject.toJSONString((Object)fileInfo));
        String url = fileInfo.getFileUrl();
        try {
            URL uri = new URL(url);
            String fileType = fileInfo.getFileType();
            String suffix = "";
            if (!StringUtils.isEmpty((CharSequence)fileType) && fileType.contains("/")) {
                suffix = "." + fileType.substring(fileType.lastIndexOf("/") + 1);
            }
            File tmpFile = File.createTempFile(String.format("tmp_%s", System.currentTimeMillis()), suffix);
            FileUtils.copyURLToFile((URL)uri, (File)tmpFile);
            return FileUtils.readFileToByteArray((File)tmpFile);
        }
        catch (MalformedURLException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7gai\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6url\u51fa\u73b0\u5f02\u5e38\u3002", (String)"GaiFileUtils_1", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7gai\u6587\u4ef6id\u4e0b\u8f7d\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"GaiFileUtils_2", (String)"ai-gai-core", (Object[])new Object[0]));
        }
    }

    public static String getGaiFilePath(Long fileId) {
        String path;
        block4: {
            logger.info("gai file id:{}", (Object)fileId);
            FileInfo fileInfo = FileService.queryFileUrl(fileId);
            logger.info("gai fileInfo:{}", (Object)JSONObject.toJSONString((Object)fileInfo));
            if (fileInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230gai\u6587\u4ef6id\u5bf9\u5e94\u7684\u6587\u4ef6url\u3002", (String)"GaiFileUtils_4", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            String url = fileInfo.getFileUrl();
            path = "";
            try {
                URIBuilder builder = new URIBuilder(url);
                List pairList = builder.getQueryParams();
                if (pairList == null || pairList.isEmpty()) break block4;
                for (NameValuePair pair : pairList) {
                    String name = pair.getName();
                    String value = pair.getValue();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"path")) continue;
                    path = value;
                    break;
                }
            }
            catch (URISyntaxException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7gai\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6url\u51fa\u73b0\u5f02\u5e38\u3002", (String)"GaiFileUtils_3", (String)"ai-gai-core", (Object[])new Object[0]));
            }
        }
        logger.info("gai file id:{},path:{}", (Object)fileId, (Object)path);
        return path;
    }
}

