/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class JsonExtractor {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static JsonNode extractByStructure(String jsonSource, String template) throws JsonProcessingException {
        return JsonExtractor.extractByStructure(JsonExtractor.parserJsonNode(jsonSource), JsonExtractor.parserJsonNode(template));
    }

    public static String extract2StringByStructure(String jsonSource, String template) throws JsonProcessingException {
        return JsonExtractor.toJsonString(JsonExtractor.extractByStructure(JsonExtractor.parserJsonNode(jsonSource), JsonExtractor.parserJsonNode(template)));
    }

    public static JsonNode extractByStructure(JsonNode source, JsonNode template) {
        if (template.isObject()) {
            ObjectNode result = mapper.createObjectNode();
            template.fields().forEachRemaining(entry -> {
                String key = (String)entry.getKey();
                JsonNode templateChild = (JsonNode)entry.getValue();
                JsonNode sourceChild = source.get(key);
                if (sourceChild != null) {
                    JsonNode extracted = JsonExtractor.extractByStructure(sourceChild, templateChild);
                    result.set(key, extracted);
                }
            });
            return result;
        }
        if (template.isArray()) {
            ArrayNode result = mapper.createArrayNode();
            JsonNode templateElement = template.isEmpty() ? mapper.nullNode() : template.get(0);
            source.forEach(element -> {
                JsonNode extracted = JsonExtractor.extractByStructure(element, templateElement);
                result.add(extracted);
            });
            return result;
        }
        return source.deepCopy();
    }

    public static JsonNode parserJsonNode(String json) throws JsonProcessingException {
        return mapper.readTree(json);
    }

    public static String toJsonString(JsonNode node) throws JsonProcessingException {
        return mapper.writeValueAsString((Object)node);
    }

    public static boolean isValidJson(String json) {
        try {
            new ObjectMapper().readTree(json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

