/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonStructureValidator {
    private static final ObjectMapper mapper = new ObjectMapper();
    private String outputDesc = "";
    private String dataDesc = "";

    public JsonStructureValidator(String outputDesc, String dataDesc) {
        this.outputDesc = outputDesc;
        this.dataDesc = dataDesc;
    }

    public List<ValidationError> validate(String data, String template) throws Exception {
        JsonNode nodeData = mapper.readTree(data);
        JsonNode nodeTemplate = mapper.readTree(template);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateStructure(nodeData, nodeTemplate, "", errors);
        return errors;
    }

    private boolean validateStructure(JsonNode nodeData, JsonNode nodeTemplate, String currentPath, List<ValidationError> errors) {
        if (nodeTemplate.isObject()) {
            if (!nodeData.isObject()) {
                errors.add(new ValidationError(currentPath, "OBJECT", nodeData.getNodeType().toString(), String.format("\u7c7b\u578b\u4e0d\u5339\u914d\uff1a%s\u4e2d\u6b64\u5904\u5b9a\u4e49\u4e3a\u5bf9\u8c61\u7c7b\u578b\uff0c\u4e0e%s\u4e2d\u5b9e\u9645\u7c7b\u578b%s\u4e0d\u4e00\u81f4", this.outputDesc, this.dataDesc, nodeData.getNodeType().toString())));
                return false;
            }
            Iterator fields = nodeTemplate.fields();
            boolean isValid = true;
            while (fields.hasNext()) {
                JsonNode bChild;
                String newPath;
                Map.Entry entry = (Map.Entry)fields.next();
                String key = (String)entry.getKey();
                String string = newPath = currentPath.isEmpty() ? key : currentPath + "." + key;
                if (!nodeData.has(key)) {
                    errors.add(new ValidationError(newPath, "FIELD_EXISTS_IN_A", "FIELD_MISSING_IN_A", String.format("%s\u4e2d\u5b9a\u4e49\u4e86%s\u4e2d\u4e0d\u5b58\u5728\u7684\u5b57\u6bb5\"%s\"", this.outputDesc, this.dataDesc, key)));
                    isValid = false;
                    continue;
                }
                JsonNode aChild = nodeData.get(key);
                if (this.validateStructure(aChild, bChild = (JsonNode)entry.getValue(), newPath, errors)) continue;
                isValid = false;
            }
            return isValid;
        }
        if (nodeTemplate.isArray()) {
            if (!nodeData.isArray()) {
                errors.add(new ValidationError(currentPath, "ARRAY", nodeData.getNodeType().toString(), String.format("\u7c7b\u578b\u4e0d\u5339\u914d\uff1a%s\u4e2d\u6b64\u5904\u5b9a\u4e49\u4e3a\u6570\u7ec4\u7c7b\u578b\uff0c\u4e0e%s\u4e2d\u5b9e\u9645\u7c7b\u578b%s\u4e0d\u4e00\u81f4", this.outputDesc, this.dataDesc, nodeData.getNodeType().toString())));
                return false;
            }
            if (!nodeTemplate.isEmpty()) {
                JsonNode template = nodeTemplate.get(0);
                int index = 0;
                for (JsonNode aElement : nodeData) {
                    String elementPath;
                    if (!this.validateStructure(aElement, template, elementPath = currentPath + "[" + index + "]", errors)) {
                        return false;
                    }
                    ++index;
                }
            }
            return true;
        }
        if (nodeData.getNodeType() != nodeTemplate.getNodeType()) {
            errors.add(new ValidationError(currentPath, nodeData.getNodeType().toString(), nodeTemplate.getNodeType().toString(), String.format("\u7c7b\u578b\u4e0d\u5339\u914d\uff1a%s\u4e2d\u5b9a\u4e49\u7684\u7c7b\u578b\u4e0e%s\u4e2d\u5b9e\u9645\u7c7b\u578b%s\u4e0d\u4e00\u81f4", this.outputDesc, this.dataDesc, nodeData.getNodeType().toString())));
            return false;
        }
        return true;
    }

    public static List<String> findPathsByFlag(String json, String flag) throws Exception {
        JsonNode rootNode = mapper.readTree(json);
        return JsonStructureValidator.traverse(rootNode, "$", flag);
    }

    private static List<String> traverse(JsonNode node, String currentPath, String flag) {
        ArrayList<String> resultPaths;
        block4: {
            block3: {
                resultPaths = new ArrayList<String>(0);
                if (!node.isObject()) break block3;
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry entry = (Map.Entry)fields.next();
                    String key = (String)entry.getKey();
                    JsonNode value = (JsonNode)entry.getValue();
                    String newPath = currentPath + "." + key;
                    if (value.isObject() && value.has(flag)) {
                        resultPaths.add(newPath + "." + flag);
                    }
                    List<String> paths = JsonStructureValidator.traverse(value, newPath, flag);
                    resultPaths.addAll(paths);
                }
                break block4;
            }
            if (!node.isArray()) break block4;
            int index = 0;
            for (JsonNode element : node) {
                String arrayPath = currentPath + "[" + index + "]";
                List<String> paths = JsonStructureValidator.traverse(element, arrayPath, flag);
                resultPaths.addAll(paths);
                ++index;
            }
        }
        return resultPaths;
    }

    public static class ValidationError {
        private String path;
        private String expected;
        private String actual;
        private String message;

        public ValidationError(String path, String expected, String actual, String message) {
            this.path = path;
            this.expected = expected;
            this.actual = actual;
            this.message = message;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getExpected() {
            return this.expected;
        }

        public void setExpected(String expected) {
            this.expected = expected;
        }

        public String getActual() {
            return this.actual;
        }

        public void setActual(String actual) {
            this.actual = actual;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

