/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.agent.tool.model.FormDataEntity;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.UploadContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class MultiPartStringParser
implements UploadContext {
    private String postBody;
    private String boundary;
    private Map<String, FormDataEntity> parameters = new HashMap<String, FormDataEntity>();

    public MultiPartStringParser(String postBody) throws Exception {
        this.postBody = postBody;
        this.boundary = postBody.substring(2, postBody.indexOf(10)).trim();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        FileUpload upload = new FileUpload((FileItemFactory)factory);
        List fileItems = upload.parseRequest((RequestContext)this);
        for (FileItem fileItem : fileItems) {
            if (fileItem.isFormField()) {
                FormDataEntity entity = new FormDataEntity(fileItem.getFieldName(), fileItem.getString(), FormDataEntity.FormType.STRING);
                this.parameters.put(fileItem.getFieldName(), entity);
                continue;
            }
            String tmpName = String.format("tmp_%s", System.currentTimeMillis());
            FormDataEntity entity = new FormDataEntity(fileItem.getFieldName(), fileItem.getInputStream(), tmpName, FormDataEntity.FormType.FILE);
            this.parameters.put(fileItem.getFieldName(), entity);
        }
    }

    public Map<String, FormDataEntity> getParameters() {
        return this.parameters;
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    @Deprecated
    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return "multipart/form-data, boundary=" + this.boundary;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.postBody.getBytes());
    }

    public long contentLength() {
        return this.postBody.length();
    }
}

