/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class OpenAPIProtocolUtils {
    public static JSON getSchemaJSON(JSONObject schema) {
        return OpenAPIProtocolUtils.getSchemaJSON(null, schema);
    }

    private static JSON getSchemaJSON(String propName, JSONObject schema) {
        JSONObject data = null;
        String schemaType = schema.getString("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"object")) {
            JSONObject props = schema.getJSONObject("properties");
            data = OpenAPIProtocolUtils.handlerProperties(props);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"array")) {
            data = OpenAPIProtocolUtils.handlerItems(propName, schema);
        }
        return data;
    }

    private static JSONObject handlerProperties(JSONObject props) {
        JSONObject data = new JSONObject();
        if (props != null && !props.isEmpty()) {
            for (String propName : props.keySet()) {
                JSONObject prop = props.getJSONObject(propName);
                String desc = prop.getString("desc");
                String type = prop.getString("type");
                if ("string".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)"");
                    continue;
                }
                if ("integer".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)0);
                    continue;
                }
                if ("float".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)0.0);
                    continue;
                }
                if ("number".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)0);
                    continue;
                }
                if ("boolean".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)Boolean.FALSE);
                    continue;
                }
                if ("object".equalsIgnoreCase(type)) {
                    JSONObject subProps = prop.getJSONObject("properties");
                    JSONObject subPropsData = OpenAPIProtocolUtils.handlerProperties(subProps);
                    data.put(propName, (Object)subPropsData);
                    continue;
                }
                if (!"array".equalsIgnoreCase(type)) continue;
                JSONArray array = OpenAPIProtocolUtils.handlerItems(propName, prop);
                data.put(propName, (Object)array);
            }
        }
        return data;
    }

    private static JSONArray handlerItems(String propName, JSONObject schema) {
        return OpenAPIProtocolUtils.parseItems(propName, schema);
    }

    private static JSONArray parseItems(String propName, JSONObject schema) {
        JSONObject items = schema.getJSONObject("items");
        JSONArray data = new JSONArray();
        String itemType = items.getString("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)itemType, (CharSequence)"object")) {
            JSONObject itemProps = items.getJSONObject("properties");
            JSONObject item = OpenAPIProtocolUtils.handlerProperties(itemProps);
            data.add((Object)item);
        } else if ("array".equalsIgnoreCase(itemType)) {
            JSONObject itemsObj = items.getJSONObject("items");
            JSONArray array = OpenAPIProtocolUtils.handlerItems(propName, itemsObj);
            data.add((Object)array);
        } else if ("integer".equalsIgnoreCase(itemType)) {
            data.add((Object)0);
        } else if ("float".equalsIgnoreCase(itemType)) {
            data.add((Object)0.0);
        } else if ("number".equalsIgnoreCase(itemType)) {
            data.add((Object)0);
        } else if ("boolean".equalsIgnoreCase(itemType)) {
            data.add((Object)Boolean.FALSE);
        } else if ("string".equalsIgnoreCase(itemType)) {
            data.add((Object)"");
        }
        return data;
    }

    public static void handlerParameters(JSONArray params, JSONObject item) {
        for (String propName : item.keySet()) {
            JSONObject data = new JSONObject();
            Object value = item.get((Object)propName);
            data.put("name", (Object)propName);
            if (value != null) {
                String typeName = value.getClass().getName();
                int length = typeName.lastIndexOf(".");
                String type = typeName.substring(length + 1);
                data.put("dataType", (Object)type);
            }
            params.add((Object)data);
        }
    }

    public static JSON getSchemaJSONAndType(JSONObject schema) {
        JSONObject data = null;
        String schemaType = schema.getString("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"object")) {
            JSONObject props = schema.getJSONObject("properties");
            data = OpenAPIProtocolUtils.handlerPropertiesAndType(props);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"array")) {
            data = OpenAPIProtocolUtils.parseItemsAndType(schema);
        }
        return data;
    }

    private static JSONObject handlerPropertiesAndType(JSONObject props) {
        JSONObject result = new JSONObject();
        if (props != null && !props.isEmpty()) {
            for (String propName : props.keySet()) {
                JSONObject prop = props.getJSONObject(propName);
                String type = prop.getString("type");
                if ("string".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type) || "float".equalsIgnoreCase(type) || "number".equalsIgnoreCase(type) || "boolean".equalsIgnoreCase(type)) {
                    JSONObject data = new JSONObject();
                    String desc = prop.getString("desc");
                    data.put("type", (Object)type);
                    data.put("desc", (Object)desc);
                    data.put("paramWay", (Object)"body");
                    result.put(propName, (Object)data);
                    continue;
                }
                if ("object".equalsIgnoreCase(type)) {
                    JSONObject subProps = prop.getJSONObject("properties");
                    JSONObject subPropsData = OpenAPIProtocolUtils.handlerPropertiesAndType(subProps);
                    result.put(propName, (Object)subPropsData);
                    continue;
                }
                if (!"array".equalsIgnoreCase(type)) continue;
                JSONObject array = OpenAPIProtocolUtils.parseItemsAndType(prop);
                result.put(propName, (Object)array);
            }
        }
        JSONObject data = new JSONObject();
        data.put("type", (Object)"object");
        data.put("paramWay", (Object)"body");
        data.put("properties", (Object)result);
        return data;
    }

    private static JSONObject parseItemsAndType(JSONObject schema) {
        JSONObject items = schema.getJSONObject("items");
        JSONObject data = null;
        String itemType = items.getString("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)itemType, (CharSequence)"object")) {
            JSONObject itemProps = items.getJSONObject("properties");
            data = OpenAPIProtocolUtils.handlerPropertiesAndType(itemProps);
        } else if ("array".equalsIgnoreCase(itemType)) {
            JSONObject itemsObj = items.getJSONObject("items");
            data = OpenAPIProtocolUtils.parseItemsAndType(itemsObj);
        } else if ("integer".equalsIgnoreCase(itemType) || "float".equalsIgnoreCase(itemType) || "number".equalsIgnoreCase(itemType) || "boolean".equalsIgnoreCase(itemType) || "string".equalsIgnoreCase(itemType)) {
            String itemDesc = items.getString("desc");
            data = new JSONObject();
            data.put("type", (Object)itemType);
            data.put("desc", (Object)itemDesc);
            data.put("paramWay", (Object)"body");
        }
        JSONObject result = new JSONObject();
        result.put("type", (Object)"array");
        result.put("paramWay", (Object)"body");
        result.put("items", (Object)data);
        return result;
    }
}

