/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Components;
import kd.ai.gai.core.agent.tool.openapi.v3.models.HttpMethod;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Info;
import kd.ai.gai.core.agent.tool.openapi.v3.models.MediaType;
import kd.ai.gai.core.agent.tool.openapi.v3.models.OpenAPI;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Operation;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Parameter;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Path;
import kd.ai.gai.core.agent.tool.openapi.v3.models.RequestBody;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Response;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Schema;
import kd.ai.gai.core.agent.tool.openapi.v3.models.SecurityRequirement;
import kd.ai.gai.core.agent.tool.openapi.v3.models.SecurityScheme;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Server;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Tag;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.ParamConfigEnum;
import kd.ai.gai.core.service.config.GaiParamConfigService;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OpenAPIUtils {
    private static final Log logger = LogFactory.getLog(OpenAPIUtils.class);
    private static final String IPV4_REGEX = "^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$";

    public static OpenAPI parserSwaggerConfig(String swaggerConfig) {
        JSONObject swagger = JSONObject.parseObject((String)swaggerConfig, (Feature[])new Feature[]{Feature.OrderedField});
        return OpenAPIUtils.parserSwaggerConfig(swagger);
    }

    public static OpenAPI parserSwaggerConfig(JSONObject swagger) {
        String openapi = swagger.getString("openapi");
        Info info = (Info)JSONObject.parseObject((String)swagger.getString("info"), Info.class);
        ArrayList<Tag> tags = new ArrayList();
        JSONArray tagArrays = swagger.getJSONArray("tags");
        if (tagArrays != null && !tagArrays.isEmpty()) {
            tags = JSONArray.parseArray((String)tagArrays.toJSONString(), Tag.class);
        }
        ArrayList<Server> servers = new ArrayList<Server>();
        JSONArray serverArrays = swagger.getJSONArray("servers");
        if (serverArrays != null && !serverArrays.isEmpty()) {
            servers = JSONArray.parseArray((String)serverArrays.toJSONString(), Server.class);
        } else {
            servers.add(new Server("/"));
        }
        List security = JSONArray.parseArray((String)swagger.getString("security"), SecurityRequirement.class);
        LinkedHashMap<String, Path> paths = new LinkedHashMap<String, Path>();
        Map pathsRoot = (Map)JSONObject.parseObject((String)swagger.getString("paths"), Map.class);
        OpenAPIUtils.getPaths(pathsRoot, paths);
        OpenAPI openAPI = new OpenAPI();
        JSONObject components = swagger.getJSONObject("components");
        if (components != null) {
            Components component = (Components)JSONObject.parseObject((String)components.toJSONString(), Components.class);
            openAPI.setComponents(component);
        }
        openAPI.setOpenapi(openapi);
        openAPI.setInfo(info);
        openAPI.setTags(tags);
        openAPI.setSecurity(security);
        openAPI.setPaths(paths);
        openAPI.setServers(servers);
        return openAPI;
    }

    private static void getPaths(final Map<String, JSONObject> pathsRoot, final Map<String, Path> paths) {
        if (pathsRoot == null || pathsRoot.isEmpty()) {
            return;
        }
        pathsRoot.keySet().stream().forEach(new Consumer<String>(){

            @Override
            public void accept(final String location) {
                final JSONObject operations = (JSONObject)pathsRoot.get(location);
                final Path path = new Path();
                logger.info("\u89e3\u6790Path({})", (Object)location);
                if (operations != null && !operations.isEmpty()) {
                    path.setSummary(operations.getString("summary"));
                    path.setDescription(operations.getString("description"));
                    path.set$ref(operations.getString("$ref"));
                    operations.keySet().stream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String key) {
                            if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)HttpMethod.GET.toString())) {
                                JSONObject operation = operations.getJSONObject(key);
                                Operation op = OpenAPIUtils.parseGetOperation(operation);
                                if (StringUtils.isEmpty((CharSequence)op.getOperationId())) {
                                    op.setOperationId(OpenAPIUtils.buildOperationId(location, key));
                                }
                                path.setGet(op);
                            } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)HttpMethod.POST.toString())) {
                                JSONObject operation = operations.getJSONObject(key);
                                Operation op = OpenAPIUtils.parsePostOperation(operation);
                                if (StringUtils.isEmpty((CharSequence)op.getOperationId())) {
                                    op.setOperationId(OpenAPIUtils.buildOperationId(location, key));
                                }
                                path.setPost(op);
                            } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)HttpMethod.PUT.toString())) {
                                JSONObject operation = operations.getJSONObject(key);
                                Operation op = OpenAPIUtils.parsePostOperation(operation);
                                if (StringUtils.isEmpty((CharSequence)op.getOperationId())) {
                                    op.setOperationId(OpenAPIUtils.buildOperationId(location, key));
                                }
                                path.setPut(op);
                            } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)HttpMethod.DELETE.toString())) {
                                JSONObject operation = operations.getJSONObject(key);
                                Operation op = OpenAPIUtils.parsePostOperation(operation);
                                if (StringUtils.isEmpty((CharSequence)op.getOperationId())) {
                                    op.setOperationId(OpenAPIUtils.buildOperationId(location, key));
                                }
                                path.setDelete(op);
                            }
                        }
                    });
                    paths.put(location, path);
                }
            }
        });
    }

    private static Operation parseGetOperation(JSONObject operation) {
        Operation op = new Operation();
        OpenAPIUtils.parseOperation(op, operation);
        List<Parameter> parameters = new LinkedList<Parameter>();
        JSONArray paramArrays = operation.getJSONArray("parameters");
        if (paramArrays != null && !paramArrays.isEmpty()) {
            parameters = JSONArray.parseArray((String)paramArrays.toJSONString(), Parameter.class);
        }
        op.setParameters(parameters);
        return op;
    }

    private static Operation parsePostOperation(JSONObject operation) {
        Operation op = new Operation();
        OpenAPIUtils.parseOperation(op, operation);
        JSONObject requestBody = operation.getJSONObject("requestBody");
        if (requestBody != null) {
            RequestBody body = (RequestBody)JSONObject.parseObject((String)requestBody.toJSONString(), RequestBody.class);
            op.setRequestBody(body);
        }
        List<Parameter> parameters = new LinkedList<Parameter>();
        JSONArray paramArrays = operation.getJSONArray("parameters");
        if (paramArrays != null && !paramArrays.isEmpty()) {
            parameters = JSONArray.parseArray((String)paramArrays.toJSONString(), Parameter.class);
        }
        op.setParameters(parameters);
        return op;
    }

    private static void parseOperation(Operation op, JSONObject operation) {
        op.setSummary(operation.getString("summary"));
        op.setDescription(operation.getString("description"));
        op.setOperationId(operation.getString("operationId"));
        op.setDeprecated(operation.getBoolean("deprecated"));
        LinkedHashMap<String, Response> responses = new LinkedHashMap<String, Response>();
        Map responsesRoot = (Map)JSONObject.parseObject((String)operation.getString("responses"), Map.class);
        if (!ObjectUtils.isEmpty((Object)responsesRoot)) {
            for (Map.Entry e1 : responsesRoot.entrySet()) {
                String mapKey = (String)e1.getKey();
                JSONObject responseObj = (JSONObject)e1.getValue();
                Response response = new Response();
                if (responseObj != null) {
                    response.setDescription(responseObj.getString("description"));
                    JSONObject contentObj = responseObj.getJSONObject("content");
                    if (contentObj != null && !contentObj.isEmpty()) {
                        HashMap<String, MediaType> contentMap = new HashMap<String, MediaType>(contentObj.keySet().size());
                        for (String contentType : contentObj.keySet()) {
                            JSONObject content = contentObj.getJSONObject(contentType);
                            if (content == null) continue;
                            JSONObject schemaObj = content.getJSONObject("schema");
                            Schema schema = (Schema)JSONObject.parseObject((String)JSONObject.toJSONString((Object)schemaObj), Schema.class);
                            MediaType mediaType = new MediaType();
                            mediaType.setSchema(schema);
                            contentMap.put(contentType, mediaType);
                        }
                        response.setContent(contentMap);
                    }
                }
                responses.put(mapKey, response);
            }
        }
        op.setResponses(responses);
        List<String> tags = new ArrayList<String>();
        JSONArray arrays = operation.getJSONArray("tags");
        if (arrays != null && !arrays.isEmpty()) {
            tags = JSONArray.parseArray((String)arrays.toJSONString(), String.class);
        }
        op.setTags(tags);
        ArrayList<Map<String, List<String>>> security = new ArrayList<Map<String, List<String>>>(1);
        JSONArray securitys = operation.getJSONArray("security");
        if (securitys != null && !securitys.isEmpty()) {
            for (int i = 0; i < securitys.size(); ++i) {
                JSONObject securityObj = securitys.getJSONObject(i);
                if (securityObj == null || securityObj.isEmpty()) continue;
                HashMap<String, List> securityMap = new HashMap<String, List>();
                Iterator iterator = securityObj.keySet().iterator();
                while (iterator.hasNext()) {
                    String securitySchema;
                    JSONArray array = securityObj.getJSONArray(securitySchema = (String)iterator.next());
                    List scopes = JSONObject.parseArray((String)JSONObject.toJSONString((Object)array), String.class);
                    securityMap.put(securitySchema, scopes == null ? new ArrayList() : scopes);
                }
                security.add(securityMap);
            }
        }
        op.setSecurity(security);
    }

    public static Map<String, OperationParam> parseOperationParam(OpenAPI openAPI) {
        HashMap<String, OperationParam> operationParamMap = new HashMap<String, OperationParam>();
        if (openAPI != null) {
            Map<String, Path> pathMap = openAPI.getPaths();
            List<Server> servers = openAPI.getServers();
            Components components = openAPI.getComponents();
            Map<String, SecurityScheme> securitySchemes = null;
            if (components != null) {
                securitySchemes = components.getSecuritySchemes();
            }
            String server = servers.get(0).getUrl();
            for (Map.Entry<String, Path> entry : pathMap.entrySet()) {
                Operation deleteOp;
                Operation putOp;
                Operation postOp;
                String locationPath = entry.getKey();
                Path path = entry.getValue();
                List<Parameter> pathParameters = path.getParameters();
                if (path == null) continue;
                Operation getOp = path.getGet();
                if (getOp != null) {
                    OpenAPIUtils.handlerOperation(getOp, HttpMethod.GET, server, locationPath, pathParameters, operationParamMap, securitySchemes);
                }
                if ((postOp = path.getPost()) != null) {
                    OpenAPIUtils.handlerOperation(postOp, HttpMethod.POST, server, locationPath, pathParameters, operationParamMap, securitySchemes);
                }
                if ((putOp = path.getPut()) != null) {
                    OpenAPIUtils.handlerOperation(putOp, HttpMethod.PUT, server, locationPath, pathParameters, operationParamMap, securitySchemes);
                }
                if ((deleteOp = path.getDelete()) == null) continue;
                OpenAPIUtils.handlerOperation(deleteOp, HttpMethod.DELETE, server, locationPath, pathParameters, operationParamMap, securitySchemes);
            }
        }
        return operationParamMap;
    }

    private static void handlerOperation(Operation operation, HttpMethod method, String server, String locationPath, List<Parameter> pathParameters, Map<String, OperationParam> operationParamMap, Map<String, SecurityScheme> securitySchemes) {
        String operationId = operation.getOperationId();
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            operationId = OpenAPIUtils.buildOperationId(locationPath, method.toString().toLowerCase(Locale.ROOT));
        }
        List<Parameter> opParameters = operation.getParameters();
        List<Parameter> parameters = OpenAPIUtils.combineParameters(pathParameters, opParameters);
        RequestBody requestBody = operation.getRequestBody();
        String summary = operation.getSummary();
        OperationParam op = new OperationParam(server, operationId, locationPath, method.toString(), parameters);
        op.setSummary(summary);
        op.setRequestBody(requestBody);
        Map<String, Response> responseMap = operation.getResponses();
        op.setResponses(responseMap);
        List<Map<String, List<String>>> securities = operation.getSecurity();
        if (securities != null && !securities.isEmpty()) {
            ArrayList<SecurityScheme> securitySchemeList = new ArrayList<SecurityScheme>(1);
            for (Map<String, List<String>> entry : securities) {
                for (Map.Entry<String, List<String>> entryMap : entry.entrySet()) {
                    String securitySchemaName = entryMap.getKey();
                    if (securitySchemes == null) continue;
                    SecurityScheme scheme = securitySchemes.get(securitySchemaName);
                    securitySchemeList.add(scheme);
                }
            }
            op.setSecuritySchemes(securitySchemeList);
        }
        operationParamMap.put(operationId, op);
    }

    private static String buildOperationId(String locationPath, String method) {
        String operationId = String.format("%s_%s", locationPath.replaceAll("/", ""), method);
        return operationId;
    }

    public static Map<String, OperationParam> parseOperationParam(String swaggerConfig) {
        OpenAPI openAPI = OpenAPIUtils.parserSwaggerConfig(swaggerConfig);
        return OpenAPIUtils.parseOperationParam(openAPI);
    }

    private static List<Parameter> combineParameters(List<Parameter> pathParameters, List<Parameter> opParameters) {
        if (pathParameters.isEmpty()) {
            return opParameters;
        }
        if (opParameters.isEmpty()) {
            return pathParameters;
        }
        final HashMap parameterMap = new HashMap();
        pathParameters.stream().forEach(new Consumer<Parameter>(){

            @Override
            public void accept(Parameter parameter) {
                parameterMap.put(parameter.getName(), parameter);
            }
        });
        opParameters.stream().forEach(new Consumer<Parameter>(){

            @Override
            public void accept(Parameter parameter) {
                parameterMap.put(parameter.getName(), parameter);
            }
        });
        return parameterMap.values().stream().collect(Collectors.toList());
    }

    public static long genLongId() {
        return ID.genLongId();
    }

    public static Map<String, OperationParam> parserRestfulOperationParam(String toolConfig, String[] operationIds) {
        JSONObject configJo = JSONObject.parseObject((String)toolConfig, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray apiList = configJo.getJSONArray("apiList");
        if (apiList == null || apiList.isEmpty()) {
            return new HashMap<String, OperationParam>();
        }
        String server = configJo.getString("url");
        HashMap<String, OperationParam> operationParamMap = new HashMap<String, OperationParam>(0);
        for (int i = 0; i < apiList.size(); ++i) {
            HashMap<String, MediaType> content;
            JSONObject api = apiList.getJSONObject(i);
            String path = api.getString("location");
            String operationId = api.getString("operationId");
            if (operationIds != null && operationIds.length > 0 && !Arrays.asList(operationIds).contains(operationId)) continue;
            String method = api.getString("method");
            String contentType = api.getString("contentType");
            String description = api.getString("description");
            String testStatus = api.getString("testStatus");
            String name = api.getString("name");
            JSONObject inputParams = api.getJSONObject("inputParams");
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(0);
            Schema bodySchema = null;
            if (inputParams != null && !inputParams.isEmpty()) {
                for (String propName : inputParams.keySet()) {
                    JSONObject itemsJo;
                    Map<String, Object> properties;
                    JSONObject propJo = inputParams.getJSONObject(propName);
                    String paramType = propJo.getString("type");
                    if (StringUtils.isEmpty((CharSequence)paramType)) {
                        logger.warn("param {} data type is null\uff0cset default type is string", (Object)propName);
                        paramType = ToolConstant.ParamType.STRING.getName();
                        propJo.put("type", (Object)paramType);
                    }
                    if (ToolConstant.ParamType.isBasicType(paramType)) {
                        Map<String, Object> objProperties;
                        String paramDesc;
                        String paramWay = propJo.getString("paramWay");
                        if (StringUtils.isEmpty((CharSequence)paramWay)) {
                            paramWay = ToolConstant.OpenAPIConstant.In.QUERY.getValue();
                        }
                        if (StringUtils.isEmpty((CharSequence)(paramDesc = propJo.getString("desc")))) {
                            paramDesc = propJo.getString("description");
                        }
                        Object defaultValue = propJo.get((Object)"default");
                        if (StringUtils.equalsIgnoreCase((CharSequence)paramWay, (CharSequence)ToolConstant.OpenAPIConstant.In.QUERY.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)paramWay, (CharSequence)ToolConstant.OpenAPIConstant.In.PATH.getValue()) || StringUtils.equalsIgnoreCase((CharSequence)paramWay, (CharSequence)ToolConstant.OpenAPIConstant.In.HEADER.getValue())) {
                            Schema paramSchema = new Schema();
                            paramSchema.setType(paramType);
                            Parameter parameter = new Parameter(propName, paramWay, paramDesc);
                            parameter.setSchema(paramSchema);
                            parameter.setDefaultValue(defaultValue);
                            parameters.add(parameter);
                            continue;
                        }
                        if (bodySchema == null) {
                            bodySchema = OpenAPIUtils.initBodySchema();
                        }
                        if ((objProperties = bodySchema.getProperties()) == null) {
                            objProperties = new HashMap<String, Object>();
                        }
                        Map<String, Object> prop = OpenAPIUtils.buildBasicProp(propJo);
                        objProperties.put(propName, prop);
                        bodySchema.setProperties(objProperties);
                        continue;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.OBJECT.getName())) {
                        JSONObject propertiesJo;
                        if (bodySchema == null) {
                            bodySchema = OpenAPIUtils.initBodySchema();
                        }
                        if ((propertiesJo = propJo.getJSONObject("properties")) == null) continue;
                        Map<String, Object> prop = OpenAPIUtils.buildObjectProp(propertiesJo);
                        properties = bodySchema.getProperties();
                        properties.put(propName, prop);
                        continue;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.ARRAY.getName())) continue;
                    if (bodySchema == null) {
                        bodySchema = OpenAPIUtils.initBodySchema();
                    }
                    if ((itemsJo = propJo.getJSONObject("items")) == null) continue;
                    Map<String, Object> itemsProp = OpenAPIUtils.buildArrayProp(itemsJo);
                    properties = bodySchema.getProperties();
                    properties.put(propName, itemsProp);
                }
            }
            JSONObject outputParams = api.getJSONObject("outputParams");
            Schema responseSchema = OpenAPIUtils.initBodySchema();
            if (outputParams != null && !outputParams.isEmpty()) {
                for (String propName : outputParams.keySet()) {
                    JSONObject itemsJo;
                    Map<String, Object> properties;
                    Map<String, Object> prop;
                    JSONObject propJo = outputParams.getJSONObject(propName);
                    String paramType = propJo.getString("type");
                    if (StringUtils.isEmpty((CharSequence)paramType)) {
                        logger.warn("param {} data type is null\uff0cset default type is string", (Object)propName);
                        paramType = ToolConstant.ParamType.STRING.getName();
                        propJo.put("type", (Object)paramType);
                    }
                    if (ToolConstant.ParamType.isBasicType(paramType)) {
                        Map<String, Object> objProperties = responseSchema.getProperties();
                        prop = OpenAPIUtils.buildBasicProp(propJo);
                        objProperties.put(propName, prop);
                        continue;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.OBJECT.getName())) {
                        JSONObject propertiesJo = propJo.getJSONObject("properties");
                        if (propertiesJo == null) continue;
                        prop = OpenAPIUtils.buildObjectProp(propertiesJo);
                        properties = responseSchema.getProperties();
                        properties.put(propName, prop);
                        continue;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.ARRAY.getName()) || (itemsJo = propJo.getJSONObject("items")) == null) continue;
                    Map<String, Object> itemsProp = OpenAPIUtils.buildArrayProp(itemsJo);
                    properties = responseSchema.getProperties();
                    properties.put(propName, itemsProp);
                }
            }
            OperationParam op = new OperationParam(server, operationId, path, method, parameters);
            if (bodySchema != null) {
                MediaType mediaType = new MediaType();
                mediaType.setSchema(bodySchema);
                RequestBody requestBody = new RequestBody();
                content = new HashMap<String, MediaType>(0);
                content.put(contentType, mediaType);
                requestBody.setContent(content);
                op.setRequestBody(requestBody);
            }
            if (!responseSchema.getProperties().isEmpty()) {
                HashMap<String, Response> responses = new HashMap<String, Response>(0);
                MediaType mediaType = new MediaType();
                mediaType.setSchema(responseSchema);
                content = new HashMap(0);
                content.put(contentType, mediaType);
                Response response = new Response();
                response.setContent(content);
                responses.put("200", response);
                op.setResponses(responses);
            }
            op.setContentType(contentType);
            op.setSummary(description);
            op.setTestStatus(testStatus);
            op.setName(name);
            op.setInputParamsJson(JSONObject.toJSONString((Object)inputParams));
            op.setOutputParamsJson(JSONObject.toJSONString((Object)outputParams));
            operationParamMap.put(operationId, op);
        }
        return operationParamMap;
    }

    public static Map<String, OperationParam> parserRestfulOperationParam(JSONObject toolConfigJo, String[] operationIds) {
        return OpenAPIUtils.parserRestfulOperationParam(JSONObject.toJSONString((Object)toolConfigJo), operationIds);
    }

    public static OperationParam parserSingleRestfulOperationParam(JSONObject configJo, String operationId) {
        Map<String, OperationParam> operationParamMap = OpenAPIUtils.parserRestfulOperationParam(configJo, new String[]{operationId});
        OperationParam operationParam = operationParamMap.get(operationId);
        return operationParam;
    }

    public static OperationParam parserSingleRestfulOperationParam(String toolConfig, String operationId) {
        Map<String, OperationParam> operationParamMap = OpenAPIUtils.parserRestfulOperationParam(toolConfig, new String[]{operationId});
        OperationParam operationParam = operationParamMap.get(operationId);
        return operationParam;
    }

    public static Map<String, OperationParam> parserRestfulOperationParam(String toolConfig, String operationId) {
        return OpenAPIUtils.parserRestfulOperationParam(toolConfig, new String[]{operationId});
    }

    private static Schema initBodySchema() {
        Schema bodySchema = new Schema();
        bodySchema.setType(ToolConstant.ParamType.OBJECT.getType());
        bodySchema.setProperties(new HashMap<String, Object>(0));
        return bodySchema;
    }

    private static Map<String, Object> buildObjectProp(JSONObject objPropertiesJo) {
        HashMap<String, Object> objProp = new HashMap<String, Object>(0);
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>(0);
        objProp.put("properties", properties);
        objProp.put("type", ToolConstant.ParamType.OBJECT.getName());
        for (String propName : objPropertiesJo.keySet()) {
            JSONObject itemsJo;
            Map<String, Object> subObjProp;
            JSONObject propJo = objPropertiesJo.getJSONObject(propName);
            String paramType = propJo.getString("type");
            if (ToolConstant.ParamType.isBasicType(paramType)) {
                Map<String, Object> prop = OpenAPIUtils.buildBasicProp(propJo);
                properties.put(propName, prop);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.OBJECT.getName())) {
                JSONObject propertiesJo = propJo.getJSONObject("properties");
                if (propertiesJo == null) continue;
                subObjProp = OpenAPIUtils.buildObjectProp(propertiesJo);
                properties.put(propName, subObjProp);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.ARRAY.getName()) || (itemsJo = propJo.getJSONObject("items")) == null) continue;
            subObjProp = OpenAPIUtils.buildArrayProp(itemsJo);
            properties.put(propName, subObjProp);
        }
        return objProp;
    }

    private static Map<String, Object> buildArrayProp(JSONObject itemsJo) {
        JSONObject propertiesJo;
        HashMap<String, Object> arrayProp = new HashMap<String, Object>(0);
        arrayProp.put("type", ToolConstant.ParamType.ARRAY.getName());
        String paramType = itemsJo.getString("type");
        if (ToolConstant.ParamType.isBasicType(paramType)) {
            HashMap<String, String> data = new HashMap<String, String>(0);
            data.put("type", paramType);
            arrayProp.put("items", data);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.OBJECT.getName()) && (propertiesJo = itemsJo.getJSONObject("properties")) != null) {
            Map<String, Object> subObjProp = OpenAPIUtils.buildObjectProp(propertiesJo);
            arrayProp.put("items", subObjProp);
        }
        return arrayProp;
    }

    private static Map<String, Object> buildBasicProp(JSONObject propJo) {
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put("type", propJo.getString("type"));
        prop.put("desc", propJo.getString("desc"));
        if (propJo.containsKey((Object)"format")) {
            prop.put("format", propJo.getString("format"));
        }
        if (propJo.containsKey((Object)"default")) {
            prop.put("default", propJo.get((Object)"default"));
        }
        return prop;
    }

    public static boolean containsInternalIP(String url) {
        String allowAccessInternalIp = GaiParamConfigService.getConfigValue(ParamConfigEnum.ALLOW_ACCESS_INTERNAL_IP.getId());
        if (StringUtils.equalsIgnoreCase((CharSequence)allowAccessInternalIp, (CharSequence)EnableEnum.YES.getKeyStr())) {
            return false;
        }
        try {
            URL parsedUrl = new URL(url);
            String host = parsedUrl.getHost();
            if (Pattern.matches(IPV4_REGEX, host)) {
                InetAddress address = InetAddress.getByName(host);
                byte[] ipBytes = address.getAddress();
                if (ipBytes.length == 4) {
                    int firstByte = ipBytes[0] & 0xFF;
                    int secondByte = ipBytes[1] & 0xFF;
                    return firstByte == 10 || firstByte == 172 && secondByte >= 16 && secondByte <= 31 || firstByte == 192 && secondByte == 168;
                }
                if (ipBytes.length == 16) {
                    return (ipBytes[0] & 0xFF) == 253;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

