/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.agent.tool.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.model.AuthType;
import kd.ai.gai.core.domain.dto.agent.AgentTool;
import kd.ai.gai.core.domain.dto.agent.ToolAPIInfo;
import kd.ai.gai.core.domain.dto.agent.ToolParam;
import kd.ai.gai.core.service.agent.AgentToolService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ToolUtils {
    private static final Log logger = LogFactory.getLog(ToolUtils.class);

    public static void handlerOpenAPIAuthInfo(Object toolId, JSONObject swaggerConfig) {
        QFilter filter = new QFilter("toolid", "=", toolId);
        DynamicObject authDo = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_tool_auth", (String)"id,toolid,auth_tag", (QFilter[])new QFilter[]{filter});
        if (authDo != null) {
            String authType = swaggerConfig.getString("authtype");
            String authTag = authDo.getString("auth_tag");
            logger.info("get tool auth info :{}", (Object)authTag);
            JSONObject authObj = JSONObject.parseObject((String)authTag);
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.SERVICE.getType())) {
                swaggerConfig.put("serviceConfig", (Object)authObj.getJSONObject("serviceConfig"));
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.OAUTH.getType())) {
                swaggerConfig.put("oauthConfig", (Object)authObj.getJSONObject("oauthConfig"));
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
                swaggerConfig.put("cosmicAccessTokenConfig", (Object)authObj.getJSONObject("cosmicAccessTokenConfig"));
            }
            JSONArray headers = authObj.getJSONArray("headerList");
            swaggerConfig.put("headerList", (Object)headers);
            JSONArray bodyParmas = authObj.getJSONArray("bodyParamList");
            swaggerConfig.put("bodyParamList", (Object)bodyParmas);
        }
    }

    public static void handlerCosmicToolAuthInfo(Object toolId, JSONObject ca) {
        QFilter filter = new QFilter("toolid", "=", toolId);
        DynamicObject authDo = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_tool_auth", (String)"id,toolid,auth_tag", (QFilter[])new QFilter[]{filter});
        if (authDo != null) {
            String authTag = authDo.getString("auth_tag");
            logger.info("get tool auth info :{}", (Object)authTag);
            JSONObject authObj = JSONObject.parseObject((String)authTag);
            JSONArray configParams = authObj.getJSONArray("configParams");
            ca.put("configParams", (Object)configParams);
        }
    }

    public static JSONObject handlerToolParam(Object toolId, JSONObject swaggerConfig) {
        QFilter filter = new QFilter("toolid", "=", toolId);
        DynamicObject authDo = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_tool_auth", (String)"id,toolid,auth_tag", (QFilter[])new QFilter[]{filter});
        if (authDo != null) {
            String authTag = authDo.getString("auth_tag");
            logger.info("get tool auth info :{}", (Object)authTag);
            JSONObject authObj = JSONObject.parseObject((String)authTag);
            return authObj;
        }
        return swaggerConfig;
    }

    public static void updateToolAuthInfo(DynamicObject tool, JSONObject authObj) {
        long toolId = tool.getLong("id");
        String number = tool.getString("number");
        String authJson = JSON.toJSONString((Object)authObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        QFilter filter = new QFilter("toolid", "=", (Object)toolId);
        DynamicObject authDo = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_tool_auth", (String)"id,toolid,auth_tag", (QFilter[])new QFilter[]{filter});
        if (authDo == null) {
            authDo = BusinessDataServiceHelper.newDynamicObject((String)"gai_tool_auth");
            authDo.set("toolid", (Object)toolId);
            authDo.set("number", (Object)String.format("%s-auth", number));
            authDo.set("name", (Object)String.format("%s-auth", number));
            authDo.set("status", (Object)"C");
            authDo.set("enable", (Object)"1");
            authDo.set("auth_tag", (Object)authJson);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{authDo});
        } else {
            authDo.set("auth_tag", (Object)authJson);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{authDo});
        }
    }

    public static List<ToolAPIInfo> parserToolAPIList(Long toolId, String[] operationIds) {
        ArrayList<ToolAPIInfo> apiInfoList = new ArrayList<ToolAPIInfo>(0);
        AgentTool tool = AgentToolService.getAgentTool(toolId);
        if (tool == null) {
            return apiInfoList;
        }
        String toolConfig = tool.getConfig();
        String toolType = tool.getType();
        return ToolUtils.parserToolAPIList(toolConfig, toolType, operationIds);
    }

    public static List<ToolAPIInfo> parserToolAPIList(String toolConfig, String toolType, String[] operationIds) {
        ArrayList<ToolAPIInfo> apiInfoList = new ArrayList<ToolAPIInfo>(0);
        JSONObject configJo = JSONObject.parseObject((String)toolConfig, (Feature[])new Feature[]{Feature.OrderedField});
        ToolAPIInfo apiInfo = null;
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType()) || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
            return apiInfoList;
        }
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType()) || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType()) || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
            JSONArray apiList = configJo.getJSONArray("apiList");
            if (apiList == null || apiList.isEmpty()) {
                return apiInfoList;
            }
            for (int i = 0; i < apiList.size(); ++i) {
                JSONObject outputParams;
                JSONObject api = apiList.getJSONObject(i);
                String operationId = api.getString("operationId");
                if (operationIds != null && operationIds.length > 0 && !Arrays.asList(operationIds).contains(operationId)) continue;
                apiInfo = new ToolAPIInfo();
                String path = api.getString("location");
                String description = api.getString("description");
                String name = api.getString("name");
                apiInfo.setName(name);
                apiInfo.setDescription(description);
                apiInfo.setOperationId(operationId);
                apiInfo.setEnable(api.getString("enable"));
                apiInfo.setLocation(path);
                apiInfo.setTestStatus(api.getString("testStatus"));
                JSONObject inputParams = api.getJSONObject("inputParams");
                if (inputParams != null && !inputParams.isEmpty()) {
                    List<ToolParam> inputs = ToolUtils.buildToolParams(inputParams);
                    apiInfo.setInputParams(inputs);
                }
                if ((outputParams = api.getJSONObject("outputParams")) != null && !outputParams.isEmpty()) {
                    List<ToolParam> outputs = ToolUtils.buildToolParams(outputParams);
                    apiInfo.setOutputParams(outputs);
                }
                apiInfoList.add(apiInfo);
            }
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
            apiInfo = new ToolAPIInfo();
            JSONArray inputParams = configJo.getJSONArray("inputParams");
            JSONArray outputParams = configJo.getJSONArray("outputParams");
            apiInfo.setInputParams(ToolUtils.buildCosmicActionParams(inputParams));
            apiInfo.setOutputParams(ToolUtils.buildCosmicActionParams(outputParams));
            apiInfoList.add(apiInfo);
        }
        return apiInfoList;
    }

    private static List<ToolParam> buildCosmicActionParams(JSONArray params) {
        ArrayList<ToolParam> toolParams = new ArrayList<ToolParam>(0);
        if (params != null && !params.isEmpty()) {
            ToolParam toolParam = null;
            for (int i = 0; i < params.size(); ++i) {
                JSONObject param = params.getJSONObject(i);
                String varName = param.getString("paramName");
                String varType = param.getString("paramType");
                String varDesc = param.getString("paramDesc");
                toolParam = new ToolParam(varName, varType, varDesc);
                toolParams.add(toolParam);
            }
        }
        return toolParams;
    }

    private static List<ToolParam> buildToolParams(JSONObject params) {
        ArrayList<ToolParam> toolParams = new ArrayList<ToolParam>(0);
        if (params != null && !params.isEmpty()) {
            ToolParam toolParam = null;
            for (String propName : params.keySet()) {
                JSONObject propJo = params.getJSONObject(propName);
                String paramType = propJo.getString("type");
                String paramDesc = propJo.getString("desc");
                if (StringUtils.isEmpty((CharSequence)paramDesc)) {
                    paramDesc = propJo.getString("description");
                }
                toolParam = new ToolParam(propName, paramType, paramDesc);
                if (ToolConstant.ParamType.isBasicType(paramType)) {
                    toolParams.add(toolParam);
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.OBJECT.getName())) {
                    JSONObject propertiesJo = propJo.getJSONObject("properties");
                    List<ToolParam> subParams = ToolUtils.buildObjectParams(propertiesJo);
                    toolParam.setSubParams(subParams);
                    toolParams.add(toolParam);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.ARRAY.getName())) continue;
                JSONObject itemsJo = propJo.getJSONObject("items");
                ToolUtils.buildArrayParams(itemsJo, toolParam);
                toolParams.add(toolParam);
            }
        }
        return toolParams;
    }

    private static ToolParam buildBasicParam(JSONObject propJo) {
        ToolParam param = new ToolParam();
        param.setType(propJo.getString("type"));
        param.setDescription(propJo.getString("desc"));
        return param;
    }

    private static List<ToolParam> buildObjectParams(JSONObject objPropertiesJo) {
        ArrayList<ToolParam> toolParams = new ArrayList<ToolParam>(0);
        for (String propName : objPropertiesJo.keySet()) {
            JSONObject propJo = objPropertiesJo.getJSONObject(propName);
            String paramType = propJo.getString("type");
            ToolParam param = ToolUtils.buildBasicParam(propJo);
            param.setName(propName);
            if (ToolConstant.ParamType.isBasicType(paramType)) {
                toolParams.add(param);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.OBJECT.getName())) {
                JSONObject propertiesJo = propJo.getJSONObject("properties");
                List<ToolParam> subObjParams = ToolUtils.buildObjectParams(propertiesJo);
                param.setSubParams(subObjParams);
                toolParams.add(param);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.ARRAY.getName())) continue;
            JSONObject itemsJo = propJo.getJSONObject("items");
            ToolUtils.buildArrayParams(itemsJo, param);
            toolParams.add(param);
        }
        return toolParams;
    }

    private static void buildArrayParams(JSONObject itemsJo, ToolParam toolParam) {
        String paramType = itemsJo.getString("type");
        if (ToolConstant.ParamType.isBasicType(paramType)) {
            toolParam.setType(String.format("Array<%s>", paramType));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)paramType, (CharSequence)ToolConstant.ParamType.OBJECT.getName())) {
            JSONObject propertiesJo = itemsJo.getJSONObject("properties");
            List<ToolParam> subObjParams = ToolUtils.buildObjectParams(propertiesJo);
            toolParam.setSubParams(subObjParams);
            toolParam.setType(String.format("Array<%s>", ToolConstant.ParamType.OBJECT.getType()));
        }
    }
}

